/** @file sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
#define SLAVE_ADDRESS 0x4C
#define DATA_COUNT  1
/* USER CODE END */

/* Include Files */

#include "sys_common.h"

/* USER CODE BEGIN (1) */
#include "i2c.h"
#include "gio.h"
#include <stdio.h>
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
uint8_t RX_Data_Slave[DATA_COUNT];
uint8_t FLAG_STATUS = 0x00;
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */

    i2cInit();
    gioInit();
    _enable_IRQ();

    gioSetDirection(gioPORTB, 0xFF);

    i2cSetSlaveAdd(i2cREG1, SLAVE_ADDRESS);  // Slave cihaznn adresini ayarla
    i2cSetDirection(i2cREG1, I2C_RECEIVER);  // Alc olarak ayarla
    i2cSetMode(i2cREG1, I2C_SLAVE);  // Slave modunda al
    i2cSetStart(i2cREG1);  // Balang sinyali gnder

    while (1) {
        if (FLAG_STATUS == 0xFF) { // Veri alndnda FLAG gncellenir
            gioSetBit(gioPORTB, 1, 1);
            FLAG_STATUS = 0x00;  // FLAG sfrlanr ve tekrar veri beklenir
            }
    }

/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
void i2cNotification(i2cBASE_t *i2c, uint32 flags) {
    if (i2c == i2cREG1 && (flags & I2C_RX_INT)) {
        i2cReceive(i2cREG1, DATA_COUNT, RX_Data_Slave);
        FLAG_STATUS = 0xFF;  // Alm tamamlandnda FLAG ayarla
    }
}
/* USER CODE END */
