#include "BSP.h"
#include "..\pll\pll.h"

// return the number of digits
int numlength(uint32_t n){
  if(n < 10) return 1;
  if(n < 100) return 2;
  if(n < 1000) return 3;
  if(n < 10000) return 4;
  if(n < 100000) return 5;
  if(n < 1000000) return 6;
  if(n < 10000000) return 7;
  if(n < 100000000) return 8;
  if(n < 1000000000) return 9;
  return 10;
}

void main(void){
    int16_t color;
    uint32_t lux;

    pll();
    sysctlInit();
    accInit();
    //buzzerInit();
    //DCinit();
    joyInit();
    lightInit();
    RGBInit();
    initS(INITS_BLACKTAB);

    lux = lightInput();
    lightSenseStart();

    while(true){
        accIn(&AccX, &AccY, &AccZ);
        drawString(0, 5, "AccX=     ", color565(255,255,255));
        setCursor(5,5);
        outUDec((uint32_t) AccX, color565(255,0,255));
        drawString(0, 6, "AccY=     ", color565(255,255,255));
        setCursor(5,6);
        outUDec((uint32_t) AccY, color565(255,0,255));
        drawString(0, 7, "AccZ=     ", color565(255,255,255));
        setCursor(5,7);
        outUDec((uint32_t) AccZ, color565(255,0,255));

        joyIn(&joyX, &joyY, &push);
        drawString(0, 3, "JoyX=     ", color565(255,255,255));
        setCursor(5,3);
        outUDec((uint32_t) joyX, color565(255,0,255));
        drawString(0, 4, "JoyY=     ", color565(255,255,255));
        setCursor(5,4);
        outUDec((uint32_t) joyY, color565(255,0,255));

        if(lightSenseEnd(&lux)){
            color = color565(255,255,0);
            lightSenseStart();
        }else
            color = color565(255,255,255);
        drawString(0,8,"Light=        ",color565(255,255,255));
        setCursor(6,8);
        outUDec(lux/100, color);
        drawString(6+numlength(lux/100), 8, ".", color);
        setCursor(7+numlength(lux/100),8);
        if (numlength(lux%100) == 1)
            outUDec(0, color);
        outUDec(lux%100, color);

        drawString(0,0,"Red=    ",color565(255,0,0));
        setCursor(4,0);
        if (GPIO_PORTF[LED1_PF2] == LED1_PF2)
            drawString(4,0,"On",color565(255,0,0));
        else
            drawString(4,0,"Off",color565(255,0,0));
        drawString(0,1,"Green=    ",color565(0,255,0));
        setCursor(6,1);
        if (GPIO_PORTF[LED2_PF3] == LED2_PF3)
            drawString(6,1,"On",color565(0,255,0));
        else
            drawString(6,1,"Off",color565(0,255,0));
        drawString(0,2,"Blue=    ",color565(0,0,255));
        setCursor(5,2);
        if (GPIO_PORTG[LED3_PG0] == LED3_PG0)
            drawString(5,2,"On",color565(0,0,255));
        else
            drawString(5,2,"Off",color565(0,0,255));
    }
}
