#define SYSCTL ((volatile uint32_t *)0x400FE000)

#define SYSCTL_OSCRNG (1 << 4)

#define SYSCTL_MOSCPUPRIS (1 << 8)

#define SYSCTL_OSCSRC (3 << 20)
#define SYSCTL_PLLSRC (3 << 24)

#define SYSCTL_MINT (96 >> 0)
#define SYSCTL_PLLPWR (1 << 23)

#define SYSCTL_N 4
#define SYSCTL_Q (1 << 8)

#define SYSCTL_NEWFREQ (1 << 30)
#define SYSCTL_PSYSDIV_M (0x3FF >> 0)
#define SYSCTL_PSYSDIV 1
#define SYSCTL_USEPLL (1 << 28)
#define SYSCTL_MEMTIMU (1 << 31)

enum{
    SYSCTL_MOSCCTL = (0x07C >> 2),
    SYSCTL_RIS = (0x050 >> 2),
    SYSCTL_RSCLKCFG = (0x0B0 >> 2),
    SYSCTL_PLLFREQ0 = (0x160 >> 2),
    SYSCTL_PLLFREQ1 = (0x164 >> 2),
    SYSCTL_MEMTIM0 = (0x0C0 >> 2),
    SYSCTL_PLLSTAT = (0x168 >> 2)
};

void pll(void){
    SYSCTL[SYSCTL_MOSCCTL] &= ~0x1F;
    SYSCTL[SYSCTL_MOSCCTL] |= SYSCTL_OSCRNG;
    while(!(SYSCTL[SYSCTL_RIS] & SYSCTL_MOSCPUPRIS));

    SYSCTL[SYSCTL_MEMTIM0] = 0x00910091;

    SYSCTL[SYSCTL_RSCLKCFG] &= ~0xFFFFFFFF;
    SYSCTL[SYSCTL_RSCLKCFG] = SYSCTL_MEMTIMU;
    SYSCTL[SYSCTL_RSCLKCFG] |= SYSCTL_OSCSRC | SYSCTL_PLLSRC;

    SYSCTL[SYSCTL_PLLFREQ1] = SYSCTL_N | SYSCTL_Q;

    SYSCTL[SYSCTL_PLLFREQ0] |= SYSCTL_MINT | SYSCTL_PLLPWR;

    SYSCTL[SYSCTL_MEMTIM0] &= ~0xFFFFFFFF;
    SYSCTL[SYSCTL_MEMTIM0] = 0x01950195;

    if (SYSCTL[SYSCTL_PLLFREQ0] & SYSCTL_PLLPWR)
        SYSCTL[SYSCTL_RSCLKCFG] |= SYSCTL_NEWFREQ;
    else
        SYSCTL[SYSCTL_PLLFREQ0] |= SYSCTL_PLLPWR;

    while (!SYSCTL[SYSCTL_PLLSTAT]);

    SYSCTL[SYSCTL_RSCLKCFG] |= SYSCTL_USEPLL | SYSCTL_MEMTIMU | SYSCTL_PSYSDIV | SYSCTL_OSCSRC | SYSCTL_PLLSRC;

    SYSCTL[SYSCTL_RSCLKCFG] &= ~0x00F00000;
}
