/** @file sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "sys_common.h"

/* USER CODE BEGIN (1) */
#include "sci.h"
#include "rti.h"
#include "het.h"
#include "sys_vim.h"
#include "sys_core.h"
#include "LRM1.h"
#include "sys_dma.h"

uint32_t firstTick = 0U;
uint32_t lastTick = 0U;
uint32_t elapsedTime = 0U;
uint8_t rxBuffer[8];
uint8_t dma_rx_buf[8];

/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
#define SCI_SET_RX_DMA      (1<<17)
#define SCI_SET_RX_DMA_ALL  (1<<18)

#define DMA_SCI2_RX         28U
#define DMA_SCI2_RX_ADD     ((uint32_t)(&(scilinREG->LINRDx[3U])))
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
    g_dmaCTRL g_dmaCTRLPKT1;

    sciInit();
    rtiInit();
    rtiEnableNotification(3);
    hetInit();
    vimInit();

    while (((scilinREG->FLR & SCI_TX_INT) == 0U) || ((scilinREG->FLR & 0x4) == 0x4))
    {
    }

    dmaReqAssign(DMA_CH0, DMA_SCI2_RX);

    /*Configure control packet for Channel 0*/

    g_dmaCTRLPKT1.SADD      = DMA_SCI2_RX_ADD;      /* source address             */
    g_dmaCTRLPKT1.DADD      = (uint32_t)dma_rx_buf; /* destination  address       */
    g_dmaCTRLPKT1.CHCTRL    = 0;                    /* channel control            */
    g_dmaCTRLPKT1.FRCNT     = 1;                  /* frame count                */
    g_dmaCTRLPKT1.ELCNT     = 8;                    /* element count              */
    g_dmaCTRLPKT1.ELDOFFSET = 0;                    /* element destination offset */
    g_dmaCTRLPKT1.ELSOFFSET = 0;                    /* element destination offset */
    g_dmaCTRLPKT1.FRDOFFSET = 0;                    /* frame destination offset   */
    g_dmaCTRLPKT1.FRSOFFSET = 0;                    /* frame destination offset   */
    g_dmaCTRLPKT1.PORTASGN  = 4;
    g_dmaCTRLPKT1.RDSIZE    = ACCESS_8_BIT;         /* read size                  */
    g_dmaCTRLPKT1.WRSIZE    = ACCESS_8_BIT;         /* write size                 */
    g_dmaCTRLPKT1.TTYPE     = FRAME_TRANSFER;       /* transfer type              */
    g_dmaCTRLPKT1.ADDMODERD = ADDR_FIXED;            /* address mode read          */
    g_dmaCTRLPKT1.ADDMODEWR = ADDR_INC1;            /* address mode write         */
    g_dmaCTRLPKT1.AUTOINIT  = AUTOINIT_OFF;         /* autoinit                   */

   // sciEnableNotification(scilinREG, SCI_RX_INT);
    dmaSetCtrlPacket(DMA_CH0, g_dmaCTRLPKT1);

    dmaSetChEnable(DMA_CH0, DMA_HW);

    dmaEnable();

    scilinREG->SETINT |= SCI_SET_RX_DMA | SCI_SET_RX_DMA_ALL;
   // while(dmaGetInterruptStatus(DMA_CH0, BTC) != TRUE);

    rtiStartCounter(0U);


    //sciReceive(scilinREG, 8, rxBuffer);

    while(1)
    {
        if(dma_rx_buf[3] == 34)
        {
            int a= 0;
            a+=1;
        }
//        firstTick = rtiGetTick();
      //  ccdl_transmit(scilinREG, (unsigned char *)"012345\n\r");
//        elapsedTime = rti_cal_counter(firstTick, rtiGetTick());
//        firstTick = 0U;
    }

/* USER CODE END */
}


/* USER CODE BEGIN (4) */

void sciNotification(sciBASE_t *sci, uint32 flags)
{

    sciReceive(sci, 8, rxBuffer);
    ccdl_transmit(scilinREG, (unsigned char *)rxBuffer);

}

void rtiNotification(uint32 notification)
{
    if(notification == rtiNOTIFICATION_COMPARE0)            // 10uS Interrupt
    {
        ;
    }
    else                                                    // 1uS Interrupt
    {
        ;
    }
}
/* USER CODE END */
