/** @file sys_main.c 
*   @brief Application main file
*   @date 11-Dec-2018
*   @version 04.07.01
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2018 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "sys_common.h"

/* USER CODE BEGIN (1) */
#include "sys_core.h"
#include "can.h"
#include "sys_dma.h"
/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
#define D_SIZE 80 //  N Byte
#define CAN_TRANSMIT_BYTE 8 //CAN   DATA 8 Byte

uint32 Fram_size = D_SIZE/8; //  Ƚ

uint8 TX_DATA[D_SIZE] = {0}; //۽ 
uint8 RX_DATA[D_SIZE] = {0}; // 

uint8 fGo = 0; // ġ

g_dmaCTRL g_dmaCTRLPKT_TX; //TX DMA Ʈ Ŷ Ʈó ̸ 

g_dmaCTRL g_dmaCTRLPKT_RX; //RX DMA Ʈ Ŷ Ʈó ̸ 

void dmaGroupANotification(dmaInterrupt_t inttype, uint32 channel); //DMA ͷƮ

void canMessageNotification(canBASE_t *node, uint32 channel); //CAN ͷƮ

void dmaConfigCtrlTxPacket(uint32 sadd, uint32 dadd, uint32 esize, uint32 fsize); //TX DMA Ʈ Ŷ

void dmaConfigCtrlRxPacket(uint32 sadd, uint32 dadd, uint32 esize, uint32 fsize); //RX DMA Ʈ Ŷ

uint32 canTransmit_DMA(canBASE_t *node, uint32 messageBox, uint32 fsize); //TX CAN 

void Tx_Value(); // ۽  


/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
    canInit(); //CAN ʱȭ
    _enable_interrupt_(); //ͷƮ  

    Tx_Value(); //۽ TX  

    canREG2->IF3UEy[0] = 0x00000001; //޼ ڽ1 Ȱȭ

    dmaEnable(); //DMA  

    dmaEnableInterrupt(DMA_CH0, FTC); //RX ä ͷƮ  (FTC:    ͷƮ)
    dmaEnableInterrupt(DMA_CH1, FTC); //TX ä ͷƮ  (FTC:    ͷƮ)

    dmaConfigCtrlRxPacket((uint32)(canREG2->IF3DATx), (uint32)(RX_DATA), CAN_TRANSMIT_BYTE, Fram_size); //RX Ʈ Ŷ 
    dmaConfigCtrlTxPacket((uint32)(TX_DATA), (uint32)(canREG1->IF1DATx), CAN_TRANSMIT_BYTE, Fram_size); //TX Ʈ Ŷ 

    dmaSetCtrlPacket(DMA_CH0, g_dmaCTRLPKT_RX); //RX DMA Ʈ Ŷ   ä RX äο 
    dmaSetCtrlPacket(DMA_CH1, g_dmaCTRLPKT_TX); //TX DMA Ʈ Ŷ ۽  ä TX äο 

    //dmaEnableInterrupt(DMA_CH0, BTC);

    dmaReqAssign(DMA_CH0, 4);

    canREG2->CTL |= 1 << 20;
    canREG2->IF3OBS = 0x18;
    dmaSetChEnable(DMA_CH0, DMA_HW);

    while(1)
    {
        if(fGo == 1) //  ġ
        {
            fGo = 0; //ݺ  
            canTransmit_DMA(canREG1, canMESSAGE_BOX1, Fram_size); // ۽
        }
    }
/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */

void dmaConfigCtrlRxPacket(uint32 sadd, uint32 dadd, uint32 esize, uint32 fsize)
{
    g_dmaCTRLPKT_RX.SADD = sadd; // ּ
    g_dmaCTRLPKT_RX.DADD = dadd; // ּ
    g_dmaCTRLPKT_RX.CHCTRL = 0; //ä
    g_dmaCTRLPKT_RX.FRCNT = fsize; // 
    g_dmaCTRLPKT_RX.ELCNT = esize; // 
    g_dmaCTRLPKT_RX.ELDOFFSET = 1; //  
    g_dmaCTRLPKT_RX.ELSOFFSET = 1; //  
    g_dmaCTRLPKT_RX.FRDOFFSET = 8; //  
    g_dmaCTRLPKT_RX.FRSOFFSET = 0; //  
    g_dmaCTRLPKT_RX.PORTASGN = 4; //Port B Number
    g_dmaCTRLPKT_RX.RDSIZE = ACCESS_8_BIT; //Read ũ
    g_dmaCTRLPKT_RX.WRSIZE = ACCESS_8_BIT; //Write ũ
    g_dmaCTRLPKT_RX.TTYPE = FRAME_TRANSFER; // Ÿ
    g_dmaCTRLPKT_RX.ADDMODERD = ADDR_OFFSET; //Read 
    g_dmaCTRLPKT_RX.ADDMODEWR = ADDR_OFFSET; //Write 
    g_dmaCTRLPKT_RX.AUTOINIT = AUTOINIT_OFF; //ڵ 
}

void dmaConfigCtrlTxPacket(uint32 sadd, uint32 dadd, uint32 esize, uint32 fsize)
{
    g_dmaCTRLPKT_TX.SADD = sadd; // ּ
    g_dmaCTRLPKT_TX.DADD = dadd; // ּ
    g_dmaCTRLPKT_TX.CHCTRL = 0; //ä
    g_dmaCTRLPKT_TX.FRCNT = fsize; // 
    g_dmaCTRLPKT_TX.ELCNT = esize; // 
    g_dmaCTRLPKT_TX.ELDOFFSET = 1; //  
    g_dmaCTRLPKT_TX.ELSOFFSET = 1; //  
    g_dmaCTRLPKT_TX.FRDOFFSET = 0; //  
    g_dmaCTRLPKT_TX.FRSOFFSET = 8; //  
    g_dmaCTRLPKT_TX.PORTASGN = 5; // Port B Number
    g_dmaCTRLPKT_TX.RDSIZE = ACCESS_8_BIT; //Read ũ
    g_dmaCTRLPKT_TX.WRSIZE = ACCESS_8_BIT; //Write ũ
    g_dmaCTRLPKT_TX.TTYPE = FRAME_TRANSFER; // Ÿ
    g_dmaCTRLPKT_TX.ADDMODERD = ADDR_OFFSET; //Read 
    g_dmaCTRLPKT_TX.ADDMODEWR = ADDR_OFFSET; //Write 
    g_dmaCTRLPKT_TX.AUTOINIT = AUTOINIT_OFF; //ڵ 
}

// TX DATA  Լ
void Tx_Value()
{
    uint32 i = 0;
    for(i = 0; i < D_SIZE; i++)
    {
        TX_DATA[i] = i;
    }
}

/* USER CODE END */
