/** @file sys_main.c 
*   @brief Application main file
*   @date 07-July-2017
*   @version 04.07.00
*
*   This file contains an empty main function,
*   which can be used for the application.
*/

/* 
* Copyright (C) 2009-2016 Texas Instruments Incorporated - www.ti.com 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*/


/* USER CODE BEGIN (0) */
/* USER CODE END */

/* Include Files */

#include "sys_common.h"

/* USER CODE BEGIN (1) */
#include "gio.h"
#include "sci.h"
#include "rti.h"
#include "sys_vim.h"
#include "swi_util.h"

#include "pl455.h"

#define nDev_ID 0

int UART_RX_RDY = 0;
int RTI_TIMEOUT = 0;



float getCellVoltage(BYTE *bFrame){
    int i;
    float voltage;
    float packV = 0;
    for(i=1; i<=8; i++){
        voltage = (bFrame[i*2-1]<<8|bFrame[i*2]) * 0.000076295;
        packV+=voltage;
        }
    return packV;
}


/* USER CODE END */

/** @fn void main(void)
*   @brief Application main function
*   @note This function is empty by default.
*
*   This function is called after startup.
*   The user can use this function to implement the application.
*/

/* USER CODE BEGIN (2) */
/* USER CODE END */

int main(void)
{
/* USER CODE BEGIN (3) */
    systemInit();
    gioInit();
    sciInit();
    sciSetBaudrate(scilinREG, BAUDRATE);
    rtiInit();
    vimInit();

    _enable_IRQ();

//    WakePL455();

    CommClear();

    CommReset();
    gioSetDirection(gioPORTA, 0xD7); // pin Direction (7,6,4,2,1,0 as output)


// initialize local variables
    int nSent, nRead, nTopFound = 0;
    float vPack;
    BYTE  bFrame[132];
    uint32  wTemp = 0;




    /** Code examples
     * The command sequences below are examples of the message examples in the bq76PL455 Communication Examples document.
     * each message example references the section in the document.
     */

    // Wake devices ID 0
    // The wake tone will awaken any device that is already in shutdown and the pwrdown will shutdown any device
    // that is already awake. The least number of times to sequence wake and pwrdown will be half the number of
    // boards to cover the worst case combination of boards already awake or shutdown.
    nSent = WriteReg(nDev_ID, 12, 0x40, 1, FRMWRT_SGL_NR);  // send out broadcast pwrdown command
    delayms(5); //~5ms
    WakePL455();
    delayms(5); //~5ms

    // Mask Customer Checksum Fault bit
    nSent = WriteReg(nDev_ID, 107, 0x8000, 2, FRMWRT_SGL_NR); // clear all fault summary flags

    // Clear all faults
    nSent = WriteReg(nDev_ID, 82, 0xFFC0, 2, FRMWRT_SGL_NR);      // clear all fault summary flags
    nSent = WriteReg(nDev_ID, 81, 0x38, 1, FRMWRT_SGL_NR); // clear fault flags in the system status register

    // Set addresses for all boards in daisy-chain (section 1.2.3)
    nSent = WriteReg(nDev_ID, 10, nDev_ID, 1, FRMWRT_SGL_NR); // send address to each board

    // Enable all communication interfaces on all boards in the stack (section 1.2.1)
    nSent = WriteReg(nDev_ID, 16, 0x10F8, 2, FRMWRT_SGL_NR);  // set communications baud rate and enable all interfaces on all boards in stack

    nSent = WriteReg(nDev_ID, 16, 0x1020, 2, FRMWRT_SGL_NR);    // Disable High side receiver on differential (1.2.5)

    nSent = WriteReg(nDev_ID, 16, 0x10C0, 2, FRMWRT_SGL_NR);    // Disable High side receiver on differential (1.2.6)


    // Clear all faults (section 1.2.7)
    nSent = WriteReg(nDev_ID, 82, 0xFFC0, 2, FRMWRT_ALL_NR); // clear all fault summary flags
    nSent = WriteReg(nDev_ID, 81, 0x38, 1, FRMWRT_ALL_NR); // clear fault flags in the system status register

    delayms(10);

    // Configure AFE
    nSent = WriteReg(0, 61, 0x00, 1, FRMWRT_ALL_NR); // set 0 initial delay
    // Configure cell voltage and internal temp sample period
    nSent = WriteReg(0, 62, 0xBC, 1, FRMWRT_ALL_NR); // set 60us cell and 100us temp ADC sample period
    // Configure AUX voltage sample period AUX0-5 are external thermistor, AUX6 is current sense
    nSent = WriteReg(0, 63, 0x44444444, 4, FRMWRT_ALL_NR); // set 12.6us AUX sample period
    // Configure the oversampling rate
    nSent = WriteReg(0, 7, 0x7B, 1, FRMWRT_ALL_NR); // set 8x oversampling, stay on channel for oversample and 12.6us oversample period for cell and AUX
    // Set AFE_PCTL
    nSent = WriteReg(0, 15, 0x80, 1, FRMWRT_ALL_NR); // set AFE_PCTL bit to on (only enable AFE when sampling)


    nSent = WriteReg(nDev_ID, 81, 0x38, 1, FRMWRT_SGL_NR); // clear fault flags in the system status register
    nSent = WriteReg(nDev_ID, 82, 0xFFC0, 2, FRMWRT_SGL_NR); // clear all fault summary flags

    // Select number of cells and channels to sample (section 2.2.5.1)
    nSent = WriteReg(nDev_ID, 13, 0x08, 1, FRMWRT_SGL_NR); // set number of cells to 8
    nSent = WriteReg(nDev_ID, 3, 0x00FFFFC0, 4, FRMWRT_SGL_NR); // select all cell, AUX channels 0 and 1, and internal digital die and internal analog die temperatures

    // Set cell over-voltage and cell under-voltage thresholds on a single board (section 2.2.6.1)
    nSent = WriteReg(nDev_ID, 144, 0xD70A, 2, FRMWRT_SGL_NR); // set OV threshold = 4.2000V
    nSent = WriteReg(nDev_ID, 142, 0x8CCD, 2, FRMWRT_SGL_NR); // set UV threshold = 2.75000V

    // Configure GPIO pin direction and set new pin values (section 5.2.1)
    nSent = WriteReg(nDev_ID, 123, 0x00, 1, FRMWRT_SGL_NR); // turn off all GPIO pull downs
    nSent = WriteReg(nDev_ID, 122, 0x00, 1, FRMWRT_SGL_NR); // turn off all GPIO pull ups
    nSent = WriteReg(nDev_ID, 120, 0x3F, 1, FRMWRT_SGL_NR); // set GPIO[5:0] to output direction
    nSent = WriteReg(nDev_ID, 122, 0x3F, 1, FRMWRT_SGL_NR); // turn on all GPIO pull ups
    nSent = WriteReg(nDev_ID, 121, 0x00, 1, FRMWRT_SGL_NR); // set GPIO outputs (as 0)




    printf("Battery  Management System .\n");


    while(1){


       WakePL455();
       delayms(5); //~5ms

       nSent = WriteReg(nDev_ID, 20, 0, 2, FRMWRT_SGL_NR); //Balancing off
       nSent = WriteReg(nDev_ID, 2, 0x01, 1, FRMWRT_SGL_R); // send sync sample command
       nSent = WaitRespFrame(bFrame, 39, 0); // 16(8 cell voltage) + 4(temp)  bytes data + packet header + CRC, 0ms timeout

        vPack = getCellVoltage(bFrame);
        printf("Pack Voltage= %f\n",vPack);
        delayms(1000);


    }

/* USER CODE END */

    return 0;
}


/* USER CODE BEGIN (4) */
/* USER CODE END */
