/*
 * TLGB_Pagine_Prog.c
 *
 *  Created on: 16/feb/2015
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"

#include "drivers/my_LCD.h"
#include "drivers/tca8418_keypad.h"

#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Comandi_Manuali.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Tempi.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Unita_Misura.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Soglie.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Stringhe.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Decimali.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Duplica_Ricetta.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Rinomina_Ricetta.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Scelta_Lingua.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile prog_lvl0 prog_lvl0_selezionato = prog_lvl0_tempi_st1;
volatile unsigned long refresh_schermo_prog = 1;

//==============================================================================
// Global functions

void gestione_menu_prog_lvl0 (void)
{
	switch(prog_lvl0_selezionato)
	{
		/*
		 * PAGINA PRINCIPALE DEL PROGRAMMA
		 */
		case prog_lvl0_tempi_st1:
		{
			switch(tempi_lvl1_selezionato)
			{
				case tempi_lvl1_pagina_menu:
				{
					if(refresh_schermo_prog == 1)
					{
						refresh_schermo_prog = 0;
						sprintf(MSG, "> %s st1", messaggi[salva.lingua][messaggio_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s st1", messaggi[salva.lingua][messaggio_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s st1", messaggi[salva.lingua][messaggio_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %s st1", messaggi[salva.lingua][messaggio_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							tempi_lvl1_selezionato = tempi_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato--;
							if(prog_lvl0_selezionato == prog_lvl0_pagina_iniziale)
							{
								prog_lvl0_selezionato = prog_lvl0_pagine_totali;
								prog_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato++;
							if(prog_lvl0_selezionato == prog_lvl0_pagine_totali)
							{
								prog_lvl0_selezionato = prog_lvl0_pagina_iniziale;
								prog_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_tempi_lvl1(stazione_1);
				}
				break;
			}
		}
		break;
		case prog_lvl0_soglie_st1:
		{
			switch(soglie_lvl1_selezionato)
			{
				case soglie_lvl1_pagina_menu:
				{
					if(refresh_schermo_prog == 1)
					{
						refresh_schermo_prog = 0;
						sprintf(MSG, "- %s st1", messaggi[salva.lingua][messaggio_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "> %s st1", messaggi[salva.lingua][messaggio_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s st1", messaggi[salva.lingua][messaggio_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %s st1", messaggi[salva.lingua][messaggio_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							soglie_lvl1_selezionato = soglie_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato--;
							if(prog_lvl0_selezionato == prog_lvl0_pagina_iniziale)
							{
								prog_lvl0_selezionato = prog_lvl0_pagine_totali;
								prog_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato++;
							if(prog_lvl0_selezionato == prog_lvl0_pagine_totali)
							{
								prog_lvl0_selezionato = prog_lvl0_pagina_iniziale;
								prog_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_soglie_lvl1(stazione_1);
				}
				break;
			}
		}
		break;
		case prog_lvl0_unita_misura_st1:
		{
			switch(unita_misura_lvl1_selezionato)
			{
				case unita_misura_lvl1_pagina_menu:
				{
					if(refresh_schermo_prog == 1)
					{
						refresh_schermo_prog = 0;
						sprintf(MSG, "- %s st1", messaggi[salva.lingua][messaggio_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s st1", messaggi[salva.lingua][messaggio_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "> %s st1", messaggi[salva.lingua][messaggio_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %s st1", messaggi[salva.lingua][messaggio_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							unita_misura_lvl1_selezionato = unita_misura_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato--;
							if(prog_lvl0_selezionato == prog_lvl0_pagina_iniziale)
							{
								prog_lvl0_selezionato = prog_lvl0_pagine_totali;
								prog_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato++;
							if(prog_lvl0_selezionato == prog_lvl0_pagine_totali)
							{
								prog_lvl0_selezionato = prog_lvl0_pagina_iniziale;
								prog_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_unita_misura_lvl1(stazione_1);
				}
				break;
			}
		}
		break;
		case prog_lvl0_decimali_st1:
		{
			switch(decimali_lvl1_selezionato)
			{
				case decimali_lvl1_pagina_menu:
				{
					if(refresh_schermo_prog == 1)
					{
						refresh_schermo_prog = 0;
						sprintf(MSG, "- %s st1", messaggi[salva.lingua][messaggio_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s st1", messaggi[salva.lingua][messaggio_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s st1", messaggi[salva.lingua][messaggio_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "> %s st1", messaggi[salva.lingua][messaggio_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							decimali_lvl1_selezionato = decimali_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato--;
							if(prog_lvl0_selezionato == prog_lvl0_pagina_iniziale)
							{
								prog_lvl0_selezionato = prog_lvl0_pagine_totali;
								prog_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato++;
							if(prog_lvl0_selezionato == prog_lvl0_pagine_totali)
							{
								prog_lvl0_selezionato = prog_lvl0_pagina_iniziale;
								prog_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_decimali_lvl1(stazione_1);
				}
				break;
			}
		}
		break;
		case prog_lvl0_stringhe_st1:
		{
			switch(stringhe_lvl1_selezionato)
			{
				case stringhe_lvl1_pagina_menu:
				{
					if(refresh_schermo_prog == 1)
					{
						refresh_schermo_prog = 0;
						sprintf(MSG, "> %s st1", messaggi[salva.lingua][messaggio_STRINGHE]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							stringhe_lvl1_selezionato = stringhe_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato--;
							if(prog_lvl0_selezionato == prog_lvl0_pagina_iniziale)
							{
								prog_lvl0_selezionato = prog_lvl0_pagine_totali;
								prog_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato++;
							if(prog_lvl0_selezionato == prog_lvl0_pagine_totali)
							{
								prog_lvl0_selezionato = prog_lvl0_pagina_iniziale;
								prog_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_stringhe_lvl1(stazione_1);
				}
				break;
			}
		}
		break;

		/*
		case prog_lvl0_tempi_st2:
		{
			switch(tempi_lvl1_selezionato)
			{
				case tempi_lvl1_pagina_menu:
				{
					if(refresh_schermo_prog == 1)
					{
						refresh_schermo_prog = 0;
						sprintf(MSG, "> %s st2", messaggi[salva.lingua][messaggio_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s st2", messaggi[salva.lingua][messaggio_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s st2", messaggi[salva.lingua][messaggio_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %s st2", messaggi[salva.lingua][messaggio_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							tempi_lvl1_selezionato = tempi_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato--;
							if(prog_lvl0_selezionato == prog_lvl0_pagina_iniziale)
							{
								prog_lvl0_selezionato = prog_lvl0_pagine_totali;
								prog_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato++;
							if(prog_lvl0_selezionato == prog_lvl0_pagine_totali)
							{
								prog_lvl0_selezionato = prog_lvl0_pagina_iniziale;
								prog_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_tempi_lvl1(stazione_2);
				}
				break;
			}
		}
		break;
		case prog_lvl0_soglie_st2:
		{
			switch(soglie_lvl1_selezionato)
			{
				case soglie_lvl1_pagina_menu:
				{
					if(refresh_schermo_prog == 1)
					{
						refresh_schermo_prog = 0;
						sprintf(MSG, "- %s st2", messaggi[salva.lingua][messaggio_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "> %s st2", messaggi[salva.lingua][messaggio_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s st2", messaggi[salva.lingua][messaggio_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %s st2", messaggi[salva.lingua][messaggio_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							soglie_lvl1_selezionato = soglie_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato--;
							if(prog_lvl0_selezionato == prog_lvl0_pagina_iniziale)
							{
								prog_lvl0_selezionato = prog_lvl0_pagine_totali;
								prog_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato++;
							if(prog_lvl0_selezionato == prog_lvl0_pagine_totali)
							{
								prog_lvl0_selezionato = prog_lvl0_pagina_iniziale;
								prog_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_soglie_lvl1(stazione_2);
				}
				break;
			}
		}
		break;
		case prog_lvl0_unita_misura_st2:
		{
			switch(unita_misura_lvl1_selezionato)
			{
				case unita_misura_lvl1_pagina_menu:
				{
					if(refresh_schermo_prog == 1)
					{
						refresh_schermo_prog = 0;
						sprintf(MSG, "- %s st2", messaggi[salva.lingua][messaggio_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s st2", messaggi[salva.lingua][messaggio_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "> %s st2", messaggi[salva.lingua][messaggio_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %s st2", messaggi[salva.lingua][messaggio_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							unita_misura_lvl1_selezionato = unita_misura_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato--;
							if(prog_lvl0_selezionato == prog_lvl0_pagina_iniziale)
							{
								prog_lvl0_selezionato = prog_lvl0_pagine_totali;
								prog_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato++;
							if(prog_lvl0_selezionato == prog_lvl0_pagine_totali)
							{
								prog_lvl0_selezionato = prog_lvl0_pagina_iniziale;
								prog_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_unita_misura_lvl1(stazione_2);
				}
				break;
			}
		}
		break;
		case prog_lvl0_decimali_st2:
		{
			switch(decimali_lvl1_selezionato)
			{
				case decimali_lvl1_pagina_menu:
				{
					if(refresh_schermo_prog == 1)
					{
						refresh_schermo_prog = 0;
						sprintf(MSG, "- %s st2", messaggi[salva.lingua][messaggio_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s st2", messaggi[salva.lingua][messaggio_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s st2", messaggi[salva.lingua][messaggio_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "> %s st2", messaggi[salva.lingua][messaggio_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							decimali_lvl1_selezionato = decimali_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato--;
							if(prog_lvl0_selezionato == prog_lvl0_pagina_iniziale)
							{
								prog_lvl0_selezionato = prog_lvl0_pagine_totali;
								prog_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato++;
							if(prog_lvl0_selezionato == prog_lvl0_pagine_totali)
							{
								prog_lvl0_selezionato = prog_lvl0_pagina_iniziale;
								prog_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_decimali_lvl1(stazione_2);
				}
				break;
			}
		}
		break;

		case prog_lvl0_stringhe_st2:
		{
			switch(stringhe_lvl1_selezionato)
			{
				case stringhe_lvl1_pagina_menu:
				{
					if(refresh_schermo_prog == 1)
					{
						refresh_schermo_prog = 0;
						sprintf(MSG, "> %s st2", messaggi[salva.lingua][messaggio_STRINGHE]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							stringhe_lvl1_selezionato = stringhe_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato--;
							if(prog_lvl0_selezionato == prog_lvl0_pagina_iniziale)
							{
								prog_lvl0_selezionato = prog_lvl0_pagine_totali;
								prog_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato++;
							if(prog_lvl0_selezionato == prog_lvl0_pagine_totali)
							{
								prog_lvl0_selezionato = prog_lvl0_pagina_iniziale;
								prog_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_stringhe_lvl1(stazione_2);
				}
				break;
			}
		}
		break;
		*/

		case prog_lvl0_comandi_manuali:
		{
			switch(comandi_manuali_lvl1_selezionato)
			{
				case ingressi_uscite_pagina_menu:
				{
					if(refresh_schermo_prog == 1)
					{
						refresh_schermo_prog = 0;
						sprintf(MSG, "> %-18s", messaggi[salva.lingua][messaggio_COMANDI_MANUALI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{

						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							comandi_manuali_lvl1_selezionato = ingressi_uscite_ingresso_1;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato--;
							if(prog_lvl0_selezionato == prog_lvl0_pagina_iniziale)
							{
								prog_lvl0_selezionato = prog_lvl0_pagine_totali;
								prog_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato++;
							if(prog_lvl0_selezionato == prog_lvl0_pagine_totali)
							{
								prog_lvl0_selezionato = prog_lvl0_pagina_iniziale;
								prog_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_comandi_manuali_lvl1();
				}
				break;
			}
		}
		break;

		case prog_lvl0_duplica_ricetta:
		{
			switch(duplica_ricetta_lvl1_selezionato)
			{
				case duplica_ricetta_lvl1_pagina_menu:
				{
					if(refresh_schermo_prog == 1)
					{
						refresh_schermo_prog = 0;
						LCD_Display_Clear();
						sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_DUPLICA_RICETTA]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_RINOMINA_RICETTA]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_ELIMINA_RICETTA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_LINGUA]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_sorgente_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato--;
							if(prog_lvl0_selezionato == prog_lvl0_pagina_iniziale)
							{
								prog_lvl0_selezionato = prog_lvl0_pagine_totali;
								prog_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato++;
							if(prog_lvl0_selezionato == prog_lvl0_pagine_totali)
							{
								prog_lvl0_selezionato = prog_lvl0_pagina_iniziale;
								prog_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_duplica_ricetta_lvl1();
				}
				break;
			}

		}
		break;
		case prog_lvl0_rinomina_ricetta:
		{
			switch(rinomina_ricetta_lvl1_selezionato)
			{
				case rinomina_ricetta_lvl1_pagina_menu:
				{
					if(refresh_schermo_prog == 1)
					{
						refresh_schermo_prog = 0;
						LCD_Display_Clear();
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_DUPLICA_RICETTA]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_RINOMINA_RICETTA]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_ELIMINA_RICETTA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_LINGUA]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_scelta_ricetta_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato--;
							if(prog_lvl0_selezionato == prog_lvl0_pagina_iniziale)
							{
								prog_lvl0_selezionato = prog_lvl0_pagine_totali;
								prog_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato++;
							if(prog_lvl0_selezionato == prog_lvl0_pagine_totali)
							{
								prog_lvl0_selezionato = prog_lvl0_pagina_iniziale;
								prog_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				default:
				{
					gestione_menu_rinomina_ricetta_lvl1();
				}
				break;
			}
		}
		break;
		case prog_lvl0_elimina_ricetta:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_DUPLICA_RICETTA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_RINOMINA_RICETTA]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_ELIMINA_RICETTA]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_LINGUA]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					prog_lvl0_selezionato--;
					if(prog_lvl0_selezionato == prog_lvl0_pagina_iniziale)
					{
						prog_lvl0_selezionato = prog_lvl0_pagine_totali;
						prog_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					prog_lvl0_selezionato++;
					if(prog_lvl0_selezionato == prog_lvl0_pagine_totali)
					{
						prog_lvl0_selezionato = prog_lvl0_pagina_iniziale;
						prog_lvl0_selezionato++;
					}
				}
				break;
			}
		}
		break;
		case prog_lvl0_scelta_lingua:
		{
			switch(scelta_lingua_lvl1_selezionato)
			{
				case scelta_lingua_lvl1_pagina_menu:
				{
					if(refresh_schermo_prog == 1)
					{
						refresh_schermo_prog = 0;
						LCD_Display_Clear();
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_DUPLICA_RICETTA]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_RINOMINA_RICETTA]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_ELIMINA_RICETTA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_LINGUA]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							scelta_lingua_lvl1_selezionato = scelta_lingua_lvl1_italiano;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato--;
							if(prog_lvl0_selezionato == prog_lvl0_pagina_iniziale)
							{
								prog_lvl0_selezionato = prog_lvl0_pagine_totali;
								prog_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_prog = 1;
							prog_lvl0_selezionato++;
							if(prog_lvl0_selezionato == prog_lvl0_pagine_totali)
							{
								prog_lvl0_selezionato = prog_lvl0_pagina_iniziale;
								prog_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_scelta_lingua_lvl1();
				}
				break;
			}
		}
		break;
	}
	return;
}

