/*
 * TLGB_Pagine_Prog_Comandi_Manuali.c
 *
 *  Created on: 28 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"

#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"

#include "TLGB/TLGB_Diginout.h"
#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Comandi_Manuali.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile comandi_manuali_lvl1 comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_comandi_manuali_lvl1 (void)
{
	static unsigned long long Refresh = {0};

	switch(comandi_manuali_lvl1_selezionato)
	{
		case ingressi_uscite_ingresso_1:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615
			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				leggi_ingressi();
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_1], in_visualizzati[0].in1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_2], in_visualizzati[0].in2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_3], in_visualizzati[0].in3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_4], in_visualizzati[0].in4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[0].in1 = 1;
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[0].in1 = 0;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_ingresso_2:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615
			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				leggi_ingressi();
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_1], in_visualizzati[0].in1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_2], in_visualizzati[0].in2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_3], in_visualizzati[0].in3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_4], in_visualizzati[0].in4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[0].in2 = 1;
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[0].in2 = 0;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_ingresso_3:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				leggi_ingressi();
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_1], in_visualizzati[0].in1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_2], in_visualizzati[0].in2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_3], in_visualizzati[0].in3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_4], in_visualizzati[0].in4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[0].in3 = 1;
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[0].in3 = 0;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_ingresso_4:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				leggi_ingressi();
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_1], in_visualizzati[0].in1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_2], in_visualizzati[0].in2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_3], in_visualizzati[0].in3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_4], in_visualizzati[0].in4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[0].in4 = 1;
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[0].in4 = 0;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_ingresso_5:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615
			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				leggi_ingressi();
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_5], in_visualizzati[1].in1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_6], in_visualizzati[1].in2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_7], in_visualizzati[1].in3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_8], in_visualizzati[1].in4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[1].in1 = 1;
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[1].in1 = 0;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_ingresso_6:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				leggi_ingressi();
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_5], in_visualizzati[1].in1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_6], in_visualizzati[1].in2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_7], in_visualizzati[1].in3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_8], in_visualizzati[1].in4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[1].in2 = 1;
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[1].in2 = 0;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_ingresso_7:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				leggi_ingressi();
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_5], in_visualizzati[1].in1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_6], in_visualizzati[1].in2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_7], in_visualizzati[1].in3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_8], in_visualizzati[1].in4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[1].in3 = 1;
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[1].in3 = 0;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_ingresso_8:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				leggi_ingressi();
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_5], in_visualizzati[1].in1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_6], in_visualizzati[1].in2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_7], in_visualizzati[1].in3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_8], in_visualizzati[1].in4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[1].in4 = 1;
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[1].in4 = 0;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_ingresso_9:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				leggi_ingressi();
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_9], in_visualizzati[2].in1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_10], in_visualizzati[2].in2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_11], in_visualizzati[2].in3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_12], in_visualizzati[2].in4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[2].in1 = 1;
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[2].in1 = 0;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_ingresso_10:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				leggi_ingressi();
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_9], in_visualizzati[2].in1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_10], in_visualizzati[2].in2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_11], in_visualizzati[2].in3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_12], in_visualizzati[2].in4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[2].in2 = 1;
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[2].in2 = 0;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_ingresso_11:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				leggi_ingressi();
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_9], in_visualizzati[2].in1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_10], in_visualizzati[2].in2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_11], in_visualizzati[2].in3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_12], in_visualizzati[2].in4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[2].in3 = 1;
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[2].in3 = 0;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_ingresso_12:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				leggi_ingressi();
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_9], in_visualizzati[2].in1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_10], in_visualizzati[2].in2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_11], in_visualizzati[2].in3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_INGRESSO_12], in_visualizzati[2].in4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[2].in4 = 1;
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					in_forzati[2].in4 = 0;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}

		}
		break;

		case ingressi_uscite_uscita_1:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_1], out[0].out1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_2], out[0].out2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_3], out[0].out3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_4], out[0].out4 );
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out1 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out1 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_2:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_1], out[0].out1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_2], out[0].out2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_3], out[0].out3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_4], out[0].out4 );
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out2 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out2 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}

		}
		break;

		case ingressi_uscite_uscita_3:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_1], out[0].out1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_2], out[0].out2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_3], out[0].out3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_4], out[0].out4 );
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out3 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out3 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}

		}
		break;

		case ingressi_uscite_uscita_4:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_1], out[0].out1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_2], out[0].out2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_3], out[0].out3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_4], out[0].out4 );
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out4 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out4 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_5:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_5], out[0].out5);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_6], out[0].out6);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_7], out[0].out7);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_8], out[0].out8);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out5 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out5 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_6:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615
			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_5], out[0].out5);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_6], out[0].out6);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_7], out[0].out7);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_8], out[0].out8);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out6 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out6 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_7:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_5], out[0].out5);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_6], out[0].out6);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_7], out[0].out7);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_8], out[0].out8);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out7 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out7 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_8:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_5], out[0].out5);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_6], out[0].out6);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_7], out[0].out7);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_8], out[0].out8);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out8 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out8 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_9:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_9], out[0].out9);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_10], out[0].out10);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_11], out[0].out11);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_12], out[0].out12);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out9 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out9 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_10:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_9], out[0].out9);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_10], out[0].out10);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_11], out[0].out11);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_12], out[0].out12);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out10 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out10 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_11:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_9], out[0].out9);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_10], out[0].out10);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_11], out[0].out11);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_12], out[0].out12);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out11 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out11 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_12:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_9], out[0].out9);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_10], out[0].out10);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_11], out[0].out11);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_12], out[0].out12);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out12 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[0].out12 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_13:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_13], out[1].out1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_14], out[1].out2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_15], out[1].out3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_16], out[1].out4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out1 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out1 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_14:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_13], out[1].out1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_14], out[1].out2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_15], out[1].out3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_16], out[1].out4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out2 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out2 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_15:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_13], out[1].out1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_14], out[1].out2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_15], out[1].out3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_16], out[1].out4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out3 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out3 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_16:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_13], out[1].out1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_14], out[1].out2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_15], out[1].out3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_16], out[1].out4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out4 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out4 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_17:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_17], out[1].out5);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_18], out[1].out6);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_19], out[1].out7);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_20], out[1].out8);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out5 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out5 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_18:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_17], out[1].out5);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_18], out[1].out6);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_19], out[1].out7);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_20], out[1].out8);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out6 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out6 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_19:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_17], out[1].out5);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_18], out[1].out6);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_19], out[1].out7);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_20], out[1].out8);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out7 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out7 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_20:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_17], out[1].out5);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_18], out[1].out6);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_19], out[1].out7);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_20], out[1].out8);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out8 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out8 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_21:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_21], out[1].out9);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_22], out[1].out10);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_23], out[1].out11);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_24], out[1].out12);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out9 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out9 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_22:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_21], out[1].out9);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_22], out[1].out10);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_23], out[1].out11);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_24], out[1].out12);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out10 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out10 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_23:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_21], out[1].out9);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_22], out[1].out10);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_23], out[1].out11);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_24], out[1].out12);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out11 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out11 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;

		case ingressi_uscite_uscita_24:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_21], out[1].out9);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_22], out[1].out10);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_23], out[1].out11);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_24], out[1].out12);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out12 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[1].out12 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;
		case ingressi_uscite_uscita_25:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_25], out[2].out1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_26], out[2].out2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_27], out[2].out3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_28], out[2].out4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out1 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out1 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;
		case ingressi_uscite_uscita_26:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_25], out[2].out1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_26], out[2].out2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_27], out[2].out3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_28], out[2].out4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out2 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out2 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;
		case ingressi_uscite_uscita_27:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_25], out[2].out1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_26], out[2].out2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_27], out[2].out3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_28], out[2].out4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out3 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out3 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;
		case ingressi_uscite_uscita_28:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_25], out[2].out1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_26], out[2].out2);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_27], out[2].out3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_28], out[2].out4);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out4 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out4 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;
		case ingressi_uscite_uscita_29:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_29], out[2].out5);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_30], out[2].out6);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_31], out[2].out7);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_32], out[2].out8);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out5 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out5 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;
		case ingressi_uscite_uscita_30:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_29], out[2].out5);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_30], out[2].out6);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_31], out[2].out7);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_32], out[2].out8);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out6 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out6 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;
		case ingressi_uscite_uscita_31:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_29], out[2].out5);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_30], out[2].out6);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_31], out[2].out7);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_32], out[2].out8);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out7 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out7 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;
		case ingressi_uscite_uscita_32:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_29], out[2].out5);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_30], out[2].out6);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_31], out[2].out7);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_32], out[2].out8);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out8 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out8 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;
		case ingressi_uscite_uscita_33:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_33], out[2].out9);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_34], out[2].out10);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_35], out[2].out11);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_36], out[2].out12);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out9 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out9 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;
		case ingressi_uscite_uscita_34:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_33], out[2].out9);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_34], out[2].out10);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_35], out[2].out11);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_36], out[2].out12);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out10 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out10 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;
		case ingressi_uscite_uscita_35:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_33], out[2].out9);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_34], out[2].out10);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_35], out[2].out11);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_36], out[2].out12);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out11 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out11 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;
		case ingressi_uscite_uscita_36:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_33], out[2].out9);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_34], out[2].out10);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %-16s %u", messaggi[salva.lingua][messaggio_USCITA_35], out[2].out11);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-16s %u", messaggi[salva.lingua][messaggio_USCITA_36], out[2].out12);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case UNO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out12 = 1;
					scrivi_uscite();
				}
				break;
				case ZERO:
				{
					UltimoTastoPremuto = KEY_NONE;
					out_forzati[2].out12 = 0;
					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato--;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagina_menu)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagine_totali;
						comandi_manuali_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato++;
					if(comandi_manuali_lvl1_selezionato == ingressi_uscite_pagine_totali)
					{
						comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
						comandi_manuali_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
				}
				break;
			}
		}
		break;
	}
	return;
}
