/*
 * TLGB_Pagine_Prog_Duplica_Ricetta.c
 *
 *  Created on: 29 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"
#include "string.h"

#include "driverlib/rom.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"

#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_flash.h"
#include "TLGB/TLGB_Funzioni.h"

#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Duplica_Ricetta.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile duplica_ricetta_lvl1 duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_duplica_ricetta_lvl1 (void)
{
	static E_Programmi sorgente = programma_0;
	static E_Programmi destinazione = programma_0;

	switch(duplica_ricetta_lvl1_selezionato)
	{

		case duplica_ricetta_lvl1_pagina_scelta_sorgente_00:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_SORGENTE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> PRG.00 %s", ricetta.titolo[0]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.01 %s", ricetta.titolo[1]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.02 %s", ricetta.titolo[2]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					sorgente = programma_0;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_00;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_menu)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_sorgente_01:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_SORGENTE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.00 %s", ricetta.titolo[0]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> PRG.01 %s", ricetta.titolo[1]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.02 %s", ricetta.titolo[2]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					sorgente = programma_1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_00;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_menu)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_sorgente_02:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_SORGENTE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.00 %s", ricetta.titolo[0]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.01 %s", ricetta.titolo[1]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> PRG.02 %s", ricetta.titolo[2]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					sorgente = programma_2;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_00;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_menu)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_sorgente_03:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_SORGENTE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> PRG.03 %s", ricetta.titolo[3]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.04 %s", ricetta.titolo[4]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.05 %s", ricetta.titolo[5]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					sorgente = programma_3;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_00;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_menu)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_sorgente_04:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_SORGENTE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.03 %s", ricetta.titolo[3]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> PRG.04 %s", ricetta.titolo[4]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.05 %s", ricetta.titolo[5]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					sorgente = programma_4;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_00;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_menu)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_sorgente_05:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_SORGENTE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.03 %s", ricetta.titolo[3]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.04 %s", ricetta.titolo[4]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> PRG.05 %s", ricetta.titolo[5]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					sorgente = programma_5;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_00;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_menu)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_sorgente_06:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_SORGENTE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> PRG.06 %s", ricetta.titolo[6]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.07 %s", ricetta.titolo[7]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.08 %s", ricetta.titolo[8]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					sorgente = programma_6;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_00;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_menu)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_sorgente_07:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_SORGENTE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.06 %s", ricetta.titolo[6]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> PRG.07 %s", ricetta.titolo[7]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.08 %s", ricetta.titolo[8]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					sorgente = programma_7;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_00;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_menu)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_sorgente_08:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_SORGENTE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.06 %s", ricetta.titolo[6]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.07 %s", ricetta.titolo[7]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> PRG.08 %s", ricetta.titolo[8]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					sorgente = programma_8;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_00;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_menu)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_sorgente_09:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_SORGENTE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> PRG.09 %s", ricetta.titolo[9]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.10 %s", ricetta.titolo[10]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.11 %s", ricetta.titolo[11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					sorgente = programma_9;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_00;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_menu)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_sorgente_10:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_SORGENTE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.09 %s", ricetta.titolo[9]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> PRG.10 %s", ricetta.titolo[10]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.11 %s", ricetta.titolo[11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					sorgente = programma_10;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_00;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_menu)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_sorgente_11:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_SORGENTE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.09 %s", ricetta.titolo[9]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.10 %s", ricetta.titolo[10]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> PRG.11 %s", ricetta.titolo[11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					sorgente = programma_11;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_00;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_menu)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_sorgente_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;


		case duplica_ricetta_lvl1_pagina_scelta_destinazione_00:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_DESTINAZIONE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> PRG.00 %s", ricetta.titolo[0]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.01 %s", ricetta.titolo[1]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.02 %s", ricetta.titolo[2]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					destinazione = programma_0;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_conferma;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_destinazione_01:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_DESTINAZIONE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.00 %s", ricetta.titolo[0]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> PRG.01 %s", ricetta.titolo[1]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.02 %s", ricetta.titolo[2]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					destinazione = programma_1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_conferma;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_destinazione_02:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_DESTINAZIONE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.00 %s", ricetta.titolo[0]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.01 %s", ricetta.titolo[1]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> PRG.02 %s", ricetta.titolo[2]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					destinazione = programma_2;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_conferma;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_destinazione_03:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_DESTINAZIONE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> PRG.03 %s", ricetta.titolo[3]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.04 %s", ricetta.titolo[4]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.05 %s", ricetta.titolo[5]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					destinazione = programma_3;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_conferma;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_destinazione_04:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_DESTINAZIONE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.03 %s", ricetta.titolo[3]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> PRG.04 %s", ricetta.titolo[4]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.05 %s", ricetta.titolo[5]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					destinazione = programma_4;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_conferma;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_destinazione_05:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_DESTINAZIONE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.03 %s", ricetta.titolo[3]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.04 %s", ricetta.titolo[4]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> PRG.05 %s", ricetta.titolo[5]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					destinazione = programma_5;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_conferma;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_destinazione_06:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_DESTINAZIONE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> PRG.06 %s", ricetta.titolo[6]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.07 %s", ricetta.titolo[7]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.08 %s", ricetta.titolo[8]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					destinazione = programma_6;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_conferma;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_destinazione_07:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_DESTINAZIONE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.06 %s", ricetta.titolo[6]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> PRG.07 %s", ricetta.titolo[7]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.08 %s", ricetta.titolo[8]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					destinazione = programma_7;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_conferma;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_destinazione_08:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_DESTINAZIONE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.06 %s", ricetta.titolo[6]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.07 %s", ricetta.titolo[7]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> PRG.08 %s", ricetta.titolo[8]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					destinazione = programma_8;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_conferma;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_destinazione_09:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_DESTINAZIONE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> PRG.09 %s", ricetta.titolo[9]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.10 %s", ricetta.titolo[10]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.11 %s", ricetta.titolo[11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					destinazione = programma_9;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_conferma;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_destinazione_10:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_DESTINAZIONE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.09 %s", ricetta.titolo[9]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> PRG.10 %s", ricetta.titolo[10]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.11 %s", ricetta.titolo[11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					destinazione = programma_10;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_conferma;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case duplica_ricetta_lvl1_pagina_scelta_destinazione_11:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_SELEZIONA_PROGRAMMA_DESTINAZIONE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.09 %s", ricetta.titolo[9]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.10 %s", ricetta.titolo[10]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> PRG.11 %s", ricetta.titolo[11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					destinazione = programma_11;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_conferma;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato--;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali;
						duplica_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato++;
					if(duplica_ricetta_lvl1_selezionato == duplica_ricetta_lvl1_pagina_scelta_destinazione_pagine_totali)
					{
						duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_scelta_destinazione_pagina_iniziale;
						duplica_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case duplica_ricetta_lvl1_pagina_conferma:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", "confermi la copia");
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%-s %02d", "della ricetta", (long)sorgente);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%-s %02d", "nella ricetta", (long)destinazione);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%-s", "Enter = Si, ESC = No");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_esecuzione_in_corso;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_operazione_annullata;
				}
				break;
			}
		}
		break;


		case duplica_ricetta_lvl1_pagina_esecuzione_in_corso:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", "copia in corso");
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%-s", "");
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%-s", "attendere prego");
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%-s", "");
				LCD_WriteLine(4,MSG);
			}


			memcpy(ricetta.titolo[destinazione], ricetta.titolo[sorgente], sizeof(ricetta.titolo[sorgente]));
			memcpy(ricetta.tempi[destinazione], ricetta.tempi[sorgente], sizeof(ricetta.tempi[sorgente]));
			memcpy(ricetta.soglie[destinazione], ricetta.soglie[sorgente], sizeof(ricetta.soglie[sorgente]));

		    ROM_SysCtlDelay(SEC_DELAY);
		    refresh_schermo_prog = 1;
			duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
		}
		break;

		case duplica_ricetta_lvl1_pagina_operazione_annullata:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", "operazione annullata");
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%-s", "");
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%-s", "attendere prego");
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%-s", "");
				LCD_WriteLine(4,MSG);
			}

		    ROM_SysCtlDelay(SEC_DELAY);
		    refresh_schermo_prog = 1;
			duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
		}
		break;

	}
	return;
}
