/*
 * TLGB_Pagine_Prog_Rinomina_Ricetta.c
 *
 *  Created on: 29 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"

#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"

#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_flash.h"
#include "TLGB/TLGB_Funzioni.h"

#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Rinomina_Ricetta.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile rinomina_ricetta_lvl1 rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_rinomina_ricetta_lvl1 (void)
{
	switch(rinomina_ricetta_lvl1_selezionato)
	{
		case rinomina_ricetta_lvl1_pagina_scelta_ricetta_00:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_RINOMINA_PROGRAMMA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> PRG.00 %s", ricetta.titolo[0]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.01 %s", ricetta.titolo[1]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.02 %s", ricetta.titolo[2]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(2, 10, 11, ricetta.titolo[0]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato--;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_menu)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali;
						rinomina_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato++;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
						rinomina_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case rinomina_ricetta_lvl1_pagina_scelta_ricetta_01:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_RINOMINA_PROGRAMMA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.00 %s", ricetta.titolo[0]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> PRG.01 %s", ricetta.titolo[1]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.02 %s", ricetta.titolo[2]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(3, 10, 11, ricetta.titolo[1]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato--;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_menu)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali;
						rinomina_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato++;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
						rinomina_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case rinomina_ricetta_lvl1_pagina_scelta_ricetta_02:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_RINOMINA_PROGRAMMA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.00 %s", ricetta.titolo[0]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.01 %s", ricetta.titolo[1]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> PRG.02 %s", ricetta.titolo[2]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(4, 10, 11, ricetta.titolo[2]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato--;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_menu)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali;
						rinomina_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato++;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
						rinomina_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case rinomina_ricetta_lvl1_pagina_scelta_ricetta_03:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_RINOMINA_PROGRAMMA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> PRG.03 %s", ricetta.titolo[3]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.04 %s", ricetta.titolo[4]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.05 %s", ricetta.titolo[5]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(2, 10, 11, ricetta.titolo[3]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato--;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_menu)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali;
						rinomina_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato++;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
						rinomina_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case rinomina_ricetta_lvl1_pagina_scelta_ricetta_04:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_RINOMINA_PROGRAMMA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.03 %s", ricetta.titolo[3]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> PRG.04 %s", ricetta.titolo[4]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.05 %s", ricetta.titolo[5]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(3, 10, 11, ricetta.titolo[4]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato--;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_menu)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali;
						rinomina_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato++;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
						rinomina_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case rinomina_ricetta_lvl1_pagina_scelta_ricetta_05:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_RINOMINA_PROGRAMMA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.03 %s", ricetta.titolo[3]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.04 %s", ricetta.titolo[4]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> PRG.05 %s", ricetta.titolo[5]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(4, 10, 11, ricetta.titolo[5]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato--;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_menu)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali;
						rinomina_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato++;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
						rinomina_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case rinomina_ricetta_lvl1_pagina_scelta_ricetta_06:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_RINOMINA_PROGRAMMA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> PRG.06 %s", ricetta.titolo[6]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.07 %s", ricetta.titolo[7]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.08 %s", ricetta.titolo[8]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(2, 10, 11, ricetta.titolo[6]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato--;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_menu)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali;
						rinomina_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato++;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
						rinomina_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case rinomina_ricetta_lvl1_pagina_scelta_ricetta_07:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_RINOMINA_PROGRAMMA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.06 %s", ricetta.titolo[6]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> PRG.07 %s", ricetta.titolo[7]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.08 %s", ricetta.titolo[8]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(3, 10, 11, ricetta.titolo[7]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_scelta_ricetta_06;
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_scelta_ricetta_08;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case rinomina_ricetta_lvl1_pagina_scelta_ricetta_08:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_RINOMINA_PROGRAMMA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.06 %s", ricetta.titolo[6]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.07 %s", ricetta.titolo[7]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> PRG.08 %s", ricetta.titolo[8]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(4, 10, 11, ricetta.titolo[8]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato--;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_menu)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali;
						rinomina_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato++;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
						rinomina_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case rinomina_ricetta_lvl1_pagina_scelta_ricetta_09:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_RINOMINA_PROGRAMMA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> PRG.09 %s", ricetta.titolo[9]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.10 %s", ricetta.titolo[10]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.11 %s", ricetta.titolo[11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(2, 10, 11, ricetta.titolo[9]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato--;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_menu)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali;
						rinomina_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato++;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
						rinomina_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case rinomina_ricetta_lvl1_pagina_scelta_ricetta_10:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_RINOMINA_PROGRAMMA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.09 %s", ricetta.titolo[9]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> PRG.10 %s", ricetta.titolo[10]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.11 %s", ricetta.titolo[11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(3, 10, 11, ricetta.titolo[10]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato--;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_menu)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali;
						rinomina_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato++;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
						rinomina_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case rinomina_ricetta_lvl1_pagina_scelta_ricetta_11:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-s", messaggi[salva.lingua][messaggio_RINOMINA_PROGRAMMA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.09 %s", ricetta.titolo[9]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.10 %s", ricetta.titolo[10]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> PRG.11 %s", ricetta.titolo[11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(4, 10, 11, ricetta.titolo[11]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato--;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_menu)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali;
						rinomina_ricetta_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato++;
					if(rinomina_ricetta_lvl1_selezionato == rinomina_ricetta_lvl1_pagina_scelta_ricetta_pagine_totali)
					{
						rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
						rinomina_ricetta_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
	}
	return;
}
