/*
 * TLGB_Pagine_Prog_Scelta_Lingua.c
 *
 *  Created on: 29 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"

#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"

#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_flash.h"
#include "TLGB/TLGB_Funzioni.h"

#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Scelta_Lingua.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile scelta_lingua_lvl1 scelta_lingua_lvl1_selezionato = scelta_lingua_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_scelta_lingua_lvl1 (void)
{
	switch(scelta_lingua_lvl1_selezionato)
	{
		case scelta_lingua_lvl1_italiano:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "> Italiano");
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- English");
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					salva.lingua = lingua_italiano;
					scelta_lingua_lvl1_selezionato = scelta_lingua_lvl1_pagina_menu;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					scelta_lingua_lvl1_selezionato--;
					if(scelta_lingua_lvl1_selezionato == scelta_lingua_lvl1_pagina_menu)
					{
						scelta_lingua_lvl1_selezionato = scelta_lingua_lvl1_pagine_totali;
						scelta_lingua_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					scelta_lingua_lvl1_selezionato++;
					if(scelta_lingua_lvl1_selezionato == scelta_lingua_lvl1_pagine_totali)
					{
						scelta_lingua_lvl1_selezionato = scelta_lingua_lvl1_pagina_menu;
						scelta_lingua_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					scelta_lingua_lvl1_selezionato = scelta_lingua_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case scelta_lingua_lvl1_inglese:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- Italiano");
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> English");
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					salva.lingua = lingua_inglese;
					scelta_lingua_lvl1_selezionato = scelta_lingua_lvl1_pagina_menu;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					scelta_lingua_lvl1_selezionato--;
					if(scelta_lingua_lvl1_selezionato == scelta_lingua_lvl1_pagina_menu)
					{
						scelta_lingua_lvl1_selezionato = scelta_lingua_lvl1_pagine_totali;
						scelta_lingua_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					scelta_lingua_lvl1_selezionato++;
					if(scelta_lingua_lvl1_selezionato == scelta_lingua_lvl1_pagine_totali)
					{
						scelta_lingua_lvl1_selezionato = scelta_lingua_lvl1_pagina_menu;
						scelta_lingua_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					scelta_lingua_lvl1_selezionato = scelta_lingua_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
	}
	return;
}
