/*
 * TLGB_Pagine_Prog_Soglie.c
 *
 *  Created on: 29 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"

#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"

#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_flash.h"
#include "TLGB/TLGB_Funzioni.h"

#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Soglie.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile soglie_lvl1 soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_soglie_lvl1 (E_Stazioni numero_stazione)
{
	char MSG_appo[21] = {0};

	switch(soglie_lvl1_selezionato)
	{
		case soglie_lvl1_00:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S00], unita_misura[ricetta.umis[S00]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S00]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S01], unita_misura[ricetta.umis[S01]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S01]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(2, 3, 8, ricetta.decimali[S00], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S00]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;


		case soglie_lvl1_01:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S00], unita_misura[ricetta.umis[S00]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S00]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S01], unita_misura[ricetta.umis[S01]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S01]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(4, 3, 8, ricetta.decimali[S01], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S01]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case soglie_lvl1_02:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S02], unita_misura[ricetta.umis[S02]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S02]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S03], unita_misura[ricetta.umis[S03]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S03]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(2, 3, 8, ricetta.decimali[S02], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S02]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case soglie_lvl1_03:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S02], unita_misura[ricetta.umis[S02]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S02]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S03], unita_misura[ricetta.umis[S03]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S03]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(4, 3, 8, ricetta.decimali[S03], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S03]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case soglie_lvl1_04:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S04], unita_misura[ricetta.umis[S04]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S04]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S05], unita_misura[ricetta.umis[S05]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S05]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(2, 3, 8, ricetta.decimali[S04], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S04]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case soglie_lvl1_05:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S04], unita_misura[ricetta.umis[S04]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S04]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S05], unita_misura[ricetta.umis[S05]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S05]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(4, 3, 8, ricetta.decimali[S05], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S05]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case soglie_lvl1_06:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S06], unita_misura[ricetta.umis[S06]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S06]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S07], unita_misura[ricetta.umis[S07]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S07]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(2, 3, 8, ricetta.decimali[S06], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S06]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case soglie_lvl1_07:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S06], unita_misura[ricetta.umis[S06]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S06]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S07], unita_misura[ricetta.umis[S07]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S07]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(4, 3, 8, ricetta.decimali[S07], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S07]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case soglie_lvl1_08:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S08], unita_misura[ricetta.umis[S08]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S08]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S09], unita_misura[ricetta.umis[S09]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S09]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(2, 3, 8, ricetta.decimali[S08], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S08]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case soglie_lvl1_09:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S08], unita_misura[ricetta.umis[S08]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S08]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S09], unita_misura[ricetta.umis[S09]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S09]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(4, 3, 8, ricetta.decimali[S09], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S09]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case soglie_lvl1_10:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S10], unita_misura[ricetta.umis[S10]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S10]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S11], unita_misura[ricetta.umis[S11]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(2, 3, 8, ricetta.decimali[S10], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S10]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;


		case soglie_lvl1_11:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S10], unita_misura[ricetta.umis[S10]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S10]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S11], unita_misura[ricetta.umis[S11]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(4, 3, 8, ricetta.decimali[S11], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S11]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case soglie_lvl1_12:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S12], unita_misura[ricetta.umis[S12]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S12]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S13], unita_misura[ricetta.umis[S13]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S13]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(2, 3, 8, ricetta.decimali[S12], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S12]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case soglie_lvl1_13:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S12], unita_misura[ricetta.umis[S12]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S12]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S13], unita_misura[ricetta.umis[S13]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S13]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(4, 3, 8, ricetta.decimali[S13], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S13]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case soglie_lvl1_14:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S14], unita_misura[ricetta.umis[S14]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S14]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S15], unita_misura[ricetta.umis[S15]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S15]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(2, 3, 8, ricetta.decimali[S14], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S14]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case soglie_lvl1_15:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S14], unita_misura[ricetta.umis[S14]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S14]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S15], unita_misura[ricetta.umis[S15]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S15]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(4, 3, 8, ricetta.decimali[S15], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S15]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case soglie_lvl1_16:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S16], unita_misura[ricetta.umis[S16]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S16]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S17], unita_misura[ricetta.umis[S17]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S17]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(2, 3, 8, ricetta.decimali[S16], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S16]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case soglie_lvl1_17:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S16], unita_misura[ricetta.umis[S16]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S16]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S17], unita_misura[ricetta.umis[S17]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S17]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(4, 3, 8, ricetta.decimali[S17], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S17]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case soglie_lvl1_18:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S18], unita_misura[ricetta.umis[S18]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S18]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S19], unita_misura[ricetta.umis[S19]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S19]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(2, 3, 8, ricetta.decimali[S18], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S18]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case soglie_lvl1_19:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf %9s", ricetta.decimali[S18], unita_misura[ricetta.umis[S18]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S18]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf %9s", ricetta.decimali[S19], unita_misura[ricetta.umis[S19]]);
				sprintf(MSG, MSG_appo, ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S19]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_signed_float(4, 3, 8, ricetta.decimali[S19], &ricetta.soglie[salva.programma_attivo[numero_stazione]][numero_stazione][S19]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato--;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagina_menu)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagine_totali;
						soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato++;
					if(soglie_lvl1_selezionato == soglie_lvl1_pagine_totali)
					{
						soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
						soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
	}
	return;
}
