/*
 * TLGB_Pagine_Prog_Stringhe.c
 *
 *  Created on: 29 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"

#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"

#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_flash.h"
#include "TLGB/TLGB_Funzioni.h"

#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Stringhe.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile stringhe_lvl1 stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_stringhe_lvl1 (E_Stazioni numero_stazione)
{
	switch(stringhe_lvl1_selezionato)
	{
		case stringhe_lvl1_00:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR00]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR01]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(2, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR00]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;


		case stringhe_lvl1_01:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR00]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR01]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(4, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR01]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case stringhe_lvl1_02:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR02]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR03]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(2, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR02]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case stringhe_lvl1_03:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR02]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR03]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(4, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR03]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case stringhe_lvl1_04:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR04]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR05]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(2, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR04]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case stringhe_lvl1_05:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR04]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR05]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(4, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR05]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case stringhe_lvl1_06:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR06]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR07]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(2, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR06]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case stringhe_lvl1_07:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR06]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR07]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(4, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR07]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case stringhe_lvl1_08:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR08]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR09]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(2, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR08]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case stringhe_lvl1_09:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR08]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR09]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(4, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR09]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case stringhe_lvl1_10:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR10]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(2, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR10]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;


		case stringhe_lvl1_11:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR10]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(4, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR11]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case stringhe_lvl1_12:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR12]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR13]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(2, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR12]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case stringhe_lvl1_13:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR12]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR13]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(4, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR13]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case stringhe_lvl1_14:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR14]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR15]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(2, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR14]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case stringhe_lvl1_15:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR14]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR15]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(4, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR15]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case stringhe_lvl1_16:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR16]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR17]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(2, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR16]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case stringhe_lvl1_17:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR16]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR17]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(4, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR17]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case stringhe_lvl1_18:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR18]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR19]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(2, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR18]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case stringhe_lvl1_19:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR18]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STR19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %-13s text", ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR19]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					leggi_scrivi_testo(4, 3, 13, ricetta.stringhe[salva.programma_attivo[numero_stazione]][numero_stazione][STR19]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato--;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagina_menu)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagine_totali;
						stringhe_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato++;
					if(stringhe_lvl1_selezionato == stringhe_lvl1_pagine_totali)
					{
						stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
						stringhe_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
	}
	return;
}
