/*
 * TLGB_Pagine_Prog_Tempi.c
 *
 *  Created on: 28 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"

#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"

#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_flash.h"
#include "TLGB/TLGB_Funzioni.h"

#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Tempi.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile tempi_lvl1 tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_tempi_lvl1 (E_Stazioni numero_stazione)
{
	//char MSG_appo[21] = {0};

	switch(tempi_lvl1_selezionato)
	{

		case tempi_lvl1_00:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T00] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T01] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T00]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T00] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_01:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T00] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T01] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T01]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T01] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case tempi_lvl1_02:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T02] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T03] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T02]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T02] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_03:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T02] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T03] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T03]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T03] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_04:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T04] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T05] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T04]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T04] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_05:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T04] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T05] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T05]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T05] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_06:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T06] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T07] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T06]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T06] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_07:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T06] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T07] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T07]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T07] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_08:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T08] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T09] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T08]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T08] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_09:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T08] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T09] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T09]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T09] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_10:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T10] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T11] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T10]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T10] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_11:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T10] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T11] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T11]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T11] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_12:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T12] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T13] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T12]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T12] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_13:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T12] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T13] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T13]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T13] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_14:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T14] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T15] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T14]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T14] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_15:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T14] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T15] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T15]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T15] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_16:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T16] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T17] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T16]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T16] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_17:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T16] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T17] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T17]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T17] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_18:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T18] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T19] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T18]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T18] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case tempi_lvl1_19:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T18] / 1000.0);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_T19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T19] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T19]))
					{
						ricetta.tempi[salva.programma_attivo[numero_stazione]][numero_stazione][T19] *= 1000;
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato--;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagina_menu)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagine_totali;
						tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato++;
					if(tempi_lvl1_selezionato == tempi_lvl1_pagine_totali)
					{
						tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
						tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
	}
	return;
}
