/*
 * TLGB_Pagine_Prog_Unita_Misura.c
 *
 *  Created on: 28 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"

#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"

#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_flash.h"
#include "TLGB/TLGB_Funzioni.h"

#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Unita_Misura.h"

#include "main.h"


//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile unita_misura_lvl1 unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_unita_misura_lvl1 (E_Stazioni numero_stazione)
{
	//char MSG_appo[21] = {0};

	switch(unita_misura_lvl1_selezionato)
	{

		case unita_misura_lvl1_00:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S00]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S01]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(2, 3, &ricetta.umis[S00]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case unita_misura_lvl1_01:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S00]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S01]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(4, 3, &ricetta.umis[S01]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_02:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S02]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S03]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(2, 3, &ricetta.umis[S02]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_03:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S02]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S03]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(4, 3, &ricetta.umis[S03]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_04:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S04]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S05]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(2, 3, &ricetta.umis[S04]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_05:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S04]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S05]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(4, 3, &ricetta.umis[S05]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_06:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S06]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S07]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(2, 3, &ricetta.umis[S06]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_07:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S06]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S07]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(4, 3, &ricetta.umis[S07]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_08:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S08]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S09]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(2, 3, &ricetta.umis[S08]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_09:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S08]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S09]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(4, 3, &ricetta.umis[S09]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_10:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S10]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S11]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(2, 3, &ricetta.umis[S10]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_11:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S10]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S11]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(4, 3, &ricetta.umis[S11]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_12:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S12]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S13]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(2, 3, &ricetta.umis[S12]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_13:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S12]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S13]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(4, 3, &ricetta.umis[S13]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_14:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S14]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S15]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(2, 3, &ricetta.umis[S14]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_15:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S14]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S15]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(4, 3, &ricetta.umis[S15]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_16:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S16]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S17]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(2, 3, &ricetta.umis[S16]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_17:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S16]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S17]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(4, 3, &ricetta.umis[S17]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_18:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S18]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S19]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(2, 3, &ricetta.umis[S18]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case unita_misura_lvl1_19:
		{
			if(refresh_schermo_prog == 1)
			{
				refresh_schermo_prog = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[ricetta.umis[S18]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_S19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[ricetta.umis[S19]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					seleziona_umis(4, 3, &ricetta.umis[S19]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato--;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagina_menu)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagine_totali;
						unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato++;
					if(unita_misura_lvl1_selezionato == unita_misura_lvl1_pagine_totali)
					{
						unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
						unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_prog = 1;
					unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
	}
	return;
}
