/*
 * TLGB_Pagine.c
 *
 *  Created on: 10/feb/2015
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"
#include "stdbool.h"
#include "string.h"


#include "driverlib/rom.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"

#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_flash.h"
#include "TLGB/TLGB_Funzioni.h"

#include "utils/uartstdio.h"

#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run.h"
#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run_Scelta_Pezzo.h"
#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run_Lotti.h"
#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run_Statistiche.h"
#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run_Risultati.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions


//==============================================================================
// Global variables

volatile run_lvl0 run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
volatile invia_esito_lvl1 invia_esito_lvl1_selezionato = invia_esito_lvl1_pagina_menu;

volatile unsigned long refresh_schermo_run = 1;

//==============================================================================
// Global functions

void gestione_menu_run_lvl0 (void)
{
	static unsigned long long Refresh = {0};
	//static unsigned long contatore = {0};
	//char s_appoggio[21] = {0};

	switch(run_lvl0_selezionato)
	{

		// PAGINA PRINCIPALE DEL PROGRAMMA
		case run_lvl0_pagina_principale_st1:
		{

			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				//LCD_Display_Clear();
			}

			if(GetTimerMs(Refresh) > 100)
			{
			    ResetTimerMs(&Refresh);
				sprintf(MSG, "St.1 Prog.%02d T000.0s", salva.programma_attivo[stazione_1]);
				LCD_WriteLine(1,MSG);
				//sprintf(MSG, "%s", messaggi[salva.lingua][MessaggioDaVisualizzare[stazione_1]]);
				//LCD_WriteLine(2,MSG);
				//sprintf(s_appoggio, "%s %%+08.%uf %s", messaggi[salva.lingua][messaggio_PRESSIONE], ricetta.decimali[S02], unita_misura[ricetta.umis[S02]]);
				//sprintf(MSG, s_appoggio, VariabiliProvaPezzo[stazione_1].PressionePrimaPagina);
				//LCD_WriteLine(3,MSG);
				//sprintf(s_appoggio, "%s %%+08.%uf %s", messaggi[salva.lingua][messaggio_PERDITA], ricetta.decimali[S04], unita_misura[ricetta.umis[S04]]);
				//sprintf(MSG, s_appoggio, VariabiliProvaPezzo[stazione_1].PortataPrimaPagina);
				//LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					refresh_schermo_run = 1;
					run_lvl0_selezionato = run_lvl0_lotti_st1;
					UltimoTastoPremuto = KEY_NONE;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato--;
					if(run_lvl0_selezionato == run_lvl0_pagina_principale_pagina_iniziale)
					{
						run_lvl0_selezionato = run_lvl0_pagina_principale_pagine_totali;
						run_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato++;
					if(run_lvl0_selezionato == run_lvl0_pagina_principale_pagine_totali)
					{
						run_lvl0_selezionato = run_lvl0_pagina_principale_pagina_iniziale;
						run_lvl0_selezionato++;
					}
				}
				break;
			}
		}
		break;

		/*
		case run_lvl0_pagina_principale_st2:
		{

			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				//LCD_Display_Clear();
			}

			if(GetTimerMs(Refresh) > 100)
			{
			    ResetTimerMs(&Refresh);
				sprintf(MSG, "St.2 Prog.%02d T000.0s", salva.programma_attivo[stazione_2]);
				LCD_WriteLine(1,MSG);
				//sprintf(MSG, "%s", messaggi[salva.lingua][MessaggioDaVisualizzare[stazione_2]]);
				//LCD_WriteLine(2,MSG);
				//sprintf(s_appoggio, "%s %%+08.%uf %s", messaggi[salva.lingua][messaggio_PRESSIONE], ricetta.decimali[S02], unita_misura[ricetta.umis[S02]]);
				//sprintf(MSG, s_appoggio, VariabiliProvaPezzo[stazione_2].PressionePrimaPagina);
				//LCD_WriteLine(3,MSG);
				//sprintf(s_appoggio, "%s %%+08.%uf %s", messaggi[salva.lingua][messaggio_PERDITA], ricetta.decimali[S04], unita_misura[ricetta.umis[S04]]);
				//sprintf(MSG, s_appoggio, VariabiliProvaPezzo[stazione_2].PortataPrimaPagina);
				//LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					refresh_schermo_run = 1;
					run_lvl0_selezionato = run_lvl0_lotti_st1;
					UltimoTastoPremuto = KEY_NONE;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato--;
					if(run_lvl0_selezionato == run_lvl0_pagina_principale_pagina_iniziale)
					{
						run_lvl0_selezionato = run_lvl0_pagina_principale_pagine_totali;
						run_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato++;
					if(run_lvl0_selezionato == run_lvl0_pagina_principale_pagine_totali)
					{
						run_lvl0_selezionato = run_lvl0_pagina_principale_pagina_iniziale;
						run_lvl0_selezionato++;
					}
				}
				break;
			}
		}
		break;
		*/

		// PAGINA MENU -> lotti ST1
		case run_lvl0_lotti_st1:
		{
			switch(lotti_lvl1_selezionato)
			{

				case lotti_lvl1_pagina_menu:
				{
					if(refresh_schermo_run == 1)
					{
						refresh_schermo_run = 0;
						sprintf(MSG, "> %-14s st%d", messaggi[salva.lingua][messaggio_CONTATORI], stazione_1 + 1);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_RISULTATI], stazione_1 + 1);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_SCELTA_PEZZO], stazione_1 + 1);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_INVIA_ESITO], stazione_1 + 1);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							lotti_lvl1_selezionato = lotti_lvl1_valori;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato--;
							if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
							{
								run_lvl0_selezionato = run_lvl0_pagine_totali;
								run_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato++;
							if(run_lvl0_selezionato == run_lvl0_pagine_totali)
							{
								run_lvl0_selezionato = run_lvl0_pagine_iniziale;
								run_lvl0_selezionato++;
							}
						}
						break;
						case CLR:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_lotti_lvl1(stazione_1);
				}
				break;
			}
		}
		break;

		// PAGINA MENU -> RISULTATI ST1
		case run_lvl0_risultati_st1:
		{

			switch(risultati_lvl1_selezionato)
			{

				case risultati_lvl1_pagina_menu:
				{
					if(refresh_schermo_run == 1)
					{
						refresh_schermo_run = 0;
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_CONTATORI], stazione_1 + 1);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "> %-14s st%d", messaggi[salva.lingua][messaggio_RISULTATI], stazione_1 + 1);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_SCELTA_PEZZO], stazione_1 + 1);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_INVIA_ESITO], stazione_1 + 1);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							risultati_lvl1_selezionato = risultati_lvl1_pagina_menu;
							risultati_lvl1_selezionato++;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato--;
							if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
							{
								run_lvl0_selezionato = run_lvl0_pagine_totali;
								run_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato++;
							if(run_lvl0_selezionato == run_lvl0_pagine_totali)
							{
								run_lvl0_selezionato = run_lvl0_pagine_iniziale;
								run_lvl0_selezionato++;
							}
						}
						break;
						case CLR:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_risultati_lvl1(stazione_1);
				}
				break;
			}

		}
		break;

		// PAGINA MENU -> SCELTA PEZZO ST1
		case run_lvl0_scelta_pezzo_st1:
		{

			switch(scelta_pezzo_lvl1_selezionato)
			{

				case scelta_pezzo_lvl1_pagina_menu:
				{
					if(refresh_schermo_run == 1)
					{
						refresh_schermo_run = 0;
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_CONTATORI], stazione_1 + 1);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_RISULTATI], stazione_1 + 1);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "> %-14s st%d", messaggi[salva.lingua][messaggio_SCELTA_PEZZO], stazione_1 + 1);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_INVIA_ESITO], stazione_1 + 1);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_prog_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato--;
							if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
							{
								run_lvl0_selezionato = run_lvl0_pagine_totali;
								run_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato++;
							if(run_lvl0_selezionato == run_lvl0_pagine_totali)
							{
								run_lvl0_selezionato = run_lvl0_pagine_iniziale;
								run_lvl0_selezionato++;
							}
						}
						break;
						case CLR:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_scelta_pezzo_lvl1(stazione_1);
				}
				break;
			}
		}
		break;

		// PAGINA MENU -> INVIA ESITO ST1
		case run_lvl0_invia_esito_st1:
		{
			switch(invia_esito_lvl1_selezionato)
			{
				case invia_esito_lvl1_pagina_menu:
				{
					if(refresh_schermo_run == 1)
					{
						refresh_schermo_run = 0;
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_CONTATORI], stazione_1 + 1);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_RISULTATI], stazione_1 + 1);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_SCELTA_PEZZO], stazione_1 + 1);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "> %-14s st%d", messaggi[salva.lingua][messaggio_INVIA_ESITO], stazione_1 + 1);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						//case ENTER:
						//{
						//	UltimoTastoPremuto = KEY_NONE;
						//	refresh_schermo_run = 1;
						//	invia_esito_lvl1_selezionato = invia_esito_lvl1_invio;
						//}
						//break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato--;
							if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
							{
								run_lvl0_selezionato = run_lvl0_pagine_totali;
								run_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato++;
							if(run_lvl0_selezionato == run_lvl0_pagine_totali)
							{
								run_lvl0_selezionato = run_lvl0_pagine_iniziale;
								run_lvl0_selezionato++;
							}
						}
						break;
						case CLR:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
						}
						break;
					}
				}
				break;
				//case invia_esito_lvl1_invio:
				//{
				//	gestione_menu_invia_esito_lvl1(stazione_1);
				//}
				//break;
			}
		}
		break;

		case run_lvl0_statistiche_st1:
		{
			switch(statistiche_lvl1_selezionato)
			{
				case statistiche_lvl1_pagina_menu:
				{
					if(refresh_schermo_run == 1)
					{
						refresh_schermo_run = 0;
						sprintf(MSG, "> %-14s st%d", messaggi[salva.lingua][messaggio_STATISTICHE], stazione_1 + 1);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_STAMPA_ETICHETTA], stazione_1 + 1);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							statistiche_lvl1_selezionato = statistiche_lvl1_pag_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato--;
							if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
							{
								run_lvl0_selezionato = run_lvl0_pagine_totali;
								run_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato++;
							if(run_lvl0_selezionato == run_lvl0_pagine_totali)
							{
								run_lvl0_selezionato = run_lvl0_pagine_iniziale;
								run_lvl0_selezionato++;
							}
						}
						break;
						case CLR:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_statistiche_lvl1(stazione_1);
				}
				break;
			}
		}
		break;

		case run_lvl0_stampa_etichetta_st1:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_STATISTICHE], stazione_1 + 1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %-14s st%d", messaggi[salva.lingua][messaggio_STAMPA_ETICHETTA], stazione_1 + 1);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;

					// Scrivo la stringa per stampare l'etichetta
					UARTprintf("%c%c%c%cCT~~CD,~CC^~CT~\n" // EF BB BF 10 43 54 7E 7E 43 44 2C 7E 43 43 5E 7E 43 54 7E 0D 0A
							"^XA~TA000~JSN^LT0^MNW^MTT^PON^PMN^LH0,0^JMA^PR3,3~SD7^JUS^LRN^CI0^XZ\n" // 5E 58 41 7E 54 41 30 30 30 7E 4A 53 4E 5E 4C 54 30 5E 4D 4E 57 5E 4D 54 54 5E 50 4F 4E 5E 50 4D 4E 5E 4C 48 30 2C 30 5E 4A 4D 41 5E 50 52 33 2C 33 7E 53 44 37 5E 4A 55 53 5E 4C 52 4E 5E 43 49 30 5E 58 5A 0D 0A
							"^XA\n" // 5E 58 41 0D 0A
							"^MMT\n" // 5E 4D 4D 54 0D 0A
							"^PW176\n" // 5E 50 57 31 37 36 0D 0A
							"^LL0320\n" // 5E 4C 4C 30 33 32 30 0D 0A
							"^LS0\n" // 5E 4C 53 30 0D 0A
							"^BY2,2.5,105^FT46,44^B3R,N,,Y,N\n" // 5E 42 59 32 2C 32 2E 35 2C 31 30 35 5E 46 54 34 36 2C 34 34 5E 42 33 52 2C 4E 2C 2C 59 2C 4E 0D 0A
							"^FD%s^FS\n" // 5E 46 44 ????? 5E 46 53 0D 0A // qui devo inserire la stringa che voglio marcare
							"^PQ1,0,1,Y^XZ\n" // 5E 50 51 31 2C 30 2C 31 2C 59 5E 58 5A 0D 0A
							, 0xEF
							, 0xBB
							, 0xBF
							, 0x10
							, ricetta.stringhe[salva.programma_attivo[0]][0][STR00]);

					// svuoto il buffer di uscita attendendo che siano stati inviati tutti i byte
					UARTFlushTx(0);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato--;
					if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
					{
						run_lvl0_selezionato = run_lvl0_pagine_totali;
						run_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato++;
					if(run_lvl0_selezionato == run_lvl0_pagine_totali)
					{
						run_lvl0_selezionato = run_lvl0_pagine_iniziale;
						run_lvl0_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
				}
				break;
			}
		}
		break;

		case run_lvl0_scorta_st1_2:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_STATISTICHE], stazione_1 + 1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_STAMPA_ETICHETTA], stazione_1 + 1);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, ">");
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato--;
					if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
					{
						run_lvl0_selezionato = run_lvl0_pagine_totali;
						run_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato++;
					if(run_lvl0_selezionato == run_lvl0_pagine_totali)
					{
						run_lvl0_selezionato = run_lvl0_pagine_iniziale;
						run_lvl0_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
				}
				break;
			}
		}
		break;

		case run_lvl0_scorta_st1_3:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_STATISTICHE], stazione_1 + 1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_STAMPA_ETICHETTA], stazione_1 + 1);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(3,MSG);
				sprintf(MSG, ">");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato--;
					if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
					{
						run_lvl0_selezionato = run_lvl0_pagine_totali;
						run_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato++;
					if(run_lvl0_selezionato == run_lvl0_pagine_totali)
					{
						run_lvl0_selezionato = run_lvl0_pagine_iniziale;
						run_lvl0_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
				}
				break;
			}
		}
		break;

		/*
		// PAGINA MENU -> CONTATORI ST2
		case run_lvl0_lotti_st2:
		{
			switch(lotti_lvl1_selezionato)
			{
				case lotti_lvl1_pagina_menu:
				{
					if(refresh_schermo_run == 1)
					{
						refresh_schermo_run = 0;
						sprintf(MSG, "> %-14s st%d", messaggi[salva.lingua][messaggio_CONTATORI], stazione_2 + 1);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_RISULTATI], stazione_2 + 1);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_SCELTA_PEZZO], stazione_2 + 1);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_INVIA_ESITO], stazione_2 + 1);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							lotti_lvl1_selezionato = lotti_lvl1_valori;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato--;
							if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
							{
								run_lvl0_selezionato = run_lvl0_pagine_totali;
								run_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato++;
							if(run_lvl0_selezionato == run_lvl0_pagine_totali)
							{
								run_lvl0_selezionato = run_lvl0_pagine_iniziale;
								run_lvl0_selezionato++;
							}
						}
						break;
						case CLR:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_lotti_lvl1(stazione_2);
				}
				break;
			}
		}
		break;

		// PAGINA MENU -> RISULTATI ST2
		case run_lvl0_risultati_st2:
		{

			switch(risultati_lvl1_selezionato)
			{

				case risultati_lvl1_pagina_menu:
				{
					if(refresh_schermo_run == 1)
					{
						refresh_schermo_run = 0;
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_CONTATORI], stazione_2 + 1);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "> %-14s st%d", messaggi[salva.lingua][messaggio_RISULTATI], stazione_2 + 1);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_SCELTA_PEZZO], stazione_2 + 1);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_INVIA_ESITO], stazione_2 + 1);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							risultati_lvl1_selezionato = risultati_lvl1_pagina_menu;
							risultati_lvl1_selezionato++;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato--;
							if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
							{
								run_lvl0_selezionato = run_lvl0_pagine_totali;
								run_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato++;
							if(run_lvl0_selezionato == run_lvl0_pagine_totali)
							{
								run_lvl0_selezionato = run_lvl0_pagine_iniziale;
								run_lvl0_selezionato++;
							}
						}
						break;
						case CLR:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_risultati_lvl1(stazione_2);
				}
				break;
			}

		}
		break;

		// PAGINA MENU -> SCELTA PEZZO ST2
		case run_lvl0_scelta_pezzo_st2:
		{
			switch(scelta_pezzo_lvl1_selezionato)
			{

				case scelta_pezzo_lvl1_pagina_menu:
				{
					if(refresh_schermo_run == 1)
					{
						refresh_schermo_run = 0;
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_CONTATORI], stazione_2 + 1);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_RISULTATI], stazione_2 + 1);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "> %-14s st%d", messaggi[salva.lingua][messaggio_SCELTA_PEZZO], stazione_2 + 1);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_INVIA_ESITO], stazione_2 + 1);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_prog_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato--;
							if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
							{
								run_lvl0_selezionato = run_lvl0_pagine_totali;
								run_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato++;
							if(run_lvl0_selezionato == run_lvl0_pagine_totali)
							{
								run_lvl0_selezionato = run_lvl0_pagine_iniziale;
								run_lvl0_selezionato++;
							}
						}
						break;
						case CLR:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_scelta_pezzo_lvl1(stazione_2);
				}
				break;
			}
		}
		break;

		// PAGINA MENU -> INVIA ESITO ST2
		case run_lvl0_invia_esito_st2:
		{
			switch(invia_esito_lvl1_selezionato)
			{
				case invia_esito_lvl1_pagina_menu:
				{
					if(refresh_schermo_run == 1)
					{
						refresh_schermo_run = 0;
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_CONTATORI], stazione_2 + 1);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_RISULTATI], stazione_2 + 1);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_SCELTA_PEZZO], stazione_2 + 1);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "> %-14s st%d", messaggi[salva.lingua][messaggio_INVIA_ESITO], stazione_2 + 1);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						//case ENTER:
						//{
						//	UltimoTastoPremuto = KEY_NONE;
						//	refresh_schermo_run = 1;
						//	invia_esito_lvl1_selezionato = invia_esito_lvl1_invio;
						//}
						//break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato--;
							if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
							{
								run_lvl0_selezionato = run_lvl0_pagine_totali;
								run_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato++;
							if(run_lvl0_selezionato == run_lvl0_pagine_totali)
							{
								run_lvl0_selezionato = run_lvl0_pagine_iniziale;
								run_lvl0_selezionato++;
							}
						}
						break;
						case CLR:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
						}
						break;
					}
				}
				break;
				//default:
				//{
				//	gestione_menu_invia_esito_lvl1(stazione_2);
				//}
				//break;
			}
		}
		break;

		case run_lvl0_statistiche_st2:
		{
			switch(statistiche_lvl1_selezionato)
			{
				case statistiche_lvl1_pagina_menu:
				{
					if(refresh_schermo_run == 1)
					{
						refresh_schermo_run = 0;
						sprintf(MSG, "> %-14s st%d", messaggi[salva.lingua][messaggio_STATISTICHE], stazione_2 + 1);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							statistiche_lvl1_selezionato = statistiche_lvl1_pag_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato--;
							if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
							{
								run_lvl0_selezionato = run_lvl0_pagine_totali;
								run_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato++;
							if(run_lvl0_selezionato == run_lvl0_pagine_totali)
							{
								run_lvl0_selezionato = run_lvl0_pagine_iniziale;
								run_lvl0_selezionato++;
							}
						}
						break;
						case CLR:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_run = 1;
							run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_statistiche_lvl1(stazione_2);
				}
				break;
			}
		}
		break;

		case run_lvl0_scorta_st2_1:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_STATISTICHE], stazione_2 + 1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, ">");
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato--;
					if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
					{
						run_lvl0_selezionato = run_lvl0_pagine_totali;
						run_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato++;
					if(run_lvl0_selezionato == run_lvl0_pagine_totali)
					{
						run_lvl0_selezionato = run_lvl0_pagine_iniziale;
						run_lvl0_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
				}
				break;
			}
		}
		break;

		case run_lvl0_scorta_st2_2:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_STATISTICHE], stazione_2 + 1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(2,MSG);
				sprintf(MSG, ">");
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato--;
					if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
					{
						run_lvl0_selezionato = run_lvl0_pagine_totali;
						run_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato++;
					if(run_lvl0_selezionato == run_lvl0_pagine_totali)
					{
						run_lvl0_selezionato = run_lvl0_pagine_iniziale;
						run_lvl0_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
				}
				break;
			}
		}
		break;

		case run_lvl0_scorta_st2_3:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				sprintf(MSG, "- %-14s st%d", messaggi[salva.lingua][messaggio_STATISTICHE], stazione_2 + 1);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(3,MSG);
				sprintf(MSG, ">");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato--;
					if(run_lvl0_selezionato == run_lvl0_pagine_iniziale)
					{
						run_lvl0_selezionato = run_lvl0_pagine_totali;
						run_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato++;
					if(run_lvl0_selezionato == run_lvl0_pagine_totali)
					{
						run_lvl0_selezionato = run_lvl0_pagine_iniziale;
						run_lvl0_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
				}
				break;
			}
		}
		break;
		*/
	}
	return;
}
