/*
 * TLGB_Pagine_Run_Lotti.c
 *
 *  Created on: 29 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"

#include "driverlib/rom.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"

#include "TLGB/TLGB_Contatori.h"
#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run.h"
#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run_Lotti.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile lotti_lvl1 lotti_lvl1_selezionato = lotti_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_lotti_lvl1 (E_Stazioni numero_stazione)
{
	switch(lotti_lvl1_selezionato)
	{
		case lotti_lvl1_valori:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%-10s %09u", messaggi[salva.lingua][messaggio_TOTALE], Lotto[numero_stazione].Anomalie + Lotto[numero_stazione].Buoni + Lotto[numero_stazione].Incerti + Lotto[numero_stazione].Scarti);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%-10s %09u", messaggi[salva.lingua][messaggio_BUONI], Lotto[numero_stazione].Buoni);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%-10s %09u", messaggi[salva.lingua][messaggio_INCERTI], Lotto[numero_stazione].Incerti);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%-10s %09u", messaggi[salva.lingua][messaggio_SCARTI], Lotto[numero_stazione].Scarti);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					lotti_lvl1_selezionato = lotti_lvl1_conferma_azzeramento;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					lotti_lvl1_selezionato = lotti_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case lotti_lvl1_conferma_azzeramento:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_VUOI_AZZERARE_IL]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_LOTTO_ATTUALE]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ENTER_SI]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_CLR_NO]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					lotti_lvl1_selezionato = lotti_lvl1_azzeramento_in_corso;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					lotti_lvl1_selezionato = lotti_lvl1_operazione_annullata;
				}
				break;
			}
		}
		break;
		case lotti_lvl1_azzeramento_in_corso:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_AZZERAMENTO_IN_CORSO]);
				LCD_WriteLine(1,MSG);
				//sprintf(MSG,"                    ");
				//LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ATTENDERE_PREGO]);
				LCD_WriteLine(3,MSG);
				//sprintf(MSG,"                    ");
				//LCD_WriteLine(4,MSG);
			}
			AzzeraLotto (numero_stazione);

		    ROM_SysCtlDelay(SEC_DELAY);

			refresh_schermo_run = 1;
			lotti_lvl1_selezionato = lotti_lvl1_valori;
		}
		break;
		case lotti_lvl1_operazione_annullata:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_OPERAZIONE_ANNULLATA]);
				LCD_WriteLine(1,MSG);
				//sprintf(MSG,"                    ");
				//LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ATTENDERE_PREGO]);
				LCD_WriteLine(3,MSG);
				//sprintf(MSG,"                    ");
				//LCD_WriteLine(4,MSG);
			}
		    ROM_SysCtlDelay(SEC_DELAY);

		    refresh_schermo_run = 1;
			lotti_lvl1_selezionato = lotti_lvl1_valori;
		}
		break;
	}
	return;
}
