/*
 * TLGB_Pagine_Run_Risultati.c
 *
 *  Created on: 29 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"

#include "driverlib/rom.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"

#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_flash.h"
#include "TLGB/TLGB_Funzioni.h"

#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run.h"
#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run_Risultati.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile risultati_lvl1 risultati_lvl1_selezionato = risultati_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_risultati_lvl1 (E_Stazioni numero_stazione)
{
	//char s_appoggio[21] = {0};
	static unsigned long long Refresh = {0};

	switch(risultati_lvl1_selezionato)
	{

		case risultati_lvl1_pag_01:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();

				sprintf(MSG, "%s %d/%d", messaggi[salva.lingua][messaggio_TITOLO_1], risultati_lvl1_selezionato, risultati_lvl1_pagine_totali - 1);
				LCD_WriteLine(1,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);
				//sprintf(s_appoggio, "%s %%+08.%uf %s", messaggi[salva.lingua][messaggio_VALORE_1], ricetta.decimali[S00], unita_misura[ricetta.umis[S00]]);
				//sprintf(MSG, s_appoggio, VariabiliProvaPezzo[numero_stazione].PressioneZero);
				//LCD_WriteLine(2,MSG);
				//sprintf(s_appoggio, "%s %%+08.%uf %s", messaggi[salva.lingua][messaggio_VALORE_2], ricetta.decimali[S00], unita_misura[ricetta.umis[S00]]);
				//sprintf(MSG, s_appoggio, VariabiliProvaPezzo[numero_stazione].PortataZero);
				//LCD_WriteLine(3,MSG);
				//sprintf(s_appoggio, "%s %%+08.%uf %s", messaggi[salva.lingua][messaggio_VALORE_3], ricetta.decimali[S02], unita_misura[ricetta.umis[S02]]);
				//sprintf(MSG, s_appoggio, VariabiliProvaPezzo[numero_stazione].PressioneRiempimentoIniziale);
				//LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					risultati_lvl1_selezionato--;
					if(risultati_lvl1_selezionato == risultati_lvl1_pagina_menu)
					{
						risultati_lvl1_selezionato = risultati_lvl1_pagine_totali;
						risultati_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					risultati_lvl1_selezionato++;
					if(risultati_lvl1_selezionato == risultati_lvl1_pagine_totali)
					{
						risultati_lvl1_selezionato = risultati_lvl1_pagina_menu;
						risultati_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					risultati_lvl1_selezionato = risultati_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		/*
		case risultati_lvl1_pag_02:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s %d/%d", messaggi[salva.lingua][messaggio_TITOLO_2], risultati_lvl1_selezionato, risultati_lvl1_pagine_totali - 1);
				LCD_WriteLine(1,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);
				//sprintf(s_appoggio, "%s %%+08.%uf %s", messaggi[salva.lingua][messaggio_VALORE_4], ricetta.decimali[S02], unita_misura[ricetta.umis[S02]]);
				//sprintf(MSG, s_appoggio, VariabiliProvaPezzo[numero_stazione].PressioneRiempimento);
				//LCD_WriteLine(2,MSG);
				//sprintf(s_appoggio, "%s %%+08.%uf %s", messaggi[salva.lingua][messaggio_VALORE_5], ricetta.decimali[S00], unita_misura[ricetta.umis[S00]]);
				//sprintf(MSG, s_appoggio, VariabiliProvaPezzo[numero_stazione].PortataRiempimento);
				//LCD_WriteLine(3,MSG);
				//sprintf(s_appoggio, "%s %%+08.%uf %s", messaggi[salva.lingua][messaggio_VALORE_6], ricetta.decimali[S00], unita_misura[ricetta.umis[S00]]);
				//sprintf(MSG, s_appoggio, VariabiliProvaPezzo[numero_stazione].PortataMisura);
				//LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					risultati_lvl1_selezionato--;
					if(risultati_lvl1_selezionato == risultati_lvl1_pagina_menu)
					{
						risultati_lvl1_selezionato = risultati_lvl1_pagine_totali;
						risultati_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					risultati_lvl1_selezionato++;
					if(risultati_lvl1_selezionato == risultati_lvl1_pagine_totali)
					{
						risultati_lvl1_selezionato = risultati_lvl1_pagina_menu;
						risultati_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					risultati_lvl1_selezionato = risultati_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case risultati_lvl1_pag_03:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s %d/%d", messaggi[salva.lingua][messaggio_TITOLO_3], risultati_lvl1_selezionato, risultati_lvl1_pagine_totali - 1);
				LCD_WriteLine(1,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);
				sprintf(s_appoggio, "%s %%+08.%uf %s", messaggi[salva.lingua][messaggio_VALORE_7], ricetta.decimali[S00], unita_misura[ricetta.umis[S00]]);
				sprintf(MSG, s_appoggio, VariabiliProvaPezzo[numero_stazione].PressioneMisura);
				LCD_WriteLine(2,MSG);
				sprintf(s_appoggio, "%s %%+08.%uf %s", messaggi[salva.lingua][messaggio_VALORE_8], ricetta.decimali[S07], unita_misura[ricetta.umis[S07]]);
				sprintf(MSG, s_appoggio, VariabiliProvaPezzo[numero_stazione].PressioneEfficienza);
				LCD_WriteLine(3,MSG);
				sprintf(s_appoggio, "%s %%+08.%uf %s", messaggi[salva.lingua][messaggio_VALORE_9], ricetta.decimali[S07], unita_misura[ricetta.umis[S07]]);
				sprintf(MSG, s_appoggio, VariabiliProvaPezzo[numero_stazione].PerditaEfficienza);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					risultati_lvl1_selezionato--;
					if(risultati_lvl1_selezionato == risultati_lvl1_pagina_menu)
					{
						risultati_lvl1_selezionato = risultati_lvl1_pagine_totali;
						risultati_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					risultati_lvl1_selezionato++;
					if(risultati_lvl1_selezionato == risultati_lvl1_pagine_totali)
					{
						risultati_lvl1_selezionato = risultati_lvl1_pagina_menu;
						risultati_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					risultati_lvl1_selezionato = risultati_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case risultati_lvl1_pag_04:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();

				sprintf(MSG, "%s %d/%d", messaggi[salva.lingua][messaggio_FUGA], risultati_lvl1_selezionato, risultati_lvl1_pagine_totali - 1);
				LCD_WriteLine(1,MSG);
			}

			// PRESSIONE CAMPANA
			//float PressionePR2Campana;
			// RIEMPIMENTO
			//float PressionePR1Riempimento;
			//float PressionePR2Riempimento;

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);
				sprintf(s_appoggio, "%s %%+08.%uf %s", messaggi[salva.lingua][messaggio_PR2_CAMPANA], 7, ricetta.decimali[soglia_S04_pressione_PR2_campana_minima], unita_misura[ricetta.umis[soglia_S04_pressione_PR2_campana_minima]]);
				sprintf(MSG, s_appoggio, VariabiliProvaFuga[numero_stazione].PressionePR2Campana);
				LCD_WriteLine(2,MSG);
				sprintf(s_appoggio, "%s   %%+08.%uf %s", messaggi[salva.lingua][messaggio_INIZIO], 7, ricetta.decimali[soglia_S08_pressione_PR2_riempimento_minima], unita_misura[ricetta.umis[soglia_S08_pressione_PR2_riempimento_minima]]);
				sprintf(MSG, s_appoggio, VariabiliProvaFuga[numero_stazione].PressionePR2Riempimento_Inizio);
				LCD_WriteLine(3,MSG);
				sprintf(s_appoggio, "%s   %%+08.%uf %s", messaggi[salva.lingua][messaggio_PERD], 7, ricetta.decimali[soglia_S10_pressione_PR2_misura_minima], unita_misura[ricetta.umis[soglia_S10_pressione_PR2_misura_minima]]);
				sprintf(MSG, s_appoggio, VariabiliProvaFuga[numero_stazione].PerditaMisuraUtilizzata_Differenza);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					risultati_lvl1_selezionato--;
					if(risultati_lvl1_selezionato == risultati_lvl1_pagina_menu)
					{
						risultati_lvl1_selezionato = risultati_lvl1_pagine_totali;
						risultati_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					risultati_lvl1_selezionato++;
					if(risultati_lvl1_selezionato == risultati_lvl1_pagine_totali)
					{
						risultati_lvl1_selezionato = risultati_lvl1_pagina_menu;
						risultati_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					risultati_lvl1_selezionato = risultati_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		*/
	}
	return;
}

