/*
 * TLGB_Pagine_Run_Scelta_Pezzo.c
 *
 *  Created on: 29 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"

#include "driverlib/rom.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"

#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run.h"
#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run_Scelta_Pezzo.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile scelta_pezzo_lvl1 scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_scelta_pezzo_lvl1 (E_Stazioni numero_stazione)
{
	static E_Programmi numero_programma_da_caricare = programma_0;
	static scelta_pezzo_lvl1 scelta_pezzo_lvl1_old = scelta_pezzo_lvl1_pagina_menu;

	switch(scelta_pezzo_lvl1_selezionato)
	{
		case scelta_pezzo_lvl1_prog_00:
		{

			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "> PRG.00 %s", ricetta.titolo[0]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.01 %s", ricetta.titolo[1]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.02 %s", ricetta.titolo[2]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.03 %s", ricetta.titolo[3]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_old = scelta_pezzo_lvl1_selezionato;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_conferma_caricamento;
					numero_programma_da_caricare = programma_0;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato--;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagina_menu)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagine_totali;
						scelta_pezzo_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato++;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagine_totali)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
						scelta_pezzo_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case scelta_pezzo_lvl1_prog_01:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- PRG.00 %s", ricetta.titolo[0]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> PRG.01 %s", ricetta.titolo[1]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.02 %s", ricetta.titolo[2]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.03 %s", ricetta.titolo[3]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_old = scelta_pezzo_lvl1_selezionato;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_conferma_caricamento;
					numero_programma_da_caricare = programma_1;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato--;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagina_menu)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagine_totali;
						scelta_pezzo_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato++;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagine_totali)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
						scelta_pezzo_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case scelta_pezzo_lvl1_prog_02:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- PRG.00 %s", ricetta.titolo[0]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.01 %s", ricetta.titolo[1]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> PRG.02 %s", ricetta.titolo[2]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.03 %s", ricetta.titolo[3]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_old = scelta_pezzo_lvl1_selezionato;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_conferma_caricamento;
					numero_programma_da_caricare = programma_2;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato--;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagina_menu)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagine_totali;
						scelta_pezzo_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato++;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagine_totali)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
						scelta_pezzo_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case scelta_pezzo_lvl1_prog_03:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- PRG.00 %s", ricetta.titolo[0]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.01 %s", ricetta.titolo[1]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.02 %s", ricetta.titolo[2]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> PRG.03 %s", ricetta.titolo[3]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_old = scelta_pezzo_lvl1_selezionato;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_conferma_caricamento;
					numero_programma_da_caricare = programma_3;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato--;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagina_menu)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagine_totali;
						scelta_pezzo_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato++;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagine_totali)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
						scelta_pezzo_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case scelta_pezzo_lvl1_prog_04:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "> PRG.04 %s", ricetta.titolo[4]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.05 %s", ricetta.titolo[5]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.06 %s", ricetta.titolo[6]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.07 %s", ricetta.titolo[7]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_old = scelta_pezzo_lvl1_selezionato;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_conferma_caricamento;
					numero_programma_da_caricare = programma_4;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato--;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagina_menu)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagine_totali;
						scelta_pezzo_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato++;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagine_totali)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
						scelta_pezzo_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case scelta_pezzo_lvl1_prog_05:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- PRG.04 %s", ricetta.titolo[4]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> PRG.05 %s", ricetta.titolo[5]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.06 %s", ricetta.titolo[6]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.07 %s", ricetta.titolo[7]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_old = scelta_pezzo_lvl1_selezionato;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_conferma_caricamento;
					numero_programma_da_caricare = programma_5;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato--;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagina_menu)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagine_totali;
						scelta_pezzo_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato++;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagine_totali)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
						scelta_pezzo_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case scelta_pezzo_lvl1_prog_06:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- PRG.04 %s", ricetta.titolo[4]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.05 %s", ricetta.titolo[5]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> PRG.06 %s", ricetta.titolo[6]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.07 %s", ricetta.titolo[7]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_old = scelta_pezzo_lvl1_selezionato;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_conferma_caricamento;
					numero_programma_da_caricare = programma_6;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato--;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagina_menu)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagine_totali;
						scelta_pezzo_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato++;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagine_totali)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
						scelta_pezzo_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case scelta_pezzo_lvl1_prog_07:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- PRG.04 %s", ricetta.titolo[4]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.05 %s", ricetta.titolo[5]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.06 %s", ricetta.titolo[6]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> PRG.07 %s", ricetta.titolo[7]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_old = scelta_pezzo_lvl1_selezionato;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_conferma_caricamento;
					numero_programma_da_caricare = programma_7;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato--;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagina_menu)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagine_totali;
						scelta_pezzo_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato++;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagine_totali)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
						scelta_pezzo_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case scelta_pezzo_lvl1_prog_08:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "> PRG.08 %s", ricetta.titolo[8]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.09 %s", ricetta.titolo[9]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.10 %s", ricetta.titolo[10]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.11 %s", ricetta.titolo[11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_old = scelta_pezzo_lvl1_selezionato;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_conferma_caricamento;
					numero_programma_da_caricare = programma_8;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato--;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagina_menu)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagine_totali;
						scelta_pezzo_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato++;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagine_totali)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
						scelta_pezzo_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case scelta_pezzo_lvl1_prog_09:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- PRG.08 %s", ricetta.titolo[8]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> PRG.09 %s", ricetta.titolo[9]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.10 %s", ricetta.titolo[10]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.11 %s", ricetta.titolo[11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_old = scelta_pezzo_lvl1_selezionato;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_conferma_caricamento;
					numero_programma_da_caricare = programma_9;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato--;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagina_menu)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagine_totali;
						scelta_pezzo_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato++;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagine_totali)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
						scelta_pezzo_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case scelta_pezzo_lvl1_prog_10:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- PRG.08 %s", ricetta.titolo[8]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.09 %s", ricetta.titolo[9]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> PRG.10 %s", ricetta.titolo[10]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- PRG.11 %s", ricetta.titolo[11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_old = scelta_pezzo_lvl1_selezionato;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_conferma_caricamento;
					numero_programma_da_caricare = programma_10;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato--;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagina_menu)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagine_totali;
						scelta_pezzo_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato++;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagine_totali)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
						scelta_pezzo_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case scelta_pezzo_lvl1_prog_11:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- PRG.08 %s", ricetta.titolo[8]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- PRG.09 %s", ricetta.titolo[9]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- PRG.10 %s", ricetta.titolo[10]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> PRG.11 %s", ricetta.titolo[11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_old = scelta_pezzo_lvl1_selezionato;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_conferma_caricamento;
					numero_programma_da_caricare = programma_11;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato--;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagina_menu)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagine_totali;
						scelta_pezzo_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato++;
					if(scelta_pezzo_lvl1_selezionato == scelta_pezzo_lvl1_pagine_totali)
					{
						scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
						scelta_pezzo_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case scelta_pezzo_lvl1_conferma_caricamento:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_VUOI_CARICARE_IL]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_PRODOTTO_ATTUALE]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ENTER_SI]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_CLR_NO]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_caricamento_in_corso;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_operazione_annullata;
				}
				break;
			}
		}
		break;
		case scelta_pezzo_lvl1_caricamento_in_corso:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_CARICAMENTO_IN_CORSO]);
				LCD_WriteLine(1,MSG);
				//sprintf(MSG,"                    ");
				//LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ATTENDERE_PREGO]);
				LCD_WriteLine(3,MSG);
				//sprintf(MSG,"                    ");
				//LCD_WriteLine(4,MSG);
			}

		    salva.programma_attivo[numero_stazione] = numero_programma_da_caricare;
            WriteSalva(&salva);

		    ROM_SysCtlDelay(SEC_DELAY);
			refresh_schermo_run = 1;
			scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_old;
		}
		break;
		case scelta_pezzo_lvl1_operazione_annullata:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_OPERAZIONE_ANNULLATA]);
				LCD_WriteLine(1,MSG);
				//sprintf(MSG,"                    ");
				//LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ATTENDERE_PREGO]);
				LCD_WriteLine(3,MSG);
				//sprintf(MSG,"                    ");
				//LCD_WriteLine(4,MSG);
			}

		    ROM_SysCtlDelay(SEC_DELAY);
		    refresh_schermo_run = 1;
			scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_old;
		}
		break;

	}
	return;
}
