/*
 * TLGB_Pagine_Run_Statistiche.c
 *
 *  Created on: 29 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"

#include "driverlib/rom.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"

#include "TLGB/TLGB_Contatori.h"
#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run.h"
#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run_Statistiche.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile statistiche_lvl1 statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_statistiche_lvl1 (E_Stazioni numero_stazione)
{
	switch(statistiche_lvl1_selezionato)
	{
		case statistiche_lvl1_pag_00:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_E_ZERO_MIN_PORTATA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT00);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_E_ZERO_MAX_PORTATA]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT01);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato--;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagina_menu)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagine_totali;
						statistiche_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato++;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagine_totali)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
						statistiche_lvl1_selezionato++;
					}
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_conferma_azzeramento;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case statistiche_lvl1_pag_01:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_E_PRESSIONE_MINIMA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT02);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_E_PRESSIONE_MASSIMA]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT03);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato--;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagina_menu)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagine_totali;
						statistiche_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato++;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagine_totali)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
						statistiche_lvl1_selezionato++;
					}
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_conferma_azzeramento;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case statistiche_lvl1_pag_02:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_E_PORTATA_FUORI_SCALA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT04);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_E_PORTATA_MINIMA]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT05);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato--;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagina_menu)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagine_totali;
						statistiche_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato++;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagine_totali)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
						statistiche_lvl1_selezionato++;
					}
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_conferma_azzeramento;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case statistiche_lvl1_pag_03:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_E_PORTATA_MASSIMA]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT06);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_E_STOP_CICLO]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT07);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato--;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagina_menu)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagine_totali;
						statistiche_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato++;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagine_totali)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
						statistiche_lvl1_selezionato++;
					}

				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_conferma_azzeramento;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case statistiche_lvl1_pag_04:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_V_BUONO]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT08);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", "");// messaggi[salva.lingua][]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT09);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato--;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagina_menu)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagine_totali;
						statistiche_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato++;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagine_totali)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
						statistiche_lvl1_selezionato++;
					}
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_conferma_azzeramento;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case statistiche_lvl1_pag_05:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", "");// messaggi[salva.lingua][]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT10);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", "");// messaggi[salva.lingua][]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT11);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato--;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagina_menu)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagine_totali;
						statistiche_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato++;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagine_totali)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
						statistiche_lvl1_selezionato++;
					}

				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_conferma_azzeramento;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case statistiche_lvl1_pag_06:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", "");// messaggi[salva.lingua][]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT12);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", "");// messaggi[salva.lingua][]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT13);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato--;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagina_menu)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagine_totali;
						statistiche_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato++;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagine_totali)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
						statistiche_lvl1_selezionato++;
					}

				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_conferma_azzeramento;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case statistiche_lvl1_pag_07:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", "");// messaggi[salva.lingua][]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT14);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", "");// messaggi[salva.lingua][]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT15);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato--;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagina_menu)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagine_totali;
						statistiche_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato++;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagine_totali)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
						statistiche_lvl1_selezionato++;
					}

				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_conferma_azzeramento;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case statistiche_lvl1_pag_08:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", "");// messaggi[salva.lingua][]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT16);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", "");// messaggi[salva.lingua][]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT17);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato--;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagina_menu)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagine_totali;
						statistiche_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato++;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagine_totali)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
						statistiche_lvl1_selezionato++;
					}

				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_conferma_azzeramento;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case statistiche_lvl1_pag_09:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", "");// messaggi[salva.lingua][]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT18);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", "");// messaggi[salva.lingua][]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%u", Statistiche[numero_stazione].STAT19);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato--;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagina_menu)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagine_totali;
						statistiche_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato++;
					if(statistiche_lvl1_selezionato == statistiche_lvl1_pagine_totali)
					{
						statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
						statistiche_lvl1_selezionato++;
					}

				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_conferma_azzeramento;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case statistiche_lvl1_conferma_azzeramento:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_VUOI_AZZERARE_LE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_STATISTICHE_ATTUALI]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ENTER_SI]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_CLR_NO]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_azzeramento_in_corso;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_run = 1;
					statistiche_lvl1_selezionato = statistiche_lvl1_operazione_annullata;
				}
				break;
			}
		}
		break;
		case statistiche_lvl1_azzeramento_in_corso:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_AZZERAMENTO_IN_CORSO]);
				LCD_WriteLine(1,MSG);
				//sprintf(MSG,"                    ");
				//LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ATTENDERE_PREGO]);
				LCD_WriteLine(3,MSG);
				//sprintf(MSG,"                    ");
				//LCD_WriteLine(4,MSG);
			}

			AzzeraStatistiche (numero_stazione);

		    ROM_SysCtlDelay(SEC_DELAY);

			refresh_schermo_run = 1;
			statistiche_lvl1_selezionato = statistiche_lvl1_pag_00;
		}
		break;
		case statistiche_lvl1_operazione_annullata:
		{
			if(refresh_schermo_run == 1)
			{
				refresh_schermo_run = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_OPERAZIONE_ANNULLATA]);
				LCD_WriteLine(1,MSG);
				//sprintf(MSG,"                    ");
				//LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ATTENDERE_PREGO]);
				LCD_WriteLine(3,MSG);
				//sprintf(MSG,"                    ");
				//LCD_WriteLine(4,MSG);
			}

		    ROM_SysCtlDelay(SEC_DELAY);

		    refresh_schermo_run = 1;
			statistiche_lvl1_selezionato = statistiche_lvl1_pag_00;

		}
		break;
	}
	return;
}

