/*
 * TLGB_Pagine_Tlgb.c
 *
 *  Created on: 17/feb/2015
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"
#include "string.h"

#include "driverlib/rom.h"

#include "drivers/AD7193.h"
#include "drivers/my_calibration.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"
#include "drivers/tca8418_keypad.h"

#include "TLGB/TLGB_Diginout.h"
#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_Funzioni.h"
#include "TLGB/TLGB_TempiSoglieParametri.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Configurazione_ADC.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Configurazione_IO_Analogici.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Diagnostica_IO_Analogici.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Diagnostica_IO_Digitali.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Generali_Tempi.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Generali_Soglie.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Generali_Decimali.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Generali_Unita_Misura.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Stazione_Tempi.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Stazione_Soglie.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Stazione_Decimali.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Stazione_Unita_Misura.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile tlgb_lvl0 tlgb_lvl0_selezionato = tlgb_lvl0_parametri_generali_tempi;
volatile unsigned long refresh_schermo_tlgb = 1;

//==============================================================================
// Global functions

void gestione_menu_tlgb_lvl0 (void)
{

	switch(tlgb_lvl0_selezionato)
	{
		/*
		 * PAGINA PRINCIPALE DEL PROGRAMMA
		 */

	case tlgb_lvl0_parametri_generali_tempi:
	{
		switch(parametri_generali_tempi_lvl1_selezionato)
		{
			case parametri_generali_tempi_lvl1_pagina_menu:
			{

				if(refresh_schermo_tlgb == 1)
				{
					refresh_schermo_tlgb = 0;
					LCD_Display_Clear();
					sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_TEMPI]);
					LCD_WriteLine(1,MSG);
					sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_SOGLIE]);
					LCD_WriteLine(2,MSG);
					sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_UNITA_MISURA]);
					LCD_WriteLine(3,MSG);
					sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_DECIMALI]);
					LCD_WriteLine(4,MSG);
				}

				switch(UltimoTastoPremuto)
				{
					case ENTER:
					{
						UltimoTastoPremuto = KEY_NONE;
						refresh_schermo_tlgb = 1;
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_00;
					}
					break;
					case FRECCIA_SU:
					{
						UltimoTastoPremuto = KEY_NONE;
						refresh_schermo_tlgb = 1;
						tlgb_lvl0_selezionato--;
						if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
						{
							tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
							tlgb_lvl0_selezionato--;
						}
					}
					break;
					case FRECCIA_GIU:
					{
						UltimoTastoPremuto = KEY_NONE;
						refresh_schermo_tlgb = 1;
						tlgb_lvl0_selezionato++;
						if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
						{
							tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
							tlgb_lvl0_selezionato++;
						}
					}
					break;
				}
			}
			break;
			default:
			{
				gestione_menu_parametri_generali_tempi_lvl1();
			}
			break;
		}
	}
	break;
	case tlgb_lvl0_parametri_generali_soglie:
	{
		switch(parametri_generali_soglie_lvl1_selezionato)
		{
			case parametri_generali_soglie_lvl1_pagina_menu:
			{

				if(refresh_schermo_tlgb == 1)
				{
					refresh_schermo_tlgb = 0;
					LCD_Display_Clear();
					sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_TEMPI]);
					LCD_WriteLine(1,MSG);
					sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_SOGLIE]);
					LCD_WriteLine(2,MSG);
					sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_UNITA_MISURA]);
					LCD_WriteLine(3,MSG);
					sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_DECIMALI]);
					LCD_WriteLine(4,MSG);
				}

				switch(UltimoTastoPremuto)
				{
					case ENTER:
					{
						UltimoTastoPremuto = KEY_NONE;
						refresh_schermo_tlgb = 1;
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_00;
					}
					break;
					case FRECCIA_SU:
					{
						UltimoTastoPremuto = KEY_NONE;
						refresh_schermo_tlgb = 1;
						tlgb_lvl0_selezionato--;
						if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
						{
							tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
							tlgb_lvl0_selezionato--;
						}
					}
					break;
					case FRECCIA_GIU:
					{
						UltimoTastoPremuto = KEY_NONE;
						refresh_schermo_tlgb = 1;
						tlgb_lvl0_selezionato++;
						if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
						{
							tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
							tlgb_lvl0_selezionato++;
						}
					}
					break;
				}
			}
			break;
			default:
			{
				gestione_menu_parametri_generali_soglie_lvl1();
			}
			break;
		}
	}
	break;
		case tlgb_lvl0_parametri_generali_unita_misura:
		{
			switch(parametri_generali_unita_misura_lvl1_selezionato)
			{
				case parametri_generali_unita_misura_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							parametri_generali_unita_misura_lvl1_selezionato = parametri_generali_unita_misura_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_parametri_generali_unita_misura_lvl1();
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_parametri_generali_decimali:
		{
			switch(parametri_generali_decimali_lvl1_selezionato)
			{
				case parametri_generali_decimali_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_PARAMETRI_GENERALI_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							parametri_generali_decimali_lvl1_selezionato = parametri_generali_decimali_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_parametri_generali_decimali_lvl1();
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_parametri_stazione_1_tempi:
		{
			switch(parametri_stazione_tempi_lvl1_selezionato)
			{
				case parametri_stazione_tempi_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "> %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_parametri_stazione_tempi_lvl1(stazione_1);
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_parametri_stazione_1_soglie:
		{
			switch(parametri_stazione_soglie_lvl1_selezionato)
			{
				case parametri_stazione_soglie_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "- %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "> %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_parametri_stazione_soglie_lvl1(stazione_1);
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_parametri_stazione_1_unita_misura:
		{
			switch(parametri_stazione_unita_misura_lvl1_selezionato)
			{
				case parametri_stazione_unita_misura_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "- %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "> %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_parametri_stazione_unita_misura_lvl1(stazione_1);
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_parametri_stazione_1_decimali:
		{
			switch(parametri_stazione_decimali_lvl1_selezionato)
			{
				case parametri_stazione_decimali_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "- %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "> %s 1", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							parametri_stazione_decimali_lvl1_selezionato = parametri_stazione_decimali_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_parametri_stazione_decimali_lvl1(stazione_1);
				}
				break;
			}
		}
		break;
		/*
		case tlgb_lvl0_parametri_stazione_2_tempi:
		{
			switch(parametri_stazione_tempi_lvl1_selezionato)
			{
				case parametri_stazione_tempi_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "> %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_parametri_stazione_tempi_lvl1(stazione_2);
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_parametri_stazione_2_soglie:
		{
			switch(parametri_stazione_soglie_lvl1_selezionato)
			{
				case parametri_stazione_soglie_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "- %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "> %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_parametri_stazione_soglie_lvl1(stazione_2);
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_parametri_stazione_2_unita_misura:
		{
			switch(parametri_stazione_unita_misura_lvl1_selezionato)
			{
				case parametri_stazione_unita_misura_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "- %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "> %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "- %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_parametri_stazione_unita_misura_lvl1(stazione_2);
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_parametri_stazione_2_decimali:
		{
			switch(parametri_stazione_decimali_lvl1_selezionato)
			{
				case parametri_stazione_decimali_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "- %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_TEMPI]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_SOGLIE]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_UNITA_MISURA]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "> %s 2", messaggi[salva.lingua][messaggio_PARAMETRI_STAZIONE_DECIMALI]);
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							parametri_stazione_decimali_lvl1_selezionato = parametri_stazione_decimali_lvl1_00;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_parametri_stazione_decimali_lvl1(stazione_2);
				}
				break;
			}
		}
		break;
		*/
		case tlgb_lvl0_diagnostica_io_digitali:
		{
			switch(diagnostica_io_digitali_lvl1_selezionato)
			{
				case diagnostica_io_digitali_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_DIAGNOSTICA_IO_DIG]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_DIAGNOSTICA_IO_ANA]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_PROGRAMMAZIONE_ADC]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_diagnostica_scheda_1;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_diagnostica_io_digitali_lvl1();
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_diagnostica_io_analogici:
		{
			switch(diagnostica_io_analogici_lvl1_selezionato)
			{
				case diagnostica_io_analogici_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_DIAGNOSTICA_IO_DIG]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_DIAGNOSTICA_IO_ANA]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_PROGRAMMAZIONE_ADC]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							diagnostica_io_analogici_lvl1_selezionato = diagnostica_io_analogici_lvl1_pagina_diagnostica;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_diagnostica_io_analogici_lvl1();
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_configurazione_adc:
		{
			switch(configurazione_adc_lvl1_selezionato)
			{
				case configurazione_adc_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_DIAGNOSTICA_IO_DIG]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_DIAGNOSTICA_IO_ANA]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_PROGRAMMAZIONE_ADC]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_single_ended;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_configurazione_adc_lvl1();
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_configurazione_trasduttore_1:
		{
			switch(configurazione_io_analogici_lvl1_selezionato)
			{
				case configurazione_io_analogici_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "> %s 1", messaggi[salva.lingua][messaggio_TARATURA_TRASDUTTORE]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s %s", messaggi[salva.lingua][messaggio_UNITA_MISURA_TRASDUTTORE], unita_misura[adc.umis[0]]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_DECIMALI_TRASDUTTORE], adc.decimali[0]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_punto_1_V;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_configurazione_io_analogici_lvl1(0);
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_configurazione_trasduttore_1_unita_misura:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s 1", messaggi[salva.lingua][messaggio_TARATURA_TRASDUTTORE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s %s", messaggi[salva.lingua][messaggio_UNITA_MISURA_TRASDUTTORE], unita_misura[adc.umis[0]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_DECIMALI_TRASDUTTORE], adc.decimali[0]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(2, 16, &adc.umis[0]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato--;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
						tlgb_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato++;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
						tlgb_lvl0_selezionato++;
					}
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_configurazione_trasduttore_1_decimali:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s 1", messaggi[salva.lingua][messaggio_TARATURA_TRASDUTTORE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s %s", messaggi[salva.lingua][messaggio_UNITA_MISURA_TRASDUTTORE], unita_misura[adc.umis[0]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %s %u", messaggi[salva.lingua][messaggio_DECIMALI_TRASDUTTORE], adc.decimali[0]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;

					leggi_scrivi_unsigned_long(3, 20, 1, &adc.decimali[0]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato--;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
						tlgb_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato++;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
						tlgb_lvl0_selezionato++;
					}
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_configurazione_trasduttore_2:
		{
			switch(configurazione_io_analogici_lvl1_selezionato)
			{
				case configurazione_io_analogici_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "> %s 2", messaggi[salva.lingua][messaggio_TARATURA_TRASDUTTORE]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s %s", messaggi[salva.lingua][messaggio_UNITA_MISURA_TRASDUTTORE], unita_misura[adc.umis[1]]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_DECIMALI_TRASDUTTORE], adc.decimali[1]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_punto_1_V;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_configurazione_io_analogici_lvl1(1);
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_configurazione_trasduttore_2_unita_misura:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s 2", messaggi[salva.lingua][messaggio_TARATURA_TRASDUTTORE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s %s", messaggi[salva.lingua][messaggio_UNITA_MISURA_TRASDUTTORE], unita_misura[adc.umis[1]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_DECIMALI_TRASDUTTORE], adc.decimali[1]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(2, 16, &adc.umis[1]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato--;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
						tlgb_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato++;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
						tlgb_lvl0_selezionato++;
					}
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_configurazione_trasduttore_2_decimali:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s 2", messaggi[salva.lingua][messaggio_TARATURA_TRASDUTTORE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s %s", messaggi[salva.lingua][messaggio_UNITA_MISURA_TRASDUTTORE], unita_misura[adc.umis[1]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %s %u", messaggi[salva.lingua][messaggio_DECIMALI_TRASDUTTORE], adc.decimali[1]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;

					leggi_scrivi_unsigned_long(3, 20, 1, &adc.decimali[1]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato--;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
						tlgb_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato++;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
						tlgb_lvl0_selezionato++;
					}
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_configurazione_trasduttore_3:
		{
			switch(configurazione_io_analogici_lvl1_selezionato)
			{
				case configurazione_io_analogici_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "> %s 3", messaggi[salva.lingua][messaggio_TARATURA_TRASDUTTORE]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s %s", messaggi[salva.lingua][messaggio_UNITA_MISURA_TRASDUTTORE], unita_misura[adc.umis[2]]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_DECIMALI_TRASDUTTORE], adc.decimali[2]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_punto_1_V;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_configurazione_io_analogici_lvl1(2);
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_configurazione_trasduttore_3_unita_misura:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s 3", messaggi[salva.lingua][messaggio_TARATURA_TRASDUTTORE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s %s", messaggi[salva.lingua][messaggio_UNITA_MISURA_TRASDUTTORE], unita_misura[adc.umis[2]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_DECIMALI_TRASDUTTORE], adc.decimali[2]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(2, 16, &adc.umis[2]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato--;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
						tlgb_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato++;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
						tlgb_lvl0_selezionato++;
					}
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_configurazione_trasduttore_3_decimali:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s 3", messaggi[salva.lingua][messaggio_TARATURA_TRASDUTTORE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s %s", messaggi[salva.lingua][messaggio_UNITA_MISURA_TRASDUTTORE], unita_misura[adc.umis[2]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %s %u", messaggi[salva.lingua][messaggio_DECIMALI_TRASDUTTORE], adc.decimali[2]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;

					leggi_scrivi_unsigned_long(3, 20, 1, &adc.decimali[2]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato--;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
						tlgb_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato++;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
						tlgb_lvl0_selezionato++;
					}
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_configurazione_trasduttore_4:
		{
			switch(configurazione_io_analogici_lvl1_selezionato)
			{
				case configurazione_io_analogici_lvl1_pagina_menu:
				{

					if(refresh_schermo_tlgb == 1)
					{
						refresh_schermo_tlgb = 0;
						LCD_Display_Clear();
						sprintf(MSG, "> %s 4", messaggi[salva.lingua][messaggio_TARATURA_TRASDUTTORE]);
						LCD_WriteLine(1,MSG);
						sprintf(MSG, "- %s %s", messaggi[salva.lingua][messaggio_UNITA_MISURA_TRASDUTTORE], unita_misura[adc.umis[3]]);
						LCD_WriteLine(2,MSG);
						sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_DECIMALI_TRASDUTTORE], adc.decimali[3]);
						LCD_WriteLine(3,MSG);
						sprintf(MSG, "-");
						LCD_WriteLine(4,MSG);
					}

					switch(UltimoTastoPremuto)
					{
						case ENTER:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_punto_1_V;
						}
						break;
						case FRECCIA_SU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato--;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
								tlgb_lvl0_selezionato--;
							}
						}
						break;
						case FRECCIA_GIU:
						{
							UltimoTastoPremuto = KEY_NONE;
							refresh_schermo_tlgb = 1;
							tlgb_lvl0_selezionato++;
							if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
							{
								tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
								tlgb_lvl0_selezionato++;
							}
						}
						break;
					}
				}
				break;
				default:
				{
					gestione_menu_configurazione_io_analogici_lvl1(3);
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_configurazione_trasduttore_4_unita_misura:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s 4", messaggi[salva.lingua][messaggio_TARATURA_TRASDUTTORE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s %s", messaggi[salva.lingua][messaggio_UNITA_MISURA_TRASDUTTORE], unita_misura[adc.umis[3]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_DECIMALI_TRASDUTTORE], adc.decimali[3]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(2, 16, &adc.umis[3]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato--;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
						tlgb_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato++;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
						tlgb_lvl0_selezionato++;
					}
				}
				break;
			}
		}
		break;
		case tlgb_lvl0_configurazione_trasduttore_4_decimali:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s 4", messaggi[salva.lingua][messaggio_TARATURA_TRASDUTTORE]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s %s", messaggi[salva.lingua][messaggio_UNITA_MISURA_TRASDUTTORE], unita_misura[adc.umis[3]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %s %u", messaggi[salva.lingua][messaggio_DECIMALI_TRASDUTTORE], adc.decimali[3]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;

					leggi_scrivi_unsigned_long(3, 20, 1, &adc.decimali[3]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato--;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagina_iniziale)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagine_totali;
						tlgb_lvl0_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					tlgb_lvl0_selezionato++;
					if(tlgb_lvl0_selezionato == tlgb_lvl0_pagine_totali)
					{
						tlgb_lvl0_selezionato = tlgb_lvl0_pagina_iniziale;
						tlgb_lvl0_selezionato++;
					}
				}
				break;
			}
		}
		break;
	}
	return;
}
