/*
 * TLGB_Pagine_Tlgb_Configurazione_ADC.c
 *
 *  Created on: 30 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"
#include "string.h"

#include "driverlib/rom.h"

#include "drivers/AD7193.h"
#include "drivers/my_calibration.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"
#include "drivers/tca8418_keypad.h"

#include "TLGB/TLGB_Diginout.h"
#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_Funzioni.h"
#include "TLGB/TLGB_TempiSoglieParametri.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Configurazione_ADC.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile configurazione_adc_lvl1 configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_configurazione_adc_lvl1 (void)
{
	unsigned long ul_appoggio = {0};

	switch(configurazione_adc_lvl1_selezionato)
	{
		case configurazione_adc_lvl1_pagina_single_ended:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_SINGLE_ENDED]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_DIFFERENTIAL]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_1]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_8]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.AcquisitionManage.AcquisitionMode = Single_ended;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_differenziale:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_SINGLE_ENDED]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_DIFFERENTIAL]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_1]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_8]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.AcquisitionManage.AcquisitionMode = Differential;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_gain_1:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_SINGLE_ENDED]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_DIFFERENTIAL]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_GAIN_1]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_8]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.AcquisitionManage.Gain = 1;
					adc.AcquisitionManage.GainSel = Gain1;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_gain_8:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_SINGLE_ENDED]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_DIFFERENTIAL]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_1]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_GAIN_8]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.AcquisitionManage.Gain = 8;
					adc.AcquisitionManage.GainSel = Gain8;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_gain_16:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_GAIN_16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_32]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_64]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_128]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.AcquisitionManage.Gain = 16;
					adc.AcquisitionManage.GainSel = Gain16;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_gain_32:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_GAIN_32]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_64]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_128]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.AcquisitionManage.Gain = 32;
					adc.AcquisitionManage.GainSel = Gain32;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_gain_64:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_32]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_GAIN_64]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_128]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.AcquisitionManage.Gain = 64;
					adc.AcquisitionManage.GainSel = Gain64;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_gain_128:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_32]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_GAIN_64]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_GAIN_128]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.AcquisitionManage.Gain = 128;
					adc.AcquisitionManage.GainSel = Gain128;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;


		case configurazione_adc_lvl1_pagina_canali_attivi_1:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_1]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_2]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_3]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_4]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.AcquisitionManage.ChannelNumberSingleEnded = ChannelNum1;
					adc.AcquisitionManage.ChannelNumberDifferential = ChannelNum1;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case configurazione_adc_lvl1_pagina_canali_attivi_2:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_1]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_2]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_3]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_4]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.AcquisitionManage.ChannelNumberSingleEnded = ChannelNum2;
					adc.AcquisitionManage.ChannelNumberDifferential = ChannelNum2;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_canali_attivi_3:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_1]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_2]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_3]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_4]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.AcquisitionManage.ChannelNumberSingleEnded = ChannelNum3;
					adc.AcquisitionManage.ChannelNumberDifferential = ChannelNum3;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_canali_attivi_4:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_1]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_2]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_3]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_CANALI_ATTIVI_4]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.AcquisitionManage.ChannelNumberSingleEnded = ChannelNum4;
					adc.AcquisitionManage.ChannelNumberDifferential = ChannelNum4;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_media_0:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_MEDIA_0]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_MEDIA_2]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_MEDIA_8]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_MEDIA_16]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.Mode.AVG1 = 0;
					adc.Mode.AVG0 = 0;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case configurazione_adc_lvl1_pagina_media_2:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_MEDIA_0]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_MEDIA_2]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_MEDIA_8]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_MEDIA_16]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.Mode.AVG1 = 0;
					adc.Mode.AVG0 = 1;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_media_8:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_MEDIA_0]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_MEDIA_2]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_MEDIA_8]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_MEDIA_16]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.Mode.AVG1 = 1;
					adc.Mode.AVG0 = 0;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_media_16:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_MEDIA_0]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_MEDIA_2]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_MEDIA_8]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_MEDIA_16]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					adc.Mode.AVG1 = 1;
					adc.Mode.AVG0 = 1;
					InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case configurazione_adc_lvl1_pagina_filter_word:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "> %s %04u", messaggi[salva.lingua][messaggio_FILTER_WORD], adc.Mode.FS);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_CHOP], adc.Configuration.Chop);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_SINC3], adc.Mode.SINC3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_ZERO_LATENCY], adc.Mode.Single);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;

					if(leggi_scrivi_unsigned_long(1, 17, 4, &ul_appoggio))
					{
						adc.Mode.FS = ul_appoggio;
						if(adc.Mode.FS < 2) // dovrebbe essere 1 il limite ma non legge l'analogica con 1
						{
							adc.Mode.FS = 2; // dovrebbe essere 1 il limite ma non legge l'analogica con 1
						}
						else if(adc.Mode.FS > 1023)
						{
							adc.Mode.FS = 1023;
						}

						AD7193_Disable_Continuous_Read();
						InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
						AD7193_Enable_Continuous_Read();
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_chop:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s %04u", messaggi[salva.lingua][messaggio_FILTER_WORD], adc.Mode.FS);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s %u", messaggi[salva.lingua][messaggio_CHOP], adc.Configuration.Chop);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_SINC3], adc.Mode.SINC3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_ZERO_LATENCY], adc.Mode.Single);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;

					if(leggi_scrivi_unsigned_long(2, 20, 1, &ul_appoggio))
					{
						adc.Configuration.Chop = ul_appoggio;
						if(adc.Configuration.Chop > 1)
						{
							adc.Configuration.Chop = 1;
						}

						AD7193_Disable_Continuous_Read();
						InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
						AD7193_Enable_Continuous_Read();
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_sinc3:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s %04u", messaggi[salva.lingua][messaggio_FILTER_WORD], adc.Mode.FS);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_CHOP], adc.Configuration.Chop);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %s %u", messaggi[salva.lingua][messaggio_SINC3], adc.Mode.SINC3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_ZERO_LATENCY], adc.Mode.Single);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;

					if(leggi_scrivi_unsigned_long(3, 20, 1, &ul_appoggio))
					{
						adc.Mode.SINC3 = ul_appoggio;
						if(adc.Mode.SINC3 > 1)
						{
							adc.Mode.SINC3 = 1;
						}

						AD7193_Disable_Continuous_Read();
						InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
						AD7193_Enable_Continuous_Read();
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_zero_Latency:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s %04u", messaggi[salva.lingua][messaggio_FILTER_WORD], adc.Mode.FS);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_CHOP], adc.Configuration.Chop);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %s %u", messaggi[salva.lingua][messaggio_SINC3], adc.Mode.SINC3);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s %u", messaggi[salva.lingua][messaggio_ZERO_LATENCY], adc.Mode.Single);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;

					if(leggi_scrivi_unsigned_long(4, 20, 1, &ul_appoggio))
					{
						adc.Mode.Single = ul_appoggio;
						if(adc.Mode.Single > 1)
						{
							adc.Mode.Single = 1;
						}

						AD7193_Disable_Continuous_Read();
						InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
						AD7193_Enable_Continuous_Read();
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;

		case configurazione_adc_lvl1_pagina_system_zero_scale_calibration:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_SYSTEM_ZERO_SCALE_CALIBRATION]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_SYSTEM_FULL_SCALE_CALIBRATION]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					AD7193_Make_Calibration(System_zero_scale_calibration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_adc_lvl1_pagina_system_full_scale_calibration:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "- %s", messaggi[salva.lingua][messaggio_SYSTEM_ZERO_SCALE_CALIBRATION]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", messaggi[salva.lingua][messaggio_SYSTEM_FULL_SCALE_CALIBRATION]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "-");
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					//refresh_schermo_tlgb = 1;

					AD7193_Disable_Continuous_Read();
					AD7193_Make_Calibration(System_full_scale_calibration);
					AD7193_Enable_Continuous_Read();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato--;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagina_menu)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagine_totali;
						configurazione_adc_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato++;
					if(configurazione_adc_lvl1_selezionato == configurazione_adc_lvl1_pagine_totali)
					{
						configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
						configurazione_adc_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
	}
	return;
}
