/*
 * TLGB_Pagine_Tlgb_Configurazione_IO_Analogici.c
 *
 *  Created on: 30 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"
#include "string.h"

#include "driverlib/rom.h"

#include "drivers/AD7193.h"
#include "drivers/my_calibration.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"
#include "drivers/tca8418_keypad.h"

#include "TLGB/TLGB_Diginout.h"
#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_Funzioni.h"
#include "TLGB/TLGB_TempiSoglieParametri.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Configurazione_IO_Analogici.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile configurazione_io_analogici_lvl1 configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_configurazione_io_analogici_lvl1 (unsigned long QualeAnalogica)
{
	static unsigned long long Refresh = {0};
	char MSG_appo[21] = {0};

	switch(configurazione_io_analogici_lvl1_selezionato)
	{
		case configurazione_io_analogici_lvl1_pagina_punto_1_V:
		{

			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "1  > %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[0]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "1  - %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[0]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[0] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;

				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(3, 6, 9, 5, &adc.Linearizzazione[QualeAnalogica].Tensione[0]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_io_analogici_lvl1_pagina_punto_1_Grandezza:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "1  - %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[0]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "1  > %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[0]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[0] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 6, 9, adc.decimali[QualeAnalogica], &adc.Linearizzazione[QualeAnalogica].Grandezza[0]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_io_analogici_lvl1_pagina_punto_2_V:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "2  > %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[1]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "2  - %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[1]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[1] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(3, 6, 9, 5, &adc.Linearizzazione[QualeAnalogica].Tensione[1]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_io_analogici_lvl1_pagina_punto_2_Grandezza:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "2  - %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[1]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "2  > %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[1]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[1] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 6, 9, adc.decimali[QualeAnalogica], &adc.Linearizzazione[QualeAnalogica].Grandezza[1]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_io_analogici_lvl1_pagina_punto_3_V:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "3  > %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[2]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "3  - %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[2]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[2] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(3, 6, 9, 5, &adc.Linearizzazione[QualeAnalogica].Tensione[2]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_io_analogici_lvl1_pagina_punto_3_Grandezza:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "3  - %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[2]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "3  > %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[2]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[2] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 6, 9, adc.decimali[QualeAnalogica], &adc.Linearizzazione[QualeAnalogica].Grandezza[2]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_io_analogici_lvl1_pagina_punto_4_V:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "4  > %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[3]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "4  - %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[3]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[3] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(3, 6, 9, 5, &adc.Linearizzazione[QualeAnalogica].Tensione[3]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_io_analogici_lvl1_pagina_punto_4_Grandezza:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "4  - %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[3]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "4  > %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[3]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[3] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 6, 9, adc.decimali[QualeAnalogica], &adc.Linearizzazione[QualeAnalogica].Grandezza[3]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_io_analogici_lvl1_pagina_punto_5_V:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "5  > %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[4]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "5  - %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[4]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[4] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(3, 6, 9, 5, &adc.Linearizzazione[QualeAnalogica].Tensione[4]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_io_analogici_lvl1_pagina_punto_5_Grandezza:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "5  - %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[4]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "5  > %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[4]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[4] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 6, 9, adc.decimali[QualeAnalogica], &adc.Linearizzazione[QualeAnalogica].Grandezza[4]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_io_analogici_lvl1_pagina_punto_6_V:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "6  > %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[5]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "6  - %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[5]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[5] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(3, 6, 9, 5, &adc.Linearizzazione[QualeAnalogica].Tensione[5]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_io_analogici_lvl1_pagina_punto_6_Grandezza:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "6  - %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[5]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "6  > %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[5]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[5] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 6, 9, adc.decimali[QualeAnalogica], &adc.Linearizzazione[QualeAnalogica].Grandezza[5]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;


		case configurazione_io_analogici_lvl1_pagina_punto_7_V:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "7  > %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[6]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "7  - %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[6]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[6] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(3, 6, 9, 5, &adc.Linearizzazione[QualeAnalogica].Tensione[6]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_io_analogici_lvl1_pagina_punto_7_Grandezza:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "7  - %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[6]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "7  > %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[6]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[6] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 6, 9, adc.decimali[QualeAnalogica], &adc.Linearizzazione[QualeAnalogica].Grandezza[6]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;



		case configurazione_io_analogici_lvl1_pagina_punto_8_V:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "8  > %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[7]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "8  - %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[7]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[7] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(3, 6, 9, 5, &adc.Linearizzazione[QualeAnalogica].Tensione[7]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_io_analogici_lvl1_pagina_punto_8_Grandezza:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "8  - %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[7]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "8  > %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[7]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[7] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 6, 9, adc.decimali[QualeAnalogica], &adc.Linearizzazione[QualeAnalogica].Grandezza[7]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;



		case configurazione_io_analogici_lvl1_pagina_punto_9_V:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "9  > %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[8]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "9  - %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[8]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[8] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(3, 6, 9, 5, &adc.Linearizzazione[QualeAnalogica].Tensione[8]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_io_analogici_lvl1_pagina_punto_9_Grandezza:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "9  - %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[8]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "9  > %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[8]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[8] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 6, 9, adc.decimali[QualeAnalogica], &adc.Linearizzazione[QualeAnalogica].Grandezza[8]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;


		case configurazione_io_analogici_lvl1_pagina_punto_10_V:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "10 > %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[9]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "10 - %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[9]);
				LCD_WriteLine(4,MSG);
			}

			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "10 > I  %08.4f %3s", adc.Linearizzazione[QualeAnalogica].Tensione[9], "V");
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "10 - O  %08.4f %3s", adc.Linearizzazione[QualeAnalogica].Grandezza[9], "G");
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[9] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(3, 6, 9, 5, &adc.Linearizzazione[QualeAnalogica].Tensione[9]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case configurazione_io_analogici_lvl1_pagina_punto_10_Grandezza:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615

				sprintf(MSG, "10 - %+09.5f     V", adc.Linearizzazione[QualeAnalogica].Tensione[9]);
				LCD_WriteLine(3,MSG);

				sprintf(MSG_appo, "10 > %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
				sprintf(MSG, MSG_appo, adc.Linearizzazione[QualeAnalogica].Grandezza[9]);
				LCD_WriteLine(4,MSG);
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG, "In  !%+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG, "In   %+09.5f     V", ValoriIstantanei.TensioneAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[QualeAnalogica])
				{
					sprintf(MSG_appo, "Out !%%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				else
				{
					sprintf(MSG_appo, "Out  %%+09.%uf %s", adc.decimali[QualeAnalogica], unita_misura[adc.umis[QualeAnalogica]]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[QualeAnalogica]);
				}
				LCD_WriteLine(2,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case TASTO_2F:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					adc.Linearizzazione[QualeAnalogica].Tensione[9] = ValoriIstantanei.TensioneAnalogica[QualeAnalogica];
					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 6, 9, adc.decimali[QualeAnalogica], &adc.Linearizzazione[QualeAnalogica].Grandezza[9]);

					ricava_npunti_min_max_ingressi(QualeAnalogica);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato--;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagina_menu)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagine_totali;
						configurazione_io_analogici_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato++;
					if(configurazione_io_analogici_lvl1_selezionato == configurazione_io_analogici_lvl1_pagine_totali)
					{
						configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
						configurazione_io_analogici_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;


	}
	return;
}
