/*
 * TLGB_Pagine_Tlgb_Diagnostica_IO_Analogici.c
 *
 *  Created on: 30 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"
#include "string.h"

#include "driverlib/rom.h"

#include "drivers/AD7193.h"
#include "drivers/my_calibration.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"
#include "drivers/tca8418_keypad.h"

#include "TLGB/TLGB_Diginout.h"
#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_Funzioni.h"
#include "TLGB/TLGB_TempiSoglieParametri.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Diagnostica_IO_Analogici.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile diagnostica_io_analogici_lvl1 diagnostica_io_analogici_lvl1_selezionato = diagnostica_io_analogici_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_diagnostica_io_analogici_lvl1 (void)
{
	static unsigned long long Refresh = {0};
	char MSG_appo[21] = {0};

	switch(diagnostica_io_analogici_lvl1_selezionato)
	{
		case diagnostica_io_analogici_lvl1_pagina_diagnostica:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				Refresh = 0xFFFFFFFFFFFFFFFF; // 18446744073709551615
			}

			if(GetTimerMs(Refresh) > 100)
			{
				ResetTimerMs(&Refresh);

				if(ValoriIstantanei.ErroreAnalogica[0])
				{
					sprintf(MSG_appo, "!%+07.3fV !%%+08.%ufG", ValoriIstantanei.TensioneAnalogica[0], adc.decimali[0]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[0]);
					MSG[19] = 'G';
				}
				else
				{
					sprintf(MSG_appo, " %+07.3fV  %%+08.%ufG", ValoriIstantanei.TensioneAnalogica[0], adc.decimali[0]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[0]);
					MSG[19] = 'G';
				}
				LCD_WriteLine(1,MSG);

				if(ValoriIstantanei.ErroreAnalogica[1])
				{
					sprintf(MSG_appo, "!%+07.3fV !%%+08.%ufG", ValoriIstantanei.TensioneAnalogica[1], adc.decimali[1]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[1]);
					MSG[19] = 'G';
				}
				else
				{
					sprintf(MSG_appo, " %+07.3fV  %%+08.%ufG", ValoriIstantanei.TensioneAnalogica[1], adc.decimali[1]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[1]);
					MSG[19] = 'G';
				}
				LCD_WriteLine(2,MSG);

				if(ValoriIstantanei.ErroreAnalogica[2])
				{
					sprintf(MSG_appo, "!%+07.3fV !%%+08.%ufG", ValoriIstantanei.TensioneAnalogica[2], adc.decimali[2]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[2]);
					MSG[19] = 'G';
				}
				else
				{
					sprintf(MSG_appo, " %+07.3fV  %%+08.%ufG", ValoriIstantanei.TensioneAnalogica[2], adc.decimali[2]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[2]);
					MSG[19] = 'G';
				}
				LCD_WriteLine(3,MSG);

				if(ValoriIstantanei.ErroreAnalogica[3])
				{
					sprintf(MSG_appo, "!%+07.3fV !%%+08.%ufG", ValoriIstantanei.TensioneAnalogica[3], adc.decimali[3]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[3]);
					MSG[19] = 'G';
				}
				else
				{
					sprintf(MSG_appo, " %+07.3fV  %%+08.%ufG", ValoriIstantanei.TensioneAnalogica[3], adc.decimali[3]);
					sprintf(MSG, MSG_appo, ValoriIstantanei.GrandezzaAnalogica[3]);
					MSG[19] = 'G';
				}
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				//case ENTER:
				//{
				//}
				//break;
				//case FRECCIA_SU:
				//{
				//	UltimoTastoPremuto = KEY_NONE;
				//	refresh_schermo_tlgb = 1;
				//	diagnostica_io_analogici_lvl1_selezionato = diagnostica_io_analogici_lvl1_pagina_comandi_forzati;
				//}
				//break;
				//case FRECCIA_GIU:
				//{
				//	UltimoTastoPremuto = KEY_NONE;
				//	refresh_schermo_tlgb = 1;
				//	diagnostica_io_analogici_lvl1_selezionato = diagnostica_io_analogici_lvl1_pagina_comandi_forzati;
				//}
				//break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					diagnostica_io_analogici_lvl1_selezionato = diagnostica_io_analogici_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case diagnostica_io_analogici_lvl1_pagina_comandi_forzati:
		{

		}
		break;
	}
	return;
}
