/*
 * TLGB_Pagine_Tlgb_Diagnostica_IO_Digitali.c
 *
 *  Created on: 30 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"
#include "string.h"

#include "driverlib/rom.h"

#include "drivers/AD7193.h"
#include "drivers/my_calibration.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"
#include "drivers/tca8418_keypad.h"

#include "TLGB/TLGB_Diginout.h"
#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_Funzioni.h"
#include "TLGB/TLGB_TempiSoglieParametri.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Diagnostica_IO_Digitali.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile diagnostica_io_digitali_lvl1 diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_diagnostica_io_digitali_lvl1 (void)
{
	static unsigned long long Refresh = {0};
	static unsigned long position = {0};

	switch(diagnostica_io_digitali_lvl1_selezionato)
	{
		case diagnostica_io_digitali_lvl1_pagina_diagnostica_scheda_1:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, " INPUT OUTPUT");
				LCD_WriteLine(1,MSG);
			}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);

				sprintf(MSG, "> %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[0].in1 | in[0].in1, in_forzati[0].in2 | in[0].in2, in_forzati[0].in3 | in[0].in3, in_forzati[0].in4  | in[0].in4, out[0].out1, out[0].out2, out[0].out3, out[0].out4, out[0].out5, out[0].out6, out[0].out7, out[0].out8, out[0].out9, out[0].out10, out[0].out11, out[0].out12);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[1].in1 | in[1].in1, in_forzati[1].in2 | in[1].in2, in_forzati[1].in3 | in[1].in3, in_forzati[1].in4  | in[1].in4, out[1].out1, out[1].out2, out[1].out3, out[1].out4, out[1].out5, out[1].out6, out[1].out7, out[1].out8, out[1].out9, out[1].out10, out[1].out11, out[1].out12);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[2].in1 | in[2].in1, in_forzati[2].in2 | in[2].in2, in_forzati[2].in3 | in[2].in3, in_forzati[2].in4  | in[2].in4, out[2].out1, out[2].out2, out[2].out3, out[2].out4, out[2].out5, out[2].out6, out[2].out7, out[2].out8, out[2].out9, out[2].out10, out[2].out11, out[2].out12);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_comandi_forzati_scheda_1;

					LCD_Cursor_Blink_ON();
					//refresh_schermo_tlgb = 1;
					position = 3;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_diagnostica_scheda_3;
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_diagnostica_scheda_2;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case diagnostica_io_digitali_lvl1_pagina_diagnostica_scheda_2:
		{
			//if(refresh_schermo_tlgb == 1)
			//{
			//	refresh_schermo_tlgb = 0;
			//	LCD_Display_Clear();
			//	sprintf(MSG, " INPUT OUTPUT");
			//	LCD_WriteLine(1,MSG);
			//}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);

				sprintf(MSG, "- %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[0].in1 | in[0].in1, in_forzati[0].in2 | in[0].in2, in_forzati[0].in3 | in[0].in3, in_forzati[0].in4  | in[0].in4, out[0].out1, out[0].out2, out[0].out3, out[0].out4, out[0].out5, out[0].out6, out[0].out7, out[0].out8, out[0].out9, out[0].out10, out[0].out11, out[0].out12);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[1].in1 | in[1].in1, in_forzati[1].in2 | in[1].in2, in_forzati[1].in3 | in[1].in3, in_forzati[1].in4  | in[1].in4, out[1].out1, out[1].out2, out[1].out3, out[1].out4, out[1].out5, out[1].out6, out[1].out7, out[1].out8, out[1].out9, out[1].out10, out[1].out11, out[1].out12);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[2].in1 | in[2].in1, in_forzati[2].in2 | in[2].in2, in_forzati[2].in3 | in[2].in3, in_forzati[2].in4  | in[2].in4, out[2].out1, out[2].out2, out[2].out3, out[2].out4, out[2].out5, out[2].out6, out[2].out7, out[2].out8, out[2].out9, out[2].out10, out[2].out11, out[2].out12);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_comandi_forzati_scheda_2;

					LCD_Cursor_Blink_ON();
					//refresh_schermo_tlgb = 1;
					position = 3;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_diagnostica_scheda_1;
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_diagnostica_scheda_3;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case diagnostica_io_digitali_lvl1_pagina_diagnostica_scheda_3:
		{
			//if(refresh_schermo_tlgb == 1)
			//{
			//	refresh_schermo_tlgb = 0;
			//	LCD_Display_Clear();
			//	sprintf(MSG, " INPUT OUTPUT");
			//	LCD_WriteLine(1,MSG);
			//}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);

				sprintf(MSG, "- %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[0].in1 | in[0].in1, in_forzati[0].in2 | in[0].in2, in_forzati[0].in3 | in[0].in3, in_forzati[0].in4  | in[0].in4, out[0].out1, out[0].out2, out[0].out3, out[0].out4, out[0].out5, out[0].out6, out[0].out7, out[0].out8, out[0].out9, out[0].out10, out[0].out11, out[0].out12);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[1].in1 | in[1].in1, in_forzati[1].in2 | in[1].in2, in_forzati[1].in3 | in[1].in3, in_forzati[1].in4  | in[1].in4, out[1].out1, out[1].out2, out[1].out3, out[1].out4, out[1].out5, out[1].out6, out[1].out7, out[1].out8, out[1].out9, out[1].out10, out[1].out11, out[1].out12);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[2].in1 | in[2].in1, in_forzati[2].in2 | in[2].in2, in_forzati[2].in3 | in[2].in3, in_forzati[2].in4  | in[2].in4, out[2].out1, out[2].out2, out[2].out3, out[2].out4, out[2].out5, out[2].out6, out[2].out7, out[2].out8, out[2].out9, out[2].out10, out[2].out11, out[2].out12);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_comandi_forzati_scheda_3;

					LCD_Cursor_Blink_ON();
					//refresh_schermo_tlgb = 1;
					position = 3;
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_diagnostica_scheda_2;
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_diagnostica_scheda_1;
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case diagnostica_io_digitali_lvl1_pagina_comandi_forzati_scheda_1:
		{
			//if(refresh_schermo_tlgb == 1)
			//{
			//	refresh_schermo_tlgb = 0;
			//}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "> %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[0].in1 | in[0].in1, in_forzati[0].in2 | in[0].in2, in_forzati[0].in3 | in[0].in3, in_forzati[0].in4  | in[0].in4, out[0].out1, out[0].out2, out[0].out3, out[0].out4, out[0].out5, out[0].out6, out[0].out7, out[0].out8, out[0].out9, out[0].out10, out[0].out11, out[0].out12);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[1].in1 | in[1].in1, in_forzati[1].in2 | in[1].in2, in_forzati[1].in3 | in[1].in3, in_forzati[1].in4  | in[1].in4, out[1].out1, out[1].out2, out[1].out3, out[1].out4, out[1].out5, out[1].out6, out[1].out7, out[1].out8, out[1].out9, out[1].out10, out[1].out11, out[1].out12);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[2].in1 | in[2].in1, in_forzati[2].in2 | in[2].in2, in_forzati[2].in3 | in[2].in3, in_forzati[2].in4  | in[2].in4, out[2].out1, out[2].out2, out[2].out3, out[2].out4, out[2].out5, out[2].out6, out[2].out7, out[2].out8, out[2].out9, out[2].out10, out[2].out11, out[2].out12);
				LCD_WriteLine(4,MSG);
				LCD_Cursor_To_Position(2, position);
			}

			switch(UltimoTastoPremuto)
			{
				case ZERO:
				{
					switch(position)
					{
						case 3:
						{
							in_forzati[0].in1 = 0;
						}
						break;
						case 4:
						{
							in_forzati[0].in2 = 0;
						}
						break;
						case 5:
						{
							in_forzati[0].in3 = 0;
						}
						break;
						case 6:
						{
							in_forzati[0].in4 = 0;
						}
						break;

						case 8:
						{
							out_forzati[0].out1 = 0;
						}
						break;
						case 9:
						{
							out_forzati[0].out2 = 0;
						}
						break;
						case 10:
						{
							out_forzati[0].out3 = 0;
						}
						break;
						case 11:
						{
							out_forzati[0].out4 = 0;
						}
						break;
						case 12:
						{
							out_forzati[0].out5 = 0;
						}
						break;
						case 13:
						{
							out_forzati[0].out6 = 0;
						}
						break;
						case 14:
						{
							out_forzati[0].out7 = 0;
						}
						break;
						case 15:
						{
							out_forzati[0].out8 = 0;
						}
						break;
						case 16:
						{
							out_forzati[0].out9 = 0;
						}
						break;
						case 17:
						{
							out_forzati[0].out10 = 0;
						}
						break;
						case 18:
						{
							out_forzati[0].out11 = 0;
						}
						break;
						case 19:
						{
							out_forzati[0].out12 = 0;
						}
						break;
					}

					scrivi_uscite();
				}
				break;
				case UNO:
				{
					switch(position)
					{
						case 3:
						{
							in_forzati[0].in1 = 1;
						}
						break;
						case 4:
						{
							in_forzati[0].in2 = 1;
						}
						break;
						case 5:
						{
							in_forzati[0].in3 = 1;
						}
						break;
						case 6:
						{
							in_forzati[0].in4 = 1;
						}
						break;

						case 8:
						{
							out_forzati[0].out1 = 1;
						}
						break;
						case 9:
						{
							out_forzati[0].out2 = 1;
						}
						break;
						case 10:
						{
							out_forzati[0].out3 = 1;
						}
						break;
						case 11:
						{
							out_forzati[0].out4 = 1;
						}
						break;
						case 12:
						{
							out_forzati[0].out5 = 1;
						}
						break;
						case 13:
						{
							out_forzati[0].out6 = 1;
						}
						break;
						case 14:
						{
							out_forzati[0].out7 = 1;
						}
						break;
						case 15:
						{
							out_forzati[0].out8 = 1;
						}
						break;
						case 16:
						{
							out_forzati[0].out9 = 1;
						}
						break;
						case 17:
						{
							out_forzati[0].out10 = 1;
						}
						break;
						case 18:
						{
							out_forzati[0].out11 = 1;
						}
						break;
						case 19:
						{
							out_forzati[0].out12 = 1;
						}
						break;
					}

					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					switch(position)
					{
						case 3:
						{
							position = 19;
						}
						break;
						case 8:
						{
							position = 6;
						}
						break;
						default:
						{
							position--;
						}
						break;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					switch(position)
					{
						case 6:
						{
							position = 8;
						}
						break;
						case 19:
						{
							position = 3;
						}
						break;
						default:
						{
							position++;
						}
						break;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					LCD_Cursor_Blink_OFF();
					LCD_Cursor_OFF();
					diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_diagnostica_scheda_1;
				}
				break;
			}
		}
		break;
		case diagnostica_io_digitali_lvl1_pagina_comandi_forzati_scheda_2:
		{
			//if(refresh_schermo_tlgb == 1)
			//{
			//	refresh_schermo_tlgb = 0;
			//}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[0].in1 | in[0].in1, in_forzati[0].in2 | in[0].in2, in_forzati[0].in3 | in[0].in3, in_forzati[0].in4  | in[0].in4, out[0].out1, out[0].out2, out[0].out3, out[0].out4, out[0].out5, out[0].out6, out[0].out7, out[0].out8, out[0].out9, out[0].out10, out[0].out11, out[0].out12);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "> %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[1].in1 | in[1].in1, in_forzati[1].in2 | in[1].in2, in_forzati[1].in3 | in[1].in3, in_forzati[1].in4  | in[1].in4, out[1].out1, out[1].out2, out[1].out3, out[1].out4, out[1].out5, out[1].out6, out[1].out7, out[1].out8, out[1].out9, out[1].out10, out[1].out11, out[1].out12);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[2].in1 | in[2].in1, in_forzati[2].in2 | in[2].in2, in_forzati[2].in3 | in[2].in3, in_forzati[2].in4  | in[2].in4, out[2].out1, out[2].out2, out[2].out3, out[2].out4, out[2].out5, out[2].out6, out[2].out7, out[2].out8, out[2].out9, out[2].out10, out[2].out11, out[2].out12);
				LCD_WriteLine(4,MSG);
				LCD_Cursor_To_Position(3, position);
			}

			switch(UltimoTastoPremuto)
			{
				case ZERO:
				{
					switch(position)
					{
						case 3:
						{
							in_forzati[1].in1 = 0;
						}
						break;
						case 4:
						{
							in_forzati[1].in2 = 0;
						}
						break;
						case 5:
						{
							in_forzati[1].in3 = 0;
						}
						break;
						case 6:
						{
							in_forzati[1].in4 = 0;
						}
						break;

						case 8:
						{
							out_forzati[1].out1 = 0;
						}
						break;
						case 9:
						{
							out_forzati[1].out2 = 0;
						}
						break;
						case 10:
						{
							out_forzati[1].out3 = 0;
						}
						break;
						case 11:
						{
							out_forzati[1].out4 = 0;
						}
						break;
						case 12:
						{
							out_forzati[1].out5 = 0;
						}
						break;
						case 13:
						{
							out_forzati[1].out6 = 0;
						}
						break;
						case 14:
						{
							out_forzati[1].out7 = 0;
						}
						break;
						case 15:
						{
							out_forzati[1].out8 = 0;
						}
						break;
						case 16:
						{
							out_forzati[1].out9 = 0;
						}
						break;
						case 17:
						{
							out_forzati[1].out10 = 0;
						}
						break;
						case 18:
						{
							out_forzati[1].out11 = 0;
						}
						break;
						case 19:
						{
							out_forzati[1].out12 = 0;
						}
						break;
					}

					scrivi_uscite();
				}
				break;
				case UNO:
				{
					switch(position)
					{
						case 3:
						{
							in_forzati[1].in1 = 1;
						}
						break;
						case 4:
						{
							in_forzati[1].in2 = 1;
						}
						break;
						case 5:
						{
							in_forzati[1].in3 = 1;
						}
						break;
						case 6:
						{
							in_forzati[1].in4 = 1;
						}
						break;

						case 8:
						{
							out_forzati[1].out1 = 1;
						}
						break;
						case 9:
						{
							out_forzati[1].out2 = 1;
						}
						break;
						case 10:
						{
							out_forzati[1].out3 = 1;
						}
						break;
						case 11:
						{
							out_forzati[1].out4 = 1;
						}
						break;
						case 12:
						{
							out_forzati[1].out5 = 1;
						}
						break;
						case 13:
						{
							out_forzati[1].out6 = 1;
						}
						break;
						case 14:
						{
							out_forzati[1].out7 = 1;
						}
						break;
						case 15:
						{
							out_forzati[1].out8 = 1;
						}
						break;
						case 16:
						{
							out_forzati[1].out9 = 1;
						}
						break;
						case 17:
						{
							out_forzati[1].out10 = 1;
						}
						break;
						case 18:
						{
							out_forzati[1].out11 = 1;
						}
						break;
						case 19:
						{
							out_forzati[1].out12 = 1;
						}
						break;
					}

					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					switch(position)
					{
						case 3:
						{
							position = 19;
						}
						break;
						case 8:
						{
							position = 6;
						}
						break;
						default:
						{
							position--;
						}
						break;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					switch(position)
					{
						case 6:
						{
							position = 8;
						}
						break;
						case 19:
						{
							position = 3;
						}
						break;
						default:
						{
							position++;
						}
						break;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					LCD_Cursor_Blink_OFF();
					LCD_Cursor_OFF();
					diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_diagnostica_scheda_2;
				}
				break;
			}
		}
		break;
		case diagnostica_io_digitali_lvl1_pagina_comandi_forzati_scheda_3:
		{
			//if(refresh_schermo_tlgb == 1)
			//{
			//	refresh_schermo_tlgb = 0;
			//}

			if(GetTimerMs(Refresh) > 300)
			{
				ResetTimerMs(&Refresh);
				sprintf(MSG, "- %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[0].in1 | in[0].in1, in_forzati[0].in2 | in[0].in2, in_forzati[0].in3 | in[0].in3, in_forzati[0].in4  | in[0].in4, out[0].out1, out[0].out2, out[0].out3, out[0].out4, out[0].out5, out[0].out6, out[0].out7, out[0].out8, out[0].out9, out[0].out10, out[0].out11, out[0].out12);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "- %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[1].in1 | in[1].in1, in_forzati[1].in2 | in[1].in2, in_forzati[1].in3 | in[1].in3, in_forzati[1].in4  | in[1].in4, out[1].out1, out[1].out2, out[1].out3, out[1].out4, out[1].out5, out[1].out6, out[1].out7, out[1].out8, out[1].out9, out[1].out10, out[1].out11, out[1].out12);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %u%u%u%u %u%u%u%u%u%u%u%u%u%u%u%u", in_forzati[2].in1 | in[2].in1, in_forzati[2].in2 | in[2].in2, in_forzati[2].in3 | in[2].in3, in_forzati[2].in4  | in[2].in4, out[2].out1, out[2].out2, out[2].out3, out[2].out4, out[2].out5, out[2].out6, out[2].out7, out[2].out8, out[2].out9, out[2].out10, out[2].out11, out[2].out12);
				LCD_WriteLine(4,MSG);
				LCD_Cursor_To_Position(4, position);
			}

			switch(UltimoTastoPremuto)
			{
				case ZERO:
				{
					switch(position)
					{
						case 3:
						{
							in_forzati[2].in1 = 0;
						}
						break;
						case 4:
						{
							in_forzati[2].in2 = 0;
						}
						break;
						case 5:
						{
							in_forzati[2].in3 = 0;
						}
						break;
						case 6:
						{
							in_forzati[2].in4 = 0;
						}
						break;

						case 8:
						{
							out_forzati[2].out1 = 0;
						}
						break;
						case 9:
						{
							out_forzati[2].out2 = 0;
						}
						break;
						case 10:
						{
							out_forzati[2].out3 = 0;
						}
						break;
						case 11:
						{
							out_forzati[2].out4 = 0;
						}
						break;
						case 12:
						{
							out_forzati[2].out5 = 0;
						}
						break;
						case 13:
						{
							out_forzati[2].out6 = 0;
						}
						break;
						case 14:
						{
							out_forzati[2].out7 = 0;
						}
						break;
						case 15:
						{
							out_forzati[2].out8 = 0;
						}
						break;
						case 16:
						{
							out_forzati[2].out9 = 0;
						}
						break;
						case 17:
						{
							out_forzati[2].out10 = 0;
						}
						break;
						case 18:
						{
							out_forzati[2].out11 = 0;
						}
						break;
						case 19:
						{
							out_forzati[2].out12 = 0;
						}
						break;
					}

					scrivi_uscite();
				}
				break;
				case UNO:
				{
					switch(position)
					{
						case 3:
						{
							in_forzati[2].in1 = 1;
						}
						break;
						case 4:
						{
							in_forzati[2].in2 = 1;
						}
						break;
						case 5:
						{
							in_forzati[2].in3 = 1;
						}
						break;
						case 6:
						{
							in_forzati[2].in4 = 1;
						}
						break;

						case 8:
						{
							out_forzati[2].out1 = 1;
						}
						break;
						case 9:
						{
							out_forzati[2].out2 = 1;
						}
						break;
						case 10:
						{
							out_forzati[2].out3 = 1;
						}
						break;
						case 11:
						{
							out_forzati[2].out4 = 1;
						}
						break;
						case 12:
						{
							out_forzati[2].out5 = 1;
						}
						break;
						case 13:
						{
							out_forzati[2].out6 = 1;
						}
						break;
						case 14:
						{
							out_forzati[2].out7 = 1;
						}
						break;
						case 15:
						{
							out_forzati[2].out8 = 1;
						}
						break;
						case 16:
						{
							out_forzati[2].out9 = 1;
						}
						break;
						case 17:
						{
							out_forzati[2].out10 = 1;
						}
						break;
						case 18:
						{
							out_forzati[2].out11 = 1;
						}
						break;
						case 19:
						{
							out_forzati[2].out12 = 1;
						}
						break;
					}

					scrivi_uscite();
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					switch(position)
					{
						case 3:
						{
							position = 19;
						}
						break;
						case 8:
						{
							position = 6;
						}
						break;
						default:
						{
							position--;
						}
						break;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					switch(position)
					{
						case 6:
						{
							position = 8;
						}
						break;
						case 19:
						{
							position = 3;
						}
						break;
						default:
						{
							position++;
						}
						break;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					LCD_Cursor_Blink_OFF();
					LCD_Cursor_OFF();
					diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_diagnostica_scheda_3;
				}
				break;
			}
		}
		break;
	}
	return;
}
