/*
 * TLGB_Pagine_Tlgb_Parametri_Generali_Soglie.c
 *
 *  Created on: 10 mar 2017
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"
#include "string.h"

#include "driverlib/rom.h"

#include "drivers/AD7193.h"
#include "drivers/my_calibration.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"
#include "drivers/tca8418_keypad.h"

#include "TLGB/TLGB_Diginout.h"
#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_Funzioni.h"
#include "TLGB/TLGB_TempiSoglieParametri.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Generali_Soglie.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile parametri_generali_soglie_lvl1 parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_parametri_generali_soglie_lvl1 (void)
{
	char MSG_appo[21];

	switch(parametri_generali_soglie_lvl1_selezionato)
	{
		case parametri_generali_soglie_lvl1_00:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS00], unita_misura[parametri.umis_generali[GS00]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS00]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS01], unita_misura[parametri.umis_generali[GS01]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS01]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_generali[GS00], &parametri.soglie_generali[GS00]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_01:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS00], unita_misura[parametri.umis_generali[GS00]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS00]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS01], unita_misura[parametri.umis_generali[GS01]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS01]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_generali[GS01], &parametri.soglie_generali[GS01]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_02:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS02], unita_misura[parametri.umis_generali[GS02]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS02]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS03], unita_misura[parametri.umis_generali[GS03]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS03]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_generali[GS02], &parametri.soglie_generali[GS02]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_03:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS02], unita_misura[parametri.umis_generali[GS02]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS02]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS03], unita_misura[parametri.umis_generali[GS03]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS03]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_generali[GS03], &parametri.soglie_generali[GS03]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_04:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS04], unita_misura[parametri.umis_generali[GS04]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS04]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS05], unita_misura[parametri.umis_generali[GS05]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS05]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_generali[GS04], &parametri.soglie_generali[GS04]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_05:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS04], unita_misura[parametri.umis_generali[GS04]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS04]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS05], unita_misura[parametri.umis_generali[GS05]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS05]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_generali[GS05], &parametri.soglie_generali[GS05]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_06:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS06], unita_misura[parametri.umis_generali[GS06]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS06]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS07], unita_misura[parametri.umis_generali[GS07]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS07]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_generali[GS06], &parametri.soglie_generali[GS06]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_07:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS06], unita_misura[parametri.umis_generali[GS06]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS06]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS07], unita_misura[parametri.umis_generali[GS07]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS07]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_generali[GS07], &parametri.soglie_generali[GS07]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_08:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS08], unita_misura[parametri.umis_generali[GS08]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS08]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS09], unita_misura[parametri.umis_generali[GS09]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS09]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_generali[GS08], &parametri.soglie_generali[GS08]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_09:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS08], unita_misura[parametri.umis_generali[GS08]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS08]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS09], unita_misura[parametri.umis_generali[GS09]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS09]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_generali[GS09], &parametri.soglie_generali[GS09]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_10:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS10], unita_misura[parametri.umis_generali[GS10]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS10]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS11], unita_misura[parametri.umis_generali[GS11]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_generali[GS10], &parametri.soglie_generali[GS10]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_11:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS10], unita_misura[parametri.umis_generali[GS10]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS10]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS11], unita_misura[parametri.umis_generali[GS11]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_generali[GS11], &parametri.soglie_generali[GS11]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_12:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS12], unita_misura[parametri.umis_generali[GS12]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS12]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS13], unita_misura[parametri.umis_generali[GS13]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS13]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_generali[GS12], &parametri.soglie_generali[GS12]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_13:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS12], unita_misura[parametri.umis_generali[GS12]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS12]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS13], unita_misura[parametri.umis_generali[GS13]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS13]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_generali[GS13], &parametri.soglie_generali[GS13]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_14:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS14], unita_misura[parametri.umis_generali[GS14]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS14]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS15], unita_misura[parametri.umis_generali[GS15]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS15]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_generali[GS14], &parametri.soglie_generali[GS14]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_15:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS14], unita_misura[parametri.umis_generali[GS14]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS14]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS15], unita_misura[parametri.umis_generali[GS15]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS15]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_generali[GS15], &parametri.soglie_generali[GS15]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_16:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS16], unita_misura[parametri.umis_generali[GS16]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS16]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS17], unita_misura[parametri.umis_generali[GS17]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS17]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_generali[GS16], &parametri.soglie_generali[GS16]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_17:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS16], unita_misura[parametri.umis_generali[GS16]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS16]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS17], unita_misura[parametri.umis_generali[GS17]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS17]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_generali[GS17], &parametri.soglie_generali[GS17]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_18:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS18], unita_misura[parametri.umis_generali[GS18]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS18]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS19], unita_misura[parametri.umis_generali[GS19]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS19]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_generali[GS18], &parametri.soglie_generali[GS18]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_soglie_lvl1_19:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_generali[GS18], unita_misura[parametri.umis_generali[GS18]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS18]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GS19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_generali[GS19], unita_misura[parametri.umis_generali[GS19]]);
				sprintf(MSG, MSG_appo, parametri.soglie_generali[GS19]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_generali[GS19], &parametri.soglie_generali[GS19]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato--;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_lvl1_pagina_menu)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_pagine_totali;
						parametri_generali_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato++;
					if(parametri_generali_soglie_lvl1_selezionato == parametri_generali_soglie_pagine_totali)
					{
						parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
						parametri_generali_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
	}
	return;
}
