/*
 * TLGB_Pagine_Tlgb_Parametri_Generali_Tempi.c
 *
 *  Created on: 10 mar 2017
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"
#include "string.h"

#include "driverlib/rom.h"

#include "drivers/AD7193.h"
#include "drivers/my_calibration.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"
#include "drivers/tca8418_keypad.h"

#include "TLGB/TLGB_Diginout.h"
#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_Funzioni.h"
#include "TLGB/TLGB_TempiSoglieParametri.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Generali_Tempi.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile parametri_generali_tempi_lvl1 parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_parametri_generali_tempi_lvl1 (void)
{
	switch(parametri_generali_tempi_lvl1_selezionato)
	{
		case parametri_generali_tempi_lvl1_00:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT00] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT01] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_generali[GT00]))
					{
						parametri.tempi_generali[GT00] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_01:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT00] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT01] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_generali[GT01]))
					{
						parametri.tempi_generali[GT01] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_02:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT02] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT03] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_generali[GT02]))
					{
						parametri.tempi_generali[GT02] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_03:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT02] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT03] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_generali[GT03]))
					{
						parametri.tempi_generali[GT03] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_04:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT04] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT05] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_generali[GT04]))
					{
						parametri.tempi_generali[GT04] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_05:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT04] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT05] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_generali[GT05]))
					{
						parametri.tempi_generali[GT05] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_06:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT06] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT07] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_generali[GT06]))
					{
						parametri.tempi_generali[GT06] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_07:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT06] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT07] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_generali[GT07]))
					{
						parametri.tempi_generali[GT07] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_08:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT08] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT09] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_generali[GT08]))
					{
						parametri.tempi_generali[GT08] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_09:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT08] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT09] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_generali[GT09]))
					{
						parametri.tempi_generali[GT09] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_10:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT10] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT11] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_generali[GT10]))
					{
						parametri.tempi_generali[GT10] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_11:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT10] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT11] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_generali[GT11]))
					{
						parametri.tempi_generali[GT11] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_12:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT12] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT13] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_generali[GT12]))
					{
						parametri.tempi_generali[GT12] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_13:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT12] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT13] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_generali[GT13]))
					{
						parametri.tempi_generali[GT13] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_14:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT14] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT15] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_generali[GT14]))
					{
						parametri.tempi_generali[GT14] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_15:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT14] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT15] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_generali[GT15]))
					{
						parametri.tempi_generali[GT15] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_16:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT16] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT17] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_generali[GT16]))
					{
						parametri.tempi_generali[GT16] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_17:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT16] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT17] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_generali[GT17]))
					{
						parametri.tempi_generali[GT17] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_18:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT18] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT19] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_generali[GT18]))
					{
						parametri.tempi_generali[GT18] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_generali_tempi_lvl1_19:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_generali[GT18] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_GT19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_generali[GT19] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_generali[GT19]))
					{
						parametri.tempi_generali[GT19] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato--;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_lvl1_pagina_menu)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_pagine_totali;
						parametri_generali_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato++;
					if(parametri_generali_tempi_lvl1_selezionato == parametri_generali_tempi_pagine_totali)
					{
						parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
						parametri_generali_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
	}
	return;
}
