/*
 * TLGB_Pagine_Tlgb_Parametri_Stazione_Soglie.c
 *
 *  Created on: 10 mar 2017
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"
#include "string.h"

#include "driverlib/rom.h"

#include "drivers/AD7193.h"
#include "drivers/my_calibration.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"
#include "drivers/tca8418_keypad.h"

#include "TLGB/TLGB_Diginout.h"
#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_Funzioni.h"
#include "TLGB/TLGB_TempiSoglieParametri.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Stazione_Soglie.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile parametri_stazione_soglie_lvl1 parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_parametri_stazione_soglie_lvl1 (E_Stazioni numero_stazione)
{
	char MSG_appo[21];

	switch(parametri_stazione_soglie_lvl1_selezionato)
	{
		case parametri_stazione_soglie_lvl1_00:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS00], unita_misura[parametri.umis_stazione[SS00]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS00]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS01], unita_misura[parametri.umis_stazione[SS01]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS01]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_stazione[SS00], &parametri.soglie_stazione[numero_stazione][SS00]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_01:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS00], unita_misura[parametri.umis_stazione[SS00]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS00]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS01], unita_misura[parametri.umis_stazione[SS01]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS01]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_stazione[SS01], &parametri.soglie_stazione[numero_stazione][SS01]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_02:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS02], unita_misura[parametri.umis_stazione[SS02]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS02]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS03], unita_misura[parametri.umis_stazione[SS03]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS03]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_stazione[SS02], &parametri.soglie_stazione[numero_stazione][SS02]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_03:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS02], unita_misura[parametri.umis_stazione[SS02]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS02]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS03], unita_misura[parametri.umis_stazione[SS03]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS03]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_stazione[SS03], &parametri.soglie_stazione[numero_stazione][SS03]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_04:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS04], unita_misura[parametri.umis_stazione[SS04]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS04]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS05], unita_misura[parametri.umis_stazione[SS05]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS05]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_stazione[SS04], &parametri.soglie_stazione[numero_stazione][SS04]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_05:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS04], unita_misura[parametri.umis_stazione[SS04]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS04]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS05], unita_misura[parametri.umis_stazione[SS05]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS05]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_stazione[SS05], &parametri.soglie_stazione[numero_stazione][SS05]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_06:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS06], unita_misura[parametri.umis_stazione[SS06]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS06]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS07], unita_misura[parametri.umis_stazione[SS07]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS07]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_stazione[SS06], &parametri.soglie_stazione[numero_stazione][SS06]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_07:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS06], unita_misura[parametri.umis_stazione[SS06]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS06]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS07], unita_misura[parametri.umis_stazione[SS07]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS07]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_stazione[SS07], &parametri.soglie_stazione[numero_stazione][SS07]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_08:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS08], unita_misura[parametri.umis_stazione[SS08]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS08]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS09], unita_misura[parametri.umis_stazione[SS09]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS09]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_stazione[SS08], &parametri.soglie_stazione[numero_stazione][SS08]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_09:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS08], unita_misura[parametri.umis_stazione[SS08]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS08]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS09], unita_misura[parametri.umis_stazione[SS09]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS09]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_stazione[SS09], &parametri.soglie_stazione[numero_stazione][SS09]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_10:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS10], unita_misura[parametri.umis_stazione[SS10]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS10]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS11], unita_misura[parametri.umis_stazione[SS11]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_stazione[SS10], &parametri.soglie_stazione[numero_stazione][SS10]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_11:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS10], unita_misura[parametri.umis_stazione[SS10]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS10]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS11], unita_misura[parametri.umis_stazione[SS11]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS11]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_stazione[SS11], &parametri.soglie_stazione[numero_stazione][SS11]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_12:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS12], unita_misura[parametri.umis_stazione[SS12]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS12]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS13], unita_misura[parametri.umis_stazione[SS13]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS13]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_stazione[SS12], &parametri.soglie_stazione[numero_stazione][SS12]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_13:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS12], unita_misura[parametri.umis_stazione[SS12]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS12]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS13], unita_misura[parametri.umis_stazione[SS13]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS13]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_stazione[SS13], &parametri.soglie_stazione[numero_stazione][SS13]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_14:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS14], unita_misura[parametri.umis_stazione[SS14]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS14]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS15], unita_misura[parametri.umis_stazione[SS15]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS15]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_stazione[SS14], &parametri.soglie_stazione[numero_stazione][SS14]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_15:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS14], unita_misura[parametri.umis_stazione[SS14]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS14]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS15], unita_misura[parametri.umis_stazione[SS15]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS15]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_stazione[SS15], &parametri.soglie_stazione[numero_stazione][SS15]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_16:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS16], unita_misura[parametri.umis_stazione[SS16]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS16]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS17], unita_misura[parametri.umis_stazione[SS17]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS17]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_stazione[SS16], &parametri.soglie_stazione[numero_stazione][SS16]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_17:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS16], unita_misura[parametri.umis_stazione[SS16]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS16]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS17], unita_misura[parametri.umis_stazione[SS17]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS17]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_stazione[SS17], &parametri.soglie_stazione[numero_stazione][SS17]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_18:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS18], unita_misura[parametri.umis_stazione[SS18]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS18]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS19], unita_misura[parametri.umis_stazione[SS19]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS19]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(2, 3, 8, parametri.decimali_stazione[SS18], &parametri.soglie_stazione[numero_stazione][SS18]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_soglie_lvl1_19:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG_appo, "- %%+08.%uf     %s", parametri.decimali_stazione[SS18], unita_misura[parametri.umis_stazione[SS18]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS18]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG_appo, "> %%+08.%uf     %s", parametri.decimali_stazione[SS19], unita_misura[parametri.umis_stazione[SS19]]);
				sprintf(MSG, MSG_appo, parametri.soglie_stazione[numero_stazione][SS19]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					leggi_scrivi_signed_float(4, 3, 8, parametri.decimali_stazione[SS19], &parametri.soglie_stazione[numero_stazione][SS19]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato--;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_lvl1_pagina_menu)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_pagine_totali;
						parametri_stazione_soglie_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato++;
					if(parametri_stazione_soglie_lvl1_selezionato == parametri_stazione_soglie_pagine_totali)
					{
						parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
						parametri_stazione_soglie_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
	}
	return;
}
