/*
 * TLGB_Pagine_Tlgb_Parametri_Stazione_Tempi.c
 *
 *  Created on: 10 mar 2017
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"
#include "string.h"

#include "driverlib/rom.h"

#include "drivers/AD7193.h"
#include "drivers/my_calibration.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"
#include "drivers/tca8418_keypad.h"

#include "TLGB/TLGB_Diginout.h"
#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_Funzioni.h"
#include "TLGB/TLGB_TempiSoglieParametri.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Stazione_Tempi.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile parametri_stazione_tempi_lvl1 parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_parametri_stazione_tempi_lvl1 (E_Stazioni numero_stazione)
{
	switch(parametri_stazione_tempi_lvl1_selezionato)
	{
		case parametri_stazione_tempi_lvl1_00:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST00] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST01] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST00]))
					{
						parametri.tempi_stazione[numero_stazione][ST00] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_01:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST00] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST01] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST01]))
					{
						parametri.tempi_stazione[numero_stazione][ST01] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_02:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST02] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST03] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST02]))
					{
						parametri.tempi_stazione[numero_stazione][ST02] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_03:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST02] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST03] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST03]))
					{
						parametri.tempi_stazione[numero_stazione][ST03] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_04:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST04] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST05] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST04]))
					{
						parametri.tempi_stazione[numero_stazione][ST04] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_05:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST04] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST05] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST05]))
					{
						parametri.tempi_stazione[numero_stazione][ST05] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_06:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST06] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST07] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST06]))
					{
						parametri.tempi_stazione[numero_stazione][ST06] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_07:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST06] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST07] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST07]))
					{
						parametri.tempi_stazione[numero_stazione][ST07] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_08:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST08] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST09] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST08]))
					{
						parametri.tempi_stazione[numero_stazione][ST08] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_09:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST08] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST09] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST09]))
					{
						parametri.tempi_stazione[numero_stazione][ST09] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_10:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST10] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST11] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST10]))
					{
						parametri.tempi_stazione[numero_stazione][ST10] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_11:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST10] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST11] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST11]))
					{
						parametri.tempi_stazione[numero_stazione][ST11] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_12:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST12] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST13] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST12]))
					{
						parametri.tempi_stazione[numero_stazione][ST12] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_13:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST12] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST13] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST13]))
					{
						parametri.tempi_stazione[numero_stazione][ST13] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_14:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST14] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST15] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST14]))
					{
						parametri.tempi_stazione[numero_stazione][ST14] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_15:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST14] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST15] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST15]))
					{
						parametri.tempi_stazione[numero_stazione][ST15] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_16:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST16] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST17] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST16]))
					{
						parametri.tempi_stazione[numero_stazione][ST16] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_17:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST16] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST17] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST17]))
					{
						parametri.tempi_stazione[numero_stazione][ST17] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_18:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST18] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST19] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(2, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST18]))
					{
						parametri.tempi_stazione[numero_stazione][ST18] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_tempi_lvl1_19:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST18] / 1000.0); // lo divido per mille perche' l'ho archiviato in milli secondi
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_ST19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %+07.2f          s", parametri.tempi_stazione[numero_stazione][ST19] / 1000.0);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					if(leggi_scrivi_signed_float(4, 3, 7, 2, &parametri.tempi_stazione[numero_stazione][ST19]))
					{
						parametri.tempi_stazione[numero_stazione][ST19] *= 1000; // lo moltiplico per 1000 perche' nel programma lo uso in milli secondi
					}
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato--;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_lvl1_pagina_menu)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_pagine_totali;
						parametri_stazione_tempi_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato++;
					if(parametri_stazione_tempi_lvl1_selezionato == parametri_stazione_tempi_pagine_totali)
					{
						parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
						parametri_stazione_tempi_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
	}
	return;
}
