/*
 * TLGB_Pagine_Tlgb_Parametri_Stazione_Unita_Misura.c
 *
 *  Created on: 30 nov 2016
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"
#include "string.h"

#include "driverlib/rom.h"

#include "drivers/AD7193.h"
#include "drivers/my_calibration.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"
#include "drivers/tca8418_keypad.h"

#include "TLGB/TLGB_Diginout.h"
#include "TLGB/TLGB_Messaggi.h"
#include "TLGB/TLGB_Funzioni.h"
#include "TLGB/TLGB_TempiSoglieParametri.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Stazione_Unita_Misura.h"

#include "main.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile parametri_stazione_unita_misura_lvl1 parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;

//==============================================================================
// Global functions

void gestione_menu_parametri_stazione_unita_misura_lvl1 (E_Stazioni numero_stazione)
{
	//char MSG_appo[21] = {0};

	switch(parametri_stazione_unita_misura_lvl1_selezionato)
	{

		case parametri_stazione_unita_misura_lvl1_00:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS00]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS01]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(2, 3, &parametri.umis_stazione[SS00]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_01:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS00]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS00]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS01]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS01]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(4, 3, &parametri.umis_stazione[SS01]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_02:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS02]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS03]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(2, 3, &parametri.umis_stazione[SS02]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_03:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS02]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS02]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS03]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS03]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(4, 3, &parametri.umis_stazione[SS03]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_04:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS04]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS05]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(2, 3, &parametri.umis_stazione[SS04]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_05:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS04]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS04]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS05]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS05]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(4, 3, &parametri.umis_stazione[SS05]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_06:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS06]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS07]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(2, 3, &parametri.umis_stazione[SS06]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_07:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS06]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS06]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS07]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS07]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(4, 3, &parametri.umis_stazione[SS07]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_08:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS08]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS09]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(2, 3, &parametri.umis_stazione[SS08]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_09:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS08]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS08]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS09]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS09]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(4, 3, &parametri.umis_stazione[SS09]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_10:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS10]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS11]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(2, 3, &parametri.umis_stazione[SS10]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_11:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS10]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS10]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS11]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS11]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(4, 3, &parametri.umis_stazione[SS11]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_12:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS12]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS13]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(2, 3, &parametri.umis_stazione[SS12]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_13:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS12]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS12]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS13]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS13]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(4, 3, &parametri.umis_stazione[SS13]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_14:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS14]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS15]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(2, 3, &parametri.umis_stazione[SS14]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_15:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS14]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS14]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS15]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS15]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(4, 3, &parametri.umis_stazione[SS15]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_16:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS16]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS17]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(2, 3, &parametri.umis_stazione[SS16]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_17:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS16]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS16]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS17]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS17]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(4, 3, &parametri.umis_stazione[SS17]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_18:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS18]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS19]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(2, 3, &parametri.umis_stazione[SS18]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
		case parametri_stazione_unita_misura_lvl1_19:
		{
			if(refresh_schermo_tlgb == 1)
			{
				refresh_schermo_tlgb = 0;
				LCD_Display_Clear();
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS18]);
				LCD_WriteLine(1,MSG);
				sprintf(MSG, "- %s", unita_misura[parametri.umis_stazione[SS18]]);
				LCD_WriteLine(2,MSG);
				sprintf(MSG, "%s", messaggi[salva.lingua][messaggio_SS19]);
				LCD_WriteLine(3,MSG);
				sprintf(MSG, "> %s", unita_misura[parametri.umis_stazione[SS19]]);
				LCD_WriteLine(4,MSG);
			}

			switch(UltimoTastoPremuto)
			{
				case ENTER:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					seleziona_umis(4, 3, &parametri.umis_stazione[SS19]);
				}
				break;
				case FRECCIA_SU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato--;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_lvl1_pagina_menu)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_pagine_totali;
						parametri_stazione_unita_misura_lvl1_selezionato--;
					}
				}
				break;
				case FRECCIA_GIU:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato++;
					if(parametri_stazione_unita_misura_lvl1_selezionato == parametri_stazione_unita_misura_pagine_totali)
					{
						parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
						parametri_stazione_unita_misura_lvl1_selezionato++;
					}
				}
				break;
				case CLR:
				{
					UltimoTastoPremuto = KEY_NONE;
					refresh_schermo_tlgb = 1;
					parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
				}
				break;
			}
		}
		break;
	}
	return;
}
