/*
 * TLGB_Contatori.c
 *
 *  Created on: 05/gen/2016
 *      Author: gozzini.davide
 */


//==============================================================================
// Include files

#include "string.h"

#include "TLGB/TLGB_Contatori.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

TLotto Lotto[numero_stazioni] = {0};
TStatistiche Statistiche[numero_stazioni] = {0};

//==============================================================================
// Global functions

void SumLotto (unsigned long stazione, E_Messaggi risultato)
{

	switch(risultato)
	{
		case messaggio_E_ZERO_MIN_PORTATA:
		{
			Lotto[stazione].Anomalie++;
			Statistiche[stazione].STAT00++;
		}
		break;
		case messaggio_E_ZERO_MAX_PORTATA:
		{
			Lotto[stazione].Anomalie++;
			Statistiche[stazione].STAT01++;
		}
		break;
		case messaggio_E_PRESSIONE_MINIMA:
		{
			Lotto[stazione].Anomalie++;
			Statistiche[stazione].STAT02++;
		}
		break;
		case messaggio_E_PRESSIONE_MASSIMA:
		{
			Lotto[stazione].Anomalie++;
			Statistiche[stazione].STAT03++;
		}
		break;
		case messaggio_E_PORTATA_FUORI_SCALA:
		{
			Lotto[stazione].Anomalie++;
			Statistiche[stazione].STAT04++;
		}
		break;
		case messaggio_E_PORTATA_MINIMA:
		{
			Lotto[stazione].Anomalie++;
			Statistiche[stazione].STAT05++;
		}
		break;
		case messaggio_E_PORTATA_MASSIMA:
		{
			Lotto[stazione].Scarti++;
			Statistiche[stazione].STAT06++;
		}
		break;
		case messaggio_E_STOP_CICLO:
		{
			Lotto[stazione].Anomalie++;
			Statistiche[stazione].STAT07++;
		}
		break;
		case messaggio_V_BUONO:
		{
			Lotto[stazione].Buoni++;
			Statistiche[stazione].STAT08++;
		}
		break;
		/*
		case :
		{
			Lotto[stazione].++;
			Statistiche[stazione].STAT09++;
		}
		break;
		case :
		{
			Lotto[stazione].++;
			Statistiche[stazione].STAT10++;
		}
		break;
		case :
		{
			Lotto[stazione].++;
			Statistiche[stazione].STAT11++;
		}
		break;
		case :
		{
			Lotto[stazione].++;
			Statistiche[stazione].STAT12++;
		}
		break;
		case :
		{
			Lotto[stazione].++;
			Statistiche[stazione].STAT13++;
		}
		break;
		case :
		{
			Lotto[stazione].++;
			Statistiche[stazione].STAT14++;
		}
		break;
		case :
		{
			Lotto[stazione].++;
			Statistiche[stazione].STAT15++;
		}
		break;
		case :
		{
			Lotto[stazione].++;
			Statistiche[stazione].STAT16++;
		}
		break;
		case :
		{
			Lotto[stazione].++;
			Statistiche[stazione].STAT17++;
		}
		break;
		case :
		{
			Lotto[stazione].++;
			Statistiche[stazione].STAT18++;
		}
		break;
		case :
		{
			Lotto[stazione].++;
			Statistiche[stazione].STAT19++;
		}
		break;
		*/
	}

	return;
}

void AzzeraLotto (unsigned long stazione)
{
	memset(&Lotto[stazione], 0, sizeof(TLotto));
	return;
}

void AzzeraStatistiche (unsigned long stazione)
{
	memset(&Statistiche[stazione], 0, sizeof(TStatistiche));
	return;
}
