/*
 * TLGB_Diginout.h
 *
 *  Created on: 11/dic/2015
 *      Author: gozzini.davide
 */

#ifndef TLGB_DIGINOUT_H_
#define TLGB_DIGINOUT_H_


//==============================================================================
// Include files

#include "drivers/my_GPIO.h"

//==============================================================================
// Constants

//==============================================================================
// Types

typedef struct T_ValoriIstantanei
{
	float ErroreAnalogica[4];
	float TensioneAnalogica[4];
	float GrandezzaAnalogica[4];
}S_ValoriIstantanei;

typedef struct T_IngressiDigitali
{
	unsigned long InizioProva[1];
	unsigned long StopCiclo[1];
	unsigned long scorta_3;
	unsigned long scorta_4;
	unsigned long scorta_5;
	unsigned long scorta_6;
	unsigned long scorta_7;
	unsigned long scorta_8;
	unsigned long scorta_9;
	unsigned long scorta_10;
	unsigned long scorta_11;
	unsigned long scorta_12;
}S_IngressiDigitali;

typedef struct T_UsciteDigitali
{
	unsigned long EvRiempimentoPezzoOn[1]; // scorta_1
	unsigned long EvRiempimentoPezzoOff[1]; // scorta_2
	unsigned long scorta_3;
	unsigned long scorta_4;
	unsigned long EvRiempimentoSerbatoioOn[1]; // scorta_5
	unsigned long EvRiempimentoSerbatoioOff[1]; // scorta_6
	unsigned long Buono[1]; // scorta_7
	unsigned long Scarto[1]; // scorta_8
	unsigned long Anomalia[1]; // scorta_9
	unsigned long StrumentoPronto; // scorta_10
	unsigned long CicloInCorso[1]; // scorta_11
	unsigned long scorta_12;
	unsigned long scorta_13;
	unsigned long scorta_14;
	unsigned long scorta_15;
	unsigned long scorta_16;
	unsigned long scorta_17;
	unsigned long scorta_18;
	unsigned long scorta_19;
	unsigned long scorta_20;
	unsigned long scorta_21;
	unsigned long scorta_22;
	unsigned long scorta_23;
	unsigned long scorta_24;
	unsigned long scorta_25;
	unsigned long scorta_26;
	unsigned long scorta_27;
	unsigned long scorta_28;
	unsigned long scorta_29;
	unsigned long scorta_30;
	unsigned long scorta_31;
	unsigned long scorta_32;
	unsigned long scorta_33;
	unsigned long scorta_34;
	unsigned long scorta_35;
	unsigned long scorta_36;
}S_UsciteDigitali;

//==============================================================================
// External variables

extern S_out out[3];
extern S_in in[3];
extern S_ValoriIstantanei ValoriIstantanei;
extern S_IngressiDigitali IngressiDigitali;
extern S_UsciteDigitali UsciteDigitali;

extern S_in in_forzati[3];
extern S_out out_forzati[3];

extern S_in in_visualizzati[3];

//==============================================================================
// Global functions

void init_ev(void);
void leggi_analogiche(void);
void scrivi_uscite(void);
void leggi_ingressi(void);

void ricava_npunti_min_max_ingressi(int quale_trusc);
float linearizza_ingressi(float tensione, int can);
void ricava_npunti_min_max_uscite(int quale_trusco);
float linearizza_uscite(float grandezza, int can);


#endif /* TLGB_DIGINOUT_H_ */
