/*
 * TLGB_Funzioni.c
 *
 *  Created on: 18/feb/2015
 *      Author: gozzini.davide
 *
 *
 */

//==============================================================================
// Include files

#include "stdio.h"
#include "stdint.h"
#include "string.h"
#include "stdlib.h"
#include "math.h"

#include "driverlib/rom.h"
#include "drivers/my_timer.h"
#include "drivers/my_LCD.h"
#include "drivers/my_LED.h"
#include "drivers/tca8418_keypad.h"

#include "TLGB/TLGB_Diginout.h"
#include "TLGB/TLGB_Strutture.h"
#include "TLGB/TLGB_flash.h"
#include "TLGB/TLGB_Funzioni.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

//==============================================================================
// Global functions

void LCD_Position_Clear(unsigned long line, unsigned long position, unsigned long quante_caselle_pulire)
{
	unsigned long contatore;

	for(contatore = 0; contatore < quante_caselle_pulire; contatore++)
	{
		LCD_WriteChar(line, position + contatore, ' ');
	}

	return;
}

void LCD_Position_Write(unsigned long line, unsigned long position, char *testo)
{
	unsigned long i = 0;
	while(testo[i])
	{
		LCD_WriteChar(line, position + i, testo[i]);
		i++;
	}
	return;
}

unsigned long leggi_scrivi_signed_float(unsigned long line, unsigned long position, unsigned long numero_cifre_totali, unsigned long numero_cifre_decimali, float *esito)
{

	char s_appoggio[21] = {0};
	char stringa[21] = {0};
	unsigned long fine = {0};
	unsigned long annulla = {0};
	unsigned long contatore = {0};
	unsigned long tasto_valido = {0};

	float f_risultato = {0};
	float appo_f = {0};
	double divisore = pow(10, numero_cifre_decimali);
	unsigned long numero_cifre_intere = numero_cifre_totali - numero_cifre_decimali - (numero_cifre_decimali != 0) - 1;

	// azzeramento della stringa attuale
	sprintf(s_appoggio, "%%+0%d.%df", numero_cifre_totali, numero_cifre_decimali);
	sprintf(stringa, s_appoggio, f_risultato);
	LCD_Position_Write(line, position, stringa);

	// posizionamento per inizio scrittura nuovo valore
	LCD_Cursor_Blink_ON();

	while( (fine == 0) && (annulla == 0) )
	{


		if(Key_ready())
		{
			tasto_valido = 1;

			switch(Key_last_pressed())
			{
				case ENTER:
				{
					fine = 1;
				}
				break;
				case CLR:
				{
					annulla = 1;
				}
				break;
				case ZERO:
				{
					appo_f = 0;
				}
				break;
				case UNO:
				{
					appo_f = 1;
				}
				break;
				case DUE:
				{
					appo_f = 2;
				}
				break;
				case TRE:
				{
					appo_f = 3;
				}
				break;
				case QUATTRO:
				{
					appo_f = 4;
				}
				break;
				case CINQUE:
				{
					appo_f = 5;
				}
				break;
				case SEI:
				{
					appo_f = 6;
				}
				break;
				case SETTE:
				{
					appo_f = 7;
				}
				break;
				case OTTO:
				{
					appo_f = 8;
				}
				break;
				case NOVE:
				{
					appo_f = 9;
				}
				break;
				case FRECCIA_SU:
				{
					if(f_risultato <= 0)
					{
						f_risultato = -f_risultato;
					}
					tasto_valido = 0;
				}
				break;
				case FRECCIA_GIU:
				{
					if(f_risultato >= 0)
					{
						f_risultato = -f_risultato;
					}
					tasto_valido = 0;
				}
				break;
				default:
				{
					tasto_valido = 0;
				}
			}

			if( (fine == 0) && (annulla == 0) && (tasto_valido) )
			{
				appo_f /= divisore;
				f_risultato *= 10;
				f_risultato += appo_f;

				contatore++;
				if(contatore >= (numero_cifre_intere + numero_cifre_decimali) ) // se ho finito il numero di cifre
				{
					fine = 1;
				}
			}

			sprintf(stringa, s_appoggio, f_risultato);
			LCD_Position_Write(line, position, stringa);
		}
	}

	LCD_Cursor_Blink_OFF();
	LCD_Cursor_OFF();

	if(fine == 1)
	{
		appo_f = f_risultato;
		*esito = appo_f;
	}
	return fine;
}

unsigned long leggi_scrivi_unsigned_long(unsigned long line, unsigned long position, unsigned long numero_cifre_totali, unsigned long *esito)
{
	char s_appoggio[21] = {0};
	char stringa[21] = {0};
	unsigned long fine = {0};
	unsigned long annulla = {0};
	unsigned long contatore = {0};
	unsigned long tasto_valido = {0};

	unsigned long ul_risultato = {0};
	unsigned long appo_ul = {0};

	// azzeramento della stringa attuale
	sprintf(s_appoggio, "%%0%du", numero_cifre_totali);
	sprintf(stringa, s_appoggio, ul_risultato);
	LCD_Position_Write(line, position, stringa);

	// posizionamento per inizio scrittura nuovo valore
	LCD_Cursor_Blink_ON();

	while( (fine == 0) && (annulla == 0) )
	{
		if(Key_ready())
		{
			tasto_valido = 1;

			switch(Key_last_pressed())
			{
				case ENTER:
				{
					fine = 1;
				}
				break;
				case CLR:
				{
					annulla = 1;
				}
				break;
				case ZERO:
				{
					appo_ul = 0;
				}
				break;
				case UNO:
				{
					appo_ul = 1;
				}
				break;
				case DUE:
				{
					appo_ul = 2;
				}
				break;
				case TRE:
				{
					appo_ul = 3;
				}
				break;
				case QUATTRO:
				{
					appo_ul = 4;
				}
				break;
				case CINQUE:
				{
					appo_ul = 5;
				}
				break;
				case SEI:
				{
					appo_ul = 6;
				}
				break;
				case SETTE:
				{
					appo_ul = 7;
				}
				break;
				case OTTO:
				{
					appo_ul = 8;
				}
				break;
				case NOVE:
				{
					appo_ul = 9;
				}
				break;
				default:
				{
					tasto_valido = 0;
				}
			}

			if( (fine == 0) && (annulla == 0) && (tasto_valido) )
			{
				ul_risultato *= 10;
				ul_risultato += appo_ul;

				contatore++;
				if(contatore >= numero_cifre_totali ) // se ho finito il numero di cifre
				{
					fine = 1;
				}
			}

			sprintf(stringa, s_appoggio, ul_risultato);
			LCD_Position_Write(line, position, stringa);
		}
	}

	LCD_Cursor_Blink_OFF();
	LCD_Cursor_OFF();

	if(fine == 1)
	{
		appo_ul = ul_risultato;
		*esito = appo_ul;
	}
	return fine;
}

/*
unsigned long leggi_scrivi_numeri(unsigned long line, unsigned long position, unsigned long numero_cifre_intere, unsigned long numero_cifre_decimali, void *esito, E_TipiDato tipo_dato, unsigned long AbilitazioneNegativi)
{

	char s_appoggio[21] = {0};
	char stringa[21] = {0};
	unsigned long fine = {0};
	unsigned long annulla = {0};
	unsigned long contatore = {0};
	unsigned long tasto_valido = {0};

	float f_risultato = {0};
	float appo_f = {0};
	double divisore = pow(10, numero_cifre_decimali);
	unsigned long appo_ul = {0};
	long  appo_l = {0};

	// azzeramento della stringa attuale
	sprintf(s_appoggio, "%%0%d.%df", numero_cifre_intere + (numero_cifre_decimali != 0) + numero_cifre_decimali, numero_cifre_decimali);
	sprintf(stringa, s_appoggio, f_risultato);
	LCD_Position_Write(line, position, stringa);

	// posizionamento per inizio scrittura nuovo valore
	LCD_Cursor_Blink_ON();

	while( (fine == 0) && (annulla == 0) )
	{


		if(Key_ready())
		{
			tasto_valido = 1;

			switch(Key_last_pressed())
			{
				case ENTER:
				{
					fine = 1;
				}
				break;
				case CLR:
				{
					annulla = 1;
				}
				break;
				case ZERO:
				{
					appo_f = 0;
				}
				break;
				case UNO:
				{
					appo_f = 1;
				}
				break;
				case DUE:
				{
					appo_f = 2;
				}
				break;
				case TRE:
				{
					appo_f = 3;
				}
				break;
				case QUATTRO:
				{
					appo_f = 4;
				}
				break;
				case CINQUE:
				{
					appo_f = 5;
				}
				break;
				case SEI:
				{
					appo_f = 6;
				}
				break;
				case SETTE:
				{
					appo_f = 7;
				}
				break;
				case OTTO:
				{
					appo_f = 8;
				}
				break;
				case NOVE:
				{
					appo_f = 9;
				}
				break;
				case FRECCIA_SU:
				{
					if(f_risultato <= 0)
					{
						f_risultato = -f_risultato;
					}
					tasto_valido = 0;
				}
				break;
				case FRECCIA_GIU:
				{
					if(AbilitazioneNegativi)
					{
						if(f_risultato >= 0)
						{
							f_risultato = -f_risultato;
						}
					}
					tasto_valido = 0;
				}
				break;
				default:
				{
					tasto_valido = 0;
				}
			}

			if( (fine == 0) && (annulla == 0) && (tasto_valido) )
			{
				appo_f /= divisore;
				f_risultato *= 10;
				f_risultato += appo_f;

				contatore++;
				if(contatore >= (numero_cifre_intere + numero_cifre_decimali) ) // se ho finito il numero di cifre
				{
					fine = 1;
				}
			}

			sprintf(stringa, s_appoggio, f_risultato);
			LCD_Position_Write(line, position, stringa);
		}
	}

	LCD_Cursor_Blink_OFF();
	LCD_Cursor_OFF();

	if(fine == 1)
	{
		switch(tipo_dato)
		{
			case tipo_di_dato_float:
			{
				appo_f = f_risultato;
				*(float *)esito = appo_f;
			}
			break;
			case tipo_di_dato_unsigned_long:
			{
				appo_l = f_risultato;
				appo_ul = appo_l;
				*(unsigned long *)esito = appo_ul;
			}
			break;
		}
	}
	return fine;
}
*/

void seleziona_umis(unsigned long line, unsigned long position, E_UnitaMisura *esito)
{
	unsigned long fine = 0;
	unsigned long annulla = 0;
	unsigned long tasto_valido = 0;
	E_UnitaMisura appoggio = *esito;

	// azzeramento della stringa attuale
	LCD_Position_Clear(line, position, 5);

	// posizionamento per inizio scrittura nuovo valore
	//LCD_Cursor_To_Position(line, position);

	//LCD_Cursor_ON();
	LCD_Cursor_Blink_ON();

	while( (fine == 0) && (annulla == 0) )
	{
		if(Key_ready())
		{
			tasto_valido = 1;

			switch(Key_last_pressed())
			{
				case ENTER:
				{
					fine = 1;
				}
				break;
				case CLR:
				{
					annulla = 1;
				}
				break;
				case FRECCIA_SU:
				{
					if(appoggio == unita_misura_NULL)
					{
						appoggio = unita_misura_numero_totale;
					}
					appoggio--;
				}
				break;
				case FRECCIA_GIU:
				{
					appoggio++;
					if(appoggio == unita_misura_numero_totale)
					{
						appoggio = unita_misura_NULL;
					}
				}
				break;
				default:
				{
					tasto_valido = 0;
				}
			}

			if( (fine == 0) && (annulla == 0) && (tasto_valido) )
			{
				// azzeramento della stringa attuale
				LCD_Position_Clear(line, position, 5);
				LCD_Position_Write(line, position, unita_misura[appoggio]);
				//LCD_Cursor_Shift_Right();
			}
		}
	}

	LCD_Cursor_Blink_OFF();
	LCD_Cursor_OFF();

	if(fine == 1)
	{
		*esito = appoggio;
	}

	return;
}

/*
void CambiaRicettaDaIO(unsigned long numero_stazione)
{
	unsigned short RicettaDaCaricare = {0};

	RicettaDaCaricare += IngressiDigitali.ricetta_1 << 0;
	RicettaDaCaricare += IngressiDigitali.ricetta_2 << 1;
	RicettaDaCaricare += IngressiDigitali.ricetta_4 << 2;
	RicettaDaCaricare += IngressiDigitali.ricetta_8 << 3;

	switch(RicettaDaCaricare)
	{
		case 0:
		{
			salva.programma_attivo[numero_stazione] = programma_0;
		}
		break;
		case 1:
		{
			salva.programma_attivo[numero_stazione] = programma_1;
		}
		break;
		case 2:
		{
			salva.programma_attivo[numero_stazione] = programma_2;
		}
		break;
		case 3:
		{
			salva.programma_attivo[numero_stazione] = programma_3;
		}
		break;
		case 4:
		{
			salva.programma_attivo[numero_stazione] = programma_4;
		}
		break;
		case 5:
		{
			salva.programma_attivo[numero_stazione] = programma_5;
		}
		break;
		case 6:
		{
			salva.programma_attivo[numero_stazione] = programma_6;
		}
		break;
		case 7:
		{
			salva.programma_attivo[numero_stazione] = programma_7;
		}
		break;
		case 8:
		{
			salva.programma_attivo[numero_stazione] = programma_8;
		}
		break;
		case 9:
		{
			salva.programma_attivo[numero_stazione] = programma_9;
		}
		break;
		case 10:
		{
			salva.programma_attivo[numero_stazione] = programma_10;
		}
		break;
		case 11:
		{
			salva.programma_attivo[numero_stazione] = programma_11;
		}
		break;
		default:
		{

		}
		break;
	}

	return;
}
*/

void leggi_scrivi_testo(unsigned long line, unsigned long position, unsigned long numero_caratteri, char *risultato)
{
	char stringa[21] = {0};
	char lettera[2] = {0};
	char s_appoggio[21] = {0};
	unsigned long fine = {0};
	unsigned long annulla = {0};
	unsigned long contatore = {0};
	unsigned long tasto_valido = {0};

	// azzeramento della stringa attuale
	sprintf(s_appoggio, "%%-%ds", numero_caratteri);
	sprintf(stringa, s_appoggio, "");
	LCD_Position_Write(line, position, stringa);
	memset(stringa, 0, sizeof(stringa));

	// posizionamento per inizio scrittura nuovo valore
	LCD_Cursor_To_Position(line, position);
	LCD_Cursor_Blink_ON();


	while( (fine == 0) && (annulla == 0) )
	{
		tasto_valido = 0;

		if((ManageKeyb.lettera_ok == 1) && (ManageKeyb.LedLetNum == LED_ON))
    	{
			if(Key_is_pressed())
			{
				lettera[0] = Key_last_char_pressed();
				LCD_WriteChar(line, position + strlen(stringa), lettera[0]);
			}
    	}

    	// quando sono in modalita' lettere mi si alza il bit Key_char_ready
    	if(Key_char_ready())
        {
			tasto_valido = 1;
			lettera[0] = Key_last_char_pressed();
			strcat(stringa, lettera);

			if( (fine == 0) && (annulla == 0) && (tasto_valido) )
			{
				contatore++;
				if(contatore >= numero_caratteri) // se ho finito il numero di caratteri
				{
					fine = 1;
				}
				LCD_Position_Write(line, position, stringa);
				LCD_Cursor_Shift_Right();
			}
    	}

		if(Key_ready())
		{
			switch(Key_last_pressed())
			{
				case ENTER:
				{
					fine = 1;
				}
				break;
				case CLR:
				{
					annulla = 1;
				}
				break;
			}

			if(ManageKeyb.LedLetNum == LED_OFF)
			{
				switch(Key_last_pressed())
				{
					case ZERO:
					{
						tasto_valido = 1;
						lettera[0] = '0';
						strcat(stringa, lettera);
					}
					break;
					case UNO:
					{
						tasto_valido = 1;
						lettera[0] = '1';
						strcat(stringa, lettera);
					}
					break;
					case DUE:
					{
						tasto_valido = 1;
						lettera[0] = '2';
						strcat(stringa, lettera);
					}
					break;
					case TRE:
					{
						tasto_valido = 1;
						lettera[0] = '3';
						strcat(stringa, lettera);
					}
					break;
					case QUATTRO:
					{
						tasto_valido = 1;
						lettera[0] = '4';
						strcat(stringa, lettera);
					}
					break;
					case CINQUE:
					{
						tasto_valido = 1;
						lettera[0] = '5';
						strcat(stringa, lettera);
					}
					break;
					case SEI:
					{
						tasto_valido = 1;
						lettera[0] = '6';
						strcat(stringa, lettera);
					}
					break;
					case SETTE:
					{
						tasto_valido = 1;
						lettera[0] = '7';
						strcat(stringa, lettera);
					}
					break;
					case OTTO:
					{
						tasto_valido = 1;
						lettera[0] = '8';
						strcat(stringa, lettera);
					}
					break;
					case NOVE:
					{
						tasto_valido = 1;
						lettera[0] = '9';
						strcat(stringa, lettera);
					}
					break;
				}
			}

			if( (fine == 0) && (annulla == 0) && (tasto_valido) )
			{
				contatore++;
				if(contatore >= numero_caratteri) // se ho finito il numero di caratteri
				{
					fine = 1;
				}
				LCD_Position_Write(line, position, stringa);
				LCD_Cursor_Shift_Right();
			}
		}
	}

	LCD_Cursor_Blink_OFF();
	LCD_Cursor_OFF();

	if(fine)
	{
		sprintf(risultato, "%s", stringa);
	}

	return;
}

