/*
 * TLGB_Messaggi.h
 *
 *  Created on: 10/feb/2015
 *      Author: gozzini.davide
 */

#ifndef TLGB_MESSAGGI_EXT_H_
#define TLGB_MESSAGGI_EXT_H_

//==============================================================================
// Include files

#include "TLGB/TLGB_Strutture.h"

//==============================================================================
// Constants

//==============================================================================
// Types

typedef enum
{
	// pagine run
	messaggio_CONTATORI,
	messaggio_RISULTATI,
	messaggio_SCELTA_PEZZO,
	messaggio_INVIA_ESITO,
	messaggio_STATISTICHE,
	messaggio_STAMPA_ETICHETTA,
	messaggio_TOTALE,
	messaggio_BUONI,
	messaggio_INCERTI,
	messaggio_SCARTI,
	messaggio_VUOI_AZZERARE_IL,
	messaggio_LOTTO_ATTUALE,
	messaggio_VUOI_AZZERARE_LE,
	messaggio_STATISTICHE_ATTUALI,
	messaggio_ENTER_SI,
	messaggio_CLR_NO,
	messaggio_AZZERAMENTO_IN_CORSO,
	messaggio_ATTENDERE_PREGO,
	messaggio_OPERAZIONE_ANNULLATA,
	messaggio_VUOI_CARICARE_IL,
	messaggio_PRODOTTO_ATTUALE,
	messaggio_CARICAMENTO_IN_CORSO,
	messaggio_TEMPI,
	messaggio_SOGLIE,
	messaggio_UNITA_MISURA,
	messaggio_DECIMALI,
	messaggio_STRINGHE,
	messaggio_COMANDI_MANUALI,
	messaggio_DUPLICA_RICETTA,
	messaggio_RINOMINA_RICETTA,
	messaggio_ELIMINA_RICETTA,
	messaggio_LINGUA,
	messaggio_TARATURA_TRASDUTTORE,
	messaggio_UNITA_MISURA_TRASDUTTORE,
	messaggio_DECIMALI_TRASDUTTORE,
	messaggio_SELEZIONA_PROGRAMMA_SORGENTE,
	messaggio_SELEZIONA_PROGRAMMA_DESTINAZIONE,
	messaggio_RINOMINA_PROGRAMMA,

	// pagina principale
	messaggio_PRESSIONE,
	messaggio_PERDITA,
	// pagina risultati
	messaggio_TITOLO_1, // Zero trasduttori e Riempimento
	messaggio_VALORE_1,
	messaggio_VALORE_2,	// Zero
	messaggio_VALORE_3, // Fine riempimento
	messaggio_TITOLO_2, // Stabilizzazione e Misura
	messaggio_VALORE_4, // Fine stabilizzazione
	messaggio_VALORE_5, // Fine misura
	messaggio_VALORE_6, // Delta
	messaggio_TITOLO_3, // Efficienza
	messaggio_VALORE_7, // Fine misura
	messaggio_VALORE_8, // Fine efficienza
	messaggio_VALORE_9, // Delta

	// pagine programmazione TLGB
	messaggio_PARAMETRI_GENERALI_TEMPI,
	messaggio_PARAMETRI_GENERALI_SOGLIE,
	messaggio_PARAMETRI_GENERALI_UNITA_MISURA,
	messaggio_PARAMETRI_GENERALI_DECIMALI,
	messaggio_PARAMETRI_STAZIONE_TEMPI,
	messaggio_PARAMETRI_STAZIONE_SOGLIE,
	messaggio_PARAMETRI_STAZIONE_UNITA_MISURA,
	messaggio_PARAMETRI_STAZIONE_DECIMALI,
	messaggio_DIAGNOSTICA_IO_DIG,
	messaggio_DIAGNOSTICA_IO_ANA,
	messaggio_PROGRAMMAZIONE_ANA,
	messaggio_PROGRAMMAZIONE_ADC,
	messaggio_SINGLE_ENDED,
	messaggio_DIFFERENTIAL,
	messaggio_GAIN_1,
	messaggio_GAIN_8,
	messaggio_GAIN_16,
	messaggio_GAIN_32,
	messaggio_GAIN_64,
	messaggio_GAIN_128,
	messaggio_CANALI_ATTIVI_1,
	messaggio_CANALI_ATTIVI_2,
	messaggio_CANALI_ATTIVI_3,
	messaggio_CANALI_ATTIVI_4,
	messaggio_MEDIA_0,
	messaggio_MEDIA_2,
	messaggio_MEDIA_8,
	messaggio_MEDIA_16,
	messaggio_FILTER_WORD,
	messaggio_CHOP,
	messaggio_SINC3,
	messaggio_ZERO_LATENCY,
	messaggio_SYSTEM_ZERO_SCALE_CALIBRATION,
	messaggio_SYSTEM_FULL_SCALE_CALIBRATION,

	// pagine programmazione
	messaggio_T00,
	messaggio_T01,
	messaggio_T02,
	messaggio_T03,
	messaggio_T04,
	messaggio_T05,
	messaggio_T06,
	messaggio_T07,
	messaggio_T08,
	messaggio_T09,
	messaggio_T10,
	messaggio_T11,
	messaggio_T12,
	messaggio_T13,
	messaggio_T14,
	messaggio_T15,
	messaggio_T16,
	messaggio_T17,
	messaggio_T18,
	messaggio_T19,

	messaggio_S00,
	messaggio_S01,
	messaggio_S02,
	messaggio_S03,
	messaggio_S04,
	messaggio_S05,
	messaggio_S06,
	messaggio_S07,
	messaggio_S08,
	messaggio_S09,
	messaggio_S10,
	messaggio_S11,
	messaggio_S12,
	messaggio_S13,
	messaggio_S14,
	messaggio_S15,
	messaggio_S16,
	messaggio_S17,
	messaggio_S18,
	messaggio_S19,

	messaggio_STR00,
	messaggio_STR01,
	messaggio_STR02,
	messaggio_STR03,
	messaggio_STR04,
	messaggio_STR05,
	messaggio_STR06,
	messaggio_STR07,
	messaggio_STR08,
	messaggio_STR09,
	messaggio_STR10,
	messaggio_STR11,
	messaggio_STR12,
	messaggio_STR13,
	messaggio_STR14,
	messaggio_STR15,
	messaggio_STR16,
	messaggio_STR17,
	messaggio_STR18,
	messaggio_STR19,

	messaggio_GT00,
	messaggio_GT01,
	messaggio_GT02,
	messaggio_GT03,
	messaggio_GT04,
	messaggio_GT05,
	messaggio_GT06,
	messaggio_GT07,
	messaggio_GT08,
	messaggio_GT09,
	messaggio_GT10,
	messaggio_GT11,
	messaggio_GT12,
	messaggio_GT13,
	messaggio_GT14,
	messaggio_GT15,
	messaggio_GT16,
	messaggio_GT17,
	messaggio_GT18,
	messaggio_GT19,

	messaggio_GS00,
	messaggio_GS01,
	messaggio_GS02,
	messaggio_GS03,
	messaggio_GS04,
	messaggio_GS05,
	messaggio_GS06,
	messaggio_GS07,
	messaggio_GS08,
	messaggio_GS09,
	messaggio_GS10,
	messaggio_GS11,
	messaggio_GS12,
	messaggio_GS13,
	messaggio_GS14,
	messaggio_GS15,
	messaggio_GS16,
	messaggio_GS17,
	messaggio_GS18,
	messaggio_GS19,

	messaggio_ST00,
	messaggio_ST01,
	messaggio_ST02,
	messaggio_ST03,
	messaggio_ST04,
	messaggio_ST05,
	messaggio_ST06,
	messaggio_ST07,
	messaggio_ST08,
	messaggio_ST09,
	messaggio_ST10,
	messaggio_ST11,
	messaggio_ST12,
	messaggio_ST13,
	messaggio_ST14,
	messaggio_ST15,
	messaggio_ST16,
	messaggio_ST17,
	messaggio_ST18,
	messaggio_ST19,

	messaggio_SS00,
	messaggio_SS01,
	messaggio_SS02,
	messaggio_SS03,
	messaggio_SS04,
	messaggio_SS05,
	messaggio_SS06,
	messaggio_SS07,
	messaggio_SS08,
	messaggio_SS09,
	messaggio_SS10,
	messaggio_SS11,
	messaggio_SS12,
	messaggio_SS13,
	messaggio_SS14,
	messaggio_SS15,
	messaggio_SS16,
	messaggio_SS17,
	messaggio_SS18,
	messaggio_SS19,

	// fasi prova variabili
	messaggio_EV_OFF,
	messaggio_ATTESA_START,

	messaggio_RIEMPIMENTO_INIZIALE,
	messaggio_E_PRESSIONE_MINIMA,
	messaggio_E_PRESSIONE_MASSIMA,
	messaggio_CONTROLLO_ZERO,
	messaggio_E_ZERO_MIN_PORTATA,
	messaggio_E_ZERO_MAX_PORTATA,
	messaggio_RIEMPIMENTO_PEZZO,
	messaggio_E_PORTATA_FUORI_SCALA,
	messaggio_MISURA,
	messaggio_E_PORTATA_MINIMA,
	messaggio_E_PORTATA_MASSIMA,
	messaggio_SCARICO_FINALE,
	messaggio_RITORNO_FUORI_SCALA,

	messaggio_E_STOP_CICLO,
	messaggio_V_BUONO,
	messaggio_ATTESA_RIMOZIONE_INIZIO_CICLO,

	// comandi manuali
	messaggio_INGRESSO_1,
	messaggio_INGRESSO_2,
	messaggio_INGRESSO_3,
	messaggio_INGRESSO_4,
	messaggio_INGRESSO_5,
	messaggio_INGRESSO_6,
	messaggio_INGRESSO_7,
	messaggio_INGRESSO_8,
	messaggio_INGRESSO_9,
	messaggio_INGRESSO_10,
	messaggio_INGRESSO_11,
	messaggio_INGRESSO_12,

	messaggio_USCITA_1,
	messaggio_USCITA_2,
	messaggio_USCITA_3,
	messaggio_USCITA_4,
	messaggio_USCITA_5,
	messaggio_USCITA_6,
	messaggio_USCITA_7,
	messaggio_USCITA_8,
	messaggio_USCITA_9,
	messaggio_USCITA_10,
	messaggio_USCITA_11,
	messaggio_USCITA_12,
	messaggio_USCITA_13,
	messaggio_USCITA_14,
	messaggio_USCITA_15,
	messaggio_USCITA_16,
	messaggio_USCITA_17,
	messaggio_USCITA_18,
	messaggio_USCITA_19,
	messaggio_USCITA_20,
	messaggio_USCITA_21,
	messaggio_USCITA_22,
	messaggio_USCITA_23,
	messaggio_USCITA_24,
	messaggio_USCITA_25,
	messaggio_USCITA_26,
	messaggio_USCITA_27,
	messaggio_USCITA_28,
	messaggio_USCITA_29,
	messaggio_USCITA_30,
	messaggio_USCITA_31,
	messaggio_USCITA_32,
	messaggio_USCITA_33,
	messaggio_USCITA_34,
	messaggio_USCITA_35,
	messaggio_USCITA_36,

	messaggio_numero_totale,
	messaggio_32bit = 0xFFFFFFFF,
}E_Messaggi;

//==============================================================================
// External variables

extern char messaggi[numero_lingue][messaggio_numero_totale][20+1];

//==============================================================================
// Global functions


#endif /* TLGB_MESSAGGI_EXT_H_ */
