/*
 * TLGB_Pagine_Selettore.c
 *
 *  Created on: 17/feb/2015
 *      Author: gozzini.davide
 */

//==============================================================================
// Include files

#include "drivers/my_LED.h"
#include "drivers/my_interrupt.h"
#include "drivers/tca8418_keypad.h"

#include "TLGB/TLGB_flash.h"
#include "TLGB/TLGB_Pagine_Selettore.h"

#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run.h"
#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run_Scelta_Pezzo.h"
#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run_Lotti.h"
#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run_Statistiche.h"
#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run_Risultati.h"


#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Comandi_Manuali.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Tempi.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Unita_Misura.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Soglie.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Stringhe.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Decimali.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Duplica_Ricetta.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Rinomina_Ricetta.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog_Scelta_Lingua.h"

#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Configurazione_ADC.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Configurazione_IO_Analogici.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Diagnostica_IO_Analogici.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Diagnostica_IO_Digitali.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Generali_Tempi.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Generali_Soglie.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Generali_Decimali.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Generali_Unita_Misura.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Stazione_Tempi.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Stazione_Soglie.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Stazione_Decimali.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb_Parametri_Stazione_Unita_Misura.h"


//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

static void azzera_variabili_run (void)
{
	refresh_schermo_run = 1; // serve per quando passo in run
	run_lvl0_selezionato = run_lvl0_pagina_principale_st1;
	lotti_lvl1_selezionato = lotti_lvl1_pagina_menu;
	statistiche_lvl1_selezionato = statistiche_lvl1_pagina_menu;
	risultati_lvl1_selezionato = risultati_lvl1_pagina_menu;
	scelta_pezzo_lvl1_selezionato = scelta_pezzo_lvl1_pagina_menu;
	invia_esito_lvl1_selezionato = invia_esito_lvl1_pagina_menu;
	return;
}

static void azzera_variabili_prog (void)
{
	refresh_schermo_prog = 1; // serve per quando passo in programazzione
	prog_lvl0_selezionato = prog_lvl0_tempi_st1;
	tempi_lvl1_selezionato = tempi_lvl1_pagina_menu;
	soglie_lvl1_selezionato = soglie_lvl1_pagina_menu;
	stringhe_lvl1_selezionato = stringhe_lvl1_pagina_menu;
	unita_misura_lvl1_selezionato = unita_misura_lvl1_pagina_menu;
	decimali_lvl1_selezionato = decimali_lvl1_pagina_menu;
	scelta_lingua_lvl1_selezionato = scelta_lingua_lvl1_pagina_menu;
	comandi_manuali_lvl1_selezionato = ingressi_uscite_pagina_menu;
	duplica_ricetta_lvl1_selezionato = duplica_ricetta_lvl1_pagina_menu;
	rinomina_ricetta_lvl1_selezionato = rinomina_ricetta_lvl1_pagina_menu;
	return;
}

static void azzera_variabili_tlgb (void)
{
	refresh_schermo_tlgb = 1; // serve per quando passo in tlgb
	tlgb_lvl0_selezionato = tlgb_lvl0_parametri_generali_tempi;
	parametri_generali_tempi_lvl1_selezionato = parametri_generali_tempi_lvl1_pagina_menu;
	parametri_generali_soglie_lvl1_selezionato = parametri_generali_soglie_lvl1_pagina_menu;
	parametri_generali_unita_misura_lvl1_selezionato = parametri_generali_unita_misura_lvl1_pagina_menu;
	parametri_generali_decimali_lvl1_selezionato = parametri_generali_decimali_lvl1_pagina_menu;
	parametri_stazione_tempi_lvl1_selezionato = parametri_stazione_tempi_lvl1_pagina_menu;
	parametri_stazione_soglie_lvl1_selezionato = parametri_stazione_soglie_lvl1_pagina_menu;
	parametri_stazione_unita_misura_lvl1_selezionato = parametri_stazione_unita_misura_lvl1_pagina_menu;
	parametri_stazione_decimali_lvl1_selezionato = parametri_stazione_decimali_lvl1_pagina_menu;
	diagnostica_io_digitali_lvl1_selezionato = diagnostica_io_digitali_lvl1_pagina_menu;
	diagnostica_io_analogici_lvl1_selezionato = diagnostica_io_analogici_lvl1_pagina_menu;
	configurazione_io_analogici_lvl1_selezionato = configurazione_io_analogici_lvl1_pagina_menu;
	configurazione_adc_lvl1_selezionato = configurazione_adc_lvl1_pagina_menu;
	return;
}

//==============================================================================
// Global variables

volatile selettore_pagine selettore_pagine_selezionata = selettore_pagine_run;

//==============================================================================
// Global functions

void selettore_pagina (void)
{
	switch(microcheck_in_run)
	{
		case 0:
		{
			if( (Key_is_pressed() == 1)
				&& (Key_last_pressed() == TASTO_2F)
			)
			{
				selettore_pagine_selezionata = selettore_pagine_tlgb;
			}
			else
			{
				Set_LED_PROG(LED_ON);
				selettore_pagine_selezionata = selettore_pagine_prog;
			}
		}
		break;
		case 1:
		{
			Set_LED_PROG(LED_OFF);
			selettore_pagine_selezionata = selettore_pagine_run;

			WriteRicette(&ricetta);
			WriteSalva(&salva);
		    WriteParametri(&parametri);
		    WriteAdc(&adc);

		}
		break;
	}

	azzera_variabili_run();
	azzera_variabili_prog();
	azzera_variabili_tlgb();
	return;
}
