/*
 * TLGB_Strutture.h
 *
 *  Created on: 24/feb/2015
 *      Author: gozzini.davide
 */

#ifndef TLGB_STRUTTURE_EXT_H_
#define TLGB_STRUTTURE_EXT_H_

//==============================================================================
// Include files

//==============================================================================
// Constants

//==============================================================================
// Types

typedef enum{
	lingua_italiano = 0,
	lingua_inglese,
	numero_lingue,
	EnumLingue_32bit = 0xFFFFFFFF,
}E_Lingue;

typedef enum{
	stazione_1 = 0,
	//stazione_2,
	numero_stazioni,
	EnumStazioni_32bit = 0xFFFFFFFF,
}E_Stazioni;

typedef enum{
	programma_0 = 0,
	programma_1,
	programma_2,
	programma_3,
	programma_4,
	programma_5,
	programma_6,
	programma_7,
	programma_8,
	programma_9,
	programma_10,
	programma_11,
	numero_programmi,
	EnumProgrammi_32bit = 0xFFFFFFFF,
}E_Programmi;

typedef enum{
	unita_misura_NULL = 0,
	unita_misura_pascal,
	unita_misura_mbar,
	unita_misura_bar,
	unita_misura_ncc_min,
	unita_misura_ncc_ora,
	unita_misura_nl_min,
	unita_misura_nl_ora,
	unita_misura_numeri,
	unita_misura_centimetri_cubi,
	unita_misura_numero_totale,
	unita_misura_32bit = 0xFFFFFFFF,
}E_UnitaMisura;

typedef enum{
	tipo_di_dato_float = 0,
	tipo_di_dato_unsigned_long,
	tipo_di_dato_32bit = 0xFFFFFFFF,
}E_TipiDato;

//==============================================================================
// External variables

extern char unita_misura[unita_misura_numero_totale][5+1];

//==============================================================================
// Global functions

#endif /* TLGB_STRUTTURE_EXT_H_ */
