/*
 * TLGB_flash.h
 *
 *  Created on: 24/feb/2015
 *      Author: gozzini.davide
 */

#ifndef TLGB_FLASH_EXT_H_
#define TLGB_FLASH_EXT_H_

//==============================================================================
// Include files

#include "drivers/AD7193.h"
#include "TLGB/TLGB_Strutture.h"
#include "TLGB/TLGB_TempiSoglieParametri.h"

//==============================================================================
// Constants

#define PACKED __attribute__ ((packed))

//==============================================================================
// Types

// Ricette
typedef struct
{
	// variabili delle ricette
	char titolo[numero_programmi][13];
	float tempi[numero_programmi][numero_stazioni][tempo_numero_totale];
	float soglie[numero_programmi][numero_stazioni][soglia_numero_totale];

	// impostazioni delle ricette
	E_UnitaMisura umis[soglia_numero_totale];
	unsigned long decimali[soglia_numero_totale];
	char stringhe[numero_programmi][numero_stazioni][stringhe_numero_totale][13];
}PACKED TFlashRicetta;

// Parametri generali
typedef struct
{
	float tempi_generali[tempi_generali_numero_totale];
	float soglie_generali[soglie_generali_numero_totale];
	E_UnitaMisura umis_generali[soglie_generali_numero_totale];
	unsigned long decimali_generali[soglie_generali_numero_totale];

	float tempi_stazione[numero_stazioni][tempi_stazione_numero_totale];
	float soglie_stazione[numero_stazioni][soglia_stazione_numero_totale];
	unsigned long decimali_stazione[soglia_stazione_numero_totale];
	E_UnitaMisura umis_stazione[soglia_stazione_numero_totale];
}PACKED TFlashParametri;

typedef struct
{
	unsigned long NPuntiAttivi;
	float Tensione[10]; // 10 punti
	float Grandezza[10]; // 10 punti
}PACKED TLinearizzazione;

// Salva
typedef struct
{
	E_Lingue lingua;
	E_Programmi programma_attivo[numero_stazioni];
}PACKED TFlashSalva;

// Adc
typedef struct
{
	TAcquisitionManage AcquisitionManage;
	TMode Mode;
	TConfiguration Configuration;
	TLinearizzazione Linearizzazione[4]; // 4 canali analogici
	E_UnitaMisura umis[4]; // 4 canali analogici
	unsigned long decimali[4]; // 4 canali analogici
}PACKED TFlashAdc;


//==============================================================================
// External variables

extern TFlashRicetta ricetta;
extern TFlashParametri parametri;
extern TFlashSalva salva;
extern TFlashAdc adc;

//==============================================================================
// Global functions

void TLGB_Flash_Init(void);

extern void WriteRicette(TFlashRicetta *par);
extern void ReadRicette(TFlashRicetta *par);
void WriteParametri(TFlashParametri *par);
void ReadParametri(TFlashParametri *par);
void WriteSalva(TFlashSalva *par);
void ReadSalva(TFlashSalva *par);
void WriteAdc(TFlashAdc *par);
void ReadAdc(TFlashAdc *par);


#endif /* TLGB_FLASH_EXT_H_ */
