/*
 * AD7193.h
 *
 *  Created on: gg/mmm/ccaa
 *      Author: cognome.nome
 */

#ifndef __AD7193__H__
#define __AD7193__H__

//==============================================================================
// Include files

//==============================================================================
// Constants

//==============================================================================
// Types

typedef enum{
	Refin_1,// differenziale
	Refin_2,// single ended
	ReferenceNone = 0xFFFFFFFF
}EReference;

typedef enum
{
	ChannelNum0,
	ChannelNum1,
	ChannelNum2,
	ChannelNum3,
	ChannelNum4,
	ChannelNumberNone = 0xFFFFFFFF
}EChannelNumber;

// Register Selection
typedef enum
{
	Communications_register_during_a_write_operation,
	Status_register_during_a_read_operation,
	Mode_register,
	Configuration_register,
	Data_register_data_register_plus_status_information,
	ID_register,
	GPOCON_register,
	Offset_register,
	Full_scale_register
}ERegisterSelection;

// Operating Modes (MD)
typedef enum
{
	Continuous_conversion_mode,
	Single_conversion_mode,
	Idle_mode,
	Power_down_mode,
	Internal_zero_scale_calibration,
	Internal_full_scale_calibration,
	System_zero_scale_calibration,
	System_full_scale_calibration
}EOperatingModes;

typedef enum
{
	ChannelID1,
	ChannelID2,
	ChannelID3,
	ChannelID4,
	ChannelIDNum,
	ChannelIDNone = 0xFFFFFFFF
}EChannelID;

// Communication register (WO) default 0x00
typedef struct
{
	union
	{
		struct
		{
			unsigned char DUMMY_0           :  1;
			unsigned char DUMMY_1      	    :  1;
			unsigned char CREAD             :  1;
			unsigned char RS0      	        :  1;
			unsigned char RS1           	:  1;
			unsigned char RS2       		:  1;
			unsigned char RnW           	:  1;
			unsigned char nWEN	            :  1;
		};
		unsigned char CommunicationsAll;
	};
}TCommunications;

// Status register (RO) default 0x80
typedef struct
{
	union
	{
		struct
		{
			unsigned char CHD0	            :  1;
			unsigned char CHD1      	    :  1;
			unsigned char CHD2              :  1;
			unsigned char CHD3     	        :  1;
			unsigned char Parity           	:  1;
			unsigned char NOREF       		:  1;
			unsigned char ERR           	:  1;
			unsigned char nRDY	            :  1;
		};
		unsigned char StatusAll;
	};
}TStatus;

// Mode register (R/W) default 0x080060
typedef struct
{
	union
	{
		struct
		{
			unsigned long FS	            :  10;
			unsigned long dummy_fs          :  22;
		};
		struct
		{
			unsigned long FS0	            :  1;
			unsigned long FS1       	    :  1;
			unsigned long FS2               :  1;
			unsigned long FS3     	        :  1;
			unsigned long FS4           	:  1;
			unsigned long FS5       		:  1;
			unsigned long FS6           	:  1;
			unsigned long FS7	            :  1;
			unsigned long FS8	            :  1;
			unsigned long FS9       	    :  1;
			unsigned long REJ60             :  1;
			unsigned long Single   	        :  1;
			unsigned long CLK_DIV          	:  1;
			unsigned long ENPAR       		:  1;
			unsigned long DUMMY_14         	:  1;
			unsigned long SINC3	            :  1;
			unsigned long AVG0	            :  1;
			unsigned long AVG1       	    :  1;
			unsigned long CLK0              :  1;
			unsigned long CLK1   	        :  1;
			unsigned long DAT_STA          	:  1;
			unsigned long MD0       		:  1;
			unsigned long MD1           	:  1;
			unsigned long MD2	            :  1;
			unsigned long DUMMY_24_31       :  8;
		};
		unsigned long ModeAll;
	};
}TMode;

// Configuration register (R/W) default 0x000117
typedef struct
{
	union
	{
		struct
		{
			unsigned long gain          : 3;
			unsigned long dummy_3_31    : 29;
		};
		struct
		{
			unsigned long G0            :  1;
			unsigned long G1       	    :  1;
			unsigned long G2            :  1;
			unsigned long U_B  	        :  1;
			unsigned long BUF          	:  1;
			unsigned long DUMMY_5  		:  1;
			unsigned long REFDET       	:  1;
			unsigned long Burn 	        :  1;
			unsigned long CH0           :  1;
			unsigned long CH1     	    :  1;
			unsigned long CH2           :  1;
			unsigned long CH3  	        :  1;
			unsigned long CH4          	:  1;
			unsigned long CH5      		:  1;
			unsigned long CH6      	    :  1;
			unsigned long CH7           :  1;
			unsigned long TEMP          :  1;
			unsigned long Short   	    :  1;
			unsigned long Pseudo        :  1;
			unsigned long DUMMY_19      :  1;
			unsigned long REFSEL        :  1;
			unsigned long DUMMY_21     	:  1;
			unsigned long DUMMY_22      :  1;
			unsigned long Chop	        :  1;
			unsigned long DUMMY_24_31   :  8;
		};
		unsigned long ConfigurationAll;
	};
}TConfiguration;

// Data register (RO) default 0x000000
typedef struct
{
	union
	{
		struct
		{
			unsigned long Data0	        : 1;
			unsigned long Data1	        : 1;
			unsigned long Data2	        : 1;
			unsigned long Data3	        : 1;
			unsigned long Data4	        : 1;
			unsigned long Data5	        : 1;
			unsigned long Data6	        : 1;
			unsigned long Data7	        : 1;
			unsigned long Data8	        : 1;
			unsigned long Data9	        : 1;
			unsigned long Data10        : 1;
			unsigned long Data11        : 1;
			unsigned long Data12        : 1;
			unsigned long Data13        : 1;
			unsigned long Data14        : 1;
			unsigned long Data15        : 1;
			unsigned long Data16        : 1;
			unsigned long Data17        : 1;
			unsigned long Data18        : 1;
			unsigned long Data19        : 1;
			unsigned long Data20        : 1;
			unsigned long Data21        : 1;
			unsigned long Data22        : 1;
			unsigned long Data23        : 1;
			unsigned long CHD0	        : 1;
			unsigned long CHD1      	: 1;
			unsigned long CHD2          : 1;
			unsigned long CHD3     	    : 1;
			unsigned long Parity        : 1;
			unsigned long NOREF       	: 1;
			unsigned long ERR           : 1;
			unsigned long nRDY	        : 1;
		};
		struct
		{
			unsigned long Data	        : 24;
			unsigned long Status_CHD    : 4;
			unsigned long StatusParity  : 1;
			unsigned long StatusNOREF   : 1;
			unsigned long StatusERR     : 1;
			unsigned long StatusnRDY    : 1;
		};
		struct
		{
			unsigned long DataLSB	    : 16;
			unsigned long DataMSB       : 16;
		};
		unsigned long DataAll;
	};
}TData;

typedef enum
{
	Single_ended,
	Differential,
	AcquistionModeNone = 0xFFFFFFFF
}EAcquistionMode;

typedef enum
{
	Gain1,
	Gain8,
	Gain16,
	Gain32,
	Gain64,
	Gain128,
	DimGain,
	GainNone = 0xFFFFFFFF
}EGainSelection;

// Offset register (RW) default 0x800000
typedef struct
{
	union
	{
		struct
		{
			unsigned long Offset        : 24;
			unsigned long DUMMY_24_31   :  8;
		};
		unsigned long OffsetAll;
	};
}TOffset;

// Full-scale register (R/W) default 0x5XXXX0
typedef struct
{
	union
	{
		struct
		{
			unsigned long FullScale     : 24;
			unsigned long DUMMY_24_31   :  8;
		};
		unsigned long FullScaleAll;
	};
}TFullScale;

typedef struct
{
	EAcquistionMode AcquisitionMode;
	//EReference      Reference;
	float   		ReferenceValueRefin_1;
	float	 		ReferenceValueRefin_2;
	float   		ReferenceValue;
	EChannelNumber  ChannelNumberSingleEnded;
	EChannelNumber  ChannelNumberDifferential;
	unsigned long   Gain;
	EGainSelection  GainSel;
	volatile unsigned long WaitDisableInterruptAD;
	volatile unsigned long ContinousReadAD;
}TAcquisitionManage;

//==============================================================================
// External variables

extern TCommunications Communications;
extern TStatus Status;
extern TMode Mode;
extern TMode ModeForCalib;
extern TConfiguration Configuration;
extern TConfiguration ConfigurationForCalib;
extern TData Data;
extern TOffset Offset;
extern TFullScale FullScale;
extern TAcquisitionManage AcquisitionManage;

//==============================================================================
// Global functions

inline unsigned long AD7193_Is_continuous_read(void);

long InitAD7193(TAcquisitionManage AcquisitionManage, TMode Mode, TConfiguration ConfigurationTLGB);
long InitAD7193ForCalibration(EAcquistionMode AcquisitionMode, EGainSelection GainSelection);
long GainSelector(TConfiguration *Config, TAcquisitionManage *AcqManage);
long AD7193_ReadOffsetRegister(void);
long AD7193_ReadFullScaleRegister(void);
long AD7193_WriteModeRegister(TMode *Mode);
long AD7193_WriteConfigurationRegister(TConfiguration *Configuration);
long AD7193_LED_ON(void);
long RegisterSelection(ERegisterSelection RegisterSelection);
long AD7193_Enable_Continuous_Read(void);
long AD7193_Disable_Continuous_Read(void);

//long AD7193_ReadStatusRegister(void);
//long AD7193_ReadModeRegister(void);
//long AD7193_ReadDataRegisterWithoutCommRegister(void);
//long AD7193_LED_OFF(void);
//long AD7193_REL1_ON(void);
//long AD7193_REL1_OFF(void);

#endif
