/*
 * my_EPI.h
 *
 *  Created on: gg/mmm/ccaa
 *      Author: cognome.nome
 *
 * ram esterna
 *
 * la RAM esterna  vista dal microprocessore come un buffer
 * da 8MByte con 4.194.303 (0x003FFFFF) indirizzi da 16 bit
 *
 * esempio: scrittura ai primi due indirizzi e successiva lettura
 * unsigned short dato_1_wr = 1;
 * unsigned short dato_2_wr = 2;
 * unsigned short dato_1_rd = 0;
 * unsigned short dato_2_rd = 0;
 *
 * EPI_write_RAM(0,dato_1_wr);
 * EPI_write_RAM(1,dato_2_wr);
 * EPI_read_RAM(0,&dato_1_rd);
 * EPI_read_RAM(1,&dato_2_rd);
 */

#ifndef __MY__EPI__H__
#define __MY__EPI__H__

//==============================================================================
// Include files

//==============================================================================
// Constants

#define SDRAM_START_ADDRESS 0x00000000
#define SDRAM_END_ADDRESS   0x003FFFFF

//==============================================================================
// Types

//==============================================================================
// External variables

//==============================================================================
// Global functions

long EPI_init(void);
long EPI_read_RAM(unsigned long address, unsigned short *data);
long EPI_write_RAM(unsigned long address, unsigned short data);

#endif
