/*
 * my_GPIO.h
 *
 *  Created on: gg/mmm/ccaa
 *      Author: cognome.nome
 *
 * dicihiarazione nome ingressi uscite
 *
 */

#ifndef __MY_GPIO__H__
#define __MY_GPIO__H__

//==============================================================================
// Include files

//==============================================================================
// Constants

#define WRITE_1			  0xFF
#define WRITE_0		      0x00

//==============================================================================
// Types

typedef struct
{
	union
	{
   		struct
    	{
			unsigned long in1     :  1;
			unsigned long in2     :  1;
			unsigned long in3     :  1;
			unsigned long in4     :  1;
			unsigned long dummy   : 28;
    	};
   		unsigned long in;
  	};//union_in;
}S_in;

typedef struct
{
	union
	{
   		struct
    	{
			unsigned long out_1_4     :  4;
			unsigned long out_5_8     :  4;
			unsigned long out_9_12    :  4;
			unsigned long dummy_1     : 20;
    	};
   		struct
    	{
			unsigned long out_1_8     :  8;
			unsigned long dummy_2     : 20;
    	};
   		struct
    	{
			unsigned long out1       :   1;
			unsigned long out2       :   1;
			unsigned long out3       :   1;
			unsigned long out4       :   1;
			unsigned long out5       :   1;
			unsigned long out6       :   1;
			unsigned long out7       :   1;
			unsigned long out8       :   1;
			unsigned long out9       :   1;
			unsigned long out10      :   1;
			unsigned long out11      :   1;
			unsigned long out12      :   1;
			unsigned long dummy_3    :  20;
    	};
   		unsigned long out;
  	};//union_out;
}S_out;

//==============================================================================
// External variables

//==============================================================================
// Global functions

inline void GPIO_set_COMANDO_VENTOLA(unsigned long value);
//inline void GPIO_set_REL_1(unsigned long value);
inline unsigned long GPIO_SEL_PROG_RUN_read(void);

long GPIO_init(void);

// il read diventa un interrupt quindi non mi servira'
long Read_Input_Module(unsigned long number, S_in *in);

// read output non la usiamo e teniamo in memoria come nel pc
//long Read_Output_Module(unsigned long number, S_out *out);

// scrivo in un colpo solo tutta la struttura di una scheda
// questa e' richiamare all'inizio o alla fine del ciclo
long Write_Output_Module(unsigned long number, S_out *out);

#endif
