/*
 * my_LED.c
 *
 *  Created on: gg/mmm/ccaa
 *      Author: cognome.nome
 *
 * gestione led di stato frontali
 *
 */

//==============================================================================
// Include files

#include "string.h"
#include "stdbool.h"
#include "stdint.h"

#include "inc/hw_memmap.h"

#include "driverlib/gpio.h"
#include "driverlib/sysctl.h"
#include "driverlib/rom.h"
#include "my_LED.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

//==============================================================================
// Global functions

long LED_init(void)
{

	ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOG);
	ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOM);
	ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOQ);
	ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOS);

	//CMD_LED_RESET
	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTG_BASE, GPIO_PIN_2);
	// CMD_LED_WATCH-D
	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTG_BASE, GPIO_PIN_3);
	// CMD_LED_PWR
	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTM_BASE, GPIO_PIN_7);
	//CMD_LED_PROG
	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTS_BASE, GPIO_PIN_6);
	//CMD_LED_LET-NUM
	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTS_BASE, GPIO_PIN_7);

	// CMD_LED_1
	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTQ_BASE, GPIO_PIN_4);
	// CMD_LED_2
	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTQ_BASE, GPIO_PIN_5);
	// CMD_LED_3
	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTQ_BASE, GPIO_PIN_6);
	// CMD_LED_4
	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTQ_BASE, GPIO_PIN_7);
	// CMD_LED_5
	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTM_BASE, GPIO_PIN_4);
	// CMD_LED_6
	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTM_BASE, GPIO_PIN_5);
	// CMD_LED_7
	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTM_BASE, GPIO_PIN_6);

	Set_LED_RESET(LED_OFF);
	Set_LED_WATCH_D(LED_OFF);
	Set_LED_POWER(LED_ON);
	Set_LED_LET_NUM(LED_OFF);
	Set_LED_PROG(LED_OFF);
	Set_LED_1(LED_OFF);
	Set_LED_2(LED_OFF);
	Set_LED_3(LED_OFF);
	Set_LED_4(LED_OFF);
	Set_LED_5(LED_OFF);
	Set_LED_6(LED_OFF);
	Set_LED_7(LED_OFF);

	return 0;
}


void Set_LED_RESET(unsigned long value)
{
	ROM_GPIOPinWrite(GPIO_PORTG_BASE, GPIO_PIN_2, (value<<2));
}

void Set_LED_WATCH_D(unsigned long value)
{
	ROM_GPIOPinWrite(GPIO_PORTG_BASE, GPIO_PIN_3, (value<<3));
}

void Set_LED_POWER(unsigned long value)
{
	ROM_GPIOPinWrite(GPIO_PORTM_BASE, GPIO_PIN_7, (value<<7));
}

void Set_LED_LET_NUM(unsigned long value)
{
	ROM_GPIOPinWrite(GPIO_PORTS_BASE, GPIO_PIN_6, (value<<6));
}

void Set_LED_PROG(unsigned long value)
{
	ROM_GPIOPinWrite(GPIO_PORTS_BASE, GPIO_PIN_7, (value<<7));
}

void Set_LED_1(unsigned long value)
{
	ROM_GPIOPinWrite(GPIO_PORTQ_BASE, GPIO_PIN_4, (value<<4));
}

void Set_LED_2(unsigned long value)
{
	ROM_GPIOPinWrite(GPIO_PORTQ_BASE, GPIO_PIN_5, (value<<5));
}

void Set_LED_3(unsigned long value)
{
	ROM_GPIOPinWrite(GPIO_PORTQ_BASE, GPIO_PIN_6, (value<<6));
}

void Set_LED_4(unsigned long value)
{
	ROM_GPIOPinWrite(GPIO_PORTQ_BASE, GPIO_PIN_7, (value<<7));
}

void Set_LED_5(unsigned long value)
{
	ROM_GPIOPinWrite(GPIO_PORTM_BASE, GPIO_PIN_4, (value<<4));
}

void Set_LED_6(unsigned long value)
{
	ROM_GPIOPinWrite(GPIO_PORTM_BASE, GPIO_PIN_5, (value<<5));
}

void Set_LED_7(unsigned long value)
{
	ROM_GPIOPinWrite(GPIO_PORTM_BASE, GPIO_PIN_6, (value<<6));
}


