/*
 * my_SPI.c
 *
 *  Created on: gg/mmm/ccaa
 *      Author: cognome.nome
 *
 * non toccare
 * funzioni per dialogare con ADC e DAC
 *
 */

//==============================================================================
// Include files

#include "stdbool.h"
#include "stdint.h"

#include "inc/hw_memmap.h"
#include "inc/hw_ints.h"

#include "driverlib/interrupt.h"
#include "driverlib/rom.h"
#include "driverlib/rom_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/gpio.h"
#include "driverlib/timer.h"

#include "drivers/AD7193.h"
#include "my_GPIO.h"
#include "my_SPI.h"
#include "main.h"
#include "drivers/my_semaphore.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

static volatile unsigned long counter_timer1 = 0;
static volatile unsigned long counter_timer2 = 0;
static volatile unsigned long counter_timer3 = 0;

//==============================================================================
// Static functions

static inline void SPI_WriteCommunication_Timer_Disable(void)
{
	ROM_TimerIntDisable(TIMER0_BASE, TIMER_TIMA_TIMEOUT);
	ROM_TimerIntClear(TIMER0_BASE, TIMER_TIMA_TIMEOUT);
}

static inline void SPI_Write_Timer_Enable(void)
{
	ROM_TimerIntClear(TIMER1_BASE, TIMER_TIMA_TIMEOUT);
	ROM_TimerIntEnable(TIMER1_BASE, TIMER_TIMA_TIMEOUT);
}

static inline void SPI_Write_Timer_Disable(void)
{
	ROM_TimerIntDisable(TIMER1_BASE, TIMER_TIMA_TIMEOUT);
	ROM_TimerIntClear(TIMER1_BASE, TIMER_TIMA_TIMEOUT);
}

static inline void SPI_Read_Timer_Disable(void)
{
	ROM_TimerIntDisable(TIMER2_BASE, TIMER_TIMA_TIMEOUT);
	ROM_TimerIntClear(TIMER2_BASE, TIMER_TIMA_TIMEOUT);
}


// WRITE COMUNICATION REGISTER
static long InitTimer0(void)
{
    // The Timer0 peripheral must be enabled for use.
    ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_TIMER0);

    // Configure 32-bit periodic timer A.
    ROM_TimerConfigure(TIMER0_BASE, TIMER_CFG_PERIODIC);
    ROM_TimerLoadSet(TIMER0_BASE, TIMER_A, g_ui32SysClock/500000); // 500KHz

    // Setup the interrupts for the timer timeouts.
    ROM_TimerIntDisable(TIMER0_BASE, TIMER_TIMA_TIMEOUT);
    ROM_IntEnable(INT_TIMER0A);

    // Enable the timers.
    ROM_TimerEnable(TIMER0_BASE, TIMER_A);

	return 0;
}

// WRITE
static long InitTimer1(void)
{
    // The Timer1 peripheral must be enabled for use.
    ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_TIMER1);

    // Configure 32-bit periodic timer A.
    ROM_TimerConfigure(TIMER1_BASE, TIMER_CFG_PERIODIC);
    ROM_TimerLoadSet(TIMER1_BASE, TIMER_A, g_ui32SysClock/500000); // 500KHz

    // Setup the interrupts for the timer timeouts.
    ROM_TimerIntDisable(TIMER1_BASE, TIMER_TIMA_TIMEOUT);
    ROM_IntEnable(INT_TIMER1A);

    // Enable the timers.
    ROM_TimerEnable(TIMER1_BASE, TIMER_A);

	return 0;
}

// READ
static long InitTimer2(void)
{
    // The Timer2 peripheral must be enabled for use.
    ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_TIMER2);

    // Configure 32-bit periodic timer A.
    ROM_TimerConfigure(TIMER2_BASE, TIMER_CFG_PERIODIC);
    ROM_TimerLoadSet(TIMER2_BASE, TIMER_A, g_ui32SysClock/500000); // 500KHz

    // Setup the interrupts for the timer timeouts.
    ROM_TimerIntDisable(TIMER2_BASE, TIMER_TIMA_TIMEOUT);
    ROM_IntEnable(INT_TIMER2A);

    // Enable the timers.
    ROM_TimerEnable(TIMER2_BASE, TIMER_A);

	return 0;
}

//==============================================================================
// Global variables

TSPI SPI;

//==============================================================================
// Global functions

void InitSPI(void)
{
	ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);

	// ADC_SCLK -> 1
	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTA_BASE, GPIO_PIN_2);
	ROM_GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2, WRITE_1);

	// ADC_DIN
	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTA_BASE, GPIO_PIN_4);

	// ADC_CS -> 0
	ROM_GPIOPinTypeGPIOOutput(GPIO_PORTA_BASE, GPIO_PIN_3);
	ROM_GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_3, WRITE_0);

	//-----------------------------------------------------------------------------------------
    // interrupt sul falling edge del segnale per lettura dati ADC quando  in lettura continua
	//-----------------------------------------------------------------------------------------
	// ADC_DOUT
	ROM_GPIOPinTypeGPIOInput(GPIO_PORTA_BASE, GPIO_PIN_5);
	GPIOPadConfigSet(GPIO_PORTA_BASE, GPIO_PIN_5, GPIO_STRENGTH_2MA, GPIO_PIN_TYPE_STD_WPU); // Push-pull with weak pull-up
    ROM_GPIOIntTypeSet(GPIO_PORTA_BASE, GPIO_PIN_5, GPIO_FALLING_EDGE);
    ROM_GPIOIntDisable(GPIO_PORTA_BASE, GPIO_PIN_5);
    ROM_IntEnable(INT_GPIOA);
	//----------------------------------------------------

	InitTimer0();
	InitTimer1();
	InitTimer2();
}

void SPI_WriteCommunication_Timer_Enable(void)
{
	ROM_TimerIntClear(TIMER0_BASE, TIMER_TIMA_TIMEOUT);
	ROM_TimerIntEnable(TIMER0_BASE, TIMER_TIMA_TIMEOUT);
}

void SPI_Read_Timer_Enable(void)
{
	ROM_TimerIntClear(TIMER2_BASE, TIMER_TIMA_TIMEOUT);
	ROM_TimerIntEnable(TIMER2_BASE, TIMER_TIMA_TIMEOUT);
}

void GPIO_set_ADC_SCLK(unsigned long value)
{
	ROM_GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_2, value);
}

void GPIO_set_ADC_DIN(unsigned long value)
{
	ROM_GPIOPinWrite(GPIO_PORTA_BASE, GPIO_PIN_4, value);
}

unsigned char GPIO_get_ADC_DOUT(void)
{
	return(ROM_GPIOPinRead(GPIO_PORTA_BASE, GPIO_PIN_5) >> 5);
}

void SPI_Continuous_Read_Enable(void)
{
	ROM_GPIOIntClear(GPIO_PORTA_BASE, GPIO_PIN_5);
	ROM_GPIOIntEnable(GPIO_PORTA_BASE, GPIO_PIN_5);
}

void SPI_Continuous_Read_Disable(void)
{
	ROM_GPIOIntDisable(GPIO_PORTA_BASE, GPIO_PIN_5);
	ROM_GPIOIntClear(GPIO_PORTA_BASE, GPIO_PIN_5);
}

void Timer0_WriteCommunicationSPI(void)
{
    ROM_TimerIntClear(TIMER0_BASE, TIMER_TIMA_TIMEOUT);

    counter_timer1++;

    switch(SPI.COMM_counter)
    {
    	// cambia il dato
		case 16:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(Communications.nWEN)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 14:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(Communications.RnW)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 12:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(Communications.RS2)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 10:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(Communications.RS1)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 8:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(Communications.RS0)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 6:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(Communications.CREAD)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 4:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(Communications.DUMMY_1)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 2:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(Communications.DUMMY_0)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
    	// dato valido
		case 15:
		case 13:
		case 11:
		case 9:
		case 7:
		case 5:
		case 3:
		case 1:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_1);
    	}break;
		case 0:
		{
			if(SPI.RnW) // read
			{
				SPI_Read_Timer_Enable();
				SPI_WriteCommunication_Timer_Disable();
			}
			else        // write
			{
				SPI_Write_Timer_Enable();
				SPI_WriteCommunication_Timer_Disable();
			}
		}break;
		default:{}
    }

	SPI.COMM_counter--;
}

void Timer1_WriteSPI(void)
{
    ROM_TimerIntClear(TIMER1_BASE, TIMER_TIMA_TIMEOUT);

    counter_timer2++;

    switch(SPI.WR_counter)
    {
		case 48:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			if(SPI.DataW.BIT23)
			{
				GPIO_set_ADC_DIN(WRITE_1);
			}
			else
			{
				GPIO_set_ADC_DIN(WRITE_0);
			}
		}break;
		case 46:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			if(SPI.DataW.BIT22)
			{
				GPIO_set_ADC_DIN(WRITE_1);
			}
			else
			{
				GPIO_set_ADC_DIN(WRITE_0);
			}
		}break;
		case 44:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			if(SPI.DataW.BIT21)
			{
				GPIO_set_ADC_DIN(WRITE_1);
			}
			else
			{
				GPIO_set_ADC_DIN(WRITE_0);
			}
		}break;
		case 42:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			if(SPI.DataW.BIT20)
			{
				GPIO_set_ADC_DIN(WRITE_1);
			}
			else
			{
				GPIO_set_ADC_DIN(WRITE_0);
			}
		}break;
		case 40:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			if(SPI.DataW.BIT19)
			{
				GPIO_set_ADC_DIN(WRITE_1);
			}
			else
			{
				GPIO_set_ADC_DIN(WRITE_0);
			}
		}break;
		case 38:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			if(SPI.DataW.BIT18)
			{
				GPIO_set_ADC_DIN(WRITE_1);
			}
			else
			{
				GPIO_set_ADC_DIN(WRITE_0);
			}
		}break;
		case 36:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			if(SPI.DataW.BIT17)
			{
				GPIO_set_ADC_DIN(WRITE_1);
			}
			else
			{
				GPIO_set_ADC_DIN(WRITE_0);
			}
		}break;
		case 34:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			if(SPI.DataW.BIT16)
			{
				GPIO_set_ADC_DIN(WRITE_1);
			}
			else
			{
				GPIO_set_ADC_DIN(WRITE_0);
			}
		}break;
		case 32:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			if(SPI.DataW.BIT15)
			{
				GPIO_set_ADC_DIN(WRITE_1);
			}
			else
			{
				GPIO_set_ADC_DIN(WRITE_0);
			}
		}break;
		case 30:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			if(SPI.DataW.BIT14)
			{
				GPIO_set_ADC_DIN(WRITE_1);
			}
			else
			{
				GPIO_set_ADC_DIN(WRITE_0);
			}
		}break;
		case 28:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			if(SPI.DataW.BIT13)
			{
				GPIO_set_ADC_DIN(WRITE_1);
			}
			else
			{
				GPIO_set_ADC_DIN(WRITE_0);
			}
		}break;
		case 26:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			if(SPI.DataW.BIT12)
			{
				GPIO_set_ADC_DIN(WRITE_1);
			}
			else
			{
				GPIO_set_ADC_DIN(WRITE_0);
			}
		}break;
		case 24:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			if(SPI.DataW.BIT11)
			{
				GPIO_set_ADC_DIN(WRITE_1);
			}
			else
			{
				GPIO_set_ADC_DIN(WRITE_0);
			}
		}break;
		case 22:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			if(SPI.DataW.BIT10)
			{
				GPIO_set_ADC_DIN(WRITE_1);
			}
			else
			{
				GPIO_set_ADC_DIN(WRITE_0);
			}
		}break;
		case 20:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			if(SPI.DataW.BIT9)
			{
				GPIO_set_ADC_DIN(WRITE_1);
			}
			else
			{
				GPIO_set_ADC_DIN(WRITE_0);
			}
		}break;
		case 18:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(SPI.DataW.BIT8)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 16:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(SPI.DataW.BIT7)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 14:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(SPI.DataW.BIT6)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 12:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(SPI.DataW.BIT5)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 10:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(SPI.DataW.BIT4)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 8:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(SPI.DataW.BIT3)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 6:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(SPI.DataW.BIT2)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 4:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(SPI.DataW.BIT1)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 2:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_0);
    	    if(SPI.DataW.BIT0)
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_1);
    	    }
    	    else
    	    {
    	    	GPIO_set_ADC_DIN(WRITE_0);
    	    }
    	}break;
		case 0:
    	{
    	    SPI_Write_Timer_Disable();
    	    ReleaseSemaphore(&sem_ADC);
    	}break;
    	// dato valido
		case 47:
		case 45:
		case 43:
		case 41:
		case 39:
		case 37:
		case 35:
		case 33:
		case 31:
		case 29:
		case 27:
		case 25:
		case 23:
		case 21:
		case 19:
		case 17:
		case 15:
		case 13:
		case 11:
		case 9:
		case 7:
		case 5:
		case 3:
		case 1:
    	{
    	    GPIO_set_ADC_SCLK(WRITE_1);
    	}break;
		default:{}
    }

	SPI.WR_counter--;
}

void Timer2_ReadSPI(void)
{
    ROM_TimerIntClear(TIMER2_BASE, TIMER_TIMA_TIMEOUT);

    counter_timer3++;

    switch(SPI.RD_counter)
    {
		case 64:
		case 62:
		case 60:
		case 58:
		case 56:
		case 54:
		case 52:
		case 50:
		case 48:
		case 46:
		case 44:
		case 42:
		case 40:
		case 38:
		case 36:
		case 34:
		case 32:
		case 30:
		case 28:
		case 26:
		case 24:
		case 22:
		case 20:
		case 18:
		case 16:
		case 14:
		case 12:
		case 10:
		case 8:
		case 6:
		case 4:
		case 2:
		{
			GPIO_set_ADC_SCLK(WRITE_0);
			SPI.RD_counter--;
		}break;
		// leggo il dato
		case 63:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT31 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 61:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT30 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 59:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT29 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 57:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT28 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 55:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT27 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 53:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT26 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 51:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT25 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 49:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT24 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 47:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT23 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 45:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT22 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 43:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT21 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 41:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT20 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 39:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT19 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 37:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT18 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 35:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT17 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 33:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT16 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 31:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT15 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 29:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT14 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 27:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT13 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 25:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT12 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 23:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT11 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 21:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT10 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 19:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT9 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 17:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT8 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 15:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT7 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 13:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT6 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 11:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT5 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 9:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT4 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 7:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT3 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 5:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT2 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 3:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT1 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 1:
		{
			GPIO_set_ADC_SCLK(WRITE_1);
			SPI.DataR.BIT0 = GPIO_get_ADC_DOUT();
			SPI.RD_counter--;
		}break;
		case 0:
		{
			switch(SPI.RegisterSelection)
			{
				case Status_register_during_a_read_operation:
				{
					Status.StatusAll = SPI.DataR.DataSPIBYTE0;
				}break;
				case Mode_register:
				{
					Mode.ModeAll = SPI.DataR.DataSPIAll;
				}break;
				case Data_register_data_register_plus_status_information:
				{
					Data.DataAll = SPI.DataR.DataSPIAll;
				}break;
				case Offset_register:
				{
					Offset.OffsetAll = SPI.DataR.DataSPIAll;
				}break;
				case Full_scale_register:
				{
					FullScale.FullScaleAll = SPI.DataR.DataSPIAll;
				}break;
				default:{}
			}
			SPI_Read_Timer_Disable();
			ReleaseSemaphore(&sem_ADC);
		}break;
		default:{}
    }
}
