/*
 * my_SPI.h
 *
 *  Created on: gg/mmm/ccaa
 *      Author: cognome.nome
 *
 * non toccare
 *
 */

#ifndef __MY_SPI__H__
#define __MY_SPI__H__

//==============================================================================
// Include files

#include "inc/hw_memmap.h"

#include "driverlib/gpio.h"
#include "driverlib/rom.h"
#include "driverlib/timer.h"

#include "drivers/AD7193.h"
#include "main.h"
#include "drivers/my_semaphore.h"

//==============================================================================
// Constants

//==============================================================================
// Types

typedef struct
{
	volatile ERegisterSelection RegisterSelection;
	volatile unsigned long 		RnW;				// write = 0, read = 1
	volatile EBitCounter   		COMM_counter;
	volatile EBitCounter   		WR_counter;
	volatile EBitCounter   		RD_counter;
	// Register To SPI
	struct
	{
		union
		{
			struct
			{
				unsigned long BIT0	            :  1;
				unsigned long BIT1      	    :  1;
				unsigned long BIT2              :  1;
				unsigned long BIT3      	    :  1;
				unsigned long BIT4           	:  1;
				unsigned long BIT5      		:  1;
				unsigned long BIT6           	:  1;
				unsigned long BIT7	            :  1;
				unsigned long BIT8	            :  1;
				unsigned long BIT9      	    :  1;
				unsigned long BIT10             :  1;
				unsigned long BIT11      	    :  1;
				unsigned long BIT12           	:  1;
				unsigned long BIT13     		:  1;
				unsigned long BIT14           	:  1;
				unsigned long BIT15	            :  1;
				unsigned long BIT16	            :  1;
				unsigned long BIT17      	    :  1;
				unsigned long BIT18             :  1;
				unsigned long BIT19      	    :  1;
				unsigned long BIT20           	:  1;
				unsigned long BIT21      		:  1;
				unsigned long BIT22           	:  1;
				unsigned long BIT23	            :  1;
				unsigned long BIT24	            :  1;
				unsigned long BIT25      	    :  1;
				unsigned long BIT26             :  1;
				unsigned long BIT27      	    :  1;
				unsigned long BIT28           	:  1;
				unsigned long BIT29      		:  1;
				unsigned long BIT30           	:  1;
				unsigned long BIT31	            :  1;
			};
			unsigned long DataSPIAll;
		};
	}DataW;
	// Register To SPI
	struct
	{
		union
		{
			struct
			{
				unsigned long BIT0	            :  1;
				unsigned long BIT1      	    :  1;
				unsigned long BIT2              :  1;
				unsigned long BIT3      	    :  1;
				unsigned long BIT4           	:  1;
				unsigned long BIT5      		:  1;
				unsigned long BIT6           	:  1;
				unsigned long BIT7	            :  1;
				unsigned long BIT8	            :  1;
				unsigned long BIT9      	    :  1;
				unsigned long BIT10             :  1;
				unsigned long BIT11      	    :  1;
				unsigned long BIT12           	:  1;
				unsigned long BIT13     		:  1;
				unsigned long BIT14           	:  1;
				unsigned long BIT15	            :  1;
				unsigned long BIT16	            :  1;
				unsigned long BIT17      	    :  1;
				unsigned long BIT18             :  1;
				unsigned long BIT19      	    :  1;
				unsigned long BIT20           	:  1;
				unsigned long BIT21      		:  1;
				unsigned long BIT22           	:  1;
				unsigned long BIT23	            :  1;
				unsigned long BIT24	            :  1;
				unsigned long BIT25      	    :  1;
				unsigned long BIT26             :  1;
				unsigned long BIT27      	    :  1;
				unsigned long BIT28           	:  1;
				unsigned long BIT29      		:  1;
				unsigned long BIT30           	:  1;
				unsigned long BIT31	            :  1;
			};
			struct
			{
				unsigned char DataSPIBYTE0;
				unsigned char DataSPIBYTE1;
				unsigned char DataSPIBYTE2;
				unsigned char DataSPIBYTE3;
			};
			unsigned long DataSPIAll;
		};
	}DataR;
}TSPI;

//==============================================================================
// External variables

extern TSPI SPI;

//==============================================================================
// Global functions

void InitSPI(void);
void SPI_WriteCommunication_Timer_Enable(void);
void SPI_Read_Timer_Enable(void);
void GPIO_set_ADC_SCLK(unsigned long value);
void GPIO_set_ADC_DIN(unsigned long value);
unsigned char GPIO_get_ADC_DOUT(void);
void SPI_Continuous_Read_Enable(void);
void SPI_Continuous_Read_Disable(void);

// usare come extern in startup_ccs.c
//void Timer0_WriteCommunicationSPI(void);
//void Timer1_WriteSPI(void);
//void Timer2_ReadSPI(void);


#endif
