/*
 * my_flash.c
 *
 *  Created on: gg/mmm/ccaa
 *      Author: cognome.nome
 *
 * funzioni per utilizzare la eprom/flash
 *
 * i settori sono da 16Kbyte cio 16384 byte cio 0x4000 byte
 * la flash  da 1024 Kbyte cio 1048576 byte cio 0x100000 byte
 * ultimo settore 0xFC000
 *
 * ogni volta che faccio l'erase mi cancella tutto il settore, quindi 16Kbyte
 *
 */

//==============================================================================
// Include files

#include "string.h"
#include "stdbool.h"
#include "stdint.h"

#include "inc/hw_memmap.h"
#include "inc/hw_types.h"
#include "inc/hw_ints.h"
#include "inc/hw_flash.h"

#include "driverlib/interrupt.h"
#include "driverlib/rom.h"
#include "driverlib/rom_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/gpio.h"
#include "driverlib/flash.h"
#include "drivers/AD7193.h"

#include "drivers/my_flash.h"
#include "TLGB/TLGB_flash.h"

//==============================================================================
// Constants

#define START_PARAMETER_IP      				0xFC000
#define START_PARAMETER_CALIBRATION				0xF8000

//#define START_PARAMETER_CONFIG_CHANNELS_SECTOR	0x7D000
//#define START_PARAMETER_PRODUCT_SECTOR	        0x7E000
//#define START_PARAMETER_IP_SECTOR	            0x7F000

//==============================================================================
// Types

//==============================================================================
// Static global variables

//==============================================================================
// Static functions

//==============================================================================
// Global variables

volatile unsigned long counter_int_flash = 0;
TFlashParametersIP parIP;
TFlashCalibration FlashCalibration;
TFlashParProd parProd;
//TFlashChannelConfig channelConfig;

//==============================================================================
// Global functions

void Flash_Init(void)
{
	memset(&parIP,0xFF,sizeof(TFlashParametersIP));
	memset(&FlashCalibration,0xFF,sizeof(TFlashCalibration));
	TLGB_Flash_Init();

	ROM_FlashIntClear(FLASH_INT_ACCESS);
	ROM_FlashIntEnable(FLASH_INT_ACCESS);
	ROM_IntEnable(INT_FLASH);
}

void FlashIntHandler(void)
{
	ROM_FlashIntClear(FLASH_INT_ACCESS);

	counter_int_flash++;
}

void WriteEthernetParameters(TFlashParametersIP *par)
{
	if(par == NULL)
		return;

	ROM_FlashErase(START_PARAMETER_IP);

	ROM_FlashProgram((unsigned int *)par, START_PARAMETER_IP, sizeof(TFlashParametersIP));

	return;
}

void ReadEthernetParameters(TFlashParametersIP *par)
{
	TFlashParametersIP *tmp_ptr = NULL;

	if(par == NULL)
		return;

	tmp_ptr = (TFlashParametersIP *)START_PARAMETER_IP;
	memcpy(par,tmp_ptr,sizeof(TFlashParametersIP));

	return;
}

void WriteCalibrationParameters(TFlashCalibration *par)
{
	if(par == NULL)
		return;

	ROM_FlashErase(START_PARAMETER_CALIBRATION);

	ROM_FlashProgram((unsigned int *)par, START_PARAMETER_CALIBRATION, sizeof(TFlashCalibration));

	return;
}

void ReadCalibrationParameters(TFlashCalibration *par)
{
	TFlashCalibration *tmp_ptr = NULL;

	if(par == NULL)
		return;

	tmp_ptr = (TFlashCalibration *)START_PARAMETER_CALIBRATION;
	memcpy(par,tmp_ptr,sizeof(TFlashCalibration));

	return;
}

/*

void WriteChannelParameters(TFlashChannelConfig *par)
{
	if(par == NULL)
		return;

	ROM_FlashErase(START_PARAMETER_CONFIG_CHANNELS_SECTOR);

	ROM_FlashProgram((unsigned int *)par, START_PARAMETER_CONFIG_CHANNELS_SECTOR, sizeof(TFlashChannelConfig));

	return;
}

void ReadChannelParameters(TFlashChannelConfig *par)
{
	TFlashChannelConfig *tmp_ptr = NULL;

	if(par == NULL)
		return;

	tmp_ptr = (TFlashChannelConfig *)START_PARAMETER_CONFIG_CHANNELS_SECTOR;
	memcpy(par,tmp_ptr,sizeof(TFlashChannelConfig));

	return;
}

*/

void WriteProdParameters(TFlashParProd *par)
{
	if(par == NULL)
		return;

	ROM_FlashErase(START_PARAMETER_IP);

	ROM_FlashProgram((unsigned int *)par, START_PARAMETER_IP, sizeof(TFlashParProd));

	return;
}

void ReadProdParameters(TFlashParProd *par)
{
	TFlashParProd *tmp_ptr = NULL;

	if(par == NULL)
		return;

	tmp_ptr = (TFlashParProd *)START_PARAMETER_IP;
	memcpy(par,tmp_ptr,sizeof(TFlashParProd));

	return;
}
