/*
 * my_flash.h
 *
 *  Created on: gg/mmm/ccaa
 *      Author: cognome.nome
 *
 * strutture che leggo dalla flash
 *
 */

#ifndef __MY_FLASH__H__
#define __MY_FLASH__H__

//==============================================================================
// Include files

//==============================================================================
// Constants

//==============================================================================
// Types

typedef struct
{
	unsigned long IP_address;
	unsigned long IP_netmask;
	unsigned long IP_gateway;
}TFlashParametersIP;

typedef enum
{
	Ch1,
	Ch2,
	Ch3,
	Ch4,
	DimCh
}EChannel;

typedef struct
{
	unsigned long ChannelSingleEnded[DimCh];
	unsigned long ChannelDifferential[DimCh];
}TFlashOffsetFScale;

typedef struct
{
	TFlashOffsetFScale Offset[DimGain];
	TFlashOffsetFScale FScale[DimGain];
}TFlashCalibration;

typedef struct
{
	unsigned long serial_number;
	unsigned long part_number;
	signed long offset_ch_1;
	signed long offset_ch_2;
	signed long offset_ch_3;
	signed long offset_ch_4;
}TFlashParProd;

/*
typedef struct
{

}TFlashChannelConfig;
*/

//==============================================================================
// External variables

extern TFlashParametersIP parIP;
extern TFlashCalibration FlashCalibration;
extern TFlashParProd parProd;
//extern TFlashChannelConfig channelConfig;

//==============================================================================
// Global functions

void Flash_Init(void);
void WriteEthernetParameters(TFlashParametersIP *par);
void ReadEthernetParameters(TFlashParametersIP *par);
void WriteCalibrationParameters(TFlashCalibration *par);
void ReadCalibrationParameters(TFlashCalibration *par);
void WriteProdParameters(TFlashParProd *par);
void ReadProdParameters(TFlashParProd *par);

#endif
