/*
 * my_timer.h
 *
 *  Created on: gg/mmm/ccaa
 *      Author: cognome.nome
 *
 * funzione per leggere il tempo
 *
 */

#ifndef __MY_TIMER__H__
#define __MY_TIMER__H__

//==============================================================================
// Include files

//==============================================================================
// Constants

// VALORI VALIDI PER CLOCK A 120Mhz
// usare questa funzione ROM_SysCtlDelay(MILLI_DELAY);
// questa ferma tutto, tranne gli interrupt, piu' precisa di quella wait(ms)
// 1/120000000 * 3 (colpi di clock) * n volte = ritardo richiesto
#define MICRO_DELAY   40 //80
#define MILLI_DELAY   40000 //80000
#define SEC_DELAY     40000000 //80000000

// VALORI VALIDI PER CLOCK A 25Mhz
// usare questa funzione ROM_SysCtlDelay(MILLI_DELAY);
// questa ferma tutto, tranne gli interrupt, piu' precisa di quella wait(ms)
// 1/25000000 * 3 (colpi di clock) * n volte = ritardo richiesto
//#define MICRO_DELAY   8
//#define MILLI_DELAY   8333
//#define SEC_DELAY     8333333

// VALORI VALIDI PER CLOCK A 16Mhz
// usare questa funzione ROM_SysCtlDelay(MILLI_DELAY);
// questa ferma tutto, tranne gli interrupt, piu' precisa di quella wait(ms)
// 1/16000000 * 3 (colpi di clock) * n volte = ritardo richiesto
//#define MICRO_DELAY   5
//#define MILLI_DELAY   5333
//#define SEC_DELAY     5333333

//==============================================================================
// Types

//==============================================================================
// External variables

//==============================================================================
// Global functions

// usare come extern in startup_ccs.c
//void SysTickIntHandler(void)

long ResetTimerMs(unsigned long long *tm);
unsigned long GetTimerMs(unsigned long long tm);
long ResetTimerS(double *tm);
double GetTimerS(double tm);
long WaitMs(unsigned long tm);
long MyTimerInit(void);

#endif
