/*
 * my_uart.c
 *
 *  Created on: gg/mmm/ccaa
 *      Author: cognome.nome
 */

//==============================================================================
// Include files

#include "string.h"
#include "stdbool.h"
#include "stdint.h"
#include "stdlib.h"
//#include "stdarg.h"

#include "inc/hw_types.h"
#include "inc/hw_memmap.h"
//#include "inc/hw_epi.h"
#include "inc/hw_ints.h"
#include "inc/hw_uart.h"
//#include "inc/hw_gpio.h"
#include "driverlib/pin_map.h"
//#include "driverlib/debug.h"
//#include "driverlib/interrupt.h"
#include "driverlib/rom.h"
#include "driverlib/rom_map.h"
#include "driverlib/gpio.h"
#include "driverlib/sysctl.h"
#include "driverlib/uart.h"
//#include "utils/lwiplib.h"

#include "utils/uartstdio.h"
#include "drivers/my_ethernet.h"
#include "drivers/my_uart.h"
#include "drivers/my_USB.h"

//==============================================================================
// Constants

//==============================================================================
// Types

//==============================================================================
// Static global variables

char g_pcUARTRxBuffer[UART_RX_BUFFER_SIZE];
uint32_t g_ui32UARTRxReadIndex = 0;
uint32_t flag_interprete;


//==============================================================================
// Static functions

//==============================================================================
// Global variables

extern unsigned long g_ui32SysClock;
//==============================================================================
// Global functions

void UartInit(void)
{
	//CONFIGURAZIONE UART-SERIALE RS232 LIBRERIA STDLIB
	GPIOPinConfigure(GPIO_PA0_U0RX);
	GPIOPinConfigure(GPIO_PA1_U0TX);
	SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
	SysCtlDelay(3);
	GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);
	UARTClockSourceSet(UART0_BASE, UART_CLOCK_PIOSC);

	// funzione per configurare la porta, il baudrate, e il tempo del clock
	UARTStdioConfig(0, 9600,g_ui32SysClock);

	ROM_UARTEnable(UART0_BASE);
	ROM_UARTFIFOLevelSet(UART0_BASE, UART_FIFO_TX7_8, UART_FIFO_RX7_8);

	// Configure and enable UART interrupts.
	ROM_UARTIntClear(UART0_BASE, ROM_UARTIntStatus(UART0_BASE, false));
	ROM_UARTIntEnable(UART0_BASE, (UART_INT_RX | UART_INT_RT));

	// Enable interrupts now that the application is ready to start.
	ROM_IntEnable(INT_UART0);

	UARTEchoSet(0); // disabilito l'echo dei comandi
	return;
}

void UartInit2(void)
{
    ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_GPIOA);
    ROM_GPIOPinConfigure(GPIO_PA0_U0RX);
    ROM_GPIOPinConfigure(GPIO_PA1_U0TX);
    ROM_GPIOPinTypeUART(GPIO_PORTA_BASE, GPIO_PIN_0 | GPIO_PIN_1);
    ROM_SysCtlPeripheralEnable(SYSCTL_PERIPH_UART0);
	//UART Initialize
	//ROM_UARTConfigSetExpClk(UART0_BASE,SysCtlClockGet(), 9600, (UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
    ROM_UARTConfigSetExpClk(UART0_BASE,g_ui32SysClock, 9600, (UART_CONFIG_WLEN_8 | UART_CONFIG_STOP_ONE | UART_CONFIG_PAR_NONE));
 	ROM_UARTIntEnable(UART0_BASE, UART_INT_RX | UART_INT_RT);

 	ROM_UARTEnable(UART0_BASE);
 	ROM_IntEnable(INT_UART0);
}

void UARTSend2(char *pucBuffer)
{
	char ch;
	// Loop while there are more characters to send.
	while (*pucBuffer)
	{
		ch = *pucBuffer;
		ROM_UARTCharPut(UART0_BASE, ch);
		pucBuffer++;
	}
}

void UartTest(void)
{
	char g_pcUARTRxBuffer[UART_RX_BUFFER_SIZE + 1] = {0}; // uno spazio per il terminatore

	// controllo se e' arrivato qualche byte
	if(UARTRxBytesAvail())
	{
		// se e' arrivato controllo se e' presente un terminatore, i caratteri terminatori sono CR, LF, ESC
		if( (UARTPeek('\r') >= 0) || (UARTPeek('\n') >= 0) || (UARTPeek(0x1B) >= 0))
		{
			// se e' arrivato uno dei caratteri terminatori leggo la stringa
			UARTgets(g_pcUARTRxBuffer, sizeof(g_pcUARTRxBuffer));
			// svuoto il buffer di ingresso
			UARTFlushRx();
			// come test faccio l'echo della stringa ricevuta. attenzione, ricordarsi sempre di mettere il CR+LF alla fine del messaggio
			UARTprintf("echo: %s\n", g_pcUARTRxBuffer);
			// svuoto il buffer di uscita attendendo che siano stati inviati tutti i byte
			UARTFlushTx(0);
		}
	}
	return;
}


void interprete_comandi(void)
{
	uint32_t i;

	char txb[40];
	i=0;
	if(!strncmp(g_pcUARTRxBuffer,"ip",2))
	{
		 ip_conv(g_pcUARTRxBuffer,value_ip);
    }
	else if(!strncmp((const char*) g_pcUARTRxBuffer,"help",4))
	{
		strcpy(txb,"ip ###.###.###.###   -memorizza ip statico\n");
		UARTSend2(txb);
	}
	 for(i=0;i<10;i++) g_pcUARTRxBuffer[g_ui32UARTRxReadIndex]=0;
    g_ui32UARTRxReadIndex=0;
	flag_interprete=0;
}


//void UARTStdioIntHandler(void)
void UARTIntHandler(void)
{
	unsigned long ulStatus;
	//  Get the interrrupt status.
    ulStatus = ROM_UARTIntStatus(UART0_BASE, true);
    // Clear the asserted interrupts.
    ROM_UARTIntClear(UART0_BASE, ulStatus);
 	while(ROM_UARTCharsAvail(UART0_BASE))  g_pcUARTRxBuffer[g_ui32UARTRxReadIndex]=ROM_UARTCharGetNonBlocking(UART0_BASE);
    if(g_pcUARTRxBuffer[g_ui32UARTRxReadIndex]==0xD)flag_interprete=1;
  	else if(g_ui32UARTRxReadIndex<UART_RX_BUFFER_SIZE)g_ui32UARTRxReadIndex++;
}

