/*
 * tca8418_keypad.h
 *
 *  Created on: gg/mmm/ccaa
 *      Author: cognome.nome
 */

#ifndef _TCA8418_KEYPAD_H
#define _TCA8418_KEYPAD_H

//==============================================================================
// Include files

//==============================================================================
// Constants

//==============================================================================
// Types

typedef enum
{
	ZERO = 0,
	UNO,
	DUE,
	TRE,
	QUATTRO,
	CINQUE,
	SEI,
	SETTE,
	OTTO,
	NOVE,
	FRECCIA_SU,
	FRECCIA_GIU,
	LET_NUM,
	TASTO_2F,
	CLR,
	TARA,
	ENTER,
	START,
	STOP,
	KEY_NONE
}EKeyboard;

typedef struct
{
	volatile unsigned long counter_key_press; // contatore tasti premuti
	volatile unsigned long counter_key_release; // contatore tasti rilasciati
	EKeyboard              KeyPressed;     // Tasto premuto
	EKeyboard              KeyPressedPrev; // Tasto premuto precedente
	volatile unsigned long LedLetNum;      // LED lettere numeri
	volatile unsigned long KeyPressNum;    // Contatore pressione tasti
	volatile unsigned long KeyPressMod;    // Contatore pressione tasti in modulo
	volatile unsigned long lettera_ok;     // E' una lettera
	volatile unsigned long lettera_pronta; // Ho una lettera disponibile
	volatile unsigned long tasto_pronto;   // Non  una lettera
 	char                   lettera;

}TManageKeyb;

//==============================================================================
// External variables

extern TManageKeyb ManageKeyb;

//==============================================================================
// Global functions

// usare come extern in startup_ccs.c
//void GPIOJIntHandler(void);
//void Timer4_KeypadManage(void);

// da usare nell'applicazione TLGB
long tca8418_init(void);
long Key_is_pressed(void);
long Key_ready(void);
EKeyboard Key_last_pressed(void);
long Key_char_ready(void);
char Key_last_char_pressed(void);

#endif
