

//==============================================================================
// Include files

#include "string.h"
#include "stdbool.h"
#include "stdint.h"
#include "stdio.h"
#include "stdlib.h"


#include "inc/hw_memmap.h"
#include "inc/hw_ints.h"
#include "inc/hw_uart.h"

#include "driverlib/interrupt.h"
#include "driverlib/rom.h"
#include "driverlib/rom_map.h"
#include "driverlib/sysctl.h"
#include "driverlib/systick.h"
#include "driverlib/gpio.h"
#include "driverlib/uart.h"
#include "utils/lwiplib.h"

#include "drivers/my_GPIO.h"
#include "drivers/my_ethernet.h"
#include "drivers/my_EPI.h"
#include "drivers/my_SPI.h"
#include "drivers/AD7193.h"
#include "drivers/my_DAC.h"
#include "drivers/my_LCD.h"
#include "drivers/tca8418_keypad.h"
#include "drivers/my_timer.h"
#include "drivers/my_semaphore.h"
#include "drivers/my_GPIO.h"
#include "drivers/my_LED.h"
#include "drivers/my_interrupt.h"
#include "drivers/my_debug.h"
#include "drivers/my_flash.h"
#include "drivers/my_uart.h"
#include "drivers/my_USB.h"


#include "TLGB/TLGB_Funzioni.h"
#include "TLGB/TLGB_Diginout.h"
#include "TLGB/TLGB_Pagine_Selettore.h"
#include "TLGB/TLGB_flash.h"

#include "TLGB/PAGINE_RUN/TLGB_Pagine_Run.h"
#include "TLGB/PAGINE_PROG/TLGB_Pagine_Prog.h"
#include "TLGB/PAGINE_TLGB/TLGB_Pagine_Tlgb.h"

#include "utils/uartstdio.h"
#include "drivers/my_params_prod.h"

//==============================================================================
// Constants

// The error routine that is called if the driver library encounters an error.
#ifdef DEBUG
void
__error__(char *pcFilename, uint32_t ui32Line)
{
}
#endif

//==============================================================================
// Types

//==============================================================================
// Static global variables

//static volatile unsigned long counter_sec;
//static volatile unsigned long main_counter;
static unsigned long long TimerLedRunProg;
static unsigned long long TimerTastoPremuto;
uint32_t g_ui32SysTickCount;
uint16_t value_ip[4];



//static unsigned short data_ram = 0;

//==============================================================================
// Static functions

//==============================================================================
// Global variables
extern  uint32_t flag_interprete;

uint32_t  g_ui32SysClock = {0};
uint32_t  ui32PLLRate;

EKeyboard UltimoTastoPremuto = {KEY_NONE};
//char UltimaLetteraPremuta = {0};

//==============================================================================
// Global functions

int main(void)
{
	static selettore_pagine selettore_pagine_selezionata_old = selettore_pagine_32bit;

	//========================================================
	// IMPOSTAZIONE MASTER CLOCK  g_ui32SysClock
	//========================================================
//	g_ui32SysClock = 16000000; // 16MHz
//	g_ui32SysClock = MAP_SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ | SYSCTL_OSC_MAIN | SYSCTL_USE_PLL | SYSCTL_CFG_VCO_480), 25000000); // 25MHz
//  g_ui32SysClock = MAP_SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ | SYSCTL_OSC_MAIN | SYSCTL_USE_OSC), 25000000); // 25MHz
	//--------------------------------------------------------
	SysCtlMOSCConfigSet(SYSCTL_MOSC_HIGHFREQ); // abilita il main oscillator richiesto dalla ethernet
	// Run from the PLL at 120 MHz.
	g_ui32SysClock = MAP_SysCtlClockFreqSet((SYSCTL_XTAL_25MHZ | SYSCTL_OSC_MAIN | SYSCTL_USE_PLL | SYSCTL_CFG_VCO_480), 120000000);
	SysCtlVCOGet(SYSCTL_XTAL_25MHZ, &ui32PLLRate);
	//========================================================
	// INIZIALIZZO IL SEMAFORO
	//========================================================
    InitSemaphore(&sem_ADC);
    InitSemaphore(&sem_DAC);

	//========================================================
	// ABILITO GLI INTERRUPT
	//========================================================
    EnableInterrupts();

	//========================================================
	// INIZIALIZZO LA FLASH
    //========================================================
    Flash_Init();
    ReadRicette(&ricetta); // caricamento ricette
    ReadSalva(&salva); // caricamento salva
    ReadParametri(&parametri); // caricamento parametri
    ReadAdc(&adc); // caricamento adc

    ricava_npunti_min_max_ingressi(0);
    ricava_npunti_min_max_ingressi(1);
    ricava_npunti_min_max_ingressi(2);
    ricava_npunti_min_max_ingressi(3);

	//========================================================
	// INIZIALIZZO IL TIMER
    //========================================================
    MyTimerInit();

	//========================================================
	// INIZIALIZZO I MODULI I/O  e SERIALE RS-232
    //========================================================
    GPIO_init();

	//========================================================
	// INIZIALIZZO LA SPI
    //========================================================
    InitSPI();

	//========================================================
	// INIZIALIZZO L'ADC
    //========================================================
    // prima di questo init leggo da flash l'impostazione dell'ADC e passo i parametri giusti
	InitAD7193(adc.AcquisitionManage, adc.Mode, adc.Configuration);
    AD7193_LED_ON();
    AD7193_Enable_Continuous_Read();

	//========================================================
	// INIZIALIZZO LA MEMORIA
    //========================================================
    EPI_init();

	//========================================================
	// INIZIALIZZLO L'LCD
    //========================================================
    LCD_Init();

	//========================================================
	// INIZIALIZZO I LED
    //========================================================
    LED_init();

	//========================================================
	// INIZIALIZZO LA TASTIERA
    //========================================================
    tca8418_init();

	//========================================================
	// INIZIALIZZO IL DAC
    //========================================================
    InitDAC();

	//========================================================
	// INIZIALIZZO ETHERNET
    //========================================================
	// era attivo prima    
	//MyEthernetInit();
	//EthParamsProdInit(); // ServerSocket per mandare il dispositivo in boot e per programmare S/N ecc.( porta 40000 )

	//========================================================
	// INIZIALIZZO UART
    //========================================================
 	 UartInit2();




	//========================================================
    // FACCIO IL TEST DEGLI I/O
	//========================================================
    //Test_GPIO_MOD_1();
    //Test_GPIO_MOD_2();
    //Test_GPIO_MOD_3();

	//========================================================
	// MESSAGGIO DI BENVENUTO
	//========================================================
	LCD_Display_Clear();
	sprintf(MSG," Microcheck 1000 XL ");
    LCD_WriteLine(1,MSG);
    sprintf(MSG,"  TLGB SRL - Italy  ");
    LCD_WriteLine(2,MSG);
    sprintf(MSG," Via dell'industria ");
    LCD_WriteLine(3,MSG);
    sprintf(MSG,"  Travagliato (BS)  ");
    LCD_WriteLine(4,MSG);
    ROM_SysCtlDelay(SEC_DELAY);

    UARTSend2(MSG);
    UARTSend2("\n");
    LCD_Display_Clear();
    MyUSBInit();
	//EthParamsProdInit(); // ServerSocket per mandare il dispositivo in boot e per programmare S/N ecc.( porta 40000 )


	//========================================================
	// selettore chiave, chiamare all'inizio poi e' in interrupt
	//========================================================
    microcheck_in_run = GPIO_SEL_PROG_RUN_read();
	//selettore_pagina();

    //EPI_write_RAM(0, 0xAABB);
    //EPI_read_RAM(0, &data_ram);

	//========================================================
	// SPEGNIMENTO EV
	//========================================================
    init_ev();

    ResetTimerMs(&TimerLedRunProg);
    ResetTimerMs(&TimerTastoPremuto);

    //========================================================
    // ACCENDO LA VENTOLA
    //========================================================
    GPIO_set_COMANDO_VENTOLA(1);

    //UARTprintf("Inizio ciclo principale\n");
    //DaMicroAPC(); // novita'




	while(1)
    {
		//if (flag_interprete)
		//{
		//	interprete_comandi();
		//}

		USB_gest(); // qui si metteranno le funzioni necessarie per la USB
		if(ip_loaded==1)
		{
			 MyEthernetInit();
			 ip_loaded=2;
		}


		//UartTest(); // tengo acceso il ciclo di lettura seriale per svuotare il buffer di ingresso

	    //EPI_write_RAM(1000, 0xAABB);
	    //EPI_read_RAM(1000, &data_ram);
	    //WaitMs(1000);

    	//main_counter++;

		//if(parametri.generali[parametro_cambio_programma_IO])
		//{
		//	CambiaRicettaDaIO(stazione_1);
		//	CambiaRicettaDaIO(stazione_2);
		//}

		//if(flagBootCall == 1) // flash program from ethernet
		//{
		//	BootCall();
		//}

		if(Key_ready())
		{
		    ResetTimerMs(&TimerTastoPremuto);
			UltimoTastoPremuto = Key_last_pressed();
		}

		//if( (UltimoTastoPremuto == KEY_NONE) && Key_is_pressed() && (GetTimerMs(TimerTastoPremuto) > 300) )
		//{
		//	ResetTimerMs(&TimerTastoPremuto);
		//	UltimoTastoPremuto = Key_last_pressed();
		//}

		switch(UltimoTastoPremuto)
		{
			case START: // inizia il ciclo
			{
				UltimoTastoPremuto = KEY_NONE;
			}
			break;
			case STOP: // ferma il ciclo
			{
				UltimoTastoPremuto = KEY_NONE;
			}
			break;
		}

		leggi_analogiche();

    	switch(selettore_pagine_selezionata) // cambia nell'interrupt quando giro la chiave
    	{
			case selettore_pagine_run:
			{
				if(selettore_pagine_selezionata_old != selettore_pagine_selezionata)
				{
					selettore_pagine_selezionata_old = selettore_pagine_selezionata;
					UsciteDigitali.StrumentoPronto = 1;
					scrivi_uscite();
				}
	    		gestione_menu_run_lvl0();
			}
			break;
			case selettore_pagine_prog:
			{
				if(selettore_pagine_selezionata_old != selettore_pagine_selezionata)
				{
					selettore_pagine_selezionata_old = selettore_pagine_selezionata;
					UsciteDigitali.StrumentoPronto = 0;
					scrivi_uscite();
				}
				gestione_menu_prog_lvl0();
			}
			break;
			case selettore_pagine_tlgb:
			{
				if(selettore_pagine_selezionata_old != selettore_pagine_selezionata)
				{
					selettore_pagine_selezionata_old = selettore_pagine_selezionata;
					UsciteDigitali.StrumentoPronto = 0;
					scrivi_uscite();
				}

				gestione_menu_tlgb_lvl0();

		    	//=================================
		    	// contatore secondi
		    	if(GetTimerMs(TimerLedRunProg)> 1000)
		    	{
		    		Set_LED_PROG(LED_ON);
		    	}
		    	if(GetTimerMs(TimerLedRunProg)> 2000)
		    	{
		    		Set_LED_PROG(LED_OFF);
		        	ResetTimerMs(&TimerLedRunProg);
		    	}
			}
			break;
    	}
    }
}
