#ifndef VS1063_H_
#define VS1063_H_

void VS1063init();
void VS1063sendCMD(int reg, int cmd);
void VS1063sendData(int reg, int data);
void VS1063sendParam(int reg, int param);
int  VS1063readData(int reg);
void VS1063setEQ(int band);
void VS1063setVolume();
void VS1063playFile();
void LoadPlugIn();

static int playBuf[512];						// 512 byte large buffer
unsigned int bytesInBuffer;        				// How many bytes in buffer left

#define SDI_MAX_TRANSFER_SIZE 32
#define SDI_END_FILL_BYTES_FLAC 12288
#define SDI_END_FILL_BYTES       2050
#define REC_BUFFER_SIZE 512
#define SPEED_SHIFT_CHANGE 128

// Define controll pins
#define VS_DRQ 	 		GPIO_PIN_3
#define VS_DRQ_BASE 	GPIO_PORTG_BASE
#define VS_DRQ_INTR		INT_GPIOG
#define VS_FCS		 	GPIO_PIN_1
#define VS_FCS_BASE 	GPIO_PORTK_BASE
#define VS_DCS		 	GPIO_PIN_7
#define VS_DCS_BASE 	GPIO_PORTF_BASE
#define VS_RST   		GPIO_PIN_2
#define VS_RST_BASE 	GPIO_PORTG_BASE

// Define interface
#define VS_SSI_BASE SSI3_BASE
#define VS_SSI_PER  SYSCTL_PERIPH_SSI3
#define VS_SSI_PORT GPIO_PORTK_BASE
#define VS_MOSI		GPIO_PIN_3
#define VS_MISO		GPIO_PIN_2
#define VS_CLK		GPIO_PIN_0

// SCI registers
#define SCI_MODE        0x00	// Operation mode register
#define SCI_STATUS      0x01	// Status register
#define SCI_BASS        0x02	// Bass controll register
#define SCI_CLOCKF      0x03	// Clock configuration register
#define SCI_DECODE_TIME 0x04	// Current decoding time in secounds
#define SCI_AUDATA      0x05	// Current sampelrate and channel
#define SCI_WRAM        0x06	// WRAM register to upload user code
#define SCI_WRAMADDR    0x07	// Set adress to which the user code will be uploaded
#define SCI_HDAT0       0x08 	// Stream data register 0
#define SCI_HDAT1       0x09 	// Stream data register 1
#define SCI_AIADDR      0x0A	// Start adress of user code
#define SCI_VOL         0x0B	// Volume control register
#define SCI_AICTRL0     0x0C 	// User code access register
#define SCI_AICTRL1     0x0D 	// User code access register
#define SCI_AICTRL2     0x0E 	// User code access register
#define SCI_AICTRL3     0x0F 	// User code access register


//		SCI_MODE bits
#define SM_DIFF            0x0001	// Set differential mode for virtuell suround
#define SM_LAYER12         0x0002 	// Allow MPEG 2 layer
#define SM_RESET           0x0004	// Software reset
#define SM_CANCEL          0x0008	// Cancel decoding
#define SM_TESTS           0x0020	// Allow SDI test
#define SM_DACT            0x0100	// CLK edge select, 0 rising
#define SM_SDIORD          0x0200	// Bit order, 0 MSB first
#define SM_SDISHARE        0x0400	// Shared chip select, 0 no
#define SM_SDINEW          0x0800	// Native SPI mode
#define SM_ENCODE          0x1000 	// Activate encoding
#define SM_LINE1           0x4000 	// 0 Line, 1 MIC
#define SM_CLK_RANGE       0x8000 	// Input clcok range

//      SCI_STATUS bits
#define SS_REFERENCE_SEL  0x0001	// Reference voltage select
#define SS_AD_CLOCK       0x0002  	// AD Clock select
#define SS_APDOWN1	      0x0004	// Internal analog power down
#define SS_APDOWN2	      0x0008	// Analog driver power down
#define SS_VER1	          0x0010	// Version
#define SS_VER2	          0x0020	// Version
#define SS_VER3	          0x0040	// Version
#define SS_VER4	          0x0080	// Version
#define SS_VCM_DISABLE	  0x0400	// GBUF overload disabled
#define SS_VCM_OVERLOAD   0x0800	// GBUF overload indicator
#define SS_SWING0         0x1000	// Swing bit 0
#define SS_SWING1         0x2000	// Swing bit 1
#define SS_SWING2         0x4000	// Swing bit 2
#define SS_DO_NOT_JUMP    0x8000	// Do not fast forward/reverse

//		SCI_BASS bits
#define SB_FREQLIMIT0  0x0001	// Lower frequenzy bass limit bit 0
#define SB_FREQLIMIT1  0x0002	// Lower frequenzy bass limit bit 1
#define SB_FREQLIMIT2  0x0004	// Lower frequenzy bass limit bit 2
#define SB_FREQLIMIT3  0x0008	// Lower frequenzy bass limit bit 3
#define SB_AMPLITUDE0  0x0010	// Bass enhancment level bit 0
#define SB_AMPLITUDE1  0x0020	// Bass enhancment level bit 1
#define SB_AMPLITUDE2  0x0040	// Bass enhancment level bit 2
#define SB_AMPLITUDE3  0x0080	// Bass enhancment level bit 3
#define ST_FREQLIMIT0  0x0100	// Lower frequenzy treble limit bit 0
#define ST_FREQLIMIT1  0x0200	// Lower frequenzy treble limit bit 1
#define ST_FREQLIMIT2  0x0400	// Lower frequenzy treble limit bit 2
#define ST_FREQLIMIT3  0x0800	// Lower frequenzy treble limit bit 3
#define ST_AMPLITUDE0  0x1000	// Treble controll bit 0
#define ST_AMPLITUDE1  0x2000	// Treble controll bit 1
#define ST_AMPLITUDE2  0x4000	// Treble controll bit 2
#define ST_AMPLITUDE3  0x8000	// Treble controll bit 3

//		SCI_CLOCKF bits
#define SC_FREQ0	0x0001	// Frequenzy adjust bit 0
#define SC_FREQ1	0x0002	// Frequenzy adjust bit 1
#define SC_FREQ2	0x0004	// Frequenzy adjust bit 2
#define SC_FREQ3	0x0008	// Frequenzy adjust bit 3
#define SC_FREQ4	0x0010	// Frequenzy adjust bit 4
#define SC_FREQ5	0x0020	// Frequenzy adjust bit 5
#define SC_FREQ6	0x0040	// Frequenzy adjust bit 6
#define SC_FREQ7	0x0080	// Frequenzy adjust bit 7
#define SC_FREQ8	0x0100	// Frequenzy adjust bit 8
#define SC_FREQ9	0x0200	// Frequenzy adjust bit 9
#define SC_FREQ10	0x0400	// Frequenzy adjust bit 10
#define SC_ADD0		0x0800	// Allowed multiplier addition bit 0
#define SC_ADD1		0x1000	// Allowed multiplier addition bit 1
#define SC_MULT0	0x2000	// Clock multiplier bit 0
#define SC_MULT1	0x4000	// Clock multiplier bit 1
#define SC_MULT2	0x8000	// Clock multiplier bit 2

/* The following macro is for VS1063, VS1053, VS1033, VS1003, VS1103.
   Divide hz by two when calling if SM_CLK_RANGE = 1 */
#define HZ_TO_SC_FREQ(hz) (((hz)-8000000+2000)/4000)

//		SCI_VOL bits
#define SV_RIGHT0	0x0001	// Right channel volume controll bit 0
#define SV_RIGHT1	0x0002	// Right channel volume controll bit 1
#define SV_RIGHT2	0x0004	// Right channel volume controll bit 2
#define SV_RIGHT3	0x0008	// Right channel volume controll bit 3
#define SV_RIGHT4	0x0010	// Right channel volume controll bit 4
#define SV_RIGHT5	0x0020	// Right channel volume controll bit 5
#define SV_RIGHT6	0x0040	// Right channel volume controll bit 6
#define SV_RIGHT7	0x0080	// Right channel volume controll bit 7
#define SV_LEFT0	0x0100	// Left channel volume controll bit 0
#define SV_LEFT1	0x0200	// Left channel volume controll bit 1
#define SV_LEFT2	0x0400	// Left channel volume controll bit 2
#define SV_LEFT3	0x0800  // Left channel volume controll bit 3
#define SV_LEFT4	0x1000	// Left channel volume controll bit 4
#define SV_LEFT5	0x2000	// Left channel volume controll bit 5
#define SV_LEFT6	0x4000	// Left channel volume controll bit 6
#define SV_LEFT7	0x8000	// Left channel volume controll bit 7

//		Parametric registers
#define PAR_CHIP_ID0             0x1E00 	// Unique chip ID bit 0
#define PAR_CHIP_ID1             0x1E01 	// Unique chip ID bit 1
#define PAR_VERSION              0x1E02 	// Hardware version
#define PAR_CONFIG1              0x1E03 	// Decoder enable register
#define PAR_PLAY_SPEED           0x1E04 	// Player speed configuration
#define PAR_BITRATE_PER_100      0x1E05 	// Player bitrate divider
#define PAR_END_FILL_BYTE        0x1E06 	// Last byte send befor canceling
#define PAR_RATE_TUNE0           0x1E07 	// Sampel rate fine tune bit 0
#define PAR_RATE_TUNE1           0x1E08		// Sampel rate fine tune bit 1
#define PAR_PLAY_MODE            0x1E09 	// Select the mode the decoder should be
#define PAR_SAMPLE_COUNTER0      0x1E0A 	// Sampel counter register bit 0
#define PAR_SAMPLE_COUNTER1      0x1E0B		// Sampel counter register bit 1
#define PAR_VU_METER             0x1E0C 	// VU Meter result
#define PAR_AD_MIXER_GAIN        0x1E0D 	// AD Mixer gain in 3dB steps
#define PAR_AD_MIXER_CONFIG      0x1E0E 	// AD Mixer configuration
#define PAR_PCM_MIXER_RATE       0x1E0F 	// PCM mixer sampelrate
#define PAR_PCM_MIXER_FREE       0x1E10 	// PCM mixer FIFO free state
#define PAR_PCM_MIXER_VOL        0x1E11 	// PCM mixer volume in 0.5dB steps
#define PAR_EQ5_DUMMY            0x1E12 	// EQ dummy byte normaly not used
#define PAR_EQ5_LEVEL1           0x1E13		// Bass level in 0.5dB steps
#define PAR_EQ5_FREQ1            0x1E14 	// Bass/Mid-Bass cutoff frequenzy
#define PAR_EQ5_LEVEL2           0x1E15 	// Mid-Bass level in 0.5dB steps
#define PAR_EQ5_FREQ2            0x1E16 	// Mid-Bass/Mid cutoff frequenzy
#define PAR_EQ5_LEVEL3           0x1E17 	// Mid level in 0.5dB steps
#define PAR_EQ5_FREQ3            0x1E18 	// Mid/Mid-High cutoff frequenzy
#define PAR_EQ5_LEVEL4           0x1E19 	// Mid-High level in 0.5dB steps
#define PAR_EQ5_FREQ4            0x1E1A 	// Mid-High/Treble cutoff frequenzy
#define PAR_EQ5_LEVEL5           0x1E1B 	// Treble level in 0.5dB steps
#define PAR_EQ5_UPDATED          0x1E1C 	// Indicats setting change
#define PAR_SPEED_SHIFTER        0x1E1D 	// Speed-Shifter speed
#define PAR_EARSPEAKER_LEVEL     0x1E1E 	// Enable Earspeaker DSP and set it's level
#define PAR_SDI_FREE             0x1E1F 	// FIFO free space
#define PAR_AUDIO_FILL           0x1E20		// Audio buffer fill
#define PAR_LATEST_SOF0          0x1E25 	// Latest start of frame bit 0
#define PAR_LATEST_SOF1          0x1E26 	// Latest start of frame bit 1
#define PAR_POSITION_MSEC0       0x1E27 	// FIle position in msec bit0
#define PAR_POSITION_MSEC1       0x1E28 	// FIle position in msec bit1
#define PAR_RESYNC               0x1E29		// Automatic resync select

/* The following addresses are shared between modes. */
/* Generic pointer */
#define PAR_GENERIC                  0x1e2a /* VS1063, VS1053 */

// 		// Bits for config1 register
#define PAR_CONFIG1_DIS_WMA     0x8000 	// Disable WMA decoding
#define PAR_CONFIG1_DIS_AAC     0x4000 	// Disable AAC decoding
#define PAR_CONFIG1_DIS_MP3     0x2000 	// Disable MP3 decoding
#define PAR_CONFIG1_DIS_FLAC    0x1000 	// Disable FLAC decoding
#define PAR_CONFIG1_DIS_CRC     0x0100 	// Disable CRC check
#define PAR_CONFIG1_AAC_PS1     0x0080 	// Parametric Stereo congif bit 1
#define PAR_CONFIG1_AAC_PS0     0x0040 	// Parametric Stereo congif bit 0
#define PAR_CONFIG1_AAC_SBR1    0x0020 	// Spectral Band Replication config bit 1
#define PAR_CONFIG1_AAC_SBR0    0x0010 	// Spectral Band Replication config bit 0


#define PAR_PLAY_MODE_SPEED_SHIFTER 0x0040	// Speedshifter enable
#define PAR_PLAY_MODE_EQ5           0x0020	// Equilizer enable
#define PAR_PLAY_MODE_PCM_MIXER     0x0010	// PCM enable
#define PAR_PLAY_MODE_AD_MIXER      0x0008	// AD Mixer enable
#define PAR_PLAY_MODE_VU_METER      0x0004	// VU Meter enable
#define PAR_PLAY_MODE_PAUSE         0x0002	// Pause enable
#define PAR_PLAY_MODE_MONO          0x0000 	// Mono output select

#define PAR_AAC_SBR_AND_PS_STATUS_SBR_PRESENT_B       0 /* VS1063, VS1053 */
#define PAR_AAC_SBR_AND_PS_STATUS_UPSAMPLING_ACTIVE_B 1 /* VS1063, VS1053 */
#define PAR_AAC_SBR_AND_PS_STATUS_PS_PRESENT_B        2 /* VS1063, VS1053 */
#define PAR_AAC_SBR_AND_PS_STATUS_PS_ACTIVE_B         3 /* VS1063, VS1053 */

#define PAR_AAC_SBR_AND_PS_STATUS_SBR_PRESENT       (1<<0) /* VS1063, VS1053 */
#define PAR_AAC_SBR_AND_PS_STATUS_UPSAMPLING_ACTIVE (1<<1) /* VS1063, VS1053 */
#define PAR_AAC_SBR_AND_PS_STATUS_PS_PRESENT        (1<<2) /* VS1063, VS1053 */
#define PAR_AAC_SBR_AND_PS_STATUS_PS_ACTIVE         (1<<3) /* VS1063, VS1053 */

// Compressed plugin; Revision 1.7
static const unsigned short plugin[] =
{
	0x0007,0x0001, /*copy 1*/
	0x8050,
	0x0006,0x175e, /*copy 5982*/
	0x0000,0x0000,0x0006,0x8155,0x3d00,0x0024,0x0001,0x2f95,
	0xf400,0x5540,0x0000,0x0015,0xf400,0x5740,0x0000,0xd7d7,
	0xf400,0x55c0,0x0000,0x0857,0xf400,0x57c0,0x0006,0x2016,
	0x000f,0xd9cf,0x0000,0x1b8e,0x280f,0xd1c0,0x0000,0x004d,
	0x3613,0x0024,0x3e00,0x8024,0x0000,0x02c2,0x6124,0x0024,
	0x0000,0x0024,0x2800,0x1b05,0x4192,0x1bc2,0x0000,0x0041,
	0x2000,0x0015,0x0030,0x0317,0x2000,0x0000,0x3f00,0x4024,
	0x2000,0x0000,0x0000,0x0000,0x0006,0xc797,0x0000,0x0040,
	0x3009,0x3c00,0x280f,0xdb45,0x0000,0x0dc0,0x0030,0x02d5,
	0x3500,0x0024,0x4080,0x0024,0x0031,0x6b0f,0x2800,0x1e95,
	0x0000,0x4040,0x3d00,0x0024,0x0000,0x1f8e,0x0000,0x004d,
	0x2908,0x73c0,0x0030,0x0480,0x0000,0x0181,0x6012,0x0024,
	0x0000,0x0024,0x2800,0x2104,0x0000,0x0201,0x6010,0x0024,
	0x0031,0xb4cf,0x0000,0x220e,0x2831,0x6b40,0x0000,0x004d,
	0x3463,0x0024,0x2902,0x3fc0,0x34a0,0x8024,0x0031,0xbd0f,
	0x0000,0x23ce,0x2831,0xb500,0x0000,0x004d,0x0006,0x9a17,
	0x3701,0x0024,0x0008,0x7a17,0x449a,0x1fc4,0x0000,0x0024,
	0x2800,0x2755,0x448a,0x1cc4,0x3463,0x0024,0x2800,0x2744,
	0x34a1,0x4024,0x0000,0x0400,0x3f00,0x0024,0x2908,0xf780,
	0x3613,0x0024,0x3100,0x0024,0xf200,0x0024,0xf200,0x0024,
	0xf200,0x0024,0xf200,0x0024,0x0031,0xc08f,0x0000,0x298e,
	0x2831,0xbd40,0x0000,0x190d,0x0031,0xc98f,0x2831,0xc2c5,
	0x0000,0x2d0e,0x0000,0x0141,0x6012,0x0ccc,0x0008,0x0001,
	0x2831,0xc285,0x0000,0x0024,0x0031,0x27cf,0x0000,0x2c8e,
	0x2831,0xd5c0,0x0000,0x190d,0x2802,0x9b00,0x0000,0x190d,
	0x2935,0x74c0,0x0000,0x0024,0x0000,0x2e95,0x0008,0xdfd7,
	0x2831,0xccc0,0x3f05,0x4024,0x0006,0x0017,0x3f12,0x184c,
	0x3f13,0x7800,0x0000,0x0740,0x2911,0xa7c0,0x3f13,0x8024,
	0x4080,0x3c0f,0x0000,0x0024,0x2800,0x3bd5,0x3009,0x1bc0,
	0x0000,0x3bc8,0x0000,0x004d,0x0035,0xe5cf,0x2835,0xb7c0,
	0x0000,0x324e,0x0000,0x008d,0x0035,0xc6cf,0x0000,0x36ce,
	0x2835,0xc241,0x0000,0x0041,0x4190,0x110c,0xb886,0xb300,
	0x0000,0x04cd,0x0035,0xee0f,0x2835,0xe780,0x0000,0x350e,
	0x0000,0x0485,0x635a,0x0024,0x0000,0x324e,0x2800,0x3455,
	0x0035,0xe5cf,0x0000,0x0805,0x2a35,0xee40,0x0000,0x008d,
	0x0000,0x324e,0x0035,0xe5cf,0x2835,0xc988,0x0000,0x0024,
	0x0000,0x03d5,0x3483,0x184c,0x003f,0xfc55,0xb888,0x4511,
	0x0000,0x3d8e,0x0039,0xaf0f,0x0000,0x058d,0x2939,0x87c0,
	0x3483,0x0024,0x2900,0x3fc0,0x3613,0x0024,0x0000,0x008d,
	0x0000,0x324e,0x0035,0xe5cf,0x2a35,0xc980,0x0006,0x0017,
	0x3712,0x0024,0x3713,0x4024,0x3713,0x8024,0x3703,0xc024,
	0x2000,0x0000,0x0000,0x0024,0x000d,0x91d7,0x3700,0x4024,
	0x2938,0x3c80,0x3000,0x7841,0x000d,0x91d7,0x3009,0x1bc0,
	0x3f00,0x0024,0x2839,0xafc0,0x0000,0x058d,0x0037,0x010f,
	0x0000,0x004d,0x2836,0xfd80,0x0000,0x40ce,0x2800,0x4695,
	0x0000,0x0024,0x0000,0x0002,0x0008,0xe110,0x3000,0x184c,
	0x6200,0x0024,0x0008,0xe690,0x2800,0x46c1,0x3010,0x4024,
	0x0000,0x010d,0x36f3,0x0024,0x0000,0x0001,0x0037,0xdfcf,
	0x2837,0xd280,0x0000,0x448e,0x2837,0xd280,0x0000,0x450e,
	0x2837,0xd280,0x0000,0x458e,0x2837,0xd280,0x0000,0x460e,
	0x2800,0x4180,0x6294,0x0024,0x3010,0x584c,0x3000,0x0024,
	0x0037,0x224f,0x0000,0x004d,0x2837,0x0240,0x0000,0x480e,
	0x2800,0x8445,0x0000,0x0024,0x2800,0x4940,0xb88c,0x0024,
	0x669c,0x0024,0x0008,0xe310,0x3000,0x0024,0x6600,0x0024,
	0x0000,0x0024,0x2800,0x5858,0x0000,0x0024,0x0000,0x0003,
	0x0008,0xe110,0x3000,0x0024,0x6300,0x0024,0x0000,0x0024,
	0x2800,0x4901,0x0000,0x0024,0x0037,0x330f,0x0000,0x004d,
	0x2837,0x2700,0x0000,0x4d8e,0x2800,0x5485,0x0000,0x0024,
	0x2936,0x99c0,0xb880,0x184c,0x0000,0x0002,0x0000,0x008d,
	0x0037,0x394f,0x2837,0x3500,0x0000,0x4fce,0x2837,0x3500,
	0x0000,0x504e,0x0000,0x0002,0x0000,0x00cd,0x0037,0x3d8f,
	0x2837,0x3a40,0x0000,0x518e,0x2837,0x3a40,0x0000,0x520e,
	0x2837,0x3a40,0x0000,0x528e,0x0037,0x434f,0x0000,0x004d,
	0x2837,0x3dc0,0x0000,0x538e,0x2936,0x99c0,0x3000,0x0024,
	0x2800,0x4b00,0x6396,0x0024,0x0000,0x0002,0x0000,0x00cd,
	0x0037,0x498f,0x2837,0x4540,0x0000,0x55ce,0x2837,0x4540,
	0x0000,0x564e,0x2837,0x4540,0x0000,0x56ce,0x0037,0x4d0f,
	0x0000,0x004d,0x2837,0x49c0,0x0000,0x57ce,0x2936,0x99c0,
	0x0000,0x5288,0x0037,0x500f,0x0000,0x004d,0x2837,0x4dc0,
	0x0000,0x594e,0x2800,0x5a15,0x0000,0x0024,0x0000,0x0a80,
	0x2936,0xc4c0,0x3613,0x0024,0x2800,0x5b40,0xb88e,0x0024,
	0x679e,0x0024,0x0008,0xe310,0x3000,0x0024,0x6700,0x0024,
	0x0000,0x0024,0x2837,0x8398,0x0000,0x0024,0x2800,0x6980,
	0xb88c,0x0024,0x0037,0x5bcf,0x0000,0x004d,0x2837,0x5440,
	0x0000,0x5e4e,0x4182,0x0024,0x0008,0xe817,0x2800,0x62c9,
	0x4216,0x1c05,0x0000,0x1204,0x000d,0x8215,0xfe4a,0x0024,
	0x48ba,0x0024,0x0011,0x00c5,0x4458,0x1405,0x4458,0x0024,
	0xf400,0x4115,0x3501,0x0024,0x6348,0x0024,0x0000,0x0024,
	0x2800,0x62c9,0x0000,0x0101,0x6316,0x0024,0x6306,0x0024,
	0xf136,0x0024,0xf136,0x0024,0x0000,0x0002,0x2800,0x6609,
	0x4396,0x0024,0x2400,0x65c3,0x0000,0x0024,0xf400,0x4411,
	0xf400,0x44d2,0x293a,0x7ac0,0x3613,0x0024,0x3343,0x0024,
	0x2936,0xb440,0x3613,0x0024,0x3423,0x184c,0x4082,0x1380,
	0x6106,0x0024,0x4770,0x0024,0x0008,0xeb41,0x4100,0x0024,
	0x0000,0x0301,0x4060,0x0024,0x4380,0x4010,0x2936,0xbd40,
	0x3000,0x8024,0x669c,0x2003,0x0008,0xe110,0x3000,0x0024,
	0x6600,0x0024,0x0000,0x0024,0x2800,0x5b01,0x0000,0x0024,
	0x2936,0xb440,0x3613,0x0024,0x0025,0xa350,0xb888,0x108c,
	0xb884,0x3380,0x0000,0x0100,0x6400,0x0024,0x0000,0x0180,
	0x2800,0x7a58,0x0000,0x0024,0x4660,0x0045,0x4002,0x0024,
	0x0008,0xe940,0x4010,0x0024,0x4040,0x0024,0xf400,0x4012,
	0x3200,0x0024,0x6080,0x0024,0x0000,0x0024,0x2800,0x7205,
	0x0000,0x0024,0x678e,0x0024,0x0000,0x0024,0x2800,0x7205,
	0x0000,0x0024,0x6594,0x0024,0x2800,0x6c40,0x6498,0x0024,
	0x6520,0x0024,0x0000,0x0024,0x2800,0x7148,0x0000,0x0024,
	0x2400,0x7980,0x0000,0x0024,0x0000,0x0200,0x0000,0x0583,
	0x3413,0x184c,0xfe0f,0xc4c5,0x48b2,0x0024,0x0008,0xf041,
	0x4102,0x0024,0x4660,0x0024,0x4000,0x0024,0x4100,0x0024,
	0x4040,0x0024,0x4330,0x4012,0xfe0e,0x0801,0x0009,0x0540,
	0x48ba,0x0024,0x4040,0x0024,0xfe3c,0x0024,0x48ba,0x0024,
	0xf400,0x4103,0x4040,0x1004,0x4020,0x93c5,0xf400,0x4012,
	0x2936,0x99c0,0x3200,0x0024,0x6294,0x0024,0x2800,0x7140,
	0x0000,0x0024,0x0037,0x7c0f,0x0000,0x004d,0x2837,0x7480,
	0x0000,0x7b4e,0x0000,0x00c1,0x6212,0x0024,0x0000,0x0024,
	0x2800,0x5d58,0x6052,0x0024,0x0000,0x0024,0x2800,0x5d58,
	0x0000,0x0024,0x3300,0x510c,0x6156,0x984c,0x0000,0x0024,
	0x2800,0x7ec8,0x0000,0x0024,0xf400,0x4141,0x3c01,0xb347,
	0x6107,0xc2c4,0x0000,0x0180,0xf134,0x0044,0xfe08,0x9004,
	0x0024,0x0000,0x48be,0x4112,0x4060,0x0024,0x4280,0x4011,
	0x3430,0x8024,0x003a,0x588f,0x0000,0x320d,0x0000,0x82ce,
	0x3401,0x9307,0x293a,0x4700,0x0000,0x8388,0x0001,0xffc1,
	0x283a,0x58c0,0xb010,0x0024,0x4438,0x0c4c,0x2800,0x7b40,
	0x6294,0x4040,0x0000,0x0002,0x0008,0xe110,0x3000,0x0024,
	0x6200,0x0024,0x0000,0x0024,0x2800,0x4881,0x0000,0x0024,
	0x0000,0x00cd,0x2400,0x88cd,0x0000,0x0003,0x4220,0x984c,
	0x4002,0x0024,0x0008,0xe940,0x4010,0x0024,0x4030,0x0024,
	0x6892,0x4010,0x2936,0x99c0,0x3000,0x0024,0x6396,0x0024,
	0x2800,0x8480,0x6294,0x0024,0x3e12,0xb817,0x3e12,0x3815,
	0x3e05,0xb814,0x3615,0x0024,0x0000,0x800a,0x3e10,0x3801,
	0x3e10,0xb803,0x3e11,0x3806,0x3e11,0xf810,0x3e14,0x7812,
	0x3e14,0xf80d,0x3e03,0xf80e,0x0006,0xc950,0x3009,0x0004,
	0x0006,0xeb11,0x3009,0x0400,0x0006,0xc792,0x4408,0x8800,
	0x6502,0x0024,0x0006,0xc913,0x2800,0x9155,0x0007,0x81d0,
	0x0006,0xeb93,0x0006,0xc910,0x3009,0x0c00,0x3009,0x0001,
	0x6014,0x0024,0x0007,0x81d0,0x2800,0xa005,0x0000,0x0024,
	0x0006,0xc913,0x0010,0x9000,0x0000,0x03c1,0x3011,0x8024,
	0x30f1,0xc024,0x4fce,0x8c00,0xffea,0x0024,0x48b6,0x0024,
	0x4384,0x4097,0xb886,0x45c6,0xfede,0x0024,0x0000,0x01c7,
	0x4db6,0x0024,0x466c,0x0024,0x001c,0xd646,0x8dd6,0x0024,
	0xff70,0x4007,0x48b2,0x0024,0xffee,0x0024,0x2914,0x6c80,
	0x40b2,0x0024,0x6c96,0x0024,0x0000,0x0000,0x0000,0x0201,
	0x6d96,0x0024,0xf1d6,0x0024,0xf1d6,0x0024,0x6cde,0x0024,
	0x0000,0x0024,0x2800,0x9941,0x0000,0x0024,0x0000,0x0203,
	0xb884,0x0024,0x2911,0x8bc0,0x0006,0xc550,0x3009,0x0040,
	0x4080,0x984c,0x0000,0x0024,0x2911,0x8608,0x0000,0x9b48,
	0x4000,0x1bcc,0xf100,0xa042,0x3009,0x2383,0x2911,0x8d40,
	0x3009,0x2040,0x0006,0xc791,0x3009,0x2405,0x0006,0xc912,
	0x3009,0x0800,0x0006,0xeb93,0x3009,0x2c00,0x0006,0xc897,
	0x3009,0x1c01,0x0006,0xc357,0x3009,0x1c00,0xc102,0x0024,
	0x0000,0x0024,0x2800,0xa005,0x0000,0x4040,0x3009,0x3c00,
	0x0030,0x0510,0x0000,0x4001,0x3001,0x4024,0xb510,0x0024,
	0x0000,0x03c0,0x2800,0xa305,0xf25a,0x0024,0xf25a,0x0024,
	0xf25a,0x0024,0xf25a,0x0024,0x2800,0xa440,0xb50a,0x0024,
	0x4000,0x0024,0xf25a,0x0024,0xf25a,0x0024,0xb50a,0x0024,
	0x659a,0x0024,0x659a,0x0024,0x6450,0x0024,0x0000,0x0024,
	0x2808,0xf485,0x0000,0x0024,0x0030,0x0690,0x2908,0xb040,
	0x003f,0xf3c1,0x4084,0x0003,0xb312,0x0024,0x3800,0x4024,
	0x0030,0x0a10,0x6892,0x0000,0xb010,0x0024,0x0030,0x0691,
	0x2800,0xa715,0x0000,0x0024,0x2911,0x8bc0,0x0000,0x0080,
	0x3900,0xc0cc,0x6042,0x2002,0x0006,0xc652,0x2800,0xab91,
	0x0000,0x0024,0x31a3,0x0bc1,0x4180,0x27c1,0x3009,0x0840,
	0x2808,0xf400,0x3900,0x0024,0xf240,0x0024,0x0000,0x0100,
	0x2800,0xad91,0x4494,0x0024,0xa204,0x0024,0x0000,0x4000,
	0x2800,0xae40,0xc204,0x0024,0xf244,0x0024,0x4294,0x0024,
	0xa204,0x0024,0x6540,0x0024,0xf000,0x0024,0x4090,0x0024,
	0x0000,0x8001,0x2800,0xb119,0x0030,0x0511,0x3100,0x0024,
	0xb010,0x0024,0x0030,0x0512,0x2800,0xb515,0x0006,0xc651,
	0x0006,0xc651,0x0030,0x0512,0x3009,0x07c1,0xc120,0x0024,
	0x3af0,0x0440,0x3a00,0x07c1,0x0000,0x3fce,0x2400,0xb34e,
	0x0030,0x0650,0x3000,0x0024,0x0000,0x8001,0x30b0,0x0024,
	0x3000,0x0024,0xc012,0x0024,0x2808,0xf400,0x3800,0x4024,
	0x3009,0x07c1,0xf400,0x4040,0x0000,0x8001,0xc010,0x0024,
	0xc020,0x0024,0x3af0,0x0440,0x2808,0xf400,0x3a00,0x0024,
	0x3613,0x0024,0x3e04,0x3808,0x0000,0x0001,0x0000,0x1000,
	0x2914,0x9dc0,0x0008,0x0010,0x36f4,0x1808,0x2000,0x0000,
	0x4f82,0x0024,0x3613,0x0024,0x3e13,0xf80e,0x3e02,0x380d,
	0x000b,0x2b4f,0x0000,0xbc0e,0x290b,0x1680,0x0000,0x004d,
	0x36f2,0x180d,0x36f3,0xd80e,0x2000,0x0000,0x0000,0x0024,
	0x000b,0x77cf,0x0000,0xcbce,0x0000,0x004d,0x280b,0x2e55,
	0x0007,0x80d7,0x0004,0x0001,0x3700,0x0024,0xb010,0x0024,
	0x0000,0x0024,0x280b,0x2e55,0x0000,0x0024,0x0025,0x2a4f,
	0x0000,0xbfce,0x2925,0x27c0,0x000b,0xad48,0x0030,0x0057,
	0x0020,0x0000,0x3700,0x4024,0xc012,0x0024,0x2901,0x8d40,
	0x3f00,0x4024,0x0019,0x9300,0x0030,0x0250,0x3800,0x0024,
	0x0025,0x314f,0x0000,0xc40e,0x2825,0x2b00,0x0000,0x004d,
	0x2925,0x7d80,0x0000,0x0024,0x2811,0x8d40,0x0000,0xc148,
	0x0030,0x0057,0xf290,0x1c01,0xb012,0x0024,0x3f00,0x4024,
	0x0024,0x0d8f,0x0000,0xc60e,0x2825,0x3140,0x0000,0x004d,
	0x3009,0x3080,0x34d5,0xc024,0x3009,0x30d7,0x0000,0xc797,
	0x2824,0x0dc0,0x3ce5,0xc024,0xf400,0x4597,0x3613,0x0024,
	0x3e10,0x3804,0x3e01,0x9fc0,0x4080,0xb807,0x0006,0x6155,
	0x2800,0xcb05,0x3501,0x1c08,0x4498,0x1c15,0x2400,0xcac4,
	0x0000,0x0024,0x3501,0x9407,0xaf0e,0x0024,0x3d11,0xb407,
	0x36f1,0x9807,0x2000,0x0000,0x36f0,0x1804,0x0028,0xb70f,
	0x0000,0xcd8e,0x0000,0x004d,0x2928,0x0480,0x3009,0x2fc1,
	0x280b,0x78c0,0x36e3,0x0024,0x2800,0xd195,0x6012,0x0024,
	0x0000,0x0024,0x2800,0xd195,0x0000,0x0024,0x34c3,0x184c,
	0xf400,0x4500,0x002e,0x25cf,0x0000,0xd60e,0x0009,0xc40d,
	0x292e,0x28c0,0x3e10,0x110c,0x36f3,0x0024,0x0028,0xb70f,
	0x0000,0xcd8e,0x0000,0x004d,0x0000,0x4001,0xb880,0x130c,
	0x3410,0x8024,0x3430,0xc024,0x6dc2,0x0024,0x0000,0x0201,
	0x2829,0x0841,0x4d86,0x0024,0x0030,0x0010,0x2828,0xbd85,
	0x3613,0x0024,0x3e10,0x8024,0x2929,0x7080,0x3e00,0xc024,
	0x36f3,0x0024,0x0000,0x004d,0x291a,0x0400,0x0028,0xbd88,
	0x002a,0x5b86,0xd16c,0x0024,0x0000,0x0024,0x282e,0x2615,
	0x4c82,0x0024,0x282e,0x26c0,0x0000,0x0000,0x2a00,0xd80e,
	0x3e12,0x3817,0x3e12,0x780a,0x3e18,0x3821,0x3e18,0xb823,
	0x3e10,0x7800,0x0000,0x800a,0x0030,0x0417,0x3720,0x3815,
	0x0006,0x0101,0x4012,0x1c21,0xf400,0x4055,0x3502,0x0024,
	0xb284,0x3802,0x2000,0x0000,0x3f00,0x8024,0x0030,0x0015,
	0x0004,0x0001,0x3500,0x0024,0xb010,0x0024,0x0006,0xa415,
	0x2800,0xe185,0x3009,0x1481,0x6192,0x9780,0x6100,0xb441,
	0x0030,0x0217,0x2800,0xdf11,0x3009,0x17c0,0x4082,0xb400,
	0x3009,0x1415,0x3009,0x1400,0x0006,0xa3d5,0x3f10,0x14c0,
	0x6010,0x97c1,0x0000,0x0024,0x2800,0xe158,0x4014,0x9401,
	0x6210,0x0024,0x3f00,0x0024,0x0030,0x0497,0x2801,0x2d40,
	0x3f08,0x4024,0x0006,0xec15,0x6892,0x0024,0x0030,0x01d7,
	0x3700,0x7401,0x0006,0xebd7,0x0030,0x3002,0x6124,0xbc01,
	0x0030,0x4002,0x2800,0xead1,0x6124,0x0024,0x0006,0x9f95,
	0x2800,0xeac1,0x3009,0x17c2,0x3009,0x1401,0x0030,0x0257,
	0x6214,0x1c00,0x0019,0x9301,0x2800,0xe899,0x4294,0x0024,
	0x6102,0x0024,0x0001,0x0001,0x2800,0xe855,0x0000,0x0024,
	0x0006,0x0001,0x4214,0x0024,0x0007,0x87d7,0x2911,0x8600,
	0x3f00,0x984c,0x0006,0xebd5,0xf100,0x9401,0x0007,0x8817,
	0x0017,0x5002,0x4122,0x3c00,0x3009,0x3401,0x0038,0x0002,
	0x6124,0x0024,0x0010,0x0002,0x2800,0xecd1,0x6124,0x4055,
	0x3009,0x1441,0x2800,0xf140,0x3009,0x1400,0x0030,0x0002,
	0x2800,0xee51,0x6124,0x4055,0x0020,0x0002,0x2800,0xef11,
	0x0010,0x0000,0x3510,0x4024,0x2800,0xf140,0x3500,0x0024,
	0x6124,0x0024,0x0000,0x0024,0x2800,0xf101,0x6100,0x4095,
	0xf400,0x4015,0x3009,0x1441,0x2800,0xf140,0x3009,0x1400,
	0xf400,0x5540,0x0030,0x0197,0x0006,0xec55,0x2801,0x1300,
	0x3f00,0x7400,0x0006,0xebd7,0x0038,0x0002,0xb080,0x9c01,
	0x6124,0x0024,0x0006,0xec15,0x2800,0xf591,0x0010,0x0002,
	0x3009,0x3400,0x0030,0x0195,0x3500,0x1c15,0x3009,0x3440,
	0x2801,0x1300,0x3009,0x3c15,0x6124,0x0024,0x0030,0x0002,
	0x2800,0xf751,0x6124,0x0024,0x0020,0x0002,0x2800,0xf8d1,
	0x0000,0x0024,0x3009,0x3400,0x0030,0x0195,0x3500,0x5c15,
	0x3d10,0x4024,0x2801,0x1300,0x3009,0x3c15,0x6124,0x0024,
	0x0010,0x0002,0x2800,0xfb81,0x6124,0x0024,0x3009,0x3400,
	0x0030,0x0195,0x3500,0x0024,0x6194,0x4095,0x3009,0x3c02,
	0x2801,0x1300,0x3009,0x3400,0x3009,0x1402,0x4284,0x0024,
	0x0020,0x0002,0x2800,0xfe45,0x6124,0x0024,0x3009,0x3400,
	0x0030,0x0195,0x3500,0x4024,0x0006,0xec55,0x2801,0x1300,
	0x3009,0x3401,0x0000,0x0040,0x3009,0x3400,0x6194,0x4095,
	0x3009,0x3c02,0x0030,0x0197,0x3700,0x0024,0x0006,0xec57,
	0x6894,0x9c01,0xf400,0x5740,0x0006,0xec15,0x2801,0x1300,
	0x3009,0x3402,0x0006,0xec15,0x0006,0xebd7,0x3009,0x1402,
	0x4284,0x9c01,0x0038,0x0002,0x2801,0x0705,0xb080,0x4055,
	0x0006,0xec15,0x3009,0x3400,0x0006,0xec55,0x3009,0x1400,
	0x0030,0x0195,0x0020,0x0002,0x6124,0x3400,0x0030,0x0002,
	0x2801,0x0651,0x6124,0x0024,0x0000,0x0024,0x2801,0x1311,
	0x0000,0x0024,0x6192,0x0024,0x2801,0x1300,0x3009,0x3c01,
	0x6124,0x144c,0x0010,0x0002,0x2801,0x0911,0x3009,0x3c15,
	0x3009,0x1401,0x0030,0x0195,0x2801,0x1300,0x3d00,0x4024,
	0x6124,0x0024,0x0030,0x0002,0x2801,0x0ad1,0x6124,0x0024,
	0x0020,0x0002,0x2801,0x0bd1,0x0000,0x0024,0x3500,0x4024,
	0x0030,0x0195,0x2801,0x1300,0x3d00,0x4024,0x6124,0x0024,
	0x000f,0xffc2,0x2801,0x0e01,0x6124,0x0024,0xf400,0x4095,
	0x3009,0x1401,0x0030,0x0195,0x2801,0x1300,0x3d00,0x4024,
	0x0006,0xec17,0x6894,0x0024,0x001f,0xffc0,0x6104,0xbc02,
	0xf400,0x4095,0xf400,0x5540,0x0006,0xec55,0x3009,0x3400,
	0x0030,0x0195,0x2801,0x1300,0x3d00,0x4024,0x0030,0x0017,
	0x0004,0x0001,0x3700,0x0024,0x0006,0xa415,0xb010,0x9415,
	0x3009,0x1400,0x2801,0x1305,0x0030,0x0217,0x3f00,0x0024,
	0x0030,0x0497,0x2801,0x2d40,0x3f08,0x4024,0x0006,0xa817,
	0x3009,0x1c02,0x4284,0x0024,0x0006,0x8157,0x2801,0x1845,
	0x0030,0x0002,0x48b2,0x184c,0x3e10,0x7800,0x3e01,0x3821,
	0x0030,0x0315,0x2913,0xd940,0x3501,0x0024,0x36f1,0x1821,
	0x36f0,0x5800,0x2801,0x1300,0x2210,0x0000,0x0006,0x8157,
	0x0030,0x0002,0x4024,0x1c01,0x4182,0x4095,0x3702,0x0024,
	0x2801,0x1305,0x0000,0x0024,0x48b2,0x184c,0x3e10,0x7800,
	0x3e04,0x3821,0x0030,0x0681,0x6212,0x1400,0x0000,0x0010,
	0x2000,0x0000,0x0001,0x1f48,0x0006,0x8157,0x0030,0x0002,
	0x4024,0x1c01,0x4182,0x4095,0x3702,0x0024,0x2801,0x1305,
	0x0000,0x0024,0x48b2,0x184c,0x3e10,0x7800,0x3e04,0x3821,
	0x0030,0x0181,0x6212,0x1400,0x0000,0x0010,0x2000,0x0000,
	0x0001,0x1f48,0x36f4,0x1821,0x36f0,0x5800,0x2801,0x1300,
	0x2210,0x0000,0x0030,0x0017,0x0000,0x0102,0xd292,0x1c00,
	0xb204,0x0024,0x0000,0x0024,0x2801,0x1305,0xb010,0x0024,
	0x2808,0x0ec0,0x3f00,0x0024,0x0006,0xc397,0x0000,0x0040,
	0x3009,0x3c00,0x0006,0xc357,0x0000,0x4040,0x2801,0x1300,
	0x3009,0x3c00,0x48b2,0x184c,0x3e10,0x7800,0x2909,0x7700,
	0x3e14,0x3821,0x36f4,0x1821,0x36f0,0x5800,0x2801,0x1300,
	0x2210,0x0000,0x48b2,0x184c,0x3e10,0x7800,0x290b,0xe600,
	0x3e14,0x3821,0x36f4,0x1821,0x36f0,0x5800,0x2801,0x1300,
	0x2210,0x0000,0x48b2,0x184c,0x3e10,0x7800,0x0030,0x0157,
	0x3700,0x3861,0xb080,0x3840,0x2909,0xed00,0x3e10,0x0024,
	0x36e3,0x0024,0x3009,0x1be1,0x36f0,0x5800,0x2801,0x1300,
	0x2210,0x0000,0x0030,0x0295,0x0006,0x8157,0x3500,0x0024,
	0x3f00,0x0024,0x48b2,0x184c,0x3e10,0x7800,0x2801,0x2940,
	0xb080,0xb861,0x0030,0x0717,0x3f05,0xc024,0x36f0,0x9815,
	0x36f0,0x5800,0x36f8,0x9823,0x36f8,0x1821,0x36f2,0x180a,
	0x2000,0x0000,0x36f2,0x1817,0x2802,0x7d40,0x3e12,0x3817,
	0x3e12,0xb809,0x0030,0x0717,0x3f05,0xc024,0x3e11,0xb811,
	0x3e15,0x7810,0x3e18,0xb823,0x3e18,0x3821,0x3e10,0x3801,
	0x48b2,0x0024,0x3e10,0x3801,0x3e11,0x3802,0x3009,0x3814,
	0x0030,0x10d4,0x0006,0x9a50,0x0006,0xa591,0x2913,0x65c0,
	0x3410,0x188c,0x0006,0x9b10,0x0006,0xa591,0x2913,0x65c0,
	0x4088,0x1000,0x0006,0x6694,0xbc82,0x4006,0x0030,0x0351,
	0x3100,0x0024,0x4080,0x0024,0x0030,0x10d1,0x2801,0x3a05,
	0x0001,0x800a,0x0030,0x0351,0x3100,0x8024,0xfea8,0x0024,
	0x5ca2,0x0024,0x0000,0x0182,0xac22,0x0024,0xf7c8,0x0024,
	0x48b2,0x0024,0xac22,0x0024,0x2801,0x3d40,0xf7cc,0x1002,
	0x0030,0x0394,0x3400,0x4024,0x4480,0x984c,0x0006,0xa651,
	0x2923,0x3380,0x0006,0x6410,0x4088,0x1001,0x4680,0x984c,
	0x0006,0xa651,0x2923,0x3380,0x0006,0x6550,0x0006,0x6694,
	0x408c,0x1002,0xf224,0x0024,0x0006,0xc3d7,0x2801,0x4155,
	0x0000,0x0024,0x2801,0x4381,0x0006,0x6410,0x3050,0x0024,
	0x3000,0x4024,0x6014,0x0024,0x0000,0x0024,0x2801,0x4099,
	0x0000,0x0024,0xf400,0x4040,0x38b0,0x0024,0x2801,0x4380,
	0x3800,0x0024,0x2801,0x4341,0xf224,0x0024,0xf400,0x4182,
	0x2801,0x4385,0xf400,0x4106,0xf12c,0x0024,0xf148,0x0024,
	0x846c,0x0024,0xf400,0x4184,0x0006,0x9a15,0x3500,0x1c91,
	0xf200,0x9f90,0x0000,0x0024,0x2801,0x4791,0x0006,0x9c95,
	0x3504,0x0024,0x0006,0x9c15,0x3504,0x4024,0xf200,0x2604,
	0x3981,0x8024,0x2801,0x4851,0x3d04,0x4024,0x0006,0xc3d7,
	0x3009,0x1c91,0x3009,0x1f90,0x3009,0x2604,0x3009,0x2606,
	0x3009,0x3c11,0x3009,0x1bd4,0x36f1,0x1802,0x36f0,0x1801,
	0x2210,0x0000,0x36f0,0x1801,0x36f8,0x1821,0x36f8,0x9823,
	0x36f5,0x5810,0x36f1,0x9811,0x36f2,0x9808,0x2000,0x0000,
	0x36f2,0x1817,0x4090,0x0024,0x4090,0x0024,0x0007,0x80d7,
	0x2000,0x0015,0x0008,0x0155,0x002a,0x60cf,0x0001,0x52ce,
	0x0000,0xfa0d,0x3613,0x0024,0x3700,0x3802,0x0fff,0xfd82,
	0xa020,0x9bc2,0x8880,0x0024,0xb080,0x3400,0x0007,0x3057,
	0x2000,0x0000,0x3009,0x3c00,0x3600,0x3840,0x3e13,0x780e,
	0x3e13,0xf808,0x3e00,0x0024,0x002a,0x60cf,0x0001,0x52ce,
	0x2928,0x0300,0x0000,0x190d,0x36f3,0x0024,0x36f3,0xd808,
	0x36f3,0x580e,0x2000,0x0000,0x3009,0x1800,0x0007,0x1881,
	0x2801,0x6181,0x4412,0x0024,0xf400,0x4057,0x3702,0x0024,
	0x2000,0x0000,0x0000,0x0024,0x0007,0x0410,0x0000,0x0641,
	0x3009,0x0000,0x6012,0x0024,0x0000,0x0024,0x2801,0x5695,
	0x0000,0x0024,0x3009,0x2004,0x002a,0x834f,0x0001,0x628e,
	0x0000,0x190d,0x3613,0x0024,0x292a,0x3c80,0x3e01,0x0024,
	0x2801,0x6180,0x36f3,0x0024,0x0007,0x0410,0x0000,0x0641,
	0x3613,0x0000,0x6012,0x0024,0x0000,0x0024,0x2801,0x5a95,
	0x0000,0x0024,0x3009,0x2004,0x002a,0xa14f,0x0001,0x648e,
	0x0000,0x190d,0x292a,0x49c0,0x3e01,0x0024,0x2801,0x6180,
	0x36f3,0x0024,0x292a,0xf140,0x0007,0x3050,0x2801,0x6180,
	0x3009,0x2000,0x292b,0x1880,0x0001,0x6188,0x34d3,0x184c,
	0x3430,0x0024,0x2929,0xf2c0,0x3e00,0x0024,0x2801,0x6180,
	0x36f3,0x0024,0x0000,0x3fc0,0x0007,0x3050,0x3613,0x0024,
	0x292b,0x2780,0x3e00,0x0024,0x36f3,0x2000,0xb080,0x0024,
	0x0007,0x1555,0x3009,0x3400,0x002a,0x60cf,0x0001,0x52ce,
	0x282a,0x6e80,0x0000,0xfa0d,0x002f,0x1b0f,0x0001,0x70ce,
	0x0000,0x190d,0x292b,0x55c0,0x3e00,0x0024,0x002f,0x670f,
	0x282a,0x8400,0x0001,0x700e,0x002f,0x1b0f,0x0001,0x70ce,
	0x0000,0x190d,0x4080,0xa000,0x0008,0x6891,0x2801,0x68c5,
	0x0000,0x0000,0x3613,0x0000,0x3e10,0x0024,0x0007,0x3600,
	0x292a,0xcb80,0x3e00,0x0024,0x002a,0xb2cf,0x282a,0xa3c0,
	0x0001,0x684e,0x2914,0xb340,0x0001,0x6908,0x3009,0x2400,
	0x0004,0x0000,0x3613,0x0024,0xb880,0x3840,0x3e10,0x0024,
	0x0007,0x3600,0x3e10,0x0024,0x0007,0x3500,0x292b,0x55c0,
	0x3e00,0x0024,0x4080,0x1b4c,0x0005,0x0000,0x282a,0xb755,
	0x0000,0x0024,0xb880,0x3840,0x3e10,0x0024,0x0008,0xa300,
	0x3e10,0x0024,0x0007,0x3500,0x292b,0x55c0,0x3e00,0x0024,
	0x4080,0x1b4c,0x0000,0x00c0,0x282a,0xba95,0x0000,0x0181,
	0x002f,0x670f,0x0001,0x700e,0x282a,0xbb00,0x0000,0x190d,
	0x0000,0x01c7,0x282f,0x67c0,0xa07c,0x0024,0x0007,0x1a41,
	0x282f,0x3181,0x4012,0x0024,0xf400,0x4057,0x3702,0x0024,
	0x2000,0x0000,0x0000,0x0024,0x002f,0x21cf,0x282f,0x1d00,
	0x0001,0x734e,0x002f,0x1b0f,0x0001,0x70ce,0x0008,0x0155,
	0x3500,0x2000,0x4090,0x0024,0x0000,0x03d0,0x2801,0x7815,
	0x0007,0x1b41,0x4152,0x934c,0xf400,0x4055,0x0007,0x4801,
	0x3500,0x0024,0x3404,0x4024,0x3113,0x0024,0x3434,0x6400,
	0x4152,0x060c,0xf400,0x4055,0x3500,0x0024,0x3009,0x2400,
	0x282f,0x31c0,0xb880,0x0024,0x002f,0x278f,0x282f,0x2280,
	0x0001,0x794e,0x002f,0x1b0f,0x0001,0x70ce,0x0008,0x0155,
	0x3500,0x2000,0x4090,0x0024,0x0000,0x03d0,0x282f,0x2ed5,
	0x0007,0x4b01,0x4152,0x934c,0xf400,0x4055,0x3500,0x0024,
	0x3434,0x4024,0x3183,0x0024,0x282f,0x2ec0,0x3009,0x2400,
	0x3613,0x0024,0x3e12,0xb817,0x3e12,0x3815,0x3e05,0xb814,
	0x3625,0x0024,0x0000,0x800a,0x3e10,0x7802,0x0000,0x0201,
	0x3e10,0xf804,0x3e11,0x7810,0x3e14,0x7812,0x3e04,0xd30c,
	0x3009,0x384d,0x3e03,0xb80f,0x0030,0xe34f,0x0000,0x004d,
	0x2830,0xde00,0x0001,0x818e,0x2801,0x82d5,0x0000,0x0024,
	0x36f3,0x980f,0x2831,0x0f80,0xb880,0x980d,0x2930,0x2b40,
	0x0002,0x0001,0x2930,0x2b40,0x0030,0x03d3,0x3300,0x0024,
	0xb010,0x0024,0x0030,0xef0f,0x2801,0x8705,0x0000,0x004d,
	0x2830,0xe7c0,0x0001,0x858e,0x2910,0x0180,0x0001,0x8988,
	0x2930,0x2b40,0x0000,0x0024,0x2910,0x0180,0x3613,0x0024,
	0x0006,0x9c50,0x30f0,0x0024,0x3000,0x4024,0x6014,0x0024,
	0x0008,0x7910,0x2801,0x8605,0x0031,0x068f,0x0000,0x004d,
	0x2830,0xf200,0x0001,0x89ce,0x34b3,0x0024,0x3450,0x0024,
	0x6402,0x0024,0x0000,0x0024,0x2801,0x82d1,0x0000,0x0024,
	0x36f3,0x980f,0x2831,0x0800,0x3009,0x180d,0xfe10,0x4095,
	0x48b2,0x0024,0x0000,0x0182,0xac22,0x0024,0x2000,0x0000,
	0xf7c0,0x4542,0x3613,0x0024,0x3e10,0x3801,0x3e12,0x3802,
	0x2911,0x8bc0,0x3e04,0x3811,0x0006,0x9f50,0x3009,0x0040,
	0x3009,0x03c1,0x6102,0x0024,0x0001,0x0001,0x2801,0x9384,
	0x4012,0x4002,0x3009,0x2001,0x2925,0x7d80,0x0000,0x0024,
	0x2911,0x8d40,0x0000,0x0024,0x4290,0x0024,0x0001,0x0010,
	0x2914,0xb354,0x0000,0x0011,0x36f4,0x1811,0x36f2,0x1802,
	0x2000,0x0000,0x36f0,0x1801,0x2925,0x7d80,0x0000,0x0024,
	0x2911,0x8d40,0x0001,0x9288,0x3613,0x0024,0x3e22,0xb815,
	0x3e05,0xb814,0x3615,0x0024,0x0000,0x800a,0x3e10,0x3801,
	0x0000,0x0081,0x0000,0x0440,0x3e10,0xb803,0x3e11,0x3805,
	0x3e11,0xb807,0x0003,0x8006,0x3e14,0x3811,0x0006,0xc951,
	0x0030,0x1090,0x3e14,0xb80d,0x0030,0x0052,0x3e03,0xf80e,
	0xb887,0x0415,0xc408,0x0800,0xff6a,0x0024,0x48be,0x0024,
	0xb010,0x4185,0x0000,0x0024,0x2801,0x9b45,0x0000,0x0024,
	0x455a,0x0024,0x0000,0x0000,0x0030,0x1090,0x6396,0x2004,
	0x6052,0x0024,0x0000,0x0024,0x2801,0x9e01,0x4592,0x0024,
	0x2401,0x9dc1,0x3013,0x0024,0x6090,0x0001,0x3000,0x4024,
	0x0020,0x0000,0x0030,0x10d0,0x3000,0x8024,0x6200,0x0024,
	0x0000,0x1000,0x2801,0xa105,0x0000,0x0024,0xf290,0x0024,
	0x6200,0x0024,0x0000,0x1000,0x2801,0xa315,0x0000,0x0024,
	0x6300,0x03cc,0x003f,0xff81,0x2801,0xa301,0x0000,0x0024,
	0x3000,0x0024,0xb012,0x0024,0x2801,0x9b40,0x3800,0x4024,
	0x0030,0x1090,0x003f,0xfbc0,0xb400,0x980e,0x3800,0x0024,
	0x36f3,0xc024,0x36f4,0x980d,0x36f4,0x1811,0x36f1,0x9807,
	0x36f1,0x1805,0x36f0,0x9803,0x36f0,0x1801,0x3405,0x9014,
	0x36e3,0x0024,0x2000,0x0000,0x36f2,0x9815,0x3613,0x0024,
	0x3e12,0xb817,0x3e12,0x3815,0x3e05,0xb814,0x3665,0x0024,
	0x0000,0x800a,0x3e10,0x3801,0x3e10,0xb803,0x3e11,0x3805,
	0x3e11,0xb807,0x3e14,0x3811,0x0006,0x9c10,0x0006,0x9c51,
	0x3e14,0xb813,0x0008,0x0c93,0x3e13,0xf80e,0x3e13,0x534c,
	0x3434,0x8024,0x3001,0x0024,0x0008,0x0c50,0x3100,0x0024,
	0x6408,0x0024,0x0000,0xffc0,0xb408,0x0024,0x2911,0x8600,
	0xf148,0x0024,0xf100,0x130c,0x3440,0x4024,0x4010,0x0c01,
	0x3000,0x8024,0x0008,0x7950,0x6122,0x0006,0x0000,0x3fc2,
	0xb122,0x0024,0x6010,0x0024,0xfe60,0x0024,0x0000,0x0180,
	0x48be,0x0024,0x4468,0x0024,0x6400,0x0024,0x0008,0x09d0,
	0x2801,0xb215,0x0000,0x0c80,0x2801,0xb880,0x3800,0x0024,
	0x3000,0x0024,0x4080,0x0024,0x0000,0x0180,0x2801,0xb445,
	0x0000,0x0024,0x3000,0x0024,0x4090,0x0024,0x2801,0xb880,
	0x3800,0x0024,0x6400,0x0024,0x0000,0x0180,0x2801,0xb5d8,
	0x0000,0x0024,0x2930,0x19c0,0x0001,0xb888,0x6400,0x0024,
	0x000f,0x0001,0x2801,0xb889,0x0008,0x0c50,0x3000,0x0024,
	0x4090,0x0024,0x6016,0x2000,0x0008,0x0c51,0x2801,0xb881,
	0x000f,0x0010,0x3904,0x0024,0xb888,0x130c,0x3440,0x0024,
	0x6402,0x0024,0x0000,0x0024,0x2802,0x0f58,0x4090,0x0024,
	0x2402,0x0f00,0x0000,0x0024,0x0008,0x0251,0x3200,0x10cc,
	0x2930,0x19c0,0x3009,0x3340,0x3104,0x184c,0x3100,0x2000,
	0x0008,0x0750,0x6090,0x0024,0x3900,0x0024,0x3020,0x4024,
	0x30e0,0x8024,0x4122,0x0024,0x6016,0x0024,0x0008,0x0793,
	0x2801,0xbf51,0x33e0,0x4024,0x3000,0x0c8c,0x3900,0x0024,
	0x33e0,0x4024,0x003f,0xfdc2,0x3334,0x3852,0x3300,0x044c,
	0x293f,0xc580,0x3104,0x8024,0x0008,0x0690,0x408a,0x9bd2,
	0x3443,0x0c8c,0x3cc0,0x0024,0x2901,0x8bc0,0x3300,0x4024,
	0x408a,0x0e4c,0xfe00,0x0c46,0x33f1,0xc024,0x68f2,0x0024,
	0xac22,0x0042,0x30f0,0xc024,0x4dc2,0x0024,0x48b6,0x2040,
	0x6cde,0x23c1,0x0000,0x0024,0x2801,0xc581,0x0000,0x0024,
	0x3810,0x8024,0x38f0,0xc024,0x3433,0x038c,0xf152,0x9000,
	0xf100,0x0024,0x6010,0x0024,0x3cd0,0x0024,0x3011,0x8024,
	0x30d1,0xc024,0x3010,0x8024,0x30f0,0xc024,0x0000,0x0021,
	0xf2d6,0x0040,0xf2d6,0x03c1,0x6fd6,0x0024,0x0008,0x0610,
	0x2801,0xca41,0x0000,0x0020,0xf2c2,0x0024,0x2801,0xcac0,
	0xf2c2,0x0024,0x3010,0x0024,0x30f0,0x4024,0x0000,0x0087,
	0xb88c,0x110c,0x3c10,0x0024,0x3cf0,0x4024,0x3410,0x8024,
	0x34b0,0xc024,0x6dfe,0x0024,0x0001,0x0000,0x2801,0xce41,
	0x0008,0x0910,0x4d82,0x0024,0x003f,0xfe42,0x0000,0x0020,
	0xac22,0x0024,0x3423,0x0024,0x3ce0,0x0024,0x3000,0x0024,
	0x4080,0x0024,0x0000,0x8005,0x2801,0xd145,0x0001,0x0000,
	0x3423,0x0024,0x3c10,0x0024,0x3009,0x1000,0x2801,0xd740,
	0x3cd0,0x0024,0xb880,0x024c,0x6892,0x034c,0x3010,0x8024,
	0x30f0,0xc024,0x6dc2,0x0024,0x0000,0x8000,0x2801,0xd418,
	0x6052,0x0024,0x003f,0xfe80,0xad0e,0x4140,0x6562,0x4185,
	0x0000,0x0024,0x2801,0xd501,0x0000,0x0024,0xf400,0x4005,
	0x4580,0x108c,0x0000,0x8005,0x650a,0x1380,0x6052,0x0024,
	0x0000,0x0024,0x2801,0xd741,0x0000,0x0024,0x3423,0x0024,
	0x3ce1,0x4024,0x0008,0x0890,0x3000,0x0024,0x4080,0x0024,
	0x0030,0x0393,0x2801,0xdac5,0x0000,0x0024,0x3000,0x584c,
	0x3423,0x3801,0x3410,0x4024,0x2901,0x8bc0,0x34d0,0x0024,
	0x3009,0x1bc1,0x2901,0x8bc0,0x0001,0xdd08,0x0006,0xa651,
	0x3300,0x584c,0x3423,0x3801,0x3410,0x4024,0x2901,0x8bc0,
	0x34d0,0x0024,0x3009,0x1801,0x2923,0x3380,0x0006,0x6410,
	0x003f,0xff42,0x0008,0x0291,0x0008,0x0513,0x3a10,0x10cc,
	0x3174,0x0024,0x3133,0x0001,0x0008,0x0590,0xfe12,0x0446,
	0x48b2,0x0447,0xac22,0x0024,0xaf2e,0x0c42,0x6cf2,0x0fc3,
	0x4dc2,0x0024,0x003f,0xfe42,0x3b10,0x0024,0x3bf0,0x4024,
	0x3111,0x8024,0x31f1,0xc024,0x68f2,0x0024,0xac22,0x0042,
	0x30f0,0xc024,0x4dc2,0x0024,0x3810,0x0024,0x38f0,0x4024,
	0x34d0,0xc024,0xfe36,0x0024,0x48b6,0x0024,0x6cde,0x0024,
	0x0000,0x0024,0x2801,0xe558,0x0000,0x0024,0x3810,0x8024,
	0x38f0,0xc024,0x003f,0xfe42,0x3433,0x008c,0x34d0,0x45cc,
	0xfe12,0x0046,0x48b2,0x03c7,0xac22,0x0e4c,0x003f,0xfdc2,
	0xaf2e,0x0042,0x6cf2,0x03c3,0x4dc2,0x84cc,0x3810,0x0f0c,
	0x3890,0x4024,0x3100,0x824c,0x6824,0x03cc,0x3004,0x0024,
	0x3304,0x0001,0xfe12,0x8007,0x0008,0x0490,0x48b2,0x0024,
	0xac22,0x0402,0xfe7e,0x0024,0x48be,0x0024,0x6824,0x0024,
	0xaf2e,0x0042,0x6cf2,0x03c3,0x4dc2,0x0024,0x3810,0x0024,
	0x3890,0x4024,0x30c3,0x0024,0x3070,0x0024,0x4080,0x00cc,
	0x0000,0x0000,0x2801,0xf305,0x0000,0x0024,0x3010,0x0024,
	0x2914,0xf500,0x30f0,0x4024,0x609a,0x10cc,0x0025,0xa540,
	0x659a,0x1343,0x4050,0x184c,0xf400,0x4015,0x3500,0xb844,
	0xfea6,0xb852,0x48b6,0x01cc,0x4dd6,0x014c,0x4dd6,0x0381,
	0x4dd6,0x0010,0x3313,0x07cc,0x4388,0x0400,0x293f,0xca80,
	0x3304,0x8024,0x0000,0x0000,0x3009,0x1bd2,0x3009,0x1bc4,
	0x0008,0x0210,0x38f0,0x0024,0x3000,0x0024,0x4080,0x0024,
	0x0000,0x8000,0x2801,0xf605,0x0000,0x0024,0x3000,0x0024,
	0x4090,0x0024,0xb880,0x23c0,0x2801,0xfb00,0x3800,0x0024,
	0xb882,0x01cc,0x3063,0x0024,0x3010,0x8024,0x3090,0xc024,
	0x6dc2,0x028c,0x0000,0x0040,0x2801,0xfa41,0x0000,0x0024,
	0x30e3,0x0024,0x3000,0x0024,0x4090,0x0024,0x3000,0x0024,
	0x2801,0xfb09,0x4090,0x0024,0x6890,0x2080,0x2801,0xfb00,
	0x3800,0x0024,0x38e0,0x0024,0x0001,0x0000,0x3800,0x0024,
	0x0008,0x02d1,0x003f,0xff02,0x0008,0x0690,0x3010,0x0024,
	0x30f0,0x4024,0x2914,0xf500,0xac22,0x0024,0xf200,0x0401,
	0x4010,0x104c,0x3c00,0x024c,0x34f1,0x424c,0x685a,0x0042,
	0x3070,0xc024,0x3023,0x0024,0x3010,0x0024,0x30b0,0x4024,
	0xac52,0x0024,0x6dce,0x0380,0x3011,0x8024,0x2802,0x0801,
	0x3021,0xc024,0x30b0,0x4024,0x6fc2,0x0024,0x3010,0x0024,
	0x2802,0x0441,0x0000,0x0024,0x30f0,0x4024,0x6dc2,0x0024,
	0x0000,0x0082,0x2802,0x0441,0x0000,0x0024,0x0008,0x0313,
	0xb886,0x0c40,0x33f0,0x4024,0x4cd6,0x0024,0x3b10,0x8024,
	0x3bf0,0xc024,0x31d3,0x0024,0x3100,0x0024,0x4080,0x0024,
	0x0008,0x01d0,0x2802,0x0755,0x0000,0x2000,0x31f3,0x0024,
	0x3100,0x0024,0x4080,0x0024,0x0000,0x2000,0x2802,0x0bc5,
	0x0000,0x0024,0xb880,0x2040,0x2802,0x0bc0,0x3800,0x0024,
	0x30f0,0x4024,0x6fc2,0x0024,0x0000,0x7d00,0x2802,0x0bc1,
	0xb882,0x0024,0x6cde,0x0024,0x0000,0x0024,0x2802,0x0bc1,
	0x0000,0x0024,0x0008,0x0313,0x689c,0x0c40,0xb88e,0x0fc1,
	0x6cfe,0x0024,0x3b11,0x8024,0x3bf1,0xc024,0x0008,0x0751,
	0x0008,0x0290,0x3000,0x0024,0x6090,0x0024,0x3800,0x0024,
	0x3120,0x4024,0x31e0,0x8024,0x4122,0x0024,0x6016,0x0400,
	0x0000,0x0024,0x2802,0x0f11,0x0000,0x0024,0x3800,0x0024,
	0x6498,0x0024,0x0008,0x0710,0x3070,0x0024,0x3023,0x0024,
	0x3010,0x4024,0x4010,0x0001,0xf400,0x4011,0x3100,0x0024,
	0x6014,0x0024,0x0000,0x0024,0x2802,0x1249,0x0000,0x0024,
	0x3800,0x0024,0x30f3,0x0024,0x3090,0x0024,0x6090,0x01c1,
	0x6014,0x2240,0x0017,0x7001,0x2802,0x1948,0x3100,0x0024,
	0x0001,0x0001,0x3033,0x0024,0x3050,0x0024,0x6012,0x0000,
	0x000b,0xb801,0x2802,0x17c9,0x6012,0x0024,0x0008,0x0850,
	0x2802,0x17d8,0x3000,0x0024,0xf100,0x0024,0x6892,0x2340,
	0x30e0,0x0024,0x2902,0xd280,0x3004,0x0024,0x0008,0x0950,
	0x0000,0x0000,0x0017,0x7001,0x3810,0x0024,0x3800,0x0024,
	0x3100,0x0024,0x6012,0x0024,0x0008,0x0853,0x2802,0x1c49,
	0xb880,0x0024,0x0008,0x0950,0x3890,0x0024,0x3300,0x0024,
	0x4000,0x0024,0xc892,0x2c00,0x30e0,0x0024,0x2902,0xd280,
	0x3004,0x0024,0x36f3,0x4024,0x36f3,0xd80e,0x36f4,0x9813,
	0x36f4,0x1811,0x36f1,0x9807,0x36f1,0x1805,0x36f0,0x9803,
	0x36f0,0x1801,0x3405,0x9014,0x36f3,0x0024,0x36f2,0x1815,
	0x2000,0x0000,0x36f2,0x9817,0x3613,0x0024,0x3e12,0xb817,
	0x3e12,0x3815,0x3e05,0xb814,0x3615,0x0024,0x0000,0x800a,
	0x3e10,0x3801,0x3e14,0x3811,0x0006,0xc790,0x3e14,0xb813,
	0x34c3,0x0024,0x3410,0x0024,0x3e10,0x0024,0x3430,0x4024,
	0x2901,0xa6c0,0x3e00,0x4024,0x0007,0xd001,0x36e3,0x0000,
	0x6012,0x0024,0x000f,0xa001,0x2802,0x2995,0x0006,0x0911,
	0x0000,0x1901,0x3100,0x0024,0x6090,0x0024,0x6012,0x2400,
	0x0000,0x4b01,0x2802,0x2795,0x0030,0x04d2,0x0015,0x5540,
	0x2802,0x2e80,0x3a00,0x0024,0x6012,0x0024,0x0000,0x0000,
	0x2802,0x2e88,0x0000,0x0024,0x3900,0x0024,0x0015,0x5580,
	0x2802,0x2e80,0x3a00,0x0024,0x6012,0x0024,0x0000,0x1901,
	0x2802,0x2e95,0x0006,0x0951,0x3100,0x0024,0x6090,0x0024,
	0x6012,0x2400,0x0000,0x4b01,0x2802,0x2cd5,0x0030,0x04d2,
	0x002a,0xaac0,0x2802,0x2e80,0x3a00,0x0024,0x6012,0x0024,
	0x0000,0x0000,0x2802,0x2e88,0x0000,0x0024,0x3900,0x0024,
	0x002a,0xaa80,0x3a00,0x0024,0x0006,0x9c52,0x0006,0x9c11,
	0x3100,0x0024,0x3200,0x4024,0x6010,0x0024,0x0000,0xffc1,
	0xb010,0x0024,0x0000,0xc001,0x6012,0x0024,0x0008,0x0213,
	0x2802,0x31c9,0xb880,0x0024,0x3b00,0x0024,0x36f4,0x9813,
	0x36f4,0x1811,0x36f0,0x1801,0x3405,0x9014,0x36f3,0x0024,
	0x36f2,0x1815,0x2000,0x0000,0x36f2,0x9817,0x3613,0x0024,
	0x3e12,0xb817,0x3e12,0x3815,0x3e05,0xb814,0x3615,0x0024,
	0x0000,0x800a,0x3e10,0x3801,0x3e10,0xb804,0x3e11,0x7810,
	0x0008,0x08d0,0x3e14,0x780d,0x3e03,0xf80e,0x3001,0x534c,
	0xb888,0x10c0,0x6402,0x0024,0x0000,0x0024,0x2802,0x3d58,
	0x4090,0x0024,0x2402,0x3d00,0x0000,0x0024,0x2901,0x8bc0,
	0x4582,0x0800,0xf400,0x4481,0x0008,0x0c91,0x6192,0x0410,
	0xf400,0x4055,0x000f,0x4001,0x3800,0x0024,0x3a20,0x0024,
	0x3d00,0x0024,0x3100,0x0024,0x6090,0x0024,0x6014,0x2400,
	0x0000,0x4001,0x2802,0x3d11,0x6012,0x0024,0x3900,0x4024,
	0x6498,0x0024,0x36f3,0xd80e,0x36f4,0x580d,0x36f1,0x5810,
	0x36f0,0x9804,0x36f0,0x1801,0x3405,0x9014,0x36f3,0x0024,
	0x36f2,0x1815,0x2000,0x0000,0x36f2,0x9817,0x3613,0x0024,
	0x3e12,0xb817,0x3e12,0x3815,0x3e05,0xb814,0x3645,0x0024,
	0x0000,0x800a,0x3e10,0x3801,0x3e10,0xf804,0x0000,0x0183,
	0xb888,0xb810,0x0006,0xc790,0xb182,0x3845,0x000a,0x8005,
	0x3e14,0x7812,0x0006,0xa351,0x3e04,0xc000,0x0000,0x0f90,
	0x3009,0x2400,0x0002,0x33c0,0xac32,0x0024,0x2900,0x0080,
	0x4ce2,0x0024,0x0000,0x0001,0x0000,0x1010,0x000a,0x8005,
	0x0000,0x0183,0x0002,0x1f80,0xac32,0x4044,0x2900,0x0080,
	0x4ce2,0x0024,0x0006,0x9a10,0x3000,0x0024,0x4090,0x0024,
	0x0000,0x0024,0x2901,0x9495,0x0002,0x5808,0x000f,0xa000,
	0x6200,0x0024,0x0006,0xa590,0x2802,0x4b45,0x0020,0x0611,
	0x001f,0x4000,0x6200,0x0024,0x000b,0xb800,0x2802,0x4e15,
	0x0000,0x0024,0x0000,0x0081,0x0030,0x1093,0x0008,0x7952,
	0x6190,0x0024,0x3a00,0x0024,0x3300,0x0024,0x6012,0x0024,
	0x0000,0x00c0,0x2927,0x9940,0x3b00,0x4024,0x000b,0xb800,
	0x6200,0x0024,0x0008,0x0850,0x2802,0x56d1,0x0001,0x0000,
	0x3413,0x0024,0x3cf0,0x0024,0x000f,0xa000,0x6200,0x0024,
	0x0017,0x7000,0x2802,0x51d1,0x0000,0x0024,0x0000,0x8c00,
	0x3413,0x0024,0x3cf0,0x0024,0x0017,0x7000,0x6200,0x0024,
	0x0007,0x8b50,0x2802,0x5391,0x0004,0x0003,0x0000,0x6400,
	0x3413,0x0024,0x3cf0,0x0024,0x0004,0x0001,0x3413,0x184c,
	0x34f0,0x0024,0x3e10,0x0024,0x3e10,0x4024,0x3e10,0x0024,
	0x0001,0x0000,0x3e10,0xc024,0x3001,0x0024,0x0008,0x0850,
	0x2900,0x0fc0,0x3e01,0x0024,0x36b3,0x0024,0x3820,0x0024,
	0x38f0,0x0024,0x6890,0x2140,0x2901,0x9480,0x3800,0x0024,
	0x0002,0xabd3,0x0006,0xc792,0x0006,0xc951,0x0006,0xeb50,
	0x3009,0x0000,0x0008,0x0e10,0x3009,0x0401,0x4100,0x0024,
	0x3009,0x2400,0x0008,0x0dd1,0x2900,0x0b80,0x3009,0x0805,
	0x3804,0xc024,0x0008,0x7953,0x0001,0x7d10,0x3904,0x0024,
	0x0030,0x0110,0x3300,0x0024,0x3800,0x0024,0x0006,0x9a10,
	0x3000,0x0024,0x4080,0x0024,0x0000,0x8001,0x2802,0x6c55,
	0x0030,0x03d0,0x3000,0x0024,0xb010,0x0024,0x0006,0xc910,
	0x2802,0x6c55,0x0000,0x0024,0x3300,0x504c,0xffa2,0x184c,
	0x48b2,0xb802,0x0001,0xf402,0x3c10,0x0003,0xff26,0x3381,
	0x2914,0x6080,0x48b6,0x0024,0x4d82,0x9bc2,0x3433,0x0024,
	0x4080,0x3340,0x0030,0x1092,0x2802,0x6c45,0x0030,0x0111,
	0x0020,0x0001,0x0008,0x7950,0x3000,0x104c,0x4010,0x0024,
	0x0000,0x0181,0x3900,0x0024,0x3240,0x0024,0xb010,0x0024,
	0x6012,0x0024,0x0004,0x02c0,0x2802,0x6895,0x0000,0x0024,
	0x0004,0x05c0,0x3a00,0x184c,0x3410,0x0024,0x34e0,0x4024,
	0x3e10,0x0024,0x0000,0x0600,0x3e10,0x4024,0x3e00,0x0024,
	0x2902,0xd5c0,0x0002,0x6a88,0x3a00,0x184c,0x3410,0x0024,
	0x34e0,0x4024,0x3e10,0x0024,0x0000,0x0300,0x3e10,0x4024,
	0x2902,0xd5c0,0x3e00,0x0024,0x36e3,0x0024,0x3009,0x3810,
	0x2900,0x0100,0x0002,0xe750,0x0000,0x0a10,0x2900,0x0080,
	0x3009,0x1bcc,0x0006,0x9a12,0x0000,0x0000,0x003f,0xfdc1,
	0x0030,0x0051,0x0006,0xc750,0x3100,0x2000,0xb012,0x0024,
	0x3900,0x4024,0x3200,0x0024,0x4090,0x0024,0x0030,0x0693,
	0x2802,0x7ad5,0x0000,0x0240,0x0000,0x0010,0x0000,0x0101,
	0x0006,0xc411,0x2911,0x8d40,0x3b00,0x0024,0x3009,0x2410,
	0x0006,0xc410,0x3009,0x0000,0x6016,0x0024,0x0000,0x0101,
	0x2802,0x7155,0x0006,0xc410,0x003f,0xfc01,0x0030,0x0511,
	0x0006,0x9c13,0x0001,0x0012,0x0006,0x9c10,0x3100,0x0024,
	0xb012,0x0024,0xb880,0x27c1,0x0001,0x0101,0x3900,0x0024,
	0x3b04,0x8024,0x3000,0x0024,0x6016,0x0024,0x0001,0x0101,
	0x2802,0x7555,0x0006,0x9c10,0x0006,0xc611,0x0001,0x0013,
	0x003f,0xfc01,0x0030,0x04d2,0x2911,0x8bc0,0x0006,0x9c50,
	0x3009,0x0440,0x3a10,0x07c5,0x3200,0x0024,0xb010,0x0024,
	0xc050,0x0024,0x3a00,0x0024,0x3804,0xc024,0x0006,0x9c10,
	0x3804,0xc024,0x0008,0x0cd0,0x3804,0xc024,0x36f4,0xc024,
	0x36f4,0x5812,0x36f1,0x5810,0x36f0,0xd804,0x36f0,0x1801,
	0x3405,0x9014,0x36f3,0x0024,0x36f2,0x1815,0x2000,0x0000,
	0x36f2,0x9817,0x3613,0x0024,0x3e12,0xb817,0x3e12,0x3815,
	0x3e05,0xb814,0x3625,0x0024,0x0000,0x800a,0x3e10,0x3801,
	0x0000,0x0201,0x3e11,0x3805,0x3e14,0x3811,0x0007,0x8250,
	0x3e04,0x8024,0x3000,0x0024,0xb010,0x0024,0x0000,0x0024,
	0x2913,0x9885,0x0002,0x8b88,0x0000,0x0081,0x0006,0xc991,
	0x3009,0x0400,0x6012,0x0024,0x0006,0xa812,0x2802,0x8b81,
	0x3009,0x0800,0x4080,0x0024,0x003f,0xff41,0x2802,0x8b95,
	0x0000,0x0024,0x3043,0x104c,0x3000,0x0024,0x3c00,0x0024,
	0x0000,0x0080,0x34f0,0x2400,0x6012,0x0024,0x003f,0xf840,
	0x2802,0x8789,0x0000,0x0024,0x003f,0xff40,0x3413,0x0024,
	0x3cf0,0x0024,0x003f,0xf840,0x3810,0x0024,0x003f,0xfe80,
	0x3001,0x4024,0xa50a,0x0004,0x0000,0x00c0,0xb50a,0x0024,
	0x003f,0xff00,0xa408,0x0024,0x0000,0x00c0,0x2913,0x6b00,
	0xb408,0x0024,0x2901,0x9480,0x0000,0x0024,0x3413,0x03cc,
	0x34f0,0x0024,0x3800,0x0024,0x36f4,0x8024,0x36f4,0x1811,
	0x36f1,0x1805,0x36f0,0x1801,0x3405,0x9014,0x36f3,0x0024,
	0x36f2,0x1815,0x2000,0x0000,0x36f2,0x9817,0x3e12,0xb817,
	0x3e12,0x3815,0x3e05,0xb814,0x3615,0x0024,0x0000,0x800a,
	0x3e10,0x3801,0x3e10,0xb810,0x0007,0x2b50,0x3e14,0x4024,
	0x290a,0x9a80,0x3009,0x3852,0x3009,0x1bd2,0x3009,0x0380,
	0x4080,0x0024,0x0000,0x00c1,0x2802,0x98c5,0x3009,0x0000,
	0xb010,0x008c,0x4192,0x0024,0x6012,0x0024,0x0007,0x0051,
	0x2802,0x96d8,0x3009,0x0400,0x0007,0x2fd1,0x30e3,0x0400,
	0x4080,0x0024,0x0000,0x0301,0x2802,0x98c5,0x3009,0x0000,
	0xb010,0x0024,0x0000,0x0101,0x6012,0x0024,0x0007,0x0051,
	0x2802,0x98d5,0x0000,0x0024,0x3023,0x0400,0xf200,0x184c,
	0xb880,0xa400,0x3009,0x2000,0x3009,0x0441,0x3e10,0x4402,
	0x2909,0xed00,0x3e10,0x8024,0x36e3,0x0024,0x36f4,0x4024,
	0x36f0,0x9810,0x36f0,0x1801,0x3405,0x9014,0x36f3,0x0024,
	0x36f2,0x1815,0x2000,0x0000,0x36f2,0x9817,0x3613,0x0024,
	0x3e22,0xb815,0x3e05,0xb814,0x3615,0x0024,0x0000,0x800a,
	0x3e10,0x3801,0x3e10,0xb804,0x3e14,0x3811,0x0008,0x7b50,
	0x3e04,0xb813,0x3000,0x0024,0x4080,0x0024,0x0008,0x7b91,
	0x2802,0xa9c5,0x3100,0x0024,0x4080,0x0024,0x0006,0xa412,
	0x2802,0xa9c5,0x0006,0xa3d1,0x3009,0x0400,0x3009,0x0801,
	0x6014,0x0024,0x0008,0x7bd2,0x2802,0xa9c5,0x0030,0x0611,
	0x3100,0x0024,0x3200,0x4024,0xb010,0x0024,0x0006,0xa552,
	0x2802,0xa9d5,0xb880,0x0024,0x0008,0x7b91,0x3900,0x0800,
	0x4080,0x0024,0x0030,0x0a90,0x2802,0xa885,0x6890,0x0024,
	0x0006,0xa550,0x0006,0xa413,0xb880,0x8c12,0x3009,0x0804,
	0x3009,0x2000,0x0006,0xa490,0x3009,0x0c00,0x6090,0x8001,
	0x6014,0x8c00,0x0006,0xa450,0x2802,0xa791,0x0000,0x0024,
	0x2802,0xa7c0,0x3009,0x0000,0x6090,0x0024,0x0030,0x0a50,
	0x2802,0xa9c0,0x3801,0x2c00,0x0006,0xa413,0x3009,0x2800,
	0x3009,0x0c12,0x3009,0x0800,0x3800,0x0024,0x36f4,0x9813,
	0x36f4,0x1811,0x36f0,0x9804,0x36f0,0x1801,0x3405,0x9014,
	0x36e3,0x0024,0x2000,0x0000,0x36f2,0x9815,0x3613,0x0024,
	0x3e12,0xb817,0x3e12,0x3815,0x3e05,0xb814,0x3615,0x0024,
	0x0000,0x800a,0x3e10,0x7802,0x3e10,0xf804,0x3e14,0x3811,
	0x0006,0xa510,0x3e04,0xb813,0x3009,0x0000,0x4080,0x0024,
	0x0008,0x7b50,0x2802,0xb2c5,0x3000,0x0024,0x4080,0x0024,
	0x0008,0x7b90,0x2802,0xb2c5,0x3000,0x0024,0x4080,0x0024,
	0x0030,0x0690,0x2802,0xb2d5,0x0000,0x0024,0x003f,0xfbc1,
	0x3000,0x0024,0xb012,0x0024,0x3800,0x4024,0x0006,0xa510,
	0x3009,0x0000,0x4080,0x0024,0x0000,0x0024,0x2802,0xc285,
	0x0000,0x0024,0x0008,0x7b51,0xb880,0x12cc,0x3451,0x2000,
	0x0007,0x8190,0x4498,0x2000,0x3100,0x0024,0x4080,0x0024,
	0x0000,0x4003,0x2802,0xb805,0x0006,0xa3d3,0x0000,0x0401,
	0x0030,0x0692,0x3200,0x0024,0xc012,0x0024,0x3a00,0x4024,
	0x34c3,0x0c12,0x3444,0x0800,0x3000,0x8024,0xffa6,0x0024,
	0x48b6,0x0024,0xc030,0x0024,0x2911,0xdb00,0x0002,0xbd48,
	0x0000,0x4003,0x3444,0x0024,0x3010,0x0024,0xa010,0x0002,
	0xffa6,0x0024,0x48b6,0x0024,0x2911,0xdb00,0xc030,0x0024,
	0x4498,0x130c,0x4498,0x4510,0x3440,0x0024,0x6090,0x0024,
	0x3800,0x0024,0x4490,0x130c,0x0000,0x0201,0x2802,0xba19,
	0x0000,0x0024,0x4488,0x110c,0x0006,0xa3d2,0x2802,0xcec5,
	0x0006,0xa513,0x34c3,0x0811,0x3444,0x0024,0x3000,0x0024,
	0xa010,0x0024,0x0000,0x3fc1,0x3000,0x2400,0x0007,0x8191,
	0xb010,0x0024,0x0020,0x0001,0xc010,0x0024,0x6890,0x2400,
	0x2802,0xcec0,0x3009,0x2c00,0x0008,0x7b50,0x3000,0x12cc,
	0x3451,0x0024,0xf148,0x0024,0x4080,0x0024,0xf400,0x4100,
	0x2802,0xc5c5,0x0000,0x0024,0x0000,0x0401,0x0030,0x0691,
	0x3100,0x0024,0xc012,0x0024,0x4480,0x2401,0x4498,0x130c,
	0x4080,0x4510,0x0000,0x0024,0x2802,0xc985,0x0000,0x0024,
	0x3445,0xc024,0x3710,0x0024,0x2911,0xdb00,0x3805,0xc024,
	0x4480,0x130c,0x4498,0x4510,0x4080,0x0024,0x0000,0x0024,
	0x2802,0xc715,0x0000,0x0024,0x6892,0x13cc,0x3450,0x0024,
	0xb010,0x0024,0x0006,0xa3d2,0x2802,0xcec5,0x003f,0xc001,
	0x0006,0xa513,0x34c3,0x0811,0x3444,0x0024,0x3000,0x0024,
	0xb010,0x0024,0x0000,0x4001,0x3000,0x2400,0x0007,0x8191,
	0xff82,0x0024,0x48b2,0x0024,0xf400,0x4040,0x0020,0x0001,
	0xc010,0x0024,0x6890,0x2400,0x3009,0x2c00,0x2913,0x08c0,
	0x3613,0x0024,0x2902,0x9ac0,0x0000,0x0024,0x34b3,0x1813,
	0x3450,0x0024,0x36f4,0x8024,0x36f4,0x1811,0x36f0,0xd804,
	0x36f0,0x5802,0x3405,0x9014,0x36f3,0x0024,0x36f2,0x1815,
	0x2000,0x0000,0x36f2,0x9817,0x4090,0x184c,0x3e13,0xf80e,
	0x2802,0xd4c4,0x3e03,0x7802,0x0001,0x000a,0x2402,0xd480,
	0x3010,0x0024,0xa014,0x03c0,0x3820,0x8024,0x36f3,0x5802,
	0x36f3,0xd80e,0x2000,0x0000,0x0000,0x800a,0x3613,0x0024,
	0x3e12,0x0024,0x3e05,0xb814,0x3645,0x0024,0x3e00,0x3841,
	0x0001,0xf400,0x3e00,0xb843,0x3e01,0x3845,0x3e01,0xb850,
	0x0006,0xc910,0x3e04,0x8001,0xff90,0x0024,0x2927,0x8dc0,
	0x48b2,0x0024,0x34c3,0x184c,0x3e10,0x0024,0x3e10,0x4024,
	0x3e00,0x8024,0x3410,0x8024,0x3410,0xc024,0x3420,0x0024,
	0xffb0,0x4117,0x48b2,0x4004,0xffa8,0x45c4,0x2927,0x8dc0,
	0x40b2,0x0024,0x418a,0x4004,0x428c,0x1bc2,0x36f0,0x504c,
	0x2915,0x3180,0x36f0,0x0024,0x3c00,0x3041,0x3cf0,0x8024,
	0x3400,0x1041,0x2915,0x2b40,0x34e0,0x8024,0x3413,0x184c,
	0x4086,0x1000,0x3e10,0x1041,0x4380,0x1382,0x3e10,0x4024,
	0x2914,0x9380,0x3e00,0x8024,0x418a,0x4004,0x428c,0x1bc2,
	0x36f0,0x4024,0x2914,0x8580,0x36f0,0x0024,0x0000,0x0806,
	0xb888,0x0024,0x2914,0x9780,0x0010,0x0005,0x2927,0x87c0,
	0x0000,0x0024,0x0006,0x0e50,0x0006,0x0212,0x3810,0x2801,
	0x0000,0x00c0,0x6030,0x0024,0x3800,0x0024,0x36f4,0x8024,
	0x36f1,0x9810,0x36f1,0x1805,0x36f0,0x9803,0x36f0,0x1801,
	0x3405,0x9014,0x36f3,0x0024,0x36f2,0x0024,0x2000,0x0000,
	0x0000,0x0024,0x2a02,0xe78e,0x3009,0x3855,0x0006,0x0995,
	0x3500,0x3800,0x6090,0x380a,0x3d00,0x0024,0x2802,0xff04,
	0x0030,0x0715,0x3613,0x0024,0x3e15,0x3817,0x0006,0x0014,
	0x4090,0x4015,0x4091,0xe24a,0x0030,0x11d7,0x4090,0x1c42,
	0x3710,0xb102,0x2802,0xfe55,0x3009,0x3002,0x0006,0x0ed5,
	0x3515,0xd84c,0x3e14,0x3811,0x35d2,0x9fd1,0x3e14,0xb813,
	0x3e00,0x7860,0x3e00,0xf861,0x3e01,0x7862,0x3e13,0x7823,
	0x3e11,0xb807,0x3e13,0xf80e,0x48b2,0xb849,0x3e10,0x7800,
	0x3111,0xb804,0x3101,0xdc83,0x4ffa,0x1442,0x4fde,0x0024,
	0x478e,0x27c7,0x3911,0x9c43,0x2802,0xf154,0xb73e,0x14c0,
	0x4090,0x0024,0x39e1,0xdc53,0x3900,0x1fd1,0x3904,0x5c90,
	0x3514,0x9c44,0x3514,0x5c4d,0x2402,0xf60d,0xbf8f,0x1a2b,
	0xfe35,0x1a2b,0x543f,0x1a2b,0x543f,0x1a2b,0x543e,0x0b0c,
	0x4fbe,0x0024,0xfede,0x0024,0x48b6,0x1400,0xad06,0x0024,
	0xffdc,0x0024,0x48be,0x9c23,0x4df6,0x0024,0xf7df,0x1a2b,
	0x478c,0x48c7,0x3180,0x88c3,0xfe34,0x144c,0x4fbe,0x1440,
	0xaf0e,0x1440,0xaf06,0x0024,0x6fde,0x0024,0x4498,0x1454,
	0x35b4,0x5fcc,0x2802,0xf255,0xf7f2,0x4040,0x3404,0x9c8c,
	0x3104,0xdc17,0x3b80,0x1bc4,0x3b80,0x4024,0x36f0,0x5800,
	0x2210,0x0000,0xf400,0x4215,0x3904,0xdbc8,0x36f3,0xd80e,
	0x36f1,0x9807,0x36f3,0x5823,0x3601,0x5be2,0x3600,0xdbe1,
	0x3600,0x5be0,0x36f4,0x9813,0x36f4,0x1811,0x36f0,0x8024,
	0x36f5,0x1817,0x36f2,0x9800,0x3e05,0x4024,0x2000,0x0000,
	0x3602,0x1bd5,0x36f0,0x8024,0x36f5,0x1817,0x0030,0x0715,
	0x36f2,0x9800,0x2100,0x0000,0x3d05,0x5bd5,
	0x0007,0x0001, /*copy 1*/
	0x802e,
	0x0006,0x0002, /*copy 2*/
	0x2800,0x8980,
	0x0007,0x0001, /*copy 1*/
	0x8036,
	0x0006,0x0002, /*copy 2*/
	0x2a00,0xb700,
	0x0007,0x0001, /*copy 1*/
	0x8034,
	0x0006,0x0002, /*copy 2*/
	0x2a00,0xb940,
	0x0007,0x0001, /*copy 1*/
	0x1804,
	0x0006, 0x8006, 0x044c, /*Rle(6)*/
	0x0006,0x003a, /*copy 58*/
	0x0405,0x044c,0x036f,0x0443,0x04b1,0x044c,0x046e,0x046e,
	0x046e,0x046e,0x0481,0x048a,0x044c,0x0491,0x0499,0x04a1,
	0x03c9,0x0389,0x044c,0x044c,0x04ad,0x044c,0x044f,0x045f,
	0x045f,0x045f,0x0000,0x0000,0xffff,0x0000,0x0000,0xffff,
	0x0003,0xfffd,0x0001,0x0002,0xfffb,0x0004,0xffff,0xffff,
	0x0000,0x0001,0x0000,0x0000,0x0002,0x0000,0x0000,0xbcaa,
	0xfff8,0x1809,0x0600,0x1800,0x1829,0x0010,0x0010,0xfffd,
	0x1a72,0x1a70,
	0x0007,0x0001, /*copy 1*/
	0x8032,
	0x0006,0x0002, /*copy 2*/
	0x2802,0x8dc0,
	0x0007,0x0001, /*copy 1*/
	0x8023,
	0x0006,0x0002, /*copy 2*/
	0x2a01,0x2fce,
	0x0007,0x0001, /*copy 1*/
	0x8038,
	0x0006,0x0002, /*copy 2*/
	0x2a01,0x4b40,
	0x0007,0x0001, /*copy 1*/
	0x1c62,
	0x0006,0x00d6, /*copy 214*/
	0x0552,0x0562,0x0571,0x055a,0x0575,0x0577,0x057d,0x05ca,
	0x05ca,0x05e2,0x05ca,0x0028,0x0028,0x002d,0x0031,0x0031,
	0x0031,0x002e,0x002e,0x002a,0x002a,0x002a,0x0028,0x0000,
	0x0004,0x0008,0x000c,0x0010,0x0014,0x0018,0x0020,0x0028,
	0x0030,0x0040,0x005c,0x0078,0x0000,0x0004,0x0008,0x000c,
	0x0010,0x0014,0x0018,0x001c,0x0020,0x0024,0x0028,0x0030,
	0x0038,0x0040,0x0048,0x0050,0x0058,0x0060,0x006c,0x0078,
	0x0084,0x0090,0x00a0,0x00b0,0x00c4,0x00d8,0x00f0,0x0108,
	0x0124,0x0140,0x0160,0x0180,0x01a0,0x01c0,0x01e0,0x0200,
	0x0220,0x0240,0x0260,0x0280,0x02a0,0x02c0,0x02e0,0x0300,
	0x0320,0x0340,0x0360,0x0380,0x03a0,0x03c0,0x0000,0x0004,
	0x0008,0x000c,0x0010,0x0014,0x001c,0x0024,0x002c,0x0038,
	0x0044,0x0050,0x0060,0x0070,0x0078,0x0000,0x0004,0x0008,
	0x000c,0x0010,0x0014,0x0018,0x001c,0x0024,0x002c,0x0034,
	0x0040,0x004c,0x005c,0x006c,0x0078,0x0000,0x0004,0x0008,
	0x000c,0x0010,0x0014,0x0018,0x001c,0x0020,0x0028,0x0030,
	0x003c,0x0048,0x0058,0x006c,0x0078,0x0000,0x0004,0x0008,
	0x000c,0x0010,0x0014,0x0018,0x001c,0x0024,0x002c,0x0034,
	0x003c,0x0048,0x0058,0x006c,0x0078,0x0000,0x000c,0x0018,
	0x0024,0x0030,0x003c,0x0048,0x0054,0x0060,0x006c,0x0078,
	0x0084,0x0090,0x009c,0x00ac,0x00bc,0x00cc,0x00dc,0x00ec,
	0x00fc,0x010c,0x0120,0x0134,0x0148,0x015c,0x0174,0x018c,
	0x01a4,0x01c0,0x01dc,0x01fc,0x0220,0x0244,0x026c,0x0298,
	0x02c8,0x02fc,0x0334,0x0370,0x03b0,0x03c0,0xc1af,0xc1af,
	0xc1e6,0x1c86,0x1c86,0xc264,0xc298,0xc298,0xc2d8,0xc2d8,
	0xc2d8,0x1cf7,0x1c79,0x1c79,0x1c79,0x1cb8,0x1cb8,0x1cb8,
	0x1cc7,0x1cc7,0x1cd7,0x1cd7,0x1cd7,0x1ce7,
	0x0007,0x0001, /*copy 1*/
	0x5800,
	0x0006, 0x8008, 0x0000, /*Rle(8)*/
	0x0006,0x0009, /*copy 9*/
	0x4e13,0x1827,0x7fff,0x0001,0xc01c,0x0002,0x0002,0x0000,
	0xc01b,
	0x000a,0x0001, /*copy 1*/
	0x0050,
};


#endif
